-- MySQL dump 10.10
--
-- Host: localhost    Database: sys_datos_dfs
-- ------------------------------------------------------
-- Server version	5.0.19-nt

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `dat_articulo`
--

DROP TABLE IF EXISTS `dat_articulo`;
CREATE TABLE `dat_articulo` (
  `IdArticulo` int(11) NOT NULL COMMENT 'Id unico del articulo.\r\nSingle ID of the article.',
  `TeclaDirecta` int(11) default NULL,
  `PrecioConIVA` double(15,6) default '0.000000' COMMENT 'Precio con IVA.\r\nPrice with VAT.',
  `Descripcion` varchar(100) default NULL COMMENT 'Descripcion del articulo.\r\nDescription of the article.',
  `Descripcion1` varchar(100) default NULL COMMENT 'Descripcion adicional del articulo.\r\nAditional description of the article.',
  `Descripcion2` varchar(100) default NULL,
  `IdTipo` int(11) NOT NULL default '1' COMMENT '1=Pesado, 2=Unitario\r\n1=weight, 2=Unit',
  `IdSeccion` int(11) default NULL COMMENT 'Id Seccion del articulo.\r\nSection ID of the article.',
  `FormatoEtiquetaSerieL` varchar(2) default NULL,
  `FormatoEtiquetaSerieL2` varchar(2) default NULL,
  `IdCodBarras` int(11) default '0' COMMENT 'Id codigo de barras del articulo.\r\nBarcode ID of the article.',
  `IdIVA` int(11) default NULL COMMENT 'Id IVA del articulo.\r\nVAT ID of the article.',
  `CodSmiley` int(11) default NULL,
  `LogoPantalla` varchar(1000) default NULL COMMENT 'Ruta del logotipo del articulo.\r\nPath of the logo of the article.',
  `TipoOferta` int(11) default '0' COMMENT '0: No oferta\r\n1: Precio-Peso\r\n2: Cantidad gratis',
  `PrecioOferta` double(15,6) default '0.000000',
  `IdOfertaTemporal` int(11) default NULL,
  `PrecioEstandar` double(15,6) unsigned default '0.000000' COMMENT 'Precio estandar del articulo.\r\nStandard price of the article.',
  `FechaCaducidadActivada` tinyint(1) default '1',
  `FechaCaducidad` datetime default NULL,
  `DiasCaducidad` int(5) default NULL COMMENT 'Dias de caducidad del articulo.\r\nDays of expiration of the article.',
  `HorasCaducidad` int(5) default NULL COMMENT 'Horas de caducidad del articulo.\r\nHours of expiration of the article.',
  `MinutosCaducidad` int(5) default NULL,
  `FechaExtraActivada` tinyint(1) default '1',
  `FechaExtra` datetime default NULL,
  `DiasExtra` int(5) default NULL COMMENT 'Dias extras del articulo.\r\nExtra days of the article.',
  `HorasExtra` int(5) default NULL COMMENT 'Horas extra del articulo.\r\nExtra hours of the article.',
  `MinutosExtra` int(5) default NULL,
  `FechaCongelacionActivada` tinyint(1) default '1',
  `FechaCongelacion` datetime default NULL,
  `DiasCongelacion` int(5) default NULL,
  `HorasCongelacion` int(5) default NULL,
  `MinutosCongelacion` int(5) default NULL,
  `TaraFija` decimal(11,3) default NULL COMMENT 'Tara fija del articulo.\r\nFixed tara of the article.',
  `TaraPorcentual` int(11) default NULL COMMENT 'Tara porcentual de articulo.\r\nPercentaje tara of the article.',
  `EANScanner` varchar(20) default NULL COMMENT 'Codigo EANScanner del articulo.\r\nEANScanner code of the article.',
  `IdClase` int(11) default NULL COMMENT 'Id Clase del articulo.\r\nCass ID of the article.',
  `IdElemAsociado` int(11) default NULL COMMENT 'Id Elemento asociado del articulo.\r\nAssociated element Id of the article.',
  `ModificaPV` tinyint(1) default '0' COMMENT '0= No se puede modificar el precio del articulo en la pantalla de venta, 1= Se puede moficiar el precio del articulo en la pantalla de venta.\r\n0 = You can not change the price of the article on the screen sales, 1 = You can moficiar the price of the artic',
  `Texto1` text COMMENT 'Texto 1 del articulo.\r\nText 1 of the article.',
  `Texto2` text COMMENT 'Texto 2 del articulo.\r\nText 2 of the article.',
  `Texto3` text COMMENT 'Texto 3 del articulo.\r\nText 3 of the article.',
  `Texto4` text COMMENT 'Texto 4 del articulo.\r\nText 4 of the article.',
  `Texto5` text COMMENT 'Texto 5 del articulo.\r\nText 5 of the article.',
  `Texto6` text COMMENT 'Texto 6 del articulo.\r\nText 6 of the article.',
  `Texto7` text COMMENT 'Texto 7 del articulo.\r\nText 7 of the article.',
  `Texto8` text COMMENT 'Texto 8 del articulo.\r\nText 8 of the article.',
  `Texto9` text COMMENT 'Texto 9 del articulo.\r\nText 9 of the article.',
  `Texto10` text COMMENT 'Texto 10 del articulo.\r\nText 10 of the article.',
  `Texto11` text COMMENT 'Texto 11 del articulo.\r\nText 11 of the article.',
  `Texto12` text COMMENT 'Texto 12 del articulo.\r\nText 12 of the article.',
  `Texto13` text COMMENT 'Texto 13 del articulo.\r\nText 13 of the article.',
  `Texto14` text COMMENT 'Texto 14 del articulo.\r\nText 14 of the article.',
  `Texto15` text COMMENT 'Texto 15 del articulo.\r\nText 15 of the article.',
  `Texto16` text COMMENT 'Texto 16 del articulo.\r\nText 16 of the article.',
  `Texto17` text COMMENT 'Texto 17 del articulo.\r\nText 17 of the article.',
  `Texto18` text COMMENT 'Texto 18 del articulo.\r\nText 18 of the article.',
  `Texto19` text COMMENT 'Texto 19 del articulo.\r\nText 19 of the article.',
  `Texto20` text COMMENT 'Texto 20 del articulo.\r\nText 20 of the article.',
  `TextoLibre` text COMMENT 'Texto libre del articulo.\r\nFree text of the article.',
  `TextoNutricional1_1` varchar(100) default NULL,
  `TextoNutricional1_2` varchar(100) default NULL,
  `TextoNutricional2_1` varchar(100) default NULL,
  `TextoNutricional2_2` varchar(100) default NULL,
  `TextoNutricional3_1` varchar(100) default NULL,
  `TextoNutricional3_2` varchar(100) default NULL,
  `TextoNutricional4_1` varchar(100) default NULL,
  `TextoNutricional4_2` varchar(100) default NULL,
  `TextoNutricional5_1` varchar(100) default NULL,
  `TextoNutricional5_2` varchar(100) default NULL,
  `TextoNutricional6_1` varchar(100) default NULL,
  `TextoNutricional6_2` varchar(100) default NULL,
  `TextoNutricional7_1` varchar(100) default NULL,
  `TextoNutricional7_2` varchar(100) default NULL,
  `TextoNutricional8_1` varchar(100) default NULL,
  `TextoNutricional8_2` varchar(100) default NULL,
  `TextoNutricional9_1` varchar(100) default NULL,
  `TextoNutricional9_2` varchar(100) default NULL,
  `TextoNutricional10_1` varchar(100) default NULL,
  `TextoNutricional10_2` varchar(100) default NULL,
  `TextoNutricional11_1` varchar(100) default NULL,
  `TextoNutricional11_2` varchar(100) default NULL,
  `TextoNutricional12_1` varchar(100) default NULL,
  `TextoNutricional12_2` varchar(100) default NULL,
  `TextoNutricional13_1` varchar(100) default NULL,
  `TextoNutricional13_2` varchar(100) default NULL,
  `TextoNutricional14_1` varchar(100) default NULL,
  `TextoNutricional14_2` varchar(100) default NULL,
  `IdEmpresa` int(11) NOT NULL default '1' COMMENT 'Id Empresa del articulo.\r\nCompany ID of the article.',
  `IdSubFamilia` int(11) default NULL COMMENT 'Id Subfamilia del articulo.\r\nSubfamily ID of the article.',
  `IdEtiqueta` int(11) default NULL COMMENT 'Id etiqueta del articulo.\r\nTag Id of the article.',
  `FechaEnvasadoActivada` tinyint(1) default '0',
  `FechaEnvasado` datetime default NULL,
  `DiasEnvasado` int(5) default NULL COMMENT 'Dias envasado del articulo.\r\nPacking days of the article.',
  `HorasEnvasado` int(5) default NULL COMMENT 'Horas envasado del articulo.\r\nPacking hours of the article.',
  `IdLogo` int(11) default NULL,
  `IdLogoColor` int(11) default NULL,
  `BarCode20` int(25) default NULL,
  `IdFamilia` int(11) default NULL COMMENT 'Id Familia del articulo\r\nFamily ID of the article.',
  `PLUNumber` int(11) default NULL,
  `FechaInicioOferta` datetime default NULL,
  `FechaFinOferta` datetime default NULL,
  `HoraInicioOferta` text,
  `HoraFinOferta` text,
  `FactorPrecio` tinyint(1) default NULL,
  `DiaSemanaOferta` tinyint(1) default NULL,
  `IdReceta` int(11) default NULL,
  `TextosEAN128` tinyint(1) NOT NULL default '0' COMMENT '0: 10 textos, 1: 9 textos y EAN 128 24c, 2: 8 textos y EAN 128 48c, 3: 7 textos y EAN 128 72c',
  `IdEAN128` int(11) default '0',
  `CodigoIngrediente1` int(11) default NULL,
  `CodigoIngrediente2` int(11) default NULL,
  `CodigoIngrediente3` int(11) default NULL,
  `CodigoIngrediente4` int(11) default NULL,
  `CodigoIngrediente5` int(11) default NULL,
  `CodigoIngrediente6` int(11) default NULL,
  `CodigoIngrediente7` int(11) default NULL,
  `CodigoIngrediente8` int(11) default NULL,
  `CodigoIngrediente9` int(11) default NULL,
  `CodigoIngrediente10` int(11) default NULL,
  `PesoFijo` decimal(11,3) default NULL,
  `PrecioAnterior` double(15,6) default NULL,
  `FechaModificacionPrecio` datetime default NULL,
  `UsuarioModificacionPrecio` varchar(20) default NULL,
  `CodigoNutricional` int(11) default NULL,
  `Texto1_Texto2` text,
  `Texto3_Texto4` text,
  `Texto5_Texto6` text,
  `Texto7_Texto8` text,
  `Texto9_Texto10` text,
  `IdTaraSeccion` int(11) default NULL,
  `IdIngredienteSeccion` int(11) default NULL,
  `Descripcion_Descripcion1` text,
  `Modificado` tinyint(1) default NULL COMMENT '0 No modificado, 1 Modificado\r\n0 Not modified , 1 Modified',
  `ModificadoEAN` tinyint(1) default NULL,
  `ModificadoTextos` tinyint(1) default NULL,
  `ModificadoTextoG` tinyint(1) default NULL,
  `ModificadoNutricionales` tinyint(1) default '0',
  `Operacion` char(1) default NULL COMMENT 'A=Alta, M=Modificado, B=Borrado\r\nA=New, M=Modified, B=Deleted',
  `Usuario` varchar(20) default NULL COMMENT 'Usuario de creacion del ticket.\r\nUser creation of the ticket.',
  `CHKW_MargenInferior` decimal(11,3) default '0.000' COMMENT 'Checkweigher Margen Inferior -> Articulo',
  `CHKW_MargenSuperior` decimal(11,3) default '0.000' COMMENT 'Checkweigher Margen Superior -> Articulo',
  `PesoPieza` int(11) default '0' COMMENT 'Peso de la pieza para el modo cuentapiezas',
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP COMMENT 'Fecha y hora de la ultima modificacion del registro.\r\nDate and time of the last change of the register.',
  `Color` int(11) NOT NULL default '0',
  PRIMARY KEY  (`IdEmpresa`,`IdArticulo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guarda toda la informacion de los artic';

--
-- Dumping data for table `dat_articulo`
--


/*!40000 ALTER TABLE `dat_articulo` DISABLE KEYS */;
LOCK TABLES `dat_articulo` WRITE;
INSERT INTO `dat_articulo` (`IdArticulo`, `TeclaDirecta`, `PrecioConIVA`, `Descripcion`, `Descripcion1`, `Descripcion2`, `IdTipo`, `IdSeccion`, `FormatoEtiquetaSerieL`, `FormatoEtiquetaSerieL2`, `IdCodBarras`, `IdIVA`, `CodSmiley`, `LogoPantalla`, `TipoOferta`, `PrecioOferta`, `IdOfertaTemporal`, `PrecioEstandar`, `FechaCaducidadActivada`, `FechaCaducidad`, `DiasCaducidad`, `HorasCaducidad`, `MinutosCaducidad`, `FechaExtraActivada`, `FechaExtra`, `DiasExtra`, `HorasExtra`, `MinutosExtra`, `FechaCongelacionActivada`, `FechaCongelacion`, `DiasCongelacion`, `HorasCongelacion`, `MinutosCongelacion`, `TaraFija`, `TaraPorcentual`, `EANScanner`, `IdClase`, `IdElemAsociado`, `ModificaPV`, `Texto1`, `Texto2`, `Texto3`, `Texto4`, `Texto5`, `Texto6`, `Texto7`, `Texto8`, `Texto9`, `Texto10`, `Texto11`, `Texto12`, `Texto13`, `Texto14`, `Texto15`, `Texto16`, `Texto17`, `Texto18`, `Texto19`, `Texto20`, `TextoLibre`, `TextoNutricional1_1`, `TextoNutricional1_2`, `TextoNutricional2_1`, `TextoNutricional2_2`, `TextoNutricional3_1`, `TextoNutricional3_2`, `TextoNutricional4_1`, `TextoNutricional4_2`, `TextoNutricional5_1`, `TextoNutricional5_2`, `TextoNutricional6_1`, `TextoNutricional6_2`, `TextoNutricional7_1`, `TextoNutricional7_2`, `TextoNutricional8_1`, `TextoNutricional8_2`, `TextoNutricional9_1`, `TextoNutricional9_2`, `TextoNutricional10_1`, `TextoNutricional10_2`, `TextoNutricional11_1`, `TextoNutricional11_2`, `TextoNutricional12_1`, `TextoNutricional12_2`, `TextoNutricional13_1`, `TextoNutricional13_2`, `TextoNutricional14_1`, `TextoNutricional14_2`, `IdEmpresa`, `IdSubFamilia`, `IdEtiqueta`, `FechaEnvasadoActivada`, `FechaEnvasado`, `DiasEnvasado`, `HorasEnvasado`, `IdLogo`, `IdLogoColor`, `BarCode20`, `IdFamilia`, `PLUNumber`, `FechaInicioOferta`, `FechaFinOferta`, `HoraInicioOferta`, `HoraFinOferta`, `FactorPrecio`, `DiaSemanaOferta`, `IdReceta`, `TextosEAN128`, `IdEAN128`, `CodigoIngrediente1`, `CodigoIngrediente2`, `CodigoIngrediente3`, `CodigoIngrediente4`, `CodigoIngrediente5`, `CodigoIngrediente6`, `CodigoIngrediente7`, `CodigoIngrediente8`, `CodigoIngrediente9`, `CodigoIngrediente10`, `PesoFijo`, `PrecioAnterior`, `FechaModificacionPrecio`, `UsuarioModificacionPrecio`, `CodigoNutricional`, `Texto1_Texto2`, `Texto3_Texto4`, `Texto5_Texto6`, `Texto7_Texto8`, `Texto9_Texto10`, `IdTaraSeccion`, `IdIngredienteSeccion`, `Descripcion_Descripcion1`, `Modificado`, `ModificadoEAN`, `ModificadoTextos`, `ModificadoTextoG`, `ModificadoNutricionales`, `Operacion`, `Usuario`, `CHKW_MargenInferior`, `CHKW_MargenSuperior`, `PesoPieza`, `TimeStamp`, `Color`) VALUES (1,1,NULL,'Onglet','','',1,0,'21','',1,NULL,NULL,'',0,NULL,NULL,NULL,1,NULL,21,NULL,NULL,1,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,1,'','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','','',1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2015-09-16 23:27:36','2015-09-16 23:27:36','','',0,0,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,0,'M','admin',NULL,NULL,0,'2015-09-16 21:28:46',0);
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_articulo` ENABLE KEYS */;

/*!50003 SET @OLD_SQL_MODE=@@SQL_MODE*/;
DELIMITER ;;
/*!50003 SET SESSION SQL_MODE="STRICT_TRANS_TABLES,NO_AUTO_CREATE_USER,NO_ENGINE_SUBSTITUTION" */;;
/*!50003 CREATE */ /*!50017 DEFINER=`root`@`localhost` */ /*!50003 TRIGGER `ChangePrice` BEFORE UPDATE ON `dat_articulo` FOR EACH ROW BEGIN
  	IF (OLD.PrecioConIVA <> NEW.PrecioConIVA) THEN
  		SET NEW.PrecioAnterior = OLD.PrecioConIVA;  
        SET NEW.FechaModificacionPrecio = CURRENT_TIMESTAMP();
        SET NEW.UsuarioModificacionPrecio = NEW.Usuario;
    END IF;      		    		
  END */;;

DELIMITER ;
/*!50003 SET SESSION SQL_MODE=@OLD_SQL_MODE */;

--
-- Table structure for table `dat_articulo_grupos`
--

DROP TABLE IF EXISTS `dat_articulo_grupos`;
CREATE TABLE `dat_articulo_grupos` (
  `IdEmpresa` int(11) NOT NULL,
  `IdGrupo` int(11) NOT NULL,
  `IdArticulo` int(11) NOT NULL,
  `PrecioConIVA_Marcado` int(11) default '1',
  `PrecioConIVA` double(15,6) default '0.000000',
  `TeclaDirecta_Marcado` int(11) default '1',
  `TeclaDirecta` int(11) default NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdGrupo`,`IdArticulo`),
  KEY `IdArticulo` (`IdArticulo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_articulo_grupos`
--


/*!40000 ALTER TABLE `dat_articulo_grupos` DISABLE KEYS */;
LOCK TABLES `dat_articulo_grupos` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_articulo_grupos` ENABLE KEYS */;

--
-- Table structure for table `dat_articulo_segmentos`
--

DROP TABLE IF EXISTS `dat_articulo_segmentos`;
CREATE TABLE `dat_articulo_segmentos` (
  `IdArticulo` int(11) NOT NULL,
  `IdSegmento` int(11) NOT NULL,
  `IdTipo` int(1) NOT NULL,
  `Cantidad` double(15,3) NOT NULL,
  `Precio` double(15,3) NOT NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `Operacion` char(1) default NULL,
  `Modificado` tinyint(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdArticulo`,`IdTipo`,`IdSegmento`),
  KEY `Cantidad` (`IdArticulo`,`IdTipo`,`Cantidad`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_articulo_segmentos`
--


/*!40000 ALTER TABLE `dat_articulo_segmentos` DISABLE KEYS */;
LOCK TABLES `dat_articulo_segmentos` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_articulo_segmentos` ENABLE KEYS */;

--
-- Table structure for table `dat_articulo_segmentos_t_b`
--

DROP TABLE IF EXISTS `dat_articulo_segmentos_t_b`;
CREATE TABLE `dat_articulo_segmentos_t_b` (
  `IdArticulo` int(11) NOT NULL,
  `IdTipo` int(11) NOT NULL,
  `IdSegmento` int(11) NOT NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `IdTienda` int(11) NOT NULL default '1',
  `IdBalanza` int(11) NOT NULL default '0',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`,`IdArticulo`,`IdTipo`,`IdSegmento`),
  KEY `BusquedaSegmentos` (`IdEmpresa`,`IdArticulo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `dat_articulo_segmentos_t_b`
--


/*!40000 ALTER TABLE `dat_articulo_segmentos_t_b` DISABLE KEYS */;
LOCK TABLES `dat_articulo_segmentos_t_b` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_articulo_segmentos_t_b` ENABLE KEYS */;

--
-- Table structure for table `dat_articulo_t_b`
--

DROP TABLE IF EXISTS `dat_articulo_t_b`;
CREATE TABLE `dat_articulo_t_b` (
  `IdArticulo` int(11) NOT NULL COMMENT 'Id del articulo asociado a la balanza.\r\nId article associated with the balance.',
  `IdEmpresa` int(11) NOT NULL default '1' COMMENT 'Id Empresa del articulo asociado a la balanza.\r\nCompany ID of the article associated with the balance.',
  `IdTienda` int(11) NOT NULL default '1' COMMENT 'Id Tienda asociada con el articulo.\r\nStore ID associated with the article.',
  `IdBalanza` int(11) NOT NULL default '0' COMMENT 'Id Balanza asociada con el articulo.\r\nBalance ID associated with the article.',
  `Modificado` tinyint(1) default NULL COMMENT '0 No modificado, 1 Modificado\r\n0 Not modified , 1 Modified',
  `ModificadoEAN` tinyint(1) default NULL,
  `ModificadoTextos` tinyint(1) default NULL,
  `ModificadoTextoG` tinyint(1) default NULL,
  `ModificadoNutricionales` tinyint(1) default '0',
  `Operacion` char(1) default NULL COMMENT 'A=Alta, M=Modificado, B=Borrado\r\nA=New, M=Modified, B=Deleted',
  `Usuario` varchar(20) default NULL COMMENT 'Usuario de creacion del ticket.\r\nUser creation of the ticket.',
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP COMMENT 'Fecha y hora de la ultima modificacion del registro.\r\nDate and time of the last change of the register.',
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`,`IdArticulo`),
  KEY `BusquedaArticulos` (`IdEmpresa`,`IdArticulo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='Tabla donde se guarda la asociacion entre balanzas de una';

--
-- Dumping data for table `dat_articulo_t_b`
--


/*!40000 ALTER TABLE `dat_articulo_t_b` DISABLE KEYS */;
LOCK TABLES `dat_articulo_t_b` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_articulo_t_b` ENABLE KEYS */;

--
-- Table structure for table `dat_avisos_email`
--

DROP TABLE IF EXISTS `dat_avisos_email`;
CREATE TABLE `dat_avisos_email` (
  `IdAviso` int(11) NOT NULL,
  `SMTP` varchar(100) default NULL,
  `PortSMTP` int(6) default NULL,
  `SSL` tinyint(1) default '1',
  `NombreUsuario` varchar(100) default NULL,
  `Contrasenia` varchar(100) default NULL,
  `Asunto` text,
  `Texto` text,
  `IdDestinatarios` int(11) default NULL,
  `EnvioModificaciones` tinyint(1) default '0',
  `RecogidaVentas` tinyint(1) default '0',
  `FinDia` tinyint(1) default '0',
  `Inicializacion` tinyint(1) default '0',
  `EnvioFicheros` tinyint(1) default '0',
  `Importacion` tinyint(1) default '0',
  `Exportacion` tinyint(1) default '0',
  `OpcionesEnvio` int(11) default '1' COMMENT '1=Nunca, 2=Siempre, 3=Solo si error',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdAviso`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_avisos_email`
--


/*!40000 ALTER TABLE `dat_avisos_email` DISABLE KEYS */;
LOCK TABLES `dat_avisos_email` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_avisos_email` ENABLE KEYS */;

--
-- Table structure for table `dat_avisos_email_destinatarios`
--

DROP TABLE IF EXISTS `dat_avisos_email_destinatarios`;
CREATE TABLE `dat_avisos_email_destinatarios` (
  `IdDestinatarios` int(11) NOT NULL,
  `Tipo` int(11) NOT NULL COMMENT '1=Para, 2=CC, 3=CCO',
  `Email` varchar(100) NOT NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdDestinatarios`,`Tipo`,`Email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_avisos_email_destinatarios`
--


/*!40000 ALTER TABLE `dat_avisos_email_destinatarios` DISABLE KEYS */;
LOCK TABLES `dat_avisos_email_destinatarios` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_avisos_email_destinatarios` ENABLE KEYS */;

--
-- Table structure for table `dat_balanza`
--

DROP TABLE IF EXISTS `dat_balanza`;
CREATE TABLE `dat_balanza` (
  `IdBalanza` int(11) NOT NULL,
  `IdTienda` int(11) NOT NULL,
  `IdEmpresa` int(11) NOT NULL,
  `Nombre` varchar(50) default NULL,
  `IdDIBAL` varchar(20) default NULL,
  `EtiquetasGestionStock` tinyint(1) NOT NULL default '0',
  `Dir_IP` varchar(20) default NULL,
  `Dir_IP_Publica` varchar(20) default NULL,
  `Port` int(6) default NULL,
  `TipoBase` varchar(20) default NULL,
  `BaseDatos` varchar(50) default NULL,
  `UserDB` varchar(20) default NULL,
  `PasswDB` varchar(24) default NULL,
  `TimeOutConnection` int(4) default '15',
  `BalanzaTradicional` int(11) default NULL,
  `TipoDisplay` int(11) default NULL COMMENT '1:alfanumerica 2:grafica',
  `DireccionLogica` varchar(2) default NULL,
  `Grupo` varchar(2) default NULL,
  `PuertoEnvio_Tx` int(6) default NULL,
  `PuertoRecepcion_Rx` int(6) default NULL,
  `PathImagen` varchar(1000) default NULL,
  `DisenoImagen` tinyint(1) default '0',
  `ColorFondo` varchar(50) default NULL,
  `XPosition` int(11) default '0',
  `YPosition` int(11) default '0',
  `Ancho` int(11) default '0',
  `Alto` int(11) default '0',
  `IdConfiguracion` int(11) default '0',
  `Z0` varchar(130) default NULL,
  `ZA` varchar(130) default NULL,
  `FicheroTX` text,
  `ListadoFinDeDia` tinyint(1) default '1',
  `CaducidadGlobal` tinyint(1) NOT NULL default '0',
  `FechaActivada` tinyint(1) NOT NULL default '1',
  `FechaCaducidad` datetime default NULL,
  `Dias` int(3) default '0',
  `Horas` int(3) default '0',
  `IdGrupoCabecerasFormato0` int(11) default NULL,
  `IdGrupoCabecerasFormato1` int(11) default NULL,
  `IdGrupoCabecerasFormato2` int(11) default NULL,
  `IdGrupoCabecerasFormato3` int(11) default NULL,
  `IdTablaTeclaVendedor` int(11) default NULL,
  `IdPublicidad` int(11) default '0',
  `IdGrupoMacros` int(11) default NULL,
  `IdGrupoArticulos` int(11) default NULL,
  `ActivedScale` int(11) default '1' COMMENT 'Se utiliza para debuggear Comunicaciones simulando DFS',
  `ImportarClientes` tinyint(1) default '0',
  `Balanza_Seleccionada` tinyint(1) default '0',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guarda toda la informacion de las balanzas';

--
-- Dumping data for table `dat_balanza`
--


/*!40000 ALTER TABLE `dat_balanza` DISABLE KEYS */;
LOCK TABLES `dat_balanza` WRITE;
INSERT INTO `dat_balanza` (`IdBalanza`, `IdTienda`, `IdEmpresa`, `Nombre`, `IdDIBAL`, `EtiquetasGestionStock`, `Dir_IP`, `Dir_IP_Publica`, `Port`, `TipoBase`, `BaseDatos`, `UserDB`, `PasswDB`, `TimeOutConnection`, `BalanzaTradicional`, `TipoDisplay`, `DireccionLogica`, `Grupo`, `PuertoEnvio_Tx`, `PuertoRecepcion_Rx`, `PathImagen`, `DisenoImagen`, `ColorFondo`, `XPosition`, `YPosition`, `Ancho`, `Alto`, `IdConfiguracion`, `Z0`, `ZA`, `FicheroTX`, `ListadoFinDeDia`, `CaducidadGlobal`, `FechaActivada`, `FechaCaducidad`, `Dias`, `Horas`, `IdGrupoCabecerasFormato0`, `IdGrupoCabecerasFormato1`, `IdGrupoCabecerasFormato2`, `IdGrupoCabecerasFormato3`, `IdTablaTeclaVendedor`, `IdPublicidad`, `IdGrupoMacros`, `IdGrupoArticulos`, `ActivedScale`, `ImportarClientes`, `Balanza_Seleccionada`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`) VALUES (1,1,1,'Scale 1',NULL,0,'192.168.2.1','192.168.2.1',NULL,NULL,NULL,NULL,NULL,15,20,1,'00',NULL,3001,3000,NULL,0,'Turquoise',21,59,250,40,101,NULL,NULL,NULL,1,0,1,NULL,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,0,0,1,'B','admin','2015-09-15 20:24:30'),(2,1,1,'Scale 01',NULL,0,'192.168.2.00','192.168.2.00',NULL,NULL,NULL,NULL,NULL,15,20,1,'01',NULL,3002,3000,NULL,0,'SkyBlue',20,110,250,40,1,NULL,NULL,NULL,1,0,1,NULL,0,0,0,0,NULL,NULL,NULL,0,NULL,NULL,1,0,0,1,'B','admin','2015-09-15 20:11:34'),(3,1,1,'Scale 00',NULL,0,'192.168.1.240','192.168.1.240',NULL,NULL,NULL,NULL,NULL,15,20,1,'00',NULL,3003,3000,NULL,0,'SkyBlue',25,64,250,40,101,NULL,NULL,NULL,1,0,1,NULL,0,0,0,0,NULL,NULL,NULL,0,NULL,NULL,1,0,0,1,'M','admin','2015-09-16 23:04:41'),(4,1,1,'Scale 01',NULL,0,'192.168.2.00','192.168.2.00',NULL,NULL,NULL,NULL,NULL,15,20,1,'01',NULL,3004,3000,NULL,0,'SkyBlue',363,71,250,40,1,NULL,NULL,NULL,1,0,1,NULL,0,0,0,0,NULL,NULL,NULL,0,NULL,NULL,1,0,0,1,'B','admin','2015-09-16 23:04:41');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_balanza` ENABLE KEYS */;

--
-- Table structure for table `dat_balanzas_clientes`
--

DROP TABLE IF EXISTS `dat_balanzas_clientes`;
CREATE TABLE `dat_balanzas_clientes` (
  `IdEmpresa` int(11) NOT NULL,
  `IdTienda` int(11) NOT NULL,
  `IdBalanza` int(11) NOT NULL,
  `IdCliente` int(11) NOT NULL,
  `Nombre` varchar(9) default NULL,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`,`IdCliente`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_balanzas_clientes`
--


/*!40000 ALTER TABLE `dat_balanzas_clientes` DISABLE KEYS */;
LOCK TABLES `dat_balanzas_clientes` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_balanzas_clientes` ENABLE KEYS */;

--
-- Table structure for table `dat_balanzas_dld`
--

DROP TABLE IF EXISTS `dat_balanzas_dld`;
CREATE TABLE `dat_balanzas_dld` (
  `IdBalanza` int(11) NOT NULL,
  `IdTienda` int(11) NOT NULL,
  `IdEmpresa` int(11) NOT NULL,
  `Nombre` varchar(50) default NULL,
  `Dir_IP_Publica` varchar(20) default NULL,
  `BalanzaTradicional` int(11) default NULL,
  `DireccionLogica` varchar(2) default NULL,
  `Grupo` varchar(2) default NULL,
  `PuertoEnvio_Tx` int(6) default NULL,
  `PuertoRecepcion_Rx` int(6) default NULL,
  `IdConfiguracion` int(11) NOT NULL default '0',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guardan las balanzas creadas con el DLD';

--
-- Dumping data for table `dat_balanzas_dld`
--


/*!40000 ALTER TABLE `dat_balanzas_dld` DISABLE KEYS */;
LOCK TABLES `dat_balanzas_dld` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_balanzas_dld` ENABLE KEYS */;

--
-- Table structure for table `dat_balanzas_grupos_vendedores`
--

DROP TABLE IF EXISTS `dat_balanzas_grupos_vendedores`;
CREATE TABLE `dat_balanzas_grupos_vendedores` (
  `IdEmpresa` int(11) NOT NULL,
  `IdTienda` int(11) NOT NULL,
  `IdBalanza` int(11) NOT NULL,
  `IdGrupo` int(11) NOT NULL,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`,`IdGrupo`),
  KEY `IdGrupo` (`IdGrupo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

--
-- Dumping data for table `dat_balanzas_grupos_vendedores`
--


/*!40000 ALTER TABLE `dat_balanzas_grupos_vendedores` DISABLE KEYS */;
LOCK TABLES `dat_balanzas_grupos_vendedores` WRITE;
INSERT INTO `dat_balanzas_grupos_vendedores` (`IdEmpresa`, `IdTienda`, `IdBalanza`, `IdGrupo`) VALUES (1,1,3,0);
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_balanzas_grupos_vendedores` ENABLE KEYS */;

--
-- Table structure for table `dat_balanzas_lotes`
--

DROP TABLE IF EXISTS `dat_balanzas_lotes`;
CREATE TABLE `dat_balanzas_lotes` (
  `IdEmpresa` int(11) NOT NULL,
  `IdTienda` int(11) NOT NULL,
  `IdBalanza` int(11) NOT NULL,
  `IdLote` int(11) NOT NULL,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`,`IdLote`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_balanzas_lotes`
--


/*!40000 ALTER TABLE `dat_balanzas_lotes` DISABLE KEYS */;
LOCK TABLES `dat_balanzas_lotes` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_balanzas_lotes` ENABLE KEYS */;

--
-- Table structure for table `dat_balanzas_secciones`
--

DROP TABLE IF EXISTS `dat_balanzas_secciones`;
CREATE TABLE `dat_balanzas_secciones` (
  `idEmpresa` int(11) NOT NULL,
  `idTienda` int(11) NOT NULL,
  `idBalanza` int(11) NOT NULL,
  `idSeccion` int(11) NOT NULL,
  PRIMARY KEY  (`idEmpresa`,`idTienda`,`idBalanza`,`idSeccion`),
  KEY `idSeccion` (`idSeccion`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

--
-- Dumping data for table `dat_balanzas_secciones`
--


/*!40000 ALTER TABLE `dat_balanzas_secciones` DISABLE KEYS */;
LOCK TABLES `dat_balanzas_secciones` WRITE;
INSERT INTO `dat_balanzas_secciones` (`idEmpresa`, `idTienda`, `idBalanza`, `idSeccion`) VALUES (1,1,3,0);
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_balanzas_secciones` ENABLE KEYS */;

--
-- Table structure for table `dat_borrado_ventas`
--

DROP TABLE IF EXISTS `dat_borrado_ventas`;
CREATE TABLE `dat_borrado_ventas` (
  `Indice` int(11) NOT NULL,
  `DiasBorradoVentasAuto` int(11) default NULL,
  `FechaUltimoBorradoAuto` datetime default NULL,
  `FechaBorradoInicio` datetime default NULL,
  `FechaBorradoFin` datetime default NULL,
  `DiasBorradoVentasManual` int(11) default NULL,
  `CheckBorradoManual` int(11) default NULL,
  `HoraBorradoAuto` time default NULL,
  `CheckBorradoAuto` tinyint(1) default NULL,
  PRIMARY KEY  (`Indice`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_borrado_ventas`
--


/*!40000 ALTER TABLE `dat_borrado_ventas` DISABLE KEYS */;
LOCK TABLES `dat_borrado_ventas` WRITE;
INSERT INTO `dat_borrado_ventas` (`Indice`, `DiasBorradoVentasAuto`, `FechaUltimoBorradoAuto`, `FechaBorradoInicio`, `FechaBorradoFin`, `DiasBorradoVentasManual`, `CheckBorradoManual`, `HoraBorradoAuto`, `CheckBorradoAuto`) VALUES (1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_borrado_ventas` ENABLE KEYS */;

--
-- Table structure for table `dat_cabecera_etiqueta`
--

DROP TABLE IF EXISTS `dat_cabecera_etiqueta`;
CREATE TABLE `dat_cabecera_etiqueta` (
  `IdEmpresa` int(11) NOT NULL,
  `IdModeloBalanza` int(11) NOT NULL,
  `IdCabecera` int(11) NOT NULL,
  `Descripcion` varchar(52) NOT NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdModeloBalanza`,`IdCabecera`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_cabecera_etiqueta`
--


/*!40000 ALTER TABLE `dat_cabecera_etiqueta` DISABLE KEYS */;
LOCK TABLES `dat_cabecera_etiqueta` WRITE;
INSERT INTO `dat_cabecera_etiqueta` (`IdEmpresa`, `IdModeloBalanza`, `IdCabecera`, `Descripcion`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`) VALUES (1,1,1,'Les Fermes Du Pays Bourian',1,'A','dfd','2015-09-14 17:33:14'),(1,1,2,'La Marzelle',1,'A','dfd','2015-09-14 17:33:52'),(1,1,3,'46310 St Germain du Bel Air',1,'A','dfd','2015-09-14 17:34:09'),(1,1,4,'Num Abattoir :',1,'A','dfd','2015-09-14 19:00:26'),(1,1,5,'Ingredients :',1,'A','dfd','2015-09-15 17:45:23'),(1,1,6,'Eleveur :',1,'A','dfd','2015-09-14 17:40:52'),(1,1,7,'Nunéro de Lot :',1,'A','dfd','2015-09-15 18:03:26'),(1,1,8,'Catégorie :',1,'A','dfd','2015-09-15 20:38:57'),(1,1,9,'Type :',1,'A','dfd','2015-09-15 20:48:43'),(1,20,1,'Les Fermes du Pays Bourian',1,'A','dfd','2015-09-16 19:33:54'),(1,20,2,'La Marzelle',1,'A','dfd','2015-09-16 19:34:05'),(1,20,3,'46310 St Germain du bel Air',1,'A','dfd','2015-09-16 19:34:22'),(1,20,5,'Pays de Naissance :',1,'A','dfd','2015-09-16 19:34:25'),(1,20,6,'Pays d\'élevage :',1,'A','dfd','2015-09-16 19:34:47'),(1,20,7,'Pays d\'abattage :',1,'A','dfd','2015-09-16 19:35:02'),(1,20,8,'Num Abattoir :',1,'A','dfd','2015-09-16 19:35:13'),(1,20,9,'Race :',1,'A','dfd','2015-09-16 19:35:15'),(1,20,10,'Type :',1,'A','dfd','2015-09-16 19:35:32'),(1,20,11,'Catégorie',1,'A','dfd','2015-09-16 19:35:46');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_cabecera_etiqueta` ENABLE KEYS */;

--
-- Table structure for table `dat_cabecera_ticket`
--

DROP TABLE IF EXISTS `dat_cabecera_ticket`;
CREATE TABLE `dat_cabecera_ticket` (
  `IdEmpresa` int(11) NOT NULL,
  `IdGrupo` int(11) NOT NULL,
  `IdCabecera` int(11) NOT NULL,
  `Ubicacion` int(11) default NULL,
  `Descripcion` varchar(56) default NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdGrupo`,`IdCabecera`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_cabecera_ticket`
--


/*!40000 ALTER TABLE `dat_cabecera_ticket` DISABLE KEYS */;
LOCK TABLES `dat_cabecera_ticket` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_cabecera_ticket` ENABLE KEYS */;

--
-- Table structure for table `dat_clase`
--

DROP TABLE IF EXISTS `dat_clase`;
CREATE TABLE `dat_clase` (
  `IdClase` int(11) NOT NULL,
  `NombreClase` varchar(25) default NULL,
  `CodigoIALote` varchar(10) default NULL,
  `CodigoIAPeso` varchar(10) default NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdClase`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guardan las distintas clases que puede perten';

--
-- Dumping data for table `dat_clase`
--


/*!40000 ALTER TABLE `dat_clase` DISABLE KEYS */;
LOCK TABLES `dat_clase` WRITE;
INSERT INTO `dat_clase` (`IdClase`, `NombreClase`, `CodigoIALote`, `CodigoIAPeso`, `IdEmpresa`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`) VALUES (1,'Tracabilitee',NULL,NULL,1,0,'M','admin','2015-09-16 21:31:43');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_clase` ENABLE KEYS */;

--
-- Table structure for table `dat_clase_t_b`
--

DROP TABLE IF EXISTS `dat_clase_t_b`;
CREATE TABLE `dat_clase_t_b` (
  `IdClase` int(11) NOT NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `IdTienda` int(11) NOT NULL default '1',
  `IdBalanza` int(11) NOT NULL default '0',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`,`IdClase`),
  KEY `BusquedaClases` (`IdEmpresa`,`IdClase`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `dat_clase_t_b`
--


/*!40000 ALTER TABLE `dat_clase_t_b` DISABLE KEYS */;
LOCK TABLES `dat_clase_t_b` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_clase_t_b` ENABLE KEYS */;

--
-- Table structure for table `dat_cliente`
--

DROP TABLE IF EXISTS `dat_cliente`;
CREATE TABLE `dat_cliente` (
  `IdEmpresa` int(11) NOT NULL,
  `IdCliente` int(11) NOT NULL,
  `Nombre` varchar(9) default NULL,
  `NombreLargo` varchar(30) default NULL,
  `Direccion` varchar(30) default NULL,
  `CodPostal` varchar(10) default NULL,
  `Localidad` varchar(20) default NULL,
  `NIF` varchar(20) default NULL,
  `Activo` tinyint(1) NOT NULL default '1',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdCliente`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_cliente`
--


/*!40000 ALTER TABLE `dat_cliente` DISABLE KEYS */;
LOCK TABLES `dat_cliente` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_cliente` ENABLE KEYS */;

--
-- Table structure for table `dat_cod_barras`
--

DROP TABLE IF EXISTS `dat_cod_barras`;
CREATE TABLE `dat_cod_barras` (
  `IdCodBarras` int(11) NOT NULL default '0',
  `IdFormatosBarras` int(11) NOT NULL,
  `NombreCodBarras` varchar(20) default NULL,
  `Plantilla` varchar(500) default NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `TratamientoNegativos` int(11) default '0',
  `UsarEAN` tinyint(1) default '0',
  `AEnviar` int(11) default '1',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdCodBarras`,`IdFormatosBarras`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guardan los distintos codigos de barras. T';

--
-- Dumping data for table `dat_cod_barras`
--


/*!40000 ALTER TABLE `dat_cod_barras` DISABLE KEYS */;
LOCK TABLES `dat_cod_barras` WRITE;
INSERT INTO `dat_cod_barras` (`IdCodBarras`, `IdFormatosBarras`, `NombreCodBarras`, `Plantilla`, `IdEmpresa`, `TratamientoNegativos`, `UsarEAN`, `AEnviar`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`) VALUES (1,1,'EAN13 Peulet','29CH',1,NULL,0,1,0,'M','admin','2015-09-16 21:31:43');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_cod_barras` ENABLE KEYS */;

--
-- Table structure for table `dat_cod_barras_t_b`
--

DROP TABLE IF EXISTS `dat_cod_barras_t_b`;
CREATE TABLE `dat_cod_barras_t_b` (
  `IdCodBarras` int(11) NOT NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `IdTienda` int(11) NOT NULL default '1',
  `IdBalanza` int(11) NOT NULL default '0',
  `IdFormatosBarras` int(11) NOT NULL default '0',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`,`IdCodBarras`,`IdFormatosBarras`),
  KEY `BusquedaCodBarras` (`IdEmpresa`,`IdCodBarras`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `dat_cod_barras_t_b`
--


/*!40000 ALTER TABLE `dat_cod_barras_t_b` DISABLE KEYS */;
LOCK TABLES `dat_cod_barras_t_b` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_cod_barras_t_b` ENABLE KEYS */;

--
-- Table structure for table `dat_configuracion`
--

DROP TABLE IF EXISTS `dat_configuracion`;
CREATE TABLE `dat_configuracion` (
  `IdConfiguracion` int(6) NOT NULL,
  `NombreConfiguracion` varchar(30) default NULL,
  `IdModeloBalanza` int(11) default NULL,
  `Grupo` varchar(2) default '00',
  `LimiteMayoristas` decimal(13,4) default '0.0000',
  `MovimientoDia` int(11) default '0',
  `FinDia` int(11) default '0',
  `MarcarMensajeEtiqueta` int(11) default '0',
  `RegistroCompletoVentas` int(11) default '1',
  `InformeComunicaciones` int(11) default '0',
  `DevolucionPeso` int(11) default '0',
  `FijarPrecio` int(11) default '0',
  `PrecioLibre` int(11) default '0',
  `PrecioDirecto` int(11) default '0',
  `Multiplicacion` int(11) default '0',
  `Resta` int(11) default '0',
  `Suma` int(11) default '0',
  `Subtotal` int(11) default '0',
  `CalculoCambio` int(11) default '0',
  `NumeroCliente` int(11) default '0',
  `CodigoEnTicket` int(11) default '0',
  `TaraEnTicket` int(11) default '0',
  `DescuentoEnTicket` int(11) default '0',
  `DescuentoEnLinea` int(11) default '0',
  `IVAEnTicket` int(11) default '0',
  `ConfiguracionTicket` int(11) default '0',
  `LineasAnuladas` int(11) default '0',
  `RedondeoTicket` int(11) default '0',
  `UnArticulo` int(11) default '0',
  `PapelAdhesivo` int(11) default '0',
  `PesajeAutomatico` int(11) default '0',
  `EtiquetaPorPesada` int(11) default '0',
  `CentradoTextos` int(11) default '0',
  `AcumularEnEtiqueta` int(11) default '0',
  `ImprimirTextoG` int(11) default '0',
  `TalonCaja` int(11) default '0',
  `TalonCaja2` int(11) default '0',
  `CopiaTicket` int(11) default '0',
  `Reapertura` int(11) default '0',
  `DosModosPago` int(11) default '0',
  `CodigoBarrasSeccion` int(11) default '0',
  `CodigoBarrasTicket` int(11) default '0',
  `CodigoBarrasEtiqueta` int(11) default '0',
  `LineaInterpretacionEAN` int(11) default '0',
  `FormatoEAN13Ticket` int(11) default '0',
  `EAN13Ticket` varchar(20) default NULL,
  `FormatoEAN13Etiqueta` int(11) default '0',
  `EAN13Etiqueta` varchar(20) default NULL,
  `FormatoEAN128` int(11) default '0',
  `VentaEscaner` int(11) default '0',
  `LecturaEAN128` int(11) default '0',
  `AnalisisComodines` int(11) default '0',
  `UnidadesX1000` int(11) default '0',
  `CifrasCodigo` int(11) default '0',
  `Caducidad` int(11) default '0',
  `Publicidad` int(11) default '0',
  `ControlCajon` int(11) default '0',
  `PrecioPorcentaje` int(11) default '0',
  `ModoAutomatico` int(11) default '0',
  `TemporizacionCodigo` int(11) default '0',
  `MemorizarImporteCero` int(11) default '0',
  `MemorizarPesoCero` int(11) default '0',
  `CabeceraListados` int(11) default '0',
  `ClaseDefecto` int(11) default '0',
  `ControlPesoLote` int(11) default '0',
  `AperturaCajonCero` int(11) default '0',
  `TrazabilidadGenerica` int(11) default '0',
  `IdPuntosFidelidad` int(11) default NULL,
  `PrecioSello` decimal(13,4) default '0.0000',
  `PrecioReferencia` decimal(13,4) default '0.0000',
  `NombreSello` varchar(20) default NULL,
  `CodigoSello` int(11) default '0',
  `PuntosBonoRegalo` int(11) default '0',
  `DiasSinActividad` int(11) default '0',
  `Code25` varchar(25) default NULL,
  `Code25Checksum` int(11) default NULL,
  `ModoCheckweigher` tinyint(1) default '0' COMMENT 'Modo Checkweigher 0-> No 1-> Articulo 2-> Global',
  `CHKW_MargenInferior` decimal(11,3) default '0.000' COMMENT 'Checkweigher Margen Inferior -> Configuracion',
  `CHKW_MargenSuperior` decimal(11,3) default '0.000' COMMENT 'Checkweigher Margen Superior-> Configuracion',
  `ModoTrabajo` int(11) default '0',
  `SegundaEtiqueta` int(11) default '0',
  `FormatoEtiqueta` int(11) default '0',
  `FormatoEtiqueta2` int(11) default '0',
  `RetardoEtiqueta2` int(11) default '0',
  `FormatoTicket` int(11) default '0',
  `LineasFinTicket` int(11) default '0',
  `TicketPorEtiquetadora` int(11) default '0',
  `DestacarTexto` int(11) default '0',
  `ModoPublicidad` int(11) default '0',
  `DisplayPublicidad` tinyint(1) default '0',
  `ImagenPLU` tinyint(1) default '0',
  `TiempoEntradaPublicidadDD` int(11) default '5',
  `RecibirParametrosImpresion` tinyint(1) default '0',
  `Modificado` tinyint(1) default NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdConfiguracion`,`IdEmpresa`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_configuracion`
--


/*!40000 ALTER TABLE `dat_configuracion` DISABLE KEYS */;
LOCK TABLES `dat_configuracion` WRITE;
INSERT INTO `dat_configuracion` (`IdConfiguracion`, `NombreConfiguracion`, `IdModeloBalanza`, `Grupo`, `LimiteMayoristas`, `MovimientoDia`, `FinDia`, `MarcarMensajeEtiqueta`, `RegistroCompletoVentas`, `InformeComunicaciones`, `DevolucionPeso`, `FijarPrecio`, `PrecioLibre`, `PrecioDirecto`, `Multiplicacion`, `Resta`, `Suma`, `Subtotal`, `CalculoCambio`, `NumeroCliente`, `CodigoEnTicket`, `TaraEnTicket`, `DescuentoEnTicket`, `DescuentoEnLinea`, `IVAEnTicket`, `ConfiguracionTicket`, `LineasAnuladas`, `RedondeoTicket`, `UnArticulo`, `PapelAdhesivo`, `PesajeAutomatico`, `EtiquetaPorPesada`, `CentradoTextos`, `AcumularEnEtiqueta`, `ImprimirTextoG`, `TalonCaja`, `TalonCaja2`, `CopiaTicket`, `Reapertura`, `DosModosPago`, `CodigoBarrasSeccion`, `CodigoBarrasTicket`, `CodigoBarrasEtiqueta`, `LineaInterpretacionEAN`, `FormatoEAN13Ticket`, `EAN13Ticket`, `FormatoEAN13Etiqueta`, `EAN13Etiqueta`, `FormatoEAN128`, `VentaEscaner`, `LecturaEAN128`, `AnalisisComodines`, `UnidadesX1000`, `CifrasCodigo`, `Caducidad`, `Publicidad`, `ControlCajon`, `PrecioPorcentaje`, `ModoAutomatico`, `TemporizacionCodigo`, `MemorizarImporteCero`, `MemorizarPesoCero`, `CabeceraListados`, `ClaseDefecto`, `ControlPesoLote`, `AperturaCajonCero`, `TrazabilidadGenerica`, `IdPuntosFidelidad`, `PrecioSello`, `PrecioReferencia`, `NombreSello`, `CodigoSello`, `PuntosBonoRegalo`, `DiasSinActividad`, `Code25`, `Code25Checksum`, `ModoCheckweigher`, `CHKW_MargenInferior`, `CHKW_MargenSuperior`, `ModoTrabajo`, `SegundaEtiqueta`, `FormatoEtiqueta`, `FormatoEtiqueta2`, `RetardoEtiqueta2`, `FormatoTicket`, `LineasFinTicket`, `TicketPorEtiquetadora`, `DestacarTexto`, `ModoPublicidad`, `DisplayPublicidad`, `ImagenPLU`, `TiempoEntradaPublicidadDD`, `RecibirParametrosImpresion`, `Modificado`, `IdEmpresa`, `Operacion`, `Usuario`, `TimeStamp`) VALUES (1,'Default 500',20,'50','0.0000',0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,'',0,'',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,NULL,'0.0000','0.0000',NULL,0,0,0,'',NULL,0,'0.000','0.000',0,0,0,0,0,0,4,0,0,0,0,0,5,0,1,1,'M','admindfs','2011-05-25 14:44:54'),(2,'Default L',1,'50','0.0000',0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,'',0,'',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,NULL,0,0,NULL,'0.0000','0.0000','',0,0,0,'',NULL,0,'0.000','0.000',0,0,0,0,0,0,0,0,0,0,0,0,5,0,1,1,'M','admindfs','2011-06-29 15:02:57'),(3,'Default D900',40,'50','0.0000',0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,'0',0,'0',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,NULL,'0.0000','0.0000',NULL,0,0,0,'',NULL,0,'0.000','0.000',0,0,0,0,0,0,4,0,0,0,0,0,5,0,1,1,'M','admindfs','2013-05-06 08:15:36'),(101,'Boucherie',20,'50','0.0000',1,1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0,'',0,'',0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,NULL,'0.0000','0.0000',NULL,0,0,0,'',NULL,0,'0.000','0.000',0,0,0,0,0,0,4,0,0,0,0,0,5,0,1,1,'M','admin','2015-09-15 21:07:06');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_configuracion` ENABLE KEYS */;

--
-- Table structure for table `dat_configuracion_dfs`
--

DROP TABLE IF EXISTS `dat_configuracion_dfs`;
CREATE TABLE `dat_configuracion_dfs` (
  `SalirCom` int(11) default '0',
  `PermitirEdicionTiendaBalanza` tinyint(1) default '1',
  `NombresArticulo30Caracteres` tinyint(1) default '0',
  `TextosArticulo48Caracteres` tinyint(1) default '0',
  `TextoLibre3000Caracteres` tinyint(1) default '0',
  `ActivarScanner` tinyint(1) default '0',
  `GuardarSeleccionBalanzas` tinyint(1) default '0',
  `GenerarFicheroTxOffline` tinyint(1) default '0',
  `GenerarFicheroInventario` tinyint(1) default '0',
  `PathFicheroInventario` text,
  `GenerarFicheroCambioPrecio` tinyint(1) default '0',
  `PathFicheroCambioPrecio` text,
  `Usuario` varchar(20) default NULL,
  `IdEmpresa` int(11) NOT NULL,
  PRIMARY KEY  (`IdEmpresa`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_configuracion_dfs`
--


/*!40000 ALTER TABLE `dat_configuracion_dfs` DISABLE KEYS */;
LOCK TABLES `dat_configuracion_dfs` WRITE;
INSERT INTO `dat_configuracion_dfs` (`SalirCom`, `PermitirEdicionTiendaBalanza`, `NombresArticulo30Caracteres`, `TextosArticulo48Caracteres`, `TextoLibre3000Caracteres`, `ActivarScanner`, `GuardarSeleccionBalanzas`, `GenerarFicheroTxOffline`, `GenerarFicheroInventario`, `PathFicheroInventario`, `GenerarFicheroCambioPrecio`, `PathFicheroCambioPrecio`, `Usuario`, `IdEmpresa`) VALUES (0,1,1,0,0,0,0,0,0,'',0,'','admin',1);
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_configuracion_dfs` ENABLE KEYS */;

--
-- Table structure for table `dat_datadicional`
--

DROP TABLE IF EXISTS `dat_datadicional`;
CREATE TABLE `dat_datadicional` (
  `IdIndice` int(11) default NULL,
  `IdDatAdicional` varchar(30) NOT NULL,
  `ClaveDatAdicional` int(11) NOT NULL,
  `ValorDatAdicional` varchar(32) default NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdDatAdicional`,`ClaveDatAdicional`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guardan los distintos valores de los param';

--
-- Dumping data for table `dat_datadicional`
--


/*!40000 ALTER TABLE `dat_datadicional` DISABLE KEYS */;
LOCK TABLES `dat_datadicional` WRITE;
INSERT INTO `dat_datadicional` (`IdIndice`, `IdDatAdicional`, `ClaveDatAdicional`, `ValorDatAdicional`, `IdEmpresa`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`) VALUES (NULL,'Abattoirs',1,'FR46251001CE',1,0,'A','admin','2015-09-16 21:31:44'),(NULL,'Categorie',1,'Vache',1,0,'A','admin','2015-09-16 21:31:44'),(NULL,'Categorie',2,'Jeune Bovin',1,0,'A','admin','2015-09-16 21:31:44'),(NULL,'Categorie',3,'Veau ',1,0,'A','admin','2015-09-16 21:31:44'),(NULL,'Categorie',4,'Agneau',1,0,'A','admin','2015-09-16 21:31:44'),(NULL,'Categorie',5,'Porc',1,1,'M','admin','2015-09-19 14:00:44'),(NULL,'Eleve en',1,'France, Lot (46)',1,0,'M','admin','2015-09-16 21:31:44'),(NULL,'Pays Abattage',1,'France, Lot (46)',1,0,'M','admin','2015-09-16 21:31:44'),(NULL,'Pays de naissance',1,'France, Lot (46)',1,0,'M','admin','2015-09-16 21:31:44'),(NULL,'Race',1,'Blonde d\'Aquitaine',1,0,'A','admin','2015-09-16 21:31:44'),(NULL,'Race',2,'Limousine',1,0,'A','admin','2015-09-16 21:31:44'),(NULL,'Race',3,'Croisée',1,0,'A','admin','2015-09-16 21:31:44'),(NULL,'Type',1,'Viande',1,0,'A','admin','2015-09-16 21:31:44'),(NULL,'Type',2,'Laitier',1,0,'A','admin','2015-09-16 21:31:44'),(NULL,'Type',3,'Mixte',1,0,'A','admin','2015-09-16 21:31:44');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_datadicional` ENABLE KEYS */;

--
-- Table structure for table `dat_datadicional_t_b`
--

DROP TABLE IF EXISTS `dat_datadicional_t_b`;
CREATE TABLE `dat_datadicional_t_b` (
  `IdIndice` int(11) NOT NULL,
  `IdEmpresa` int(11) NOT NULL,
  `IdTienda` int(11) NOT NULL,
  `IdBalanza` int(11) NOT NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`,`IdIndice`),
  KEY `BusquedaDatosAdicionales` (`IdEmpresa`,`IdIndice`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `dat_datadicional_t_b`
--


/*!40000 ALTER TABLE `dat_datadicional_t_b` DISABLE KEYS */;
LOCK TABLES `dat_datadicional_t_b` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_datadicional_t_b` ENABLE KEYS */;

--
-- Table structure for table `dat_departamento`
--

DROP TABLE IF EXISTS `dat_departamento`;
CREATE TABLE `dat_departamento` (
  `IdDepartamento` int(11) NOT NULL,
  `NombreDepartamento` varchar(25) NOT NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdDepartamento`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guarda toda la informaci?n de los departamen';

--
-- Dumping data for table `dat_departamento`
--


/*!40000 ALTER TABLE `dat_departamento` DISABLE KEYS */;
LOCK TABLES `dat_departamento` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_departamento` ENABLE KEYS */;

--
-- Table structure for table `dat_detalle_elem_asociado`
--

DROP TABLE IF EXISTS `dat_detalle_elem_asociado`;
CREATE TABLE `dat_detalle_elem_asociado` (
  `IdElemAsociado` int(11) NOT NULL,
  `IdClase` int(11) NOT NULL,
  `IdParametro` int(11) NOT NULL,
  `Parametro` text,
  `IdDatAdicional` varchar(30) default NULL,
  `Valor` text COMMENT 'Valor introducido por el usuario',
  `Valor1` text COMMENT 'Valor introducido por el usuario de los ofertados en el combo (datos adicionales)',
  `IdEmpresa` int(11) NOT NULL default '1',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdElemAsociado`,`IdParametro`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guarda la informacion de los lotes de anim';

--
-- Dumping data for table `dat_detalle_elem_asociado`
--


/*!40000 ALTER TABLE `dat_detalle_elem_asociado` DISABLE KEYS */;
LOCK TABLES `dat_detalle_elem_asociado` WRITE;
INSERT INTO `dat_detalle_elem_asociado` (`IdElemAsociado`, `IdClase`, `IdParametro`, `Parametro`, `IdDatAdicional`, `Valor`, `Valor1`, `IdEmpresa`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`) VALUES (1,1,1,'Pays de Naissance','Pays de naissance','1','Pays de naissance-1',1,1,'M','admin','2015-09-19 14:00:24'),(1,1,2,'Pays d\'elevage','Eleve en','1','Eleve en-1',1,1,'M','admin','2015-09-19 14:00:24'),(1,1,3,'Pays d\'abattage','Pays Abattage','1','Pays Abattage-1',1,1,'M','admin','2015-09-19 14:00:24'),(1,1,4,'N° Abattoir','Abattoirs','1','Abattoirs-1',1,1,'M','admin','2015-09-19 14:00:24'),(1,1,5,'Race','Race','1','Race-1',1,1,'M','admin','2015-09-19 14:00:24'),(1,1,6,'Categorie','Categorie','1','Categorie-1',1,1,'M','admin','2015-09-19 14:00:24'),(1,1,7,'Type','Type','1','Type-1',1,1,'M','admin','2015-09-19 14:00:24');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_detalle_elem_asociado` ENABLE KEYS */;

--
-- Table structure for table `dat_divisas`
--

DROP TABLE IF EXISTS `dat_divisas`;
CREATE TABLE `dat_divisas` (
  `IdDivisa` int(11) NOT NULL,
  `Nombre` varchar(20) default NULL,
  `Simbolo` varchar(7) default NULL,
  `Cambio` decimal(6,3) default NULL,
  `DivisaActiva` tinyint(1) default '0',
  `IdEmpresa` int(11) NOT NULL default '1',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  UNIQUE KEY `IdEmpresa` (`IdEmpresa`,`IdDivisa`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_divisas`
--


/*!40000 ALTER TABLE `dat_divisas` DISABLE KEYS */;
LOCK TABLES `dat_divisas` WRITE;
INSERT INTO `dat_divisas` (`IdDivisa`, `Nombre`, `Simbolo`, `Cambio`, `DivisaActiva`, `IdEmpresa`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`) VALUES (0,'Corona Sueca','Skr','0.000',0,1,0,'A','admindfs','2010-09-07 12:49:25'),(1,'Yen','Y','0.000',0,1,0,'A','admindfs','2010-09-07 12:49:17'),(2,'Corona Noruega','Nkr','0.000',0,1,0,'A','admindfs','2010-09-07 12:49:17'),(3,'Libra','L','0.000',0,1,0,'A','admindfs','2010-09-07 12:49:18'),(4,'Euro','E','0.000',0,1,0,'A','admindfs','2010-11-09 11:43:17'),(5,'Dolar USA','$','0.000',0,1,0,'A','admindfs','2010-09-07 12:49:23'),(6,'Franco Suizo','SwF','0.000',0,1,0,'A','admindfs','2010-11-09 11:48:20'),(7,'Corona Danesa','DKr','0.000',0,1,0,'A','admindfs','2010-09-07 12:49:22');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_divisas` ENABLE KEYS */;

--
-- Table structure for table `dat_divisas_t_b`
--

DROP TABLE IF EXISTS `dat_divisas_t_b`;
CREATE TABLE `dat_divisas_t_b` (
  `IdDivisa` int(11) NOT NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `IdTienda` int(11) NOT NULL default '1',
  `IdBalanza` int(11) NOT NULL default '0',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`,`IdDivisa`),
  KEY `BusquedaDivisas` (`IdEmpresa`,`IdDivisa`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `dat_divisas_t_b`
--


/*!40000 ALTER TABLE `dat_divisas_t_b` DISABLE KEYS */;
LOCK TABLES `dat_divisas_t_b` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_divisas_t_b` ENABLE KEYS */;

--
-- Table structure for table `dat_elem_asociado`
--

DROP TABLE IF EXISTS `dat_elem_asociado`;
CREATE TABLE `dat_elem_asociado` (
  `IdElemAsociado` int(11) NOT NULL,
  `NombreElemAsociado` varchar(25) NOT NULL,
  `IdClase` int(11) NOT NULL,
  `Peso` double(15,3) default NULL,
  `FechaCreacion` datetime default NULL,
  `FechaCaducidad` datetime default NULL,
  `FechaMaduracion` datetime default NULL,
  `Texto1` text,
  `Peso1` double(15,3) default NULL,
  `Porcentaje1` double(9,3) default NULL,
  `Texto2` text,
  `Peso2` double(15,3) default NULL,
  `Porcentaje2` double(9,3) default NULL,
  `Texto3` text,
  `Peso3` double(15,3) default NULL,
  `Porcentaje3` double(9,3) default NULL,
  `Texto4` text,
  `Peso4` double(15,3) default NULL,
  `Porcentaje4` double(9,3) default NULL,
  `PesoLote` double(15,3) default NULL,
  `BandejasT` int(11) default '0',
  `BandejasE` int(11) default '0',
  `BandejasTE` int(11) default '0',
  `PesoVendidoT` double(15,3) default '0.000',
  `PesoVendidoE` double(15,3) default '0.000',
  `PesoVendidoTE` double(15,3) default '0.000',
  `ImporteVendidoT` double(15,3) default '0.000',
  `ImporteVendidoE` double(15,3) default '0.000',
  `ImporteVendidoTE` double(15,3) default '0.000',
  `Activo` tinyint(1) NOT NULL default '1',
  `IdEmpresa` int(11) NOT NULL default '1',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdElemAsociado`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guarda la informacion de los parametros';

--
-- Dumping data for table `dat_elem_asociado`
--


/*!40000 ALTER TABLE `dat_elem_asociado` DISABLE KEYS */;
LOCK TABLES `dat_elem_asociado` WRITE;
INSERT INTO `dat_elem_asociado` (`IdElemAsociado`, `NombreElemAsociado`, `IdClase`, `Peso`, `FechaCreacion`, `FechaCaducidad`, `FechaMaduracion`, `Texto1`, `Peso1`, `Porcentaje1`, `Texto2`, `Peso2`, `Porcentaje2`, `Texto3`, `Peso3`, `Porcentaje3`, `Texto4`, `Peso4`, `Porcentaje4`, `PesoLote`, `BandejasT`, `BandejasE`, `BandejasTE`, `PesoVendidoT`, `PesoVendidoE`, `PesoVendidoTE`, `ImporteVendidoT`, `ImporteVendidoE`, `ImporteVendidoTE`, `Activo`, `IdEmpresa`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`) VALUES (1,'H08247676',1,NULL,NULL,NULL,NULL,'',NULL,NULL,'',NULL,NULL,'',NULL,NULL,'',NULL,NULL,NULL,0,0,0,0.000,0.000,0.000,0.000,0.000,0.000,1,1,1,'M','admin','2015-09-19 14:00:24');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_elem_asociado` ENABLE KEYS */;

--
-- Table structure for table `dat_elem_asociado_t_b`
--

DROP TABLE IF EXISTS `dat_elem_asociado_t_b`;
CREATE TABLE `dat_elem_asociado_t_b` (
  `IdElemAsociado` int(11) NOT NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `IdTienda` int(11) NOT NULL default '1',
  `IdBalanza` int(11) NOT NULL default '0',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`,`IdElemAsociado`),
  KEY `BusquedaAnimales` (`IdEmpresa`,`IdElemAsociado`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `dat_elem_asociado_t_b`
--


/*!40000 ALTER TABLE `dat_elem_asociado_t_b` DISABLE KEYS */;
LOCK TABLES `dat_elem_asociado_t_b` WRITE;
INSERT INTO `dat_elem_asociado_t_b` (`IdElemAsociado`, `IdEmpresa`, `IdTienda`, `IdBalanza`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`) VALUES (1,1,1,3,1,'A','admin','2015-09-19 14:00:24');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_elem_asociado_t_b` ENABLE KEYS */;

--
-- Table structure for table `dat_empresa`
--

DROP TABLE IF EXISTS `dat_empresa`;
CREATE TABLE `dat_empresa` (
  `IdEmpresa` int(11) NOT NULL,
  `NombreEmpresa` varchar(100) NOT NULL,
  `CIF_VAT` varchar(14) default NULL,
  `Direccion` varchar(50) default NULL,
  `CodPostal` varchar(8) default NULL,
  `Poblacion` varchar(25) default NULL,
  `Provincia` varchar(25) default NULL,
  `Dir_IP` varchar(20) default NULL,
  `Dir_IP_Publica` varchar(20) default NULL,
  `Port` int(6) default NULL,
  `TipoBase` varchar(20) default NULL,
  `BaseDatos` varchar(50) default NULL,
  `UserDB` varchar(20) default NULL,
  `PasswDB` varchar(24) default NULL,
  `TimeOutConnection` int(4) default '15',
  `CodBarrasEtiquetas` int(11) default NULL,
  `CodBarrasTickets` int(11) default NULL,
  `CodBarrasPreenvasado` int(11) default NULL,
  `CodBarrasTalonCaja` int(11) default NULL,
  `FormatoEtiquetasUnitarias` int(11) default NULL,
  `FormatoEtiquetasPesadas` int(11) default NULL,
  `FormatoTickets` int(11) default NULL,
  `FormatoTalonCaja` int(11) default NULL,
  `FormatoFactura` int(11) default NULL,
  `FormatoAlbaran` int(11) default NULL,
  `NumReintentosComunicaciones` int(11) default '2',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guarda toda la informacion de las empresas';

--
-- Dumping data for table `dat_empresa`
--


/*!40000 ALTER TABLE `dat_empresa` DISABLE KEYS */;
LOCK TABLES `dat_empresa` WRITE;
INSERT INTO `dat_empresa` (`IdEmpresa`, `NombreEmpresa`, `CIF_VAT`, `Direccion`, `CodPostal`, `Poblacion`, `Provincia`, `Dir_IP`, `Dir_IP_Publica`, `Port`, `TipoBase`, `BaseDatos`, `UserDB`, `PasswDB`, `TimeOutConnection`, `CodBarrasEtiquetas`, `CodBarrasTickets`, `CodBarrasPreenvasado`, `CodBarrasTalonCaja`, `FormatoEtiquetasUnitarias`, `FormatoEtiquetasPesadas`, `FormatoTickets`, `FormatoTalonCaja`, `FormatoFactura`, `FormatoAlbaran`, `NumReintentosComunicaciones`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`) VALUES (1,'','','','','','','192.168.1.58','192.168.1.58',NULL,'','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,1,'M','admin','2015-09-16 23:02:54');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_empresa` ENABLE KEYS */;

--
-- Table structure for table `dat_esclava`
--

DROP TABLE IF EXISTS `dat_esclava`;
CREATE TABLE `dat_esclava` (
  `IdEsclava` int(11) NOT NULL,
  `IdBalanza` int(11) NOT NULL,
  `IdTienda` int(11) NOT NULL,
  `IdEmpresa` int(11) NOT NULL,
  `Nombre` varchar(50) default NULL,
  `BalanzaTradicional` tinyint(1) NOT NULL default '0',
  `IdDIBAL` varchar(20) default NULL,
  `EtiquetasGestionStock` tinyint(1) NOT NULL default '0',
  `Dir_IP` varchar(20) default NULL,
  `Port` int(6) default NULL,
  `TipoBase` varchar(20) default NULL,
  `BaseDatos` varchar(50) default NULL,
  `UserDB` varchar(20) default NULL,
  `PasswDB` varchar(24) default NULL,
  `TimeOutConnection` int(4) default '15',
  `CaducidadGlobal` tinyint(1) NOT NULL default '0',
  `FechaActivada` tinyint(1) NOT NULL default '1',
  `FechaCaducidad` datetime default NULL,
  `Dias` int(3) default '0',
  `Horas` int(3) default '0',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `Dir_IP_Publica` varchar(20) default NULL,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`,`IdEsclava`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guarda toda la informacion de las balanzas';

--
-- Dumping data for table `dat_esclava`
--


/*!40000 ALTER TABLE `dat_esclava` DISABLE KEYS */;
LOCK TABLES `dat_esclava` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_esclava` ENABLE KEYS */;

--
-- Table structure for table `dat_estado`
--

DROP TABLE IF EXISTS `dat_estado`;
CREATE TABLE `dat_estado` (
  `IdEstado` int(11) NOT NULL,
  `NombreEstado` varchar(25) NOT NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdEstado`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guardan los distintos estados que se pueden t';

--
-- Dumping data for table `dat_estado`
--


/*!40000 ALTER TABLE `dat_estado` DISABLE KEYS */;
LOCK TABLES `dat_estado` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_estado` ENABLE KEYS */;

--
-- Table structure for table `dat_etiqueta`
--

DROP TABLE IF EXISTS `dat_etiqueta`;
CREATE TABLE `dat_etiqueta` (
  `IdEtiqueta` int(11) NOT NULL,
  `NombreEtiqueta` varchar(255) default NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdEtiqueta`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guarda la informacion de las etiquetas. Ta';

--
-- Dumping data for table `dat_etiqueta`
--


/*!40000 ALTER TABLE `dat_etiqueta` DISABLE KEYS */;
LOCK TABLES `dat_etiqueta` WRITE;
INSERT INTO `dat_etiqueta` (`IdEtiqueta`, `NombreEtiqueta`, `IdEmpresa`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`) VALUES (4,'Ticket',1,0,'M','admin','2009-05-08 09:38:36'),(5,'etiquetaPesado',1,0,'M','admin','2009-05-08 09:38:37'),(6,'etiquetaUnitario',1,0,'A','admin','2009-05-08 09:38:37'),(7,'Ticket_en',1,0,'A','admin','2009-05-08 09:38:37'),(8,'etiquetaPesado_en',1,0,'A','admin','2009-05-08 09:38:37'),(9,'etiquetaUnitario_en',1,0,'A','admin','2009-05-08 09:38:37'),(10,'CounterFoil',1,0,'A','admin','2009-12-11 07:34:00'),(11,'CounterFoil_en',1,0,'A','admin','2010-03-23 07:50:54');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_etiqueta` ENABLE KEYS */;

--
-- Table structure for table `dat_exportacion`
--

DROP TABLE IF EXISTS `dat_exportacion`;
CREATE TABLE `dat_exportacion` (
  `IdExportacion` int(11) NOT NULL,
  `IdEmpresa` int(11) NOT NULL,
  `NombreExportacion` varchar(50) default NULL,
  `Activo` tinyint(1) NOT NULL default '1',
  `FicheroExportacion` varchar(1000) default NULL,
  `FicheroRx` tinyint(1) default '0' COMMENT '0: Fichero configurable, 1: FicheroRx',
  `FicheroTicket` tinyint(1) default '0' COMMENT '0: Todos los tickets a un fichero, 1: Cada ticket a un fichero.',
  `TipoLineas` tinyint(1) default '0' COMMENT '0:Ambos, 1:Ticket, 2:Etiqueta',
  `ConcaternarLineaATotal` int(11) default '0',
  `IdFtp` int(11) default '0',
  `DirectorioFtp` varchar(300) NOT NULL,
  `NumeroConsecutivo` int(11) NOT NULL default '0',
  `FechaUltimaExportacion` datetime default NULL,
  `FormatoRegistro` varchar(10) default NULL,
  `TipoFicheroExportacion` int(11) NOT NULL default '0',
  PRIMARY KEY  (`IdExportacion`,`IdEmpresa`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_exportacion`
--


/*!40000 ALTER TABLE `dat_exportacion` DISABLE KEYS */;
LOCK TABLES `dat_exportacion` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_exportacion` ENABLE KEYS */;

--
-- Table structure for table `dat_exportacion_campos`
--

DROP TABLE IF EXISTS `dat_exportacion_campos`;
CREATE TABLE `dat_exportacion_campos` (
  `IdExportacion` int(11) NOT NULL default '0',
  `IdEmpresa` int(11) NOT NULL default '1',
  `PosicionInicial` int(11) NOT NULL default '0',
  `Longitud` int(11) default NULL,
  `IdCampo` varchar(50) default NULL,
  `IdTipo` int(11) default NULL,
  `Valor` varchar(50) default NULL COMMENT 'Valor no reemplazable',
  `IdLugar` int(11) NOT NULL default '0' COMMENT '0:Cabecera, 1: L?neas, 2: Nombre fichero, 3: Extensi?n del fichero',
  PRIMARY KEY  (`IdExportacion`,`IdEmpresa`,`PosicionInicial`,`IdLugar`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_exportacion_campos`
--


/*!40000 ALTER TABLE `dat_exportacion_campos` DISABLE KEYS */;
LOCK TABLES `dat_exportacion_campos` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_exportacion_campos` ENABLE KEYS */;

--
-- Table structure for table `dat_exportacion_parametros`
--

DROP TABLE IF EXISTS `dat_exportacion_parametros`;
CREATE TABLE `dat_exportacion_parametros` (
  `IdParametro` int(11) NOT NULL,
  `Hora` datetime default NULL,
  PRIMARY KEY  (`IdParametro`),
  UNIQUE KEY `IdParametro` (`IdParametro`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_exportacion_parametros`
--


/*!40000 ALTER TABLE `dat_exportacion_parametros` DISABLE KEYS */;
LOCK TABLES `dat_exportacion_parametros` WRITE;
INSERT INTO `dat_exportacion_parametros` (`IdParametro`, `Hora`) VALUES (1,NULL),(2,NULL),(3,NULL),(4,NULL),(5,NULL);
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_exportacion_parametros` ENABLE KEYS */;

--
-- Table structure for table `dat_exportacion_parametros_general`
--

DROP TABLE IF EXISTS `dat_exportacion_parametros_general`;
CREATE TABLE `dat_exportacion_parametros_general` (
  `tipoExportacion` tinyint(1) default '0' COMMENT '0- Continua 1- Por horas',
  `ExportarBalanzasSeleccionadas` tinyint(1) default '0',
  `FinDia` tinyint(1) NOT NULL default '0',
  `HoraFinDia` datetime default NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

--
-- Dumping data for table `dat_exportacion_parametros_general`
--


/*!40000 ALTER TABLE `dat_exportacion_parametros_general` DISABLE KEYS */;
LOCK TABLES `dat_exportacion_parametros_general` WRITE;
INSERT INTO `dat_exportacion_parametros_general` (`tipoExportacion`, `ExportarBalanzasSeleccionadas`, `FinDia`, `HoraFinDia`) VALUES (0,1,0,'2015-09-16 23:00:00');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_exportacion_parametros_general` ENABLE KEYS */;

--
-- Table structure for table `dat_exportacion_tipo_campo`
--

DROP TABLE IF EXISTS `dat_exportacion_tipo_campo`;
CREATE TABLE `dat_exportacion_tipo_campo` (
  `IdTipo` int(11) NOT NULL,
  `GrupoTipo` varchar(50) NOT NULL,
  `GrupoNombre` varchar(50) NOT NULL default 'DATE',
  `IdEmpresa` int(11) NOT NULL default '1',
  `Formato` varchar(20) default '#',
  `Nombre` varchar(50) default NULL,
  `Basico` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`IdTipo`,`IdEmpresa`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_exportacion_tipo_campo`
--


/*!40000 ALTER TABLE `dat_exportacion_tipo_campo` DISABLE KEYS */;
LOCK TABLES `dat_exportacion_tipo_campo` WRITE;
INSERT INTO `dat_exportacion_tipo_campo` (`IdTipo`, `GrupoTipo`, `GrupoNombre`, `IdEmpresa`, `Formato`, `Nombre`, `Basico`) VALUES (-7,'ean_format','EAN',1,'#','2CCCCCCEEEEEQ',1),(-6,'decimal_percentage','DECIMAL',1,'2','Default',1),(-5,'no_replace','NOREPLACE',1,'#','Default',1),(-4,'decimal_weight','DECIMAL',1,'3','Default',1),(-3,'decimal_price','DECIMAL',1,'REGIONAL','Default',1),(-2,'numeric_format','INTEGER',1,'#','Default',1),(-1,'text_format','STRING',1,'#','Default',1),(1,'date_format','DATE',1,'DDMMYY','Short date',1),(2,'date_format','DATE',1,'JJJ','Julian date',1);
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_exportacion_tipo_campo` ENABLE KEYS */;

--
-- Table structure for table `dat_fin_de_dia`
--

DROP TABLE IF EXISTS `dat_fin_de_dia`;
CREATE TABLE `dat_fin_de_dia` (
  `IdEmpresa` int(11) NOT NULL,
  `IdTienda` int(11) NOT NULL,
  `IdBalanzaMaestra` int(11) NOT NULL,
  `IdFinDeDia` bigint(20) NOT NULL,
  `NumFinDeDia` bigint(20) default NULL,
  `Grupo` varchar(2) default NULL,
  `Borrado` varchar(1) default NULL COMMENT 'Indica si se tratade una transmision con o sin puesta a cero de los totalizadores. 0->Sin borrado. 1->Con borrado',
  `Clientes` int(11) default NULL COMMENT 'Numero de tickets de todo tipo. Total number of tickets.',
  `ImporteTotal` double(15,3) default NULL COMMENT 'Suma con signo de totales de tickets de todo tipo.',
  `ClientesMayoristas` int(11) default NULL COMMENT 'Numero de tickets de clientes mayoristas.',
  `ImporteMayoristas` double(15,3) default NULL COMMENT 'Suma de importes de totales de tickets de clientes mayoristas',
  `ClientesNegativos` int(11) default NULL COMMENT 'Numero de tickets negativos.',
  `ImporteNegativos` double(15,3) default NULL COMMENT 'Suma de importes de totales de tickets negativos',
  `ProductosPesados` int(11) default NULL COMMENT 'Numero de operaciones que implican pesaje',
  `ImportePesados` double(15,3) default NULL COMMENT 'Suma de las operaciones que implican pesaje',
  `ProductosNoPesados` int(11) default NULL COMMENT 'Numero de operaciones que no implican pesaje (sumas, restas, multiplicaciones).',
  `ImporteNoPesados` double(15,3) default NULL COMMENT 'Suma de las operaciones que no implican pesaje',
  `ProductosDevueltos` int(11) default NULL COMMENT 'Numero de operaciones que suponen retorno de mercancia (restas para productos no pesados, devoluciones para productos pesados).',
  `ImporteDevueltos` double(15,3) default NULL COMMENT 'Suma de las operaciones que suponen retorno de mercancia.',
  `Libres` varchar(19) default NULL,
  `Fecha` datetime default NULL,
  `Correcto` tinyint(1) default '0',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `Exportado` tinyint(1) NOT NULL default '0' COMMENT 'Acumulados no exportados. Se pone a 1 al exportarlos el RGI',
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanzaMaestra`,`IdFinDeDia`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guarda los fines de dIa recogidos de las L';

--
-- Dumping data for table `dat_fin_de_dia`
--


/*!40000 ALTER TABLE `dat_fin_de_dia` DISABLE KEYS */;
LOCK TABLES `dat_fin_de_dia` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_fin_de_dia` ENABLE KEYS */;

--
-- Table structure for table `dat_fin_de_dia_articulo`
--

DROP TABLE IF EXISTS `dat_fin_de_dia_articulo`;
CREATE TABLE `dat_fin_de_dia_articulo` (
  `IdEmpresa` int(11) NOT NULL default '1',
  `IdTienda` int(11) NOT NULL default '1',
  `IdBalanzaMaestra` int(11) NOT NULL default '0',
  `IdFinDeDia` bigint(20) NOT NULL default '0',
  `NumFinDeDia` bigint(20) default NULL,
  `IdArticulo` int(11) NOT NULL default '0',
  `Peso` double(15,3) default NULL,
  `Precio` double(15,3) default NULL,
  `Importe` double(15,3) default NULL,
  `ImporteSecundario` double(15,3) default NULL,
  `NumeroOperaciones` int(11) default NULL,
  `IdSeccion` int(11) default NULL COMMENT 'Id Seccion del articulo.\\r\\nSection ID of the article.',
  `EANScanner` varchar(20) default NULL COMMENT 'Codigo EANScanner del articulo.\\r\\nEANScanner code of the article.',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanzaMaestra`,`IdFinDeDia`,`IdArticulo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_fin_de_dia_articulo`
--


/*!40000 ALTER TABLE `dat_fin_de_dia_articulo` DISABLE KEYS */;
LOCK TABLES `dat_fin_de_dia_articulo` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_fin_de_dia_articulo` ENABLE KEYS */;

--
-- Table structure for table `dat_forma_pago`
--

DROP TABLE IF EXISTS `dat_forma_pago`;
CREATE TABLE `dat_forma_pago` (
  `IdFormaPago` int(11) NOT NULL,
  `Descripcion` varchar(50) default NULL,
  `Contado` tinyint(1) default '0',
  `AperturaCajon` tinyint(1) default '0',
  `IdEmpresa` int(11) NOT NULL default '1',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdFormaPago`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guarda toda la informacion de las posibles';

--
-- Dumping data for table `dat_forma_pago`
--


/*!40000 ALTER TABLE `dat_forma_pago` DISABLE KEYS */;
LOCK TABLES `dat_forma_pago` WRITE;
INSERT INTO `dat_forma_pago` (`IdFormaPago`, `Descripcion`, `Contado`, `AperturaCajon`, `IdEmpresa`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`) VALUES (1,'Contado',1,1,1,0,'M','Admin','2008-03-05 08:14:45'),(2,'Tarjeta/Cheque',2,0,1,0,'M','admin','2008-10-09 13:59:44'),(3,'Credito',2,0,1,0,'M','Admin','2008-10-09 13:59:52'),(4,'A cuenta',3,0,1,0,'M','Admin','2008-10-09 13:59:59'),(5,'Otros',1,1,1,0,'M','Admin','2007-05-15 09:57:21');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_forma_pago` ENABLE KEYS */;

--
-- Table structure for table `dat_ftp`
--

DROP TABLE IF EXISTS `dat_ftp`;
CREATE TABLE `dat_ftp` (
  `IdFtp` int(11) NOT NULL,
  `IdEmpresa` int(11) NOT NULL,
  `NombreFtp` varchar(100) NOT NULL,
  `ServidorFtp` varchar(100) NOT NULL,
  `PuertoFtp` int(11) default '21',
  `UsuarioFtp` varchar(100) NOT NULL,
  `Password` varchar(100) NOT NULL,
  `Modificado` tinyint(1) default NULL COMMENT '0 No modificado, 1 Modificado\r\n0 Not modified , 1 Modified',
  `Operacion` char(1) default NULL COMMENT 'A=Alta, M=Modificado, B=Borrado\r\nA=New, M=Modified, B=Deleted',
  `Usuario` varchar(20) default NULL COMMENT 'Usuario de creacion del ticket.\r\nUser creation of the receipt.',
  `TimeStamp` timestamp NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP COMMENT 'Fecha y hora de la ultima modificacion del registro.\r\nDate and time of the last change of the register.',
  PRIMARY KEY  (`IdFtp`,`IdEmpresa`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_ftp`
--


/*!40000 ALTER TABLE `dat_ftp` DISABLE KEYS */;
LOCK TABLES `dat_ftp` WRITE;
INSERT INTO `dat_ftp` (`IdFtp`, `IdEmpresa`, `NombreFtp`, `ServidorFtp`, `PuertoFtp`, `UsuarioFtp`, `Password`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`) VALUES (0,1,'','',21,'','',0,'A','dgi','2012-10-18 07:46:43');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_ftp` ENABLE KEYS */;

--
-- Table structure for table `dat_ftp_carpeta`
--

DROP TABLE IF EXISTS `dat_ftp_carpeta`;
CREATE TABLE `dat_ftp_carpeta` (
  `IdCarpetaLocal` int(11) NOT NULL,
  `IdFtp` int(11) default '0',
  `DirectorioFtp` varchar(300) NOT NULL,
  PRIMARY KEY  (`IdCarpetaLocal`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_ftp_carpeta`
--


/*!40000 ALTER TABLE `dat_ftp_carpeta` DISABLE KEYS */;
LOCK TABLES `dat_ftp_carpeta` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_ftp_carpeta` ENABLE KEYS */;

--
-- Table structure for table `dat_grupo_articulos`
--

DROP TABLE IF EXISTS `dat_grupo_articulos`;
CREATE TABLE `dat_grupo_articulos` (
  `IdGrupo` int(11) NOT NULL,
  `NombreGrupo` varchar(50) NOT NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdGrupo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_grupo_articulos`
--


/*!40000 ALTER TABLE `dat_grupo_articulos` DISABLE KEYS */;
LOCK TABLES `dat_grupo_articulos` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_grupo_articulos` ENABLE KEYS */;

--
-- Table structure for table `dat_grupo_cabeceras`
--

DROP TABLE IF EXISTS `dat_grupo_cabeceras`;
CREATE TABLE `dat_grupo_cabeceras` (
  `IdEmpresa` int(11) NOT NULL,
  `IdGrupo` int(11) NOT NULL,
  `Descripcion` varchar(50) default NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdGrupo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_grupo_cabeceras`
--


/*!40000 ALTER TABLE `dat_grupo_cabeceras` DISABLE KEYS */;
LOCK TABLES `dat_grupo_cabeceras` WRITE;
INSERT INTO `dat_grupo_cabeceras` (`IdEmpresa`, `IdGrupo`, `Descripcion`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`) VALUES (1,0,'Default',0,'A','admindfs','2015-09-16 21:31:44');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_grupo_cabeceras` ENABLE KEYS */;

--
-- Table structure for table `dat_grupo_cabeceras_t_b`
--

DROP TABLE IF EXISTS `dat_grupo_cabeceras_t_b`;
CREATE TABLE `dat_grupo_cabeceras_t_b` (
  `IdEmpresa` int(11) NOT NULL,
  `IdTienda` int(11) NOT NULL,
  `IdBalanza` int(11) NOT NULL,
  `IdFormato` int(11) NOT NULL,
  `IdGrupo` int(11) default NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`,`IdFormato`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_grupo_cabeceras_t_b`
--


/*!40000 ALTER TABLE `dat_grupo_cabeceras_t_b` DISABLE KEYS */;
LOCK TABLES `dat_grupo_cabeceras_t_b` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_grupo_cabeceras_t_b` ENABLE KEYS */;

--
-- Table structure for table `dat_grupo_macros`
--

DROP TABLE IF EXISTS `dat_grupo_macros`;
CREATE TABLE `dat_grupo_macros` (
  `IdEmpresa` int(11) NOT NULL,
  `IdGrupo` int(11) NOT NULL,
  `NombreGrupo` varchar(50) default NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdGrupo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_grupo_macros`
--


/*!40000 ALTER TABLE `dat_grupo_macros` DISABLE KEYS */;
LOCK TABLES `dat_grupo_macros` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_grupo_macros` ENABLE KEYS */;

--
-- Table structure for table `dat_grupo_pantallas`
--

DROP TABLE IF EXISTS `dat_grupo_pantallas`;
CREATE TABLE `dat_grupo_pantallas` (
  `IdEmpresa` int(11) NOT NULL default '1',
  `IdGrupo` int(11) NOT NULL,
  `IdPantalla` int(11) NOT NULL,
  `IdPublicidad` int(11) NOT NULL,
  PRIMARY KEY  (`IdEmpresa`,`IdGrupo`,`IdPantalla`,`IdPublicidad`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_grupo_pantallas`
--


/*!40000 ALTER TABLE `dat_grupo_pantallas` DISABLE KEYS */;
LOCK TABLES `dat_grupo_pantallas` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_grupo_pantallas` ENABLE KEYS */;

--
-- Table structure for table `dat_grupo_publicidad_grafica`
--

DROP TABLE IF EXISTS `dat_grupo_publicidad_grafica`;
CREATE TABLE `dat_grupo_publicidad_grafica` (
  `IdGrupo` int(11) NOT NULL,
  `NombreGrupo` varchar(50) NOT NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdGrupo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_grupo_publicidad_grafica`
--


/*!40000 ALTER TABLE `dat_grupo_publicidad_grafica` DISABLE KEYS */;
LOCK TABLES `dat_grupo_publicidad_grafica` WRITE;
INSERT INTO `dat_grupo_publicidad_grafica` (`IdGrupo`, `NombreGrupo`, `IdEmpresa`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`) VALUES (0,'Default g.',1,0,'A','admindfs','2011-12-22 09:42:59');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_grupo_publicidad_grafica` ENABLE KEYS */;

--
-- Table structure for table `dat_grupo_vendedores`
--

DROP TABLE IF EXISTS `dat_grupo_vendedores`;
CREATE TABLE `dat_grupo_vendedores` (
  `IdGrupo` int(11) NOT NULL,
  `NombreGrupo` varchar(50) NOT NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdGrupo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_grupo_vendedores`
--


/*!40000 ALTER TABLE `dat_grupo_vendedores` DISABLE KEYS */;
LOCK TABLES `dat_grupo_vendedores` WRITE;
INSERT INTO `dat_grupo_vendedores` (`IdGrupo`, `NombreGrupo`, `IdEmpresa`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`) VALUES (0,'Default group',1,0,'A','admindfs','2011-06-10 10:43:41');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_grupo_vendedores` ENABLE KEYS */;

--
-- Table structure for table `dat_importacion`
--

DROP TABLE IF EXISTS `dat_importacion`;
CREATE TABLE `dat_importacion` (
  `IdImportacion` int(11) NOT NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `NombreImportacion` varchar(50) default NULL,
  `Activo` tinyint(1) NOT NULL default '1',
  `LineaInicio` int(11) default '0',
  `FicheroImportacion` varchar(1000) default NULL,
  `TextoImportacion` varchar(20000) default NULL,
  `TipoFichero` varchar(20) default 'ARTICLES',
  `TipoOperacion` varchar(20) default 'COMBINE',
  `SeparadorCampos` varchar(1) default NULL,
  `IdFtp` int(11) default '0',
  `DirectorioFtp` varchar(300) NOT NULL,
  `FicheroFtp` varchar(100) default NULL,
  `FicheroRegular` text,
  `DirectorioProcesado` text,
  `FicheroProcesado` varchar(100) default NULL,
  `DefectoProcesado` int(11) default '1',
  `SeccionMasCodigo` int(11) default '0',
  `NivelXml` int(11) default '2',
  `TipoImagen` varchar(20) default 'ARTICLE',
  PRIMARY KEY  (`IdImportacion`,`IdEmpresa`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_importacion`
--


/*!40000 ALTER TABLE `dat_importacion` DISABLE KEYS */;
LOCK TABLES `dat_importacion` WRITE;
INSERT INTO `dat_importacion` (`IdImportacion`, `IdEmpresa`, `NombreImportacion`, `Activo`, `LineaInicio`, `FicheroImportacion`, `TextoImportacion`, `TipoFichero`, `TipoOperacion`, `SeparadorCampos`, `IdFtp`, `DirectorioFtp`, `FicheroFtp`, `FicheroRegular`, `DirectorioProcesado`, `FicheroProcesado`, `DefectoProcesado`, `SeccionMasCodigo`, `NivelXml`, `TipoImagen`) VALUES (1,1,'Imports Article',1,1,'G:\\Fiche articles PLU.csv','Code;PLU;Nom1;Format Etiquette;Jour Péremption;Tare Fixe;Text 1;Text 2;Text 3;Text 9;Text 10\n1;1;RUMSTECK;21;15;0,01;;;;;Concerver entre 2 et 4 degrés\n2;2;BAVETTE;21;15;0,01;;;;;Concerver entre 2 et 4 degrés\n3;3;BASSE COTE;21;15;0,01;;;;;Concerver entre 2 et 4 degrés','ARTICLES','DELETE',';',0,'','','Fiche articles PLU.csv','C:\\Program Files (x86)\\DFS\\RGI\\Processed files','yyyyMMddHHmmss_*.*',1,0,2,'ARTICLE');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_importacion` ENABLE KEYS */;

--
-- Table structure for table `dat_importacion_campos`
--

DROP TABLE IF EXISTS `dat_importacion_campos`;
CREATE TABLE `dat_importacion_campos` (
  `IdImportacion` int(11) default NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `PosicionInicial` int(11) default NULL,
  `CampoInicial` varchar(50) default NULL,
  `Longitud` int(11) default NULL,
  `IdCampo` varchar(50) default NULL,
  `IdTipo` varchar(50) default NULL,
  `IdCodigoTipoCampo` int(11) default NULL,
  `IdGrupoArticulo` varchar(1000) default NULL,
  `PosicionInicialPadre` int(11) default NULL,
  `CampoInicialPadre` varchar(50) default NULL,
  `Orden` int(11) default '0',
  `LongitudCodigo` varchar(1) default NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_importacion_campos`
--


/*!40000 ALTER TABLE `dat_importacion_campos` DISABLE KEYS */;
LOCK TABLES `dat_importacion_campos` WRITE;
INSERT INTO `dat_importacion_campos` (`IdImportacion`, `IdEmpresa`, `PosicionInicial`, `CampoInicial`, `Longitud`, `IdCampo`, `IdTipo`, `IdCodigoTipoCampo`, `IdGrupoArticulo`, `PosicionInicialPadre`, `CampoInicialPadre`, `Orden`, `LongitudCodigo`) VALUES (1,1,0,'',1,'IdArticulo','INTEGER',-2,'',NULL,'',0,''),(1,1,1,'',1,'TeclaDirecta','INTEGER',-2,'',NULL,'',0,''),(1,1,2,'',8,'Descripcion','STRING',-1,'',NULL,'',0,''),(1,1,3,'',2,'FormatoEtiquetaSerieL','STRING',-1,'',NULL,'',0,''),(1,1,4,'',2,'FechaCaducidad','DATE_DDMMYY',-11,'',NULL,'',0,''),(1,1,5,'',4,'TaraFija','DECIMAL_3',-6,'',NULL,'',0,''),(1,1,6,'',0,'Texto1','STRING',-1,'',NULL,'',0,''),(1,1,7,'',0,'Texto2','STRING',-1,'',NULL,'',0,''),(1,1,8,'',0,'Texto3','STRING',-1,'',NULL,'',0,''),(1,1,9,'',0,'Texto9','STRING',-1,'',NULL,'',0,''),(1,1,10,'',29,'Texto10','STRING',-1,'',NULL,'',0,'');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_importacion_campos` ENABLE KEYS */;

--
-- Table structure for table `dat_importacion_parametros`
--

DROP TABLE IF EXISTS `dat_importacion_parametros`;
CREATE TABLE `dat_importacion_parametros` (
  `HoraInicio` datetime default NULL,
  `HoraFin` datetime default NULL,
  `CicloCompletoFichero` int(11) NOT NULL default '0',
  `ImportarBalanzasSeleccionadas` tinyint(1) default '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_importacion_parametros`
--


/*!40000 ALTER TABLE `dat_importacion_parametros` DISABLE KEYS */;
LOCK TABLES `dat_importacion_parametros` WRITE;
INSERT INTO `dat_importacion_parametros` (`HoraInicio`, `HoraFin`, `CicloCompletoFichero`, `ImportarBalanzasSeleccionadas`) VALUES (NULL,NULL,1,1);
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_importacion_parametros` ENABLE KEYS */;

--
-- Table structure for table `dat_importacion_tipo_campo`
--

DROP TABLE IF EXISTS `dat_importacion_tipo_campo`;
CREATE TABLE `dat_importacion_tipo_campo` (
  `IdCodigo` int(11) NOT NULL,
  `GrupoTipo` varchar(50) NOT NULL,
  `IdTipo` varchar(50) NOT NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `Basico` tinyint(1) NOT NULL default '0',
  `Nombre` varchar(20) default NULL,
  PRIMARY KEY  (`IdCodigo`,`IdEmpresa`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_importacion_tipo_campo`
--


/*!40000 ALTER TABLE `dat_importacion_tipo_campo` DISABLE KEYS */;
LOCK TABLES `dat_importacion_tipo_campo` WRITE;
INSERT INTO `dat_importacion_tipo_campo` (`IdCodigo`, `GrupoTipo`, `IdTipo`, `IdEmpresa`, `Basico`, `Nombre`) VALUES (-16,'decimal_price','DECIMAL_0',1,1,NULL),(-15,'decimal_price','DECIMAL_3',1,1,NULL),(-14,'decimal_price','DECIMAL_1',1,1,NULL),(-13,'ean_format','STRING',1,1,NULL),(-12,'time_format','TIME',1,1,NULL),(-11,'date_format','DATE_DDMMYY',1,1,NULL),(-10,'date_format','DATE_YYYYMMDD',1,1,NULL),(-9,'upload_flag','FLAG_UPLOAD',1,1,NULL),(-8,'delete_flag','FLAG_DELETE',1,1,NULL),(-7,'decimal_price','DECIMAL_REGIONAL',1,1,NULL),(-6,'decimal_weight','DECIMAL_3',1,1,NULL),(-5,'decimal_price','DECIMAL_2',1,1,NULL),(-4,'decimal_price','DECIMAL_.',1,1,NULL),(-3,'decimal_price','DECIMAL_,',1,1,NULL),(-2,'numeric_format','INTEGER',1,1,NULL),(-1,'text_format','STRING',1,1,NULL),(1,'ean_format','EAN_nCCCCCEEEEEE',1,0,'nCCCCCEEEEEE'),(2,'ean_format','EAN_nnCCCCEEEEEE',1,0,'nnCCCCEEEEEE'),(3,'ean_format','EAN_nnKKCCCEEEEE',1,0,'nnKKCCCEEEEE');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_importacion_tipo_campo` ENABLE KEYS */;

--
-- Table structure for table `dat_ingrediente`
--

DROP TABLE IF EXISTS `dat_ingrediente`;
CREATE TABLE `dat_ingrediente` (
  `CodigoIngrediente` int(11) NOT NULL,
  `NumeroLineaIngrediente` int(11) NOT NULL,
  `TextoIngrediente` text,
  PRIMARY KEY  (`CodigoIngrediente`,`NumeroLineaIngrediente`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_ingrediente`
--


/*!40000 ALTER TABLE `dat_ingrediente` DISABLE KEYS */;
LOCK TABLES `dat_ingrediente` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_ingrediente` ENABLE KEYS */;

--
-- Table structure for table `dat_ingredientes_seccion`
--

DROP TABLE IF EXISTS `dat_ingredientes_seccion`;
CREATE TABLE `dat_ingredientes_seccion` (
  `IdSeccion` int(11) NOT NULL,
  `IdIngredienteSeccion` int(11) NOT NULL,
  `Descripcion` text,
  `TextoIngrediente` text,
  PRIMARY KEY  (`IdSeccion`,`IdIngredienteSeccion`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

--
-- Dumping data for table `dat_ingredientes_seccion`
--


/*!40000 ALTER TABLE `dat_ingredientes_seccion` DISABLE KEYS */;
LOCK TABLES `dat_ingredientes_seccion` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_ingredientes_seccion` ENABLE KEYS */;

--
-- Table structure for table `dat_iva`
--

DROP TABLE IF EXISTS `dat_iva`;
CREATE TABLE `dat_iva` (
  `IdIVA` int(11) NOT NULL,
  `PorcentajeIVA` decimal(9,2) NOT NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdIVA`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guarda toda la informacion de los distinto';

--
-- Dumping data for table `dat_iva`
--


/*!40000 ALTER TABLE `dat_iva` DISABLE KEYS */;
LOCK TABLES `dat_iva` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_iva` ENABLE KEYS */;

--
-- Table structure for table `dat_iva_t_b`
--

DROP TABLE IF EXISTS `dat_iva_t_b`;
CREATE TABLE `dat_iva_t_b` (
  `IdIVA` int(11) NOT NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `IdTienda` int(11) NOT NULL default '1',
  `IdBalanza` int(11) NOT NULL default '0',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`,`IdIVA`),
  KEY `BusquedaIVAs` (`IdEmpresa`,`IdIVA`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `dat_iva_t_b`
--


/*!40000 ALTER TABLE `dat_iva_t_b` DISABLE KEYS */;
LOCK TABLES `dat_iva_t_b` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_iva_t_b` ENABLE KEYS */;

--
-- Table structure for table `dat_logos_articulo`
--

DROP TABLE IF EXISTS `dat_logos_articulo`;
CREATE TABLE `dat_logos_articulo` (
  `IdEmpresa` int(11) NOT NULL,
  `IdLogo` int(11) NOT NULL,
  `TipoLogo` int(11) default NULL,
  `NombreLogo` varchar(100) default NULL,
  `Bmp` longblob,
  `Orden500` int(11) default NULL,
  `Bmp500` longblob,
  `AjusteBmp500` int(11) default NULL,
  `Ancho500` int(11) default NULL,
  `Alto500` int(11) default NULL,
  `OrdenL` int(11) default NULL,
  `BmpL` longblob,
  `AjusteBmpL` int(11) default NULL,
  `AnchoL` int(11) default NULL,
  `AltoL` int(11) default NULL,
  `Activo` int(11) NOT NULL default '1',
  `OrdenStar` int(11) default NULL,
  `BmpStar` longblob,
  `AnchoStar` int(11) default NULL,
  `AltoStar` int(11) default NULL,
  `OrdenD900_12` int(11) default NULL,
  `BmpD900_12` longblob,
  `AnchoD900_12` int(11) default NULL,
  `AltoD900_12` int(11) default NULL,
  `OrdenD900_15` int(11) default NULL,
  `BmpD900_15` longblob,
  `AnchoD900_15` int(11) default NULL,
  `AltoD900_15` int(11) default NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdLogo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_logos_articulo`
--


/*!40000 ALTER TABLE `dat_logos_articulo` DISABLE KEYS */;
LOCK TABLES `dat_logos_articulo` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_logos_articulo` ENABLE KEYS */;

--
-- Table structure for table `dat_logos_articulo_t_b`
--

DROP TABLE IF EXISTS `dat_logos_articulo_t_b`;
CREATE TABLE `dat_logos_articulo_t_b` (
  `IdLogo` int(11) NOT NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `IdTienda` int(11) NOT NULL default '1',
  `IdBalanza` int(11) NOT NULL default '0',
  `Modificado` tinyint(1) default NULL COMMENT '0 No modificado, 1 Modificado\r\n0 Not modified , 1 Modified',
  `Operacion` char(1) default NULL COMMENT 'A=Alta, M=Modificado, B=Borrado\r\nA=New, M=Modified, B=Deleted',
  `Usuario` varchar(20) default NULL COMMENT 'Usuario de creacion del logo.\r\nUser creation of the logo.',
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP COMMENT 'Fecha y hora de la ultima modificacion del registro.\r\nDate and time of the last change of the register.',
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`,`IdLogo`),
  KEY `BusquedaLogos` (`IdEmpresa`,`IdLogo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='Tabla donde se guarda la asociacion entre balanzas de una';

--
-- Dumping data for table `dat_logos_articulo_t_b`
--


/*!40000 ALTER TABLE `dat_logos_articulo_t_b` DISABLE KEYS */;
LOCK TABLES `dat_logos_articulo_t_b` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_logos_articulo_t_b` ENABLE KEYS */;

--
-- Table structure for table `dat_logos_impresion`
--

DROP TABLE IF EXISTS `dat_logos_impresion`;
CREATE TABLE `dat_logos_impresion` (
  `IdEmpresa` int(11) NOT NULL,
  `IdLogo` int(11) NOT NULL,
  `TipoLogo` int(11) default NULL,
  `NombreLogo` varchar(100) default NULL,
  `Bmp` longblob,
  `Orden500` int(11) default NULL,
  `Bmp500` longblob,
  `AjusteBmp500` int(11) default NULL,
  `Ancho500` int(11) default NULL,
  `Alto500` int(11) default NULL,
  `OrdenL` int(11) default NULL,
  `BmpL` longblob,
  `AjusteBmpL` int(11) default NULL,
  `AnchoL` int(11) default NULL,
  `AltoL` int(11) default NULL,
  `Activo` int(11) NOT NULL default '1',
  `OrdenStar` int(11) default NULL,
  `BmpStar` longblob,
  `AnchoStar` int(11) default NULL,
  `AltoStar` int(11) default NULL,
  `OrdenD900_12` int(11) default NULL,
  `BmpD900_12` longblob,
  `AnchoD900_12` int(11) default NULL,
  `AltoD900_12` int(11) default NULL,
  `OrdenD900_15` int(11) default NULL,
  `BmpD900_15` longblob,
  `AnchoD900_15` int(11) default NULL,
  `AltoD900_15` int(11) default NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdLogo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_logos_impresion`
--


/*!40000 ALTER TABLE `dat_logos_impresion` DISABLE KEYS */;
LOCK TABLES `dat_logos_impresion` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_logos_impresion` ENABLE KEYS */;

--
-- Table structure for table `dat_logos_inicio`
--

DROP TABLE IF EXISTS `dat_logos_inicio`;
CREATE TABLE `dat_logos_inicio` (
  `IdEmpresa` int(11) NOT NULL,
  `IdLogo` int(11) NOT NULL,
  `TipoLogo` int(11) default NULL,
  `NombreLogo` varchar(100) default NULL,
  `Bmp` longblob,
  `Orden500` int(11) default NULL,
  `Bmp500` longblob,
  `AjusteBmp500` int(11) default NULL,
  `Ancho500` int(11) default NULL,
  `Alto500` int(11) default NULL,
  `OrdenL` int(11) default NULL,
  `BmpL` longblob,
  `AjusteBmpL` int(11) default NULL,
  `AnchoL` int(11) default NULL,
  `AltoL` int(11) default NULL,
  `Activo` int(11) NOT NULL default '1',
  `OrdenStar` int(11) default NULL,
  `BmpStar` longblob,
  `AnchoStar` int(11) default NULL,
  `AltoStar` int(11) default NULL,
  `OrdenD900_12` int(11) default NULL,
  `BmpD900_12` longblob,
  `AnchoD900_12` int(11) default NULL,
  `AltoD900_12` int(11) default NULL,
  `OrdenD900_15` int(11) default NULL,
  `BmpD900_15` longblob,
  `AnchoD900_15` int(11) default NULL,
  `AltoD900_15` int(11) default NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdLogo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_logos_inicio`
--


/*!40000 ALTER TABLE `dat_logos_inicio` DISABLE KEYS */;
LOCK TABLES `dat_logos_inicio` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_logos_inicio` ENABLE KEYS */;

--
-- Table structure for table `dat_logos_publicidad`
--

DROP TABLE IF EXISTS `dat_logos_publicidad`;
CREATE TABLE `dat_logos_publicidad` (
  `IdEmpresa` int(11) NOT NULL,
  `IdLogo` int(11) NOT NULL,
  `TipoLogo` int(11) default NULL,
  `NombreLogo` varchar(100) default NULL,
  `Bmp` longblob,
  `Orden500` int(11) default NULL,
  `Bmp500` longblob,
  `AjusteBmp500` int(11) default NULL,
  `Ancho500` int(11) default NULL,
  `Alto500` int(11) default NULL,
  `OrdenL` int(11) default NULL,
  `BmpL` longblob,
  `AjusteBmpL` int(11) default NULL,
  `AnchoL` int(11) default NULL,
  `AltoL` int(11) default NULL,
  `Activo` int(11) NOT NULL default '1',
  `OrdenStar` int(11) default NULL,
  `BmpStar` longblob,
  `AnchoStar` int(11) default NULL,
  `AltoStar` int(11) default NULL,
  `OrdenD900_12` int(11) default NULL,
  `BmpD900_12` longblob,
  `AnchoD900_12` int(11) default NULL,
  `AltoD900_12` int(11) default NULL,
  `OrdenD900_15` int(11) default NULL,
  `BmpD900_15` longblob,
  `AnchoD900_15` int(11) default NULL,
  `AltoD900_15` int(11) default NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdLogo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_logos_publicidad`
--


/*!40000 ALTER TABLE `dat_logos_publicidad` DISABLE KEYS */;
LOCK TABLES `dat_logos_publicidad` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_logos_publicidad` ENABLE KEYS */;

--
-- Table structure for table `dat_macro`
--

DROP TABLE IF EXISTS `dat_macro`;
CREATE TABLE `dat_macro` (
  `IdEmpresa` int(11) NOT NULL,
  `IdMacro` int(11) NOT NULL,
  `NombreMacro` varchar(50) default NULL,
  `Tecla` varchar(20) default NULL,
  `Password` varchar(20) default NULL,
  `Combinacion` varchar(500) default NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdMacro`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_macro`
--


/*!40000 ALTER TABLE `dat_macro` DISABLE KEYS */;
LOCK TABLES `dat_macro` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_macro` ENABLE KEYS */;

--
-- Table structure for table `dat_macro_inter`
--

DROP TABLE IF EXISTS `dat_macro_inter`;
CREATE TABLE `dat_macro_inter` (
  `IdEmpresa` int(11) NOT NULL,
  `IdGrupo` int(11) NOT NULL,
  `IdMacro` int(11) NOT NULL,
  `NumeroMacro` int(11) default NULL,
  PRIMARY KEY  (`IdEmpresa`,`IdGrupo`,`IdMacro`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_macro_inter`
--


/*!40000 ALTER TABLE `dat_macro_inter` DISABLE KEYS */;
LOCK TABLES `dat_macro_inter` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_macro_inter` ENABLE KEYS */;

--
-- Table structure for table `dat_macro_t_b`
--

DROP TABLE IF EXISTS `dat_macro_t_b`;
CREATE TABLE `dat_macro_t_b` (
  `IdEmpresa` int(11) NOT NULL,
  `IdTienda` int(11) NOT NULL,
  `IdBalanza` int(11) NOT NULL,
  `IdMacro` int(11) NOT NULL,
  `NumeroMacro` int(11) NOT NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`,`IdMacro`,`NumeroMacro`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_macro_t_b`
--


/*!40000 ALTER TABLE `dat_macro_t_b` DISABLE KEYS */;
LOCK TABLES `dat_macro_t_b` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_macro_t_b` ENABLE KEYS */;

--
-- Table structure for table `dat_mensajes`
--

DROP TABLE IF EXISTS `dat_mensajes`;
CREATE TABLE `dat_mensajes` (
  `IdEmpresa` int(11) NOT NULL,
  `IdTienda` int(11) NOT NULL,
  `IdBalanza` int(11) NOT NULL,
  `IdMensaje` int(11) NOT NULL,
  `Texto` varchar(200) default NULL,
  `Enviado` tinyint(1) default NULL,
  `Recibido` tinyint(1) default NULL,
  `Fecha` datetime default NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`,`IdMensaje`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_mensajes`
--


/*!40000 ALTER TABLE `dat_mensajes` DISABLE KEYS */;
LOCK TABLES `dat_mensajes` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_mensajes` ENABLE KEYS */;

--
-- Table structure for table `dat_numero_ticket`
--

DROP TABLE IF EXISTS `dat_numero_ticket`;
CREATE TABLE `dat_numero_ticket` (
  `IdEmpresa` int(11) NOT NULL,
  `IdNumTicket` int(11) NOT NULL,
  `NombreNumTicket` varchar(50) default NULL,
  `NumeroFinDia` int(11) default NULL,
  `NumeroTicket` int(11) default NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdNumTicket`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_numero_ticket`
--


/*!40000 ALTER TABLE `dat_numero_ticket` DISABLE KEYS */;
LOCK TABLES `dat_numero_ticket` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_numero_ticket` ENABLE KEYS */;

--
-- Table structure for table `dat_nutricional_inter`
--

DROP TABLE IF EXISTS `dat_nutricional_inter`;
CREATE TABLE `dat_nutricional_inter` (
  `CodigoNutricional` int(11) NOT NULL,
  `Cantidad` double(15,3) default '0.000',
  `Unidad` varchar(20) default '',
  `ParteEnteraMedida` int(11) default '0',
  `ParteDecimalMedida` varchar(20) default '',
  `Medida` varchar(50) default '',
  `ValorEnergetico` double(15,3) default '0.000',
  `ValorEnergeticoPorcentual` double(15,3) default '0.000',
  `Carbohidratos` double(15,3) default '0.000',
  `CarbohidratosPorcentual` double(15,3) default '0.000',
  `Proteinas` double(15,3) default '0.000',
  `ProteinasPorcentual` double(15,3) default '0.000',
  `GrasasTotales` double(15,3) default '0.000',
  `GrasasTotalesPorcentual` double(15,3) default '0.000',
  `GrasasSaturadas` double(15,3) default '0.000',
  `GrasasSaturadasPorcentual` double(15,3) default '0.000',
  `GrasasTrans` double(15,3) default '0.000',
  `GrasasTransPorcentual` double(15,3) default '0.000',
  `FibraAlimentar` double(15,3) default '0.000',
  `FibraAlimentarPorcentual` double(15,3) default '0.000',
  `Sodio` double(15,3) default '0.000',
  `SodioPorcentual` double(15,3) default '0.000',
  `Modificado` int(11) default '0',
  `TextoNutricional1_1` varchar(100) default NULL,
  `TextoNutricional1_2` varchar(100) default NULL,
  `TextoNutricional2_1` varchar(100) default NULL,
  `TextoNutricional2_2` varchar(100) default NULL,
  `TextoNutricional3_1` varchar(100) default NULL,
  `TextoNutricional3_2` varchar(100) default NULL,
  `TextoNutricional4_1` varchar(100) default NULL,
  `TextoNutricional4_2` varchar(100) default NULL,
  `TextoNutricional5_1` varchar(100) default NULL,
  `TextoNutricional5_2` varchar(100) default NULL,
  `TextoNutricional6_1` varchar(100) default NULL,
  `TextoNutricional6_2` varchar(100) default NULL,
  `TextoNutricional7_1` varchar(100) default NULL,
  `TextoNutricional7_2` varchar(100) default NULL,
  `TextoNutricional8_1` varchar(100) default NULL,
  `TextoNutricional8_2` varchar(100) default NULL,
  `TextoNutricional9_1` varchar(100) default NULL,
  `TextoNutricional9_2` varchar(100) default NULL,
  `TextoNutricional10_1` varchar(100) default NULL,
  `TextoNutricional10_2` varchar(100) default NULL,
  `TextoNutricional11_1` varchar(100) default NULL,
  `TextoNutricional11_2` varchar(100) default NULL,
  `TextoNutricional12_1` varchar(100) default NULL,
  `TextoNutricional12_2` varchar(100) default NULL,
  `TextoNutricional13_1` varchar(100) default NULL,
  `TextoNutricional13_2` varchar(100) default NULL,
  `TextoNutricional14_1` varchar(100) default NULL,
  `TextoNutricional14_2` varchar(100) default NULL,
  PRIMARY KEY  (`CodigoNutricional`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_nutricional_inter`
--


/*!40000 ALTER TABLE `dat_nutricional_inter` DISABLE KEYS */;
LOCK TABLES `dat_nutricional_inter` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_nutricional_inter` ENABLE KEYS */;

--
-- Table structure for table `dat_nutricionales_preguntas`
--

DROP TABLE IF EXISTS `dat_nutricionales_preguntas`;
CREATE TABLE `dat_nutricionales_preguntas` (
  `IdEmpresa` int(11) NOT NULL,
  `IdPregunta` int(11) NOT NULL,
  `Pregunta` varchar(100) default NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdPregunta`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_nutricionales_preguntas`
--


/*!40000 ALTER TABLE `dat_nutricionales_preguntas` DISABLE KEYS */;
LOCK TABLES `dat_nutricionales_preguntas` WRITE;
INSERT INTO `dat_nutricionales_preguntas` (`IdEmpresa`, `IdPregunta`, `Pregunta`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`) VALUES (1,1,'Informacion Nutricional',0,'A','admindfs','2012-11-27 11:05:56'),(1,2,'Valor Energetico',0,'A','admindfs','2012-11-27 11:06:10'),(1,3,'Grasas',0,'A','admindfs','2012-11-27 11:06:31'),(1,4,'Acidos Grasos Saturados',0,'A','admindfs','2012-11-27 11:06:44'),(1,5,'Hidratos de carbono',0,'A','admindfs','2012-11-27 11:07:07'),(1,6,'Azucares',0,'A','admindfs','2012-11-27 11:07:27'),(1,7,'Proteinas',0,'A','admindfs','2012-11-27 11:07:39'),(1,8,'Sal',0,'A','admindfs','2012-11-27 11:07:46'),(1,9,'Fibra alimentaria',0,'A','admindfs','2012-11-27 11:07:55'),(1,10,'Vitamina A',0,'A','admindfs','2012-11-27 11:08:04'),(1,11,'Vitamina C',0,'A','admindfs','2012-11-27 11:08:19'),(1,12,'Calcio',0,'A','admindfs','2012-11-27 11:08:31'),(1,13,'Hierro',0,'A','admindfs','2012-11-27 11:08:39'),(1,14,'Vitamina',0,'A','admindfs','2012-11-27 11:08:48');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_nutricionales_preguntas` ENABLE KEYS */;

--
-- Table structure for table `dat_nutricionales_preguntas_t_b`
--

DROP TABLE IF EXISTS `dat_nutricionales_preguntas_t_b`;
CREATE TABLE `dat_nutricionales_preguntas_t_b` (
  `IdEmpresa` int(11) NOT NULL,
  `IdTienda` int(11) NOT NULL,
  `IdBalanza` int(11) NOT NULL,
  `IdPregunta` int(11) NOT NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`,`IdPregunta`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_nutricionales_preguntas_t_b`
--


/*!40000 ALTER TABLE `dat_nutricionales_preguntas_t_b` DISABLE KEYS */;
LOCK TABLES `dat_nutricionales_preguntas_t_b` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_nutricionales_preguntas_t_b` ENABLE KEYS */;

--
-- Table structure for table `dat_ofertas_temporales`
--

DROP TABLE IF EXISTS `dat_ofertas_temporales`;
CREATE TABLE `dat_ofertas_temporales` (
  `IdOfertaTemporal` int(11) NOT NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `NombreOfertaTemporal` varchar(50) NOT NULL default '',
  `FechaInicio` datetime default NULL,
  `FechaFin` datetime default NULL,
  `Dias` varchar(20) default '1, 2, 3, 4, 5, 6, 7',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdOfertaTemporal`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_ofertas_temporales`
--


/*!40000 ALTER TABLE `dat_ofertas_temporales` DISABLE KEYS */;
LOCK TABLES `dat_ofertas_temporales` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_ofertas_temporales` ENABLE KEYS */;

--
-- Table structure for table `dat_ofertas_temporales_t_b`
--

DROP TABLE IF EXISTS `dat_ofertas_temporales_t_b`;
CREATE TABLE `dat_ofertas_temporales_t_b` (
  `IdOfertaTemporal` int(11) NOT NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `IdTienda` int(11) NOT NULL default '1',
  `IdBalanza` int(11) NOT NULL default '0',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`,`IdOfertaTemporal`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_ofertas_temporales_t_b`
--


/*!40000 ALTER TABLE `dat_ofertas_temporales_t_b` DISABLE KEYS */;
LOCK TABLES `dat_ofertas_temporales_t_b` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_ofertas_temporales_t_b` ENABLE KEYS */;

--
-- Table structure for table `dat_param_clase`
--

DROP TABLE IF EXISTS `dat_param_clase`;
CREATE TABLE `dat_param_clase` (
  `IdClase` int(11) NOT NULL,
  `IdParametro` int(11) NOT NULL,
  `Parametro` text,
  `IdDatAdicional` varchar(30) default NULL,
  `Orden` int(11) default NULL,
  `CodigoIA` varchar(10) default NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdClase`,`IdParametro`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guardan los parametros que puede tomar una cl';

--
-- Dumping data for table `dat_param_clase`
--


/*!40000 ALTER TABLE `dat_param_clase` DISABLE KEYS */;
LOCK TABLES `dat_param_clase` WRITE;
INSERT INTO `dat_param_clase` (`IdClase`, `IdParametro`, `Parametro`, `IdDatAdicional`, `Orden`, `CodigoIA`, `IdEmpresa`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`) VALUES (1,1,'Pays de Naissance','Pays de naissance',1,'',1,0,'M','admin','2015-09-15 20:26:06'),(1,2,'Pays d\'elevage','Eleve en',2,'',1,0,'M','admin','2015-09-15 20:26:06'),(1,3,'Pays d\'abattage','Pays Abattage',3,'',1,0,'M','admin','2015-09-15 20:26:06'),(1,4,'N° Abattoir','Abattoirs',4,'',1,0,'M','admin','2015-09-15 20:26:06'),(1,5,'Race','Race',5,'',1,0,'M','admin','2015-09-15 20:26:06'),(1,6,'Categorie','Categorie',6,'',1,0,'A','admin','2015-09-15 20:34:07'),(1,7,'Type','Type',7,'',1,0,'A','admin','2015-09-15 20:34:07');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_param_clase` ENABLE KEYS */;

--
-- Table structure for table `dat_param_clase_t_b`
--

DROP TABLE IF EXISTS `dat_param_clase_t_b`;
CREATE TABLE `dat_param_clase_t_b` (
  `IdClase` int(11) NOT NULL,
  `IdParametro` int(11) NOT NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `IdTienda` int(11) NOT NULL default '1',
  `IdBalanza` int(11) NOT NULL default '0',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`,`IdClase`,`IdParametro`),
  KEY `BusquedaClases` (`IdEmpresa`,`IdClase`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `dat_param_clase_t_b`
--


/*!40000 ALTER TABLE `dat_param_clase_t_b` DISABLE KEYS */;
LOCK TABLES `dat_param_clase_t_b` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_param_clase_t_b` ENABLE KEYS */;

--
-- Table structure for table `dat_programacion`
--

DROP TABLE IF EXISTS `dat_programacion`;
CREATE TABLE `dat_programacion` (
  `IdEmpresa` int(11) NOT NULL,
  `IdProgramacion` int(11) NOT NULL,
  `NombreProgramacion` varchar(50) default NULL,
  `Fecha` datetime default NULL,
  `Repeticion` int(11) default NULL,
  `TiempoRepeticion` time default NULL,
  `Activa` tinyint(1) default NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdProgramacion`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_programacion`
--


/*!40000 ALTER TABLE `dat_programacion` DISABLE KEYS */;
LOCK TABLES `dat_programacion` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_programacion` ENABLE KEYS */;

--
-- Table structure for table `dat_programacion_balanzas`
--

DROP TABLE IF EXISTS `dat_programacion_balanzas`;
CREATE TABLE `dat_programacion_balanzas` (
  `IdEmpresa` int(11) NOT NULL,
  `IdTienda` int(11) NOT NULL,
  `IdBalanza` int(11) NOT NULL,
  `IdProgramacion` int(11) NOT NULL,
  `IdAccion` int(11) NOT NULL default '0',
  `Orden` int(11) default NULL,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`,`IdProgramacion`,`IdAccion`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_programacion_balanzas`
--


/*!40000 ALTER TABLE `dat_programacion_balanzas` DISABLE KEYS */;
LOCK TABLES `dat_programacion_balanzas` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_programacion_balanzas` ENABLE KEYS */;

--
-- Table structure for table `dat_publicidad_alfanumerica`
--

DROP TABLE IF EXISTS `dat_publicidad_alfanumerica`;
CREATE TABLE `dat_publicidad_alfanumerica` (
  `IdPublicidad` int(11) NOT NULL,
  `NombrePublicidad` varchar(20) default NULL,
  `Texto1` varchar(119) default NULL,
  `Ritmo1` int(11) default NULL,
  `Texto2` varchar(119) default NULL,
  `Ritmo2` int(11) default NULL,
  `Texto3` varchar(119) default NULL,
  `Ritmo3` int(11) default NULL,
  `Texto4` varchar(119) default NULL,
  `Ritmo4` int(11) default NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `IdEmpresa` int(11) NOT NULL,
  `Usuario` varchar(50) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdPublicidad`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_publicidad_alfanumerica`
--


/*!40000 ALTER TABLE `dat_publicidad_alfanumerica` DISABLE KEYS */;
LOCK TABLES `dat_publicidad_alfanumerica` WRITE;
INSERT INTO `dat_publicidad_alfanumerica` (`IdPublicidad`, `NombrePublicidad`, `Texto1`, `Ritmo1`, `Texto2`, `Ritmo2`, `Texto3`, `Ritmo3`, `Texto4`, `Ritmo4`, `Modificado`, `Operacion`, `IdEmpresa`, `Usuario`, `TimeStamp`) VALUES (0,'Default a.',NULL,1,NULL,1,NULL,1,NULL,1,0,'A',1,'admindfs','2011-06-22 09:02:03');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_publicidad_alfanumerica` ENABLE KEYS */;

--
-- Table structure for table `dat_publicidad_alfanumerica_t_b`
--

DROP TABLE IF EXISTS `dat_publicidad_alfanumerica_t_b`;
CREATE TABLE `dat_publicidad_alfanumerica_t_b` (
  `IdPublicidad` int(11) NOT NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `IdTienda` int(11) NOT NULL default '1',
  `IdBalanza` int(11) NOT NULL default '0',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`,`IdPublicidad`),
  KEY `BusquedaPublicidad` (`IdEmpresa`,`IdPublicidad`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `dat_publicidad_alfanumerica_t_b`
--


/*!40000 ALTER TABLE `dat_publicidad_alfanumerica_t_b` DISABLE KEYS */;
LOCK TABLES `dat_publicidad_alfanumerica_t_b` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_publicidad_alfanumerica_t_b` ENABLE KEYS */;

--
-- Table structure for table `dat_publicidad_grafica`
--

DROP TABLE IF EXISTS `dat_publicidad_grafica`;
CREATE TABLE `dat_publicidad_grafica` (
  `IdNumeroPantalla` int(11) NOT NULL,
  `NombrePublicidad` varchar(20) default NULL,
  `IdFont` int(11) default NULL,
  `IdLogo` int(11) default NULL,
  `Temporizacion` int(11) default NULL,
  `Texto1` varchar(50) default NULL,
  `Efecto1` int(11) default NULL,
  `Texto2` varchar(50) default NULL,
  `Efecto2` int(11) default NULL,
  `Texto3` varchar(50) default NULL,
  `Efecto3` int(11) default NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `IdEmpresa` int(11) NOT NULL,
  `Usuario` varchar(50) default NULL,
  `TimeStamp` timestamp NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdNumeroPantalla`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_publicidad_grafica`
--


/*!40000 ALTER TABLE `dat_publicidad_grafica` DISABLE KEYS */;
LOCK TABLES `dat_publicidad_grafica` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_publicidad_grafica` ENABLE KEYS */;

--
-- Table structure for table `dat_publicidad_grafica_simple`
--

DROP TABLE IF EXISTS `dat_publicidad_grafica_simple`;
CREATE TABLE `dat_publicidad_grafica_simple` (
  `IdEmpresa` int(11) NOT NULL,
  `IdPublicidad` int(11) NOT NULL,
  `NombrePublicidad` varchar(50) default NULL,
  `IdTipo` int(11) default NULL,
  `Escena1Texto1` varchar(50) default NULL,
  `Escena1Texto2` varchar(50) default NULL,
  `Escena1Texto3` varchar(50) default NULL,
  `Escena2Texto1` varchar(50) default NULL,
  `Escena2Texto2` varchar(50) default NULL,
  `Escena2Texto3` varchar(50) default NULL,
  `Escena3Texto1` varchar(50) default NULL,
  `Escena3Texto2` varchar(50) default NULL,
  `Escena3Texto3` varchar(50) default NULL,
  `Escena4Texto1` varchar(50) default NULL,
  `Escena4Texto2` varchar(50) default NULL,
  `Escena4Texto3` varchar(50) default NULL,
  `Escena5Texto1` varchar(50) default NULL,
  `Escena5Texto2` varchar(50) default NULL,
  `Escena5Texto3` varchar(50) default NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdPublicidad`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_publicidad_grafica_simple`
--


/*!40000 ALTER TABLE `dat_publicidad_grafica_simple` DISABLE KEYS */;
LOCK TABLES `dat_publicidad_grafica_simple` WRITE;
INSERT INTO `dat_publicidad_grafica_simple` (`IdEmpresa`, `IdPublicidad`, `NombrePublicidad`, `IdTipo`, `Escena1Texto1`, `Escena1Texto2`, `Escena1Texto3`, `Escena2Texto1`, `Escena2Texto2`, `Escena2Texto3`, `Escena3Texto1`, `Escena3Texto2`, `Escena3Texto3`, `Escena4Texto1`, `Escena4Texto2`, `Escena4Texto3`, `Escena5Texto1`, `Escena5Texto2`, `Escena5Texto3`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`) VALUES (1,0,'Default g.',1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'A','admindfs','2012-10-02 14:26:06');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_publicidad_grafica_simple` ENABLE KEYS */;

--
-- Table structure for table `dat_publicidad_grafica_simple_t_b`
--

DROP TABLE IF EXISTS `dat_publicidad_grafica_simple_t_b`;
CREATE TABLE `dat_publicidad_grafica_simple_t_b` (
  `IdPublicidad` int(11) NOT NULL,
  `IdEmpresa` int(11) NOT NULL,
  `IdTienda` int(11) NOT NULL,
  `IdBalanza` int(11) NOT NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`,`IdPublicidad`),
  KEY `BusquedaPublicidad` (`IdEmpresa`,`IdPublicidad`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `dat_publicidad_grafica_simple_t_b`
--


/*!40000 ALTER TABLE `dat_publicidad_grafica_simple_t_b` DISABLE KEYS */;
LOCK TABLES `dat_publicidad_grafica_simple_t_b` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_publicidad_grafica_simple_t_b` ENABLE KEYS */;

--
-- Table structure for table `dat_publicidad_grafica_t_b`
--

DROP TABLE IF EXISTS `dat_publicidad_grafica_t_b`;
CREATE TABLE `dat_publicidad_grafica_t_b` (
  `IdPublicidad` int(11) NOT NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `IdTienda` int(11) NOT NULL default '1',
  `IdBalanza` int(11) NOT NULL default '0',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`,`IdPublicidad`),
  KEY `BusquedaPublicidad` (`IdEmpresa`,`IdPublicidad`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `dat_publicidad_grafica_t_b`
--


/*!40000 ALTER TABLE `dat_publicidad_grafica_t_b` DISABLE KEYS */;
LOCK TABLES `dat_publicidad_grafica_t_b` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_publicidad_grafica_t_b` ENABLE KEYS */;

--
-- Table structure for table `dat_puntos_fidelidad`
--

DROP TABLE IF EXISTS `dat_puntos_fidelidad`;
CREATE TABLE `dat_puntos_fidelidad` (
  `IdPuntosFidelidad` int(11) NOT NULL,
  `PuntosFidelidad` int(11) default NULL,
  `TextoPuntosFidelidad` varchar(50) default NULL,
  `IdEmpresa` int(11) NOT NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(50) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdPuntosFidelidad`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_puntos_fidelidad`
--


/*!40000 ALTER TABLE `dat_puntos_fidelidad` DISABLE KEYS */;
LOCK TABLES `dat_puntos_fidelidad` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_puntos_fidelidad` ENABLE KEYS */;

--
-- Table structure for table `dat_puntos_fidelidad_t_b`
--

DROP TABLE IF EXISTS `dat_puntos_fidelidad_t_b`;
CREATE TABLE `dat_puntos_fidelidad_t_b` (
  `IdPuntosFidelidad` int(11) NOT NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `IdTienda` int(11) NOT NULL default '1',
  `IdBalanza` int(11) NOT NULL default '0',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`,`IdPuntosFidelidad`),
  KEY `BusquedaPuntosFidelidad` (`IdEmpresa`,`IdPuntosFidelidad`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `dat_puntos_fidelidad_t_b`
--


/*!40000 ALTER TABLE `dat_puntos_fidelidad_t_b` DISABLE KEYS */;
LOCK TABLES `dat_puntos_fidelidad_t_b` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_puntos_fidelidad_t_b` ENABLE KEYS */;

--
-- Table structure for table `dat_pwd_balanza`
--

DROP TABLE IF EXISTS `dat_pwd_balanza`;
CREATE TABLE `dat_pwd_balanza` (
  `IdPwd` int(11) NOT NULL,
  `Tipo` int(11) NOT NULL default '1',
  `PwdActual` varchar(10) default NULL,
  `PwdNuevo` varchar(10) default NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdPwd`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_pwd_balanza`
--


/*!40000 ALTER TABLE `dat_pwd_balanza` DISABLE KEYS */;
LOCK TABLES `dat_pwd_balanza` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_pwd_balanza` ENABLE KEYS */;

--
-- Table structure for table `dat_receta`
--

DROP TABLE IF EXISTS `dat_receta`;
CREATE TABLE `dat_receta` (
  `IdReceta` int(11) NOT NULL,
  `ModoTitulo` tinyint(1) NOT NULL default '0',
  `FuenteTitulo` tinyint(1) NOT NULL default '0',
  `MagnificacionTitulo` tinyint(2) NOT NULL default '0',
  `TextoTitulo` varchar(50) default NULL,
  `ModoLineas` tinyint(1) NOT NULL default '0',
  `FuenteLineas` tinyint(1) NOT NULL default '0',
  `MagnificacionLineas` tinyint(2) NOT NULL default '0',
  `ModoLogo` tinyint(4) NOT NULL default '0',
  `IdLogo` int(11) default NULL,
  `RotacionLogo` tinyint(1) NOT NULL default '0',
  `IdEmpresa` int(11) NOT NULL default '1',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdReceta`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_receta`
--


/*!40000 ALTER TABLE `dat_receta` DISABLE KEYS */;
LOCK TABLES `dat_receta` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_receta` ENABLE KEYS */;

--
-- Table structure for table `dat_receta_lineas`
--

DROP TABLE IF EXISTS `dat_receta_lineas`;
CREATE TABLE `dat_receta_lineas` (
  `IdReceta` int(11) NOT NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `NumeroLinea` int(11) NOT NULL,
  `TextoLinea` varchar(100) default NULL,
  PRIMARY KEY  (`IdReceta`,`IdEmpresa`,`NumeroLinea`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_receta_lineas`
--


/*!40000 ALTER TABLE `dat_receta_lineas` DISABLE KEYS */;
LOCK TABLES `dat_receta_lineas` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_receta_lineas` ENABLE KEYS */;

--
-- Table structure for table `dat_receta_t_b`
--

DROP TABLE IF EXISTS `dat_receta_t_b`;
CREATE TABLE `dat_receta_t_b` (
  `IdReceta` int(11) NOT NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `IdTienda` int(11) NOT NULL default '1',
  `IdBalanza` int(11) NOT NULL default '0',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`,`IdReceta`),
  KEY `BusquedaRecetas` (`IdEmpresa`,`IdReceta`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `dat_receta_t_b`
--


/*!40000 ALTER TABLE `dat_receta_t_b` DISABLE KEYS */;
LOCK TABLES `dat_receta_t_b` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_receta_t_b` ENABLE KEYS */;

--
-- Table structure for table `dat_seccion`
--

DROP TABLE IF EXISTS `dat_seccion`;
CREATE TABLE `dat_seccion` (
  `IdSeccion` int(11) NOT NULL,
  `NombreSeccion` varchar(50) NOT NULL default '',
  `TeclaDirecta` int(11) default NULL,
  `Prefijo` int(11) default NULL,
  `IdLogo` int(11) default NULL,
  `IdCodBarras` int(11) default NULL,
  `IdEAN128` int(11) default NULL,
  `PermitirVenta` int(11) NOT NULL default '0',
  `IdEmpresa` int(11) NOT NULL default '1',
  `Modificado` tinyint(1) default NULL,
  `ModificadoCodBarras` tinyint(1) default NULL,
  `ModificadoEAN128` tinyint(1) default NULL,
  `ModificadoPermitirVenta` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdSeccion`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guarda la informacion de las secciones. Ta';

--
-- Dumping data for table `dat_seccion`
--


/*!40000 ALTER TABLE `dat_seccion` DISABLE KEYS */;
LOCK TABLES `dat_seccion` WRITE;
INSERT INTO `dat_seccion` (`IdSeccion`, `NombreSeccion`, `TeclaDirecta`, `Prefijo`, `IdLogo`, `IdCodBarras`, `IdEAN128`, `PermitirVenta`, `IdEmpresa`, `Modificado`, `ModificadoCodBarras`, `ModificadoEAN128`, `ModificadoPermitirVenta`, `Operacion`, `Usuario`, `TimeStamp`) VALUES (0,'Default section',NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,NULL,'A','admindfs','2015-09-16 21:31:43');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_seccion` ENABLE KEYS */;

--
-- Table structure for table `dat_seccion_t_b`
--

DROP TABLE IF EXISTS `dat_seccion_t_b`;
CREATE TABLE `dat_seccion_t_b` (
  `IdSeccion` int(11) NOT NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `IdTienda` int(11) NOT NULL default '1',
  `IdBalanza` int(11) NOT NULL default '0',
  `Modificado` tinyint(1) default NULL,
  `ModificadoCodBarras` tinyint(1) default NULL,
  `ModificadoEAN128` tinyint(1) default NULL,
  `ModificadoPermitirVenta` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`,`IdSeccion`),
  KEY `BusquedaSecciones` (`IdEmpresa`,`IdSeccion`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `dat_seccion_t_b`
--


/*!40000 ALTER TABLE `dat_seccion_t_b` DISABLE KEYS */;
LOCK TABLES `dat_seccion_t_b` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_seccion_t_b` ENABLE KEYS */;

--
-- Table structure for table `dat_seriel_registros_tmp`
--

DROP TABLE IF EXISTS `dat_seriel_registros_tmp`;
CREATE TABLE `dat_seriel_registros_tmp` (
  `IdEmpresa` int(11) NOT NULL,
  `IdTienda` int(11) NOT NULL,
  `IdBalanzaMaestra` int(11) NOT NULL,
  `NumTicket` int(11) NOT NULL,
  `TipoRegistro` varchar(2) NOT NULL,
  `NumTramo` int(11) NOT NULL,
  `NumMensajeTramo` int(11) NOT NULL,
  `Registro` varchar(130) default NULL,
  `TicketCompleto` tinyint(1) default '0',
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanzaMaestra`,`NumTicket`,`TipoRegistro`,`NumTramo`,`NumMensajeTramo`),
  KEY `TipoRegistro` (`IdEmpresa`,`IdTienda`,`IdBalanzaMaestra`,`NumTicket`,`TipoRegistro`),
  KEY `Balanza` (`IdEmpresa`,`IdTienda`,`IdBalanzaMaestra`),
  KEY `NumTicket` (`IdEmpresa`,`IdTienda`,`IdBalanzaMaestra`,`NumTicket`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guarda los registros de la L que todavia no s';

--
-- Dumping data for table `dat_seriel_registros_tmp`
--


/*!40000 ALTER TABLE `dat_seriel_registros_tmp` DISABLE KEYS */;
LOCK TABLES `dat_seriel_registros_tmp` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_seriel_registros_tmp` ENABLE KEYS */;

--
-- Table structure for table `dat_tabla_teclas_vendedor`
--

DROP TABLE IF EXISTS `dat_tabla_teclas_vendedor`;
CREATE TABLE `dat_tabla_teclas_vendedor` (
  `IdEmpresa` int(11) NOT NULL,
  `IdTabla` int(11) NOT NULL,
  `NombreTabla` varchar(100) default NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdTabla`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_tabla_teclas_vendedor`
--


/*!40000 ALTER TABLE `dat_tabla_teclas_vendedor` DISABLE KEYS */;
LOCK TABLES `dat_tabla_teclas_vendedor` WRITE;
INSERT INTO `dat_tabla_teclas_vendedor` (`IdEmpresa`, `IdTabla`, `NombreTabla`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`) VALUES (1,1,'Ferme des Pays Bourian',1,'A','admin','2015-09-15 17:36:12'),(1,2,'Bruno Belivent',1,'A','admin','2015-09-15 17:36:23');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_tabla_teclas_vendedor` ENABLE KEYS */;

--
-- Table structure for table `dat_taras`
--

DROP TABLE IF EXISTS `dat_taras`;
CREATE TABLE `dat_taras` (
  `IdTara` int(11) NOT NULL,
  `Tara` decimal(5,3) NOT NULL,
  `IdEmpresa` int(11) NOT NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdTara`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_taras`
--


/*!40000 ALTER TABLE `dat_taras` DISABLE KEYS */;
LOCK TABLES `dat_taras` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_taras` ENABLE KEYS */;

--
-- Table structure for table `dat_taras_seccion`
--

DROP TABLE IF EXISTS `dat_taras_seccion`;
CREATE TABLE `dat_taras_seccion` (
  `IdSeccion` int(11) NOT NULL,
  `IdTaraSeccion` int(11) NOT NULL,
  `TaraFija` decimal(11,3) default NULL,
  PRIMARY KEY  (`IdSeccion`,`IdTaraSeccion`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

--
-- Dumping data for table `dat_taras_seccion`
--


/*!40000 ALTER TABLE `dat_taras_seccion` DISABLE KEYS */;
LOCK TABLES `dat_taras_seccion` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_taras_seccion` ENABLE KEYS */;

--
-- Table structure for table `dat_taras_t_b`
--

DROP TABLE IF EXISTS `dat_taras_t_b`;
CREATE TABLE `dat_taras_t_b` (
  `IdTara` int(11) NOT NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `IdTienda` int(11) NOT NULL default '1',
  `IdBalanza` int(11) NOT NULL default '0',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`,`IdTara`),
  KEY `BusquedaTaras` (`IdEmpresa`,`IdTara`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

--
-- Dumping data for table `dat_taras_t_b`
--


/*!40000 ALTER TABLE `dat_taras_t_b` DISABLE KEYS */;
LOCK TABLES `dat_taras_t_b` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_taras_t_b` ENABLE KEYS */;

--
-- Table structure for table `dat_teclado_tradicional`
--

DROP TABLE IF EXISTS `dat_teclado_tradicional`;
CREATE TABLE `dat_teclado_tradicional` (
  `IdEmpresa` int(11) NOT NULL,
  `IdTeclado` int(11) NOT NULL,
  `NombreTeclado` varchar(100) default NULL,
  `TipoTeclado` int(11) NOT NULL,
  `MargenSuperior` decimal(11,3) default NULL,
  `MargenInferior` decimal(11,3) default NULL,
  `MargenIzquierdo` decimal(11,3) default NULL,
  `MargenDerecho` decimal(11,3) default NULL,
  `FuenteTecla` varchar(100) default NULL,
  `ColorFuente` varchar(100) default NULL,
  `ImagenTeclado` varchar(250) default NULL,
  `TextoPLU` int(11) default '1',
  `PintarVendedores` tinyint(1) default '1',
  `IdTablaTeclas` int(11) default NULL,
  `IdTablaTeclasVendedor` int(11) default NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdTeclado`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_teclado_tradicional`
--


/*!40000 ALTER TABLE `dat_teclado_tradicional` DISABLE KEYS */;
LOCK TABLES `dat_teclado_tradicional` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_teclado_tradicional` ENABLE KEYS */;

--
-- Table structure for table `dat_ticket_cabecera`
--

DROP TABLE IF EXISTS `dat_ticket_cabecera`;
CREATE TABLE `dat_ticket_cabecera` (
  `IdTicket` bigint(20) NOT NULL default '1' COMMENT 'Identificador unico por cada ticket generado.\r\nUnique Identifier generated by each receipt.',
  `NumTicket` bigint(20) default NULL COMMENT 'Numero unico por cada Empresa, Tienda, Balanza Maestra, Balanza Esclava y Tipo de Venta.\r\nUnique number for each Enterprise, Shop, Master Scale, Slave Scale and Type of Sale.',
  `IdEmpresa` int(11) NOT NULL default '1' COMMENT 'Identificador de la Empresa desde la que se ha generado el ticket.\r\nEnterprise identifier that has generated the receipt.',
  `NombreEmpresa` varchar(100) default NULL COMMENT 'Nombre de la Empresa desde la que se ha generado el ticket.\r\nEnterprise name that has generated the receipt.',
  `IdTienda` int(11) NOT NULL default '1' COMMENT 'Identificador de la Tienda desde la que se ha generado el ticket.\r\nShop identifier that has generated the receipt.',
  `NombreTienda` varchar(50) default NULL COMMENT 'Nombre de la Tienda desde la que se ha generado el ticket.\r\nShop name that has generated the receipt.',
  `IdBalanzaMaestra` int(11) NOT NULL default '0' COMMENT 'Identificador de la Balanza Maestra en la que se ha generado el ticket.\r\nMaster Scale identifier that has generated the receipt.',
  `NombreBalanzaMaestra` varchar(50) default NULL COMMENT 'Nombre de la Balanza Maestra en la que se ha generado el ticket.\r\nMaster Scale Name that has generated the receipt.',
  `IdBalanzaEsclava` int(11) NOT NULL default '0' COMMENT 'Identificador de la Balanza Esclava desde la que se ha generado el ticket.\r\nSlave Scale identifier that has generated the receipt.',
  `NombreBalanzaEsclava` varchar(50) default NULL COMMENT 'Nombre Balanza Esclava desde la que se ha generado el ticket.\r\nSlave Scale name that has generated the receipt.',
  `Tipo` varchar(2) NOT NULL default 'T' COMMENT 'Tipo de documento: T = Ticket, E = Etiqueta.\r\nDocument type: T = Receipt, E = Label.',
  `IdVendedor` int(11) default NULL COMMENT 'Identificador del vendedor que ha generado el ticket.\r\nSeller identifier that has generated the receipt.',
  `NombreVendedor` varchar(50) default NULL COMMENT 'Nombre del vendedor que ha generado el ticket.\r\nSeller name that has generated the receipt.',
  `IdCliente` int(11) default NULL COMMENT 'Identificador del cliente al que se le ha hecho el ticket.\r\nClient Identifier for whom has made the receipt.',
  `NombreCliente` varchar(9) default NULL COMMENT 'Nombre del cliente al que se le ha hecho el ticket.\r\nClient name for whom has made the receipt.',
  `NombreLargoCliente` varchar(30) default NULL,
  `DireccionCliente` varchar(30) default NULL COMMENT 'Direccion del cliente al que se le ha hecho el ticket. Client address for whom has made the receipt.',
  `CodPostalCliente` varchar(10) default NULL COMMENT 'Codigo postal del cliente al que se le ha hecho el ticket. Client postal code for whom has made the receipt.',
  `LocalidadCliente` varchar(20) default NULL COMMENT 'Poblacion del cliente al que se le ha hecho el ticket. Client town for whom has made the receipt.',
  `NIFCliente` varchar(20) default NULL COMMENT 'DNI del cliente al que se le ha hecho el ticket. Client identication number for whom has made the receipt.',
  `TipoVenta` tinyint(1) NOT NULL default '2' COMMENT 'Tipo de venta: 2 (impreso) o 3 (no impreso)\r\nSale type: 2 (printed) or 3 (not printed)',
  `ImporteLineas` double(15,3) default NULL COMMENT 'Importe total de todas las lineas del ticket. Importe total antes del descuento en total.\r\nTotal amount of all lines of receipt. Total amount before the total discount.',
  `PorcDescuento` double(9,3) default NULL COMMENT 'Porcentaje del descuento en el total del ticket.\r\nPercentage of total discount receipt.',
  `ImporteDescuento` double(15,3) default NULL COMMENT 'Importe del descuento en el total del ticket.\r\nAmount of total discount receipt.',
  `ImporteTotal` double(15,3) default NULL COMMENT 'Importe total del ticket (despues del descuento).\r\nTotal amount of receipt (after the discount)',
  `ImporteLineas2` double(15,3) default NULL COMMENT 'Reservado.\r\nReserved.',
  `PorcDescuento2` double(9,3) default NULL COMMENT 'Reservado.\r\nReserved.',
  `ImporteDescuento2` double(15,3) default NULL COMMENT 'Reservado.\r\nReserved.',
  `ImporteTotal2` double(15,3) default NULL COMMENT 'Reservado.\r\nReserved.',
  `ImporteLineas3` double(15,3) default NULL COMMENT 'Reservado.\r\nReserved.',
  `PorcDescuento3` double(9,3) default NULL COMMENT 'Reservado.\r\nReserved.',
  `ImporteDescuento3` double(15,3) default NULL COMMENT 'Reservado.\r\nReserved.',
  `ImporteTotal3` double(15,3) default NULL COMMENT 'Reservado.\r\nReserved.',
  `ImporteTotalSinIVAConDtoL` double(15,3) default NULL COMMENT 'Importe de todas las lineas sin IVA y con descuento de linea. Amount of all the lines without VAR and with line discount.',
  `ImporteTotalSinIVAConDtoLConDtoTotal` double(15,3) default NULL COMMENT 'Importe de todas las lineas sin IVA y con descuento de linea y con descuento en total. Amount of all the lines without VAR and with line discount and with total discount.',
  `ImporteDtoTotalSinIVA` double(15,3) default NULL COMMENT 'Importe del descuento total sin IVA. Amount of  total discount without VAR.',
  `ImporteTotalDelIVAConDtoLConDtoTotal` double(15,3) default NULL COMMENT 'Importe del IVA con descuento en linea y descuento en total. Amount of VAR with line discount and with total discount.',
  `ImporteSinRedondeo` double(15,3) default NULL COMMENT 'Importe del ticket sin redondeo. Amount of the receipt without rounding.',
  `ImporteDelRedondeo` double(15,3) default NULL COMMENT 'Importe del redondeo. Amount of rounding.',
  `IdSeccion` int(11) default NULL,
  `SignoTotal` int(11) default '0',
  `ImporteTotalAbsoluto` double(15,3) default NULL,
  `PreseleccionCliente` tinyint(1) default '0' COMMENT 'Campo de uso interno.\r\nInternal use field.',
  `Fecha` datetime default NULL COMMENT 'Fecha de creacion del ticket.\r\nDate creation of the ticket.',
  `Enviado` tinyint(1) NOT NULL default '0' COMMENT 'Reservado.\r\nReserved.',
  `NumLineas` smallint(6) default NULL COMMENT 'Numero de lineas del ticket.\r\nNumber of lines of receipt.',
  `CodigoBarras` varchar(20) default NULL COMMENT 'Codigo de Barras del ticket.\r\nBarCode receipt.',
  `CodBarrasTalonCaja` varchar(20) default NULL COMMENT 'Codigo de barras del talon de caja. Bar code of counterfoil.',
  `SerieLIdFinDeDia` bigint(20) default NULL COMMENT 'Identificador del fin de dia donde se ha tenido en cuenta el ticket. End of day Identificator where the receipt has been added.',
  `SerieLTicketErroneo` tinyint(1) NOT NULL default '0' COMMENT 'Ticket erroneo de la serie L. Wrong receipt from L series.',
  `Modificado` tinyint(1) default NULL COMMENT '0 No modificado, 1 Modificado\r\n0 Not modified , 1 Modified',
  `Operacion` char(1) default NULL COMMENT 'A=Alta, M=Modificado, B=Borrado\r\nA=New, M=Modified, B=Deleted',
  `Usuario` varchar(20) default NULL COMMENT 'Usuario de creacion del ticket.\r\nUser creation of the receipt.',
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP COMMENT 'Fecha y hora de la ultima modificacion del registro.\r\nDate and time of the last change of the register.',
  `EstadoTicket` char(1) default NULL COMMENT 'Estado del ticket: C=Copia, P=Reabierto, R= Copia reabierta.\r\nReceipt state: C=Copy, P=Reopened, R= Copy reopened.',
  `ImporteEntregado` double(15,3) default NULL COMMENT 'Importe entregado por el cliente.\r\nAmount given by the customer.',
  `ImporteDevuelto` double(15,3) default NULL COMMENT 'Importe devuelto al cliente.\r\nAmount returned to the customer.',
  `PuntosFidelidad` double(15,3) default NULL COMMENT 'Puntos de fidelidad conseguidos en este ticket.\r\nFidelity points get in this receipt.',
  `Exportado` tinyint(1) NOT NULL default '0' COMMENT 'Ventas no exportadas. Se pone a 1 al exportarlas el RGI',
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanzaMaestra`,`IdBalanzaEsclava`,`TipoVenta`,`IdTicket`),
  KEY `Fecha` (`IdEmpresa`,`IdTienda`,`IdBalanzaMaestra`,`IdVendedor`,`Tipo`,`Fecha`),
  KEY `IdTicket` (`IdEmpresa`,`IdTienda`,`IdBalanzaMaestra`,`IdTicket`),
  KEY `Modificados` (`Modificado`,`Operacion`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guarda toda la informacion de un ticket ya';

--
-- Dumping data for table `dat_ticket_cabecera`
--


/*!40000 ALTER TABLE `dat_ticket_cabecera` DISABLE KEYS */;
LOCK TABLES `dat_ticket_cabecera` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_ticket_cabecera` ENABLE KEYS */;

--
-- Table structure for table `dat_ticket_cabecera_historico`
--

DROP TABLE IF EXISTS `dat_ticket_cabecera_historico`;
CREATE TABLE `dat_ticket_cabecera_historico` (
  `IdTicket` bigint(20) NOT NULL default '1',
  `NumTicket` bigint(20) default NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `NombreEmpresa` varchar(100) default NULL,
  `IdTienda` int(11) NOT NULL default '1',
  `NombreTienda` varchar(50) default NULL,
  `IdBalanzaMaestra` int(11) NOT NULL default '0',
  `NombreBalanzaMaestra` varchar(50) default NULL,
  `IdBalanzaEsclava` int(11) NOT NULL default '0',
  `NombreBalanzaEsclava` varchar(50) default NULL,
  `Tipo` varchar(2) NOT NULL default 'T' COMMENT 'T Ticket\r\nE Etiqueta',
  `IdVendedor` int(11) default NULL,
  `NombreVendedor` varchar(50) default NULL,
  `IdCliente` int(11) default NULL,
  `NombreCliente` varchar(50) default NULL,
  `DNICliente` varchar(9) default NULL COMMENT 'DNI del cliente al que se le ha hecho el ticket. Client identication number for whom has made the ticket.',
  `DireccionCliente` varchar(50) default NULL COMMENT 'Direccion del cliente al que se le ha hecho el ticket. Client address for whom has made the ticket.',
  `PoblacionCliente` varchar(25) default NULL COMMENT 'Poblacion del cliente al que se le ha hecho el ticket. Client town for whom has made the ticket.',
  `ProvinciaCliente` varchar(25) default NULL COMMENT 'Provincia del cliente al que se le ha hecho el ticket. Client state for whom has made the ticket.',
  `CPCliente` varchar(8) default NULL COMMENT 'Codigo postal del cliente al que se le ha hecho el ticket. Client postal code for whom has made the ticket.',
  `TelefonoCliente` varchar(20) default NULL COMMENT 'Telefono del cliente al que se le ha hecho el ticket. Client telephone for whom has made the ticket.',
  `TipoVenta` tinyint(1) NOT NULL default '2',
  `ImporteLineas` double(15,3) default NULL,
  `PorcDescuento` double(9,3) default NULL,
  `ImporteDescuento` double(15,3) default NULL,
  `ImporteTotal` double(15,3) default NULL,
  `ImporteLineas2` double(15,3) default NULL,
  `PorcDescuento2` double(9,3) default NULL,
  `ImporteDescuento2` double(15,3) default NULL,
  `ImporteTotal2` double(15,3) default NULL,
  `ImporteLineas3` double(15,3) default NULL,
  `PorcDescuento3` double(9,3) default NULL,
  `ImporteDescuento3` double(15,3) default NULL,
  `ImporteTotal3` double(15,3) default NULL,
  `ImporteTotalSinIVAConDtoL` double(15,3) default NULL COMMENT 'Importe de todas las lineas sin IVA y con descuento de linea. Amount of all the lines without VAR and with discount of line.',
  `ImporteTotalSinIVAConDtoLConDtoTotal` double(15,3) default NULL COMMENT 'Importe de todas las lineas sin IVA y con descuento de linea y con descuento en total. Amount of all the lines without VAR and with discount of line and with total discount.',
  `ImporteDtoTotalSinIVA` double(15,3) default NULL COMMENT 'Importe del descuento total sin IVA. Amount of  total discount without VAR.',
  `ImporteTotalDelIVAConDtoLConDtoTotal` double(15,3) default NULL COMMENT 'Importe del IVA con descuento en linea y descuento en total. Amount of VAR with discount of linea and with total discount.',
  `ImporteSinRedondeo` double(15,3) default NULL COMMENT 'Importe del ticket sin redondeo. Amount of Ticket without rounding.',
  `ImporteDelRedondeo` double(15,3) default NULL COMMENT 'Importe del redondeo. Amount of rounding.',
  `PreseleccionCliente` tinyint(1) default '0',
  `Fecha` datetime default NULL,
  `Enviado` tinyint(1) NOT NULL default '0',
  `NumLineas` smallint(6) default NULL,
  `CodigoBarras` varchar(20) default NULL,
  `CodBarrasTalonCaja` varchar(20) default NULL COMMENT 'Codigo de barras del talon de caja. Bar code of counterfoil.',
  `SerieLIdFinDeDia` bigint(20) default NULL COMMENT 'ID fin de dia donde se ha tenido en cuenta el ticket. End of day ID where the ticket has been added',
  `SerieLTicketErroneo` tinyint(1) NOT NULL default '0' COMMENT 'Ticket erroneo de la serie L. Wrong receipt from L series.',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `EstadoTicket` char(1) default NULL,
  `ImporteEntregado` double(15,3) default NULL,
  `ImporteDevuelto` double(15,3) default NULL,
  `PuntosFidelidad` double(15,3) default NULL,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanzaMaestra`,`IdBalanzaEsclava`,`TipoVenta`,`IdTicket`),
  KEY `IdEmpresa` (`IdEmpresa`,`IdTienda`,`IdBalanzaMaestra`,`IdVendedor`,`Tipo`,`Fecha`),
  KEY `IdTicket` (`IdEmpresa`,`IdTienda`,`IdBalanzaMaestra`,`IdTicket`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guarda toda la informacion de tickets cerr';

--
-- Dumping data for table `dat_ticket_cabecera_historico`
--


/*!40000 ALTER TABLE `dat_ticket_cabecera_historico` DISABLE KEYS */;
LOCK TABLES `dat_ticket_cabecera_historico` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_ticket_cabecera_historico` ENABLE KEYS */;

--
-- Table structure for table `dat_ticket_forma_pago`
--

DROP TABLE IF EXISTS `dat_ticket_forma_pago`;
CREATE TABLE `dat_ticket_forma_pago` (
  `IdTicket` bigint(20) NOT NULL default '1' COMMENT 'Identificador del ticket al que pertenece la forma de pago.\r\nReceipt identifier that belongs to the method of payment.',
  `NumTicket` bigint(20) default NULL COMMENT 'Numero unico por cada Empresa, Tienda, Balanza Maestra, Balanza Esclava y Tipo de Venta.\r\nUnique number for each Enterprise, Shop, Master Scale, Slave Scale and Type of Sale.',
  `IdEmpresa` int(11) NOT NULL default '1' COMMENT 'Identificador de la Empresa desde la que se ha generado el ticket.\r\nEnterprise identifier that has generated the receipt.',
  `IdTienda` int(11) NOT NULL default '1' COMMENT 'Identificador de la Tienda desde la que se ha generado el ticket.\r\nShop identifier that has generated the receipt.',
  `IdBalanzaMaestra` int(11) NOT NULL default '0' COMMENT 'Identificador de la Balanza Maestra en la que se ha generado el ticket.\r\nMaster Scale identifier that has generated the receipt.',
  `IdBalanzaEsclava` int(11) NOT NULL default '0' COMMENT 'Identificador de la Balanza Esclava desde la que se ha generado el ticket.\r\nSlave Scale identifier that has generated the receipt.',
  `TipoVenta` tinyint(1) NOT NULL default '2' COMMENT 'Tipo de venta: 2 (impreso) o 3 (no impreso)\r\nSale type: 2 (printed) or 3 (not printed)',
  `IdFormaPago` int(11) NOT NULL default '0' COMMENT 'Identificador del tipo de forma de pago.\r\nForm of payment identifier.',
  `Descripcion` varchar(50) default NULL COMMENT 'Descripcion de la forma de pago.\r\nDescription of the method of payment.',
  `Contado` tinyint(1) default '0' COMMENT '0=Operacion sin apertura de cajon,1=Operacion con apertura de cajon.\r\n0=Operation without opening the drawer, 1=Operation with opening the drawer.',
  `ImporteFormaPago` double(15,3) default NULL COMMENT 'Importe pagado con esta forma de pago.\r\nAmount of this form of payment.',
  `Modificado` tinyint(1) default NULL COMMENT '0 No modificado, 1 Modificado\r\n0 Not modified , 1 Modified',
  `Operacion` char(1) default NULL COMMENT 'A=Alta, M=Modificado, B=Borrado\r\nA=New, M=Modified, B=Deleted',
  `Usuario` varchar(20) default NULL COMMENT 'Usuario de creacion del ticket.\r\nUser creation of the receipt.',
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP COMMENT 'Fecha y hora de la ultima modificacion del registro.\r\nDate and time of the last change of the register.',
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanzaMaestra`,`IdBalanzaEsclava`,`TipoVenta`,`IdTicket`,`IdFormaPago`),
  KEY `IdTicket` (`IdEmpresa`,`IdTienda`,`IdBalanzaMaestra`,`IdTicket`,`IdFormaPago`),
  KEY `Modificados` (`Modificado`,`Operacion`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guarda toda la informacion de las formas d';

--
-- Dumping data for table `dat_ticket_forma_pago`
--


/*!40000 ALTER TABLE `dat_ticket_forma_pago` DISABLE KEYS */;
LOCK TABLES `dat_ticket_forma_pago` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_ticket_forma_pago` ENABLE KEYS */;

--
-- Table structure for table `dat_ticket_forma_pago_historico`
--

DROP TABLE IF EXISTS `dat_ticket_forma_pago_historico`;
CREATE TABLE `dat_ticket_forma_pago_historico` (
  `IdTicket` bigint(20) NOT NULL default '1',
  `NumTicket` bigint(20) default NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `IdTienda` int(11) NOT NULL default '1',
  `IdBalanzaMaestra` int(11) NOT NULL default '0',
  `IdBalanzaEsclava` int(11) NOT NULL default '0',
  `TipoVenta` tinyint(1) NOT NULL default '2',
  `IdFormaPago` int(11) NOT NULL default '0',
  `Descripcion` varchar(50) default NULL,
  `Contado` tinyint(1) default '0',
  `ImporteFormaPago` double(15,3) default NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanzaMaestra`,`IdBalanzaEsclava`,`TipoVenta`,`IdTicket`,`IdFormaPago`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guarda toda la informacion de las formas d';

--
-- Dumping data for table `dat_ticket_forma_pago_historico`
--


/*!40000 ALTER TABLE `dat_ticket_forma_pago_historico` DISABLE KEYS */;
LOCK TABLES `dat_ticket_forma_pago_historico` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_ticket_forma_pago_historico` ENABLE KEYS */;

--
-- Table structure for table `dat_ticket_linea`
--

DROP TABLE IF EXISTS `dat_ticket_linea`;
CREATE TABLE `dat_ticket_linea` (
  `IdLineaTicket` int(11) NOT NULL COMMENT 'Identificador unico de linea por cada Ticket, Empresa, Tienda, Balanza Maestra, Balanza Esclava y Tipo de Venta.\r\nUnique identifier of line for each Reciept, Enterprise, Shop, Master Scale, Slave Scale and Type of Sale.',
  `IdEmpresa` int(11) NOT NULL default '1' COMMENT 'Identificador de la Empresa desde la que se ha generado el ticket.\r\nEnterprise identifier that has generated the receipt.',
  `IdTienda` int(11) NOT NULL default '1' COMMENT 'IIdentificador de la Tienda desde la que se ha generado el ticket.\r\nShop identifier that has generated the receipt.',
  `IdBalanzaMaestra` int(11) NOT NULL default '0' COMMENT 'Identificador de la Balanza Maestra en la que se ha generado el ticket.\r\nMaster Scale identifier that has generated the receipt.',
  `IdBalanzaEsclava` int(11) NOT NULL default '0' COMMENT 'Identificador de la Balanza Esclava desde la que se ha generado el ticket.\r\nSlave Scale identifier that has generated the receipt.',
  `IdTicket` bigint(20) NOT NULL default '0' COMMENT 'Identificador del ticket al que pertenece la Linea. Receipt identifier that belongs the line.',
  `TipoVenta` tinyint(1) NOT NULL default '2' COMMENT 'Tipo de venta: 2 (impreso) o 3 (no impreso)\r\nSale type: 2 (printed) or 3 (not printed)',
  `EstadoLinea` smallint(6) NOT NULL default '0' COMMENT 'Estado de la linea: 0=Alta, 1=borrado\r\nLine state: 0=New, 1=Deleted',
  `IdArticulo` int(11) default NULL COMMENT 'Identificador del Articulo perteneciente a la linea creada.\r\nArticle Identifier belonging to the created line.',
  `Descripcion` varchar(100) default NULL COMMENT 'Descripcion del Articulo perteneciente a la linea creada.\r\nArticle description belonging to the created line.',
  `Descripcion1` varchar(100) default NULL COMMENT 'Descripcion adicional del Articulo perteneciente a la linea creada.\r\nAdditional Article Description belonging to the created line.',
  `Comportamiento` smallint(6) NOT NULL default '0' COMMENT 'Tipo de articulo: 1=Pesado, 0=Unitario\r\nArticle type: 1=Weight, 0=Unit',
  `Tara` decimal(11,3) default NULL COMMENT 'Tara aplicada a la venta.\r\nTara applied to the sold.',
  `TaraPreprogramada` smallint(2) default '0' COMMENT 'Tipo de tara: 0=No tara preprogramada. 1=Tara reprogramada\r\nTare tyoe: 0 = Not pre-programmed tare. 1 = Pre-programmed tare.',
  `Peso` double(15,3) default NULL COMMENT 'Peso en el plato.\r\nWeight on the plate.',
  `PesoRegalado` double(15,3) default NULL COMMENT 'Campo para guardar el peso regalado al comprador debido al regalo por segmento.\r\nFree weight given to the customer. Free weight per segment.',
  `PrecioPorCienGramos` tinyint(1) default '0' COMMENT '0=Precio por Kg/Lb, 1=Precio por 100 gramos. 0 =Price per Kg/Lg, 1=Price per 100 grams.',
  `Precio` double(15,3) default NULL COMMENT 'Precio final de la linea vendida.\r\nFinal price of the sold line.',
  `PrecioSinOferta` double(15,3) default NULL COMMENT 'Precio de venta sin aplicar la oferta.\r\nPrice without offer.',
  `PrecioSinIVA` double(15,3) default NULL COMMENT 'Precio sin IVA de la linea vendida.\r\nPrice without VAT of the sold line.',
  `PrecioConIVASinDtoL` double(15,3) default NULL COMMENT 'Precio de venta con IVA y antes de aplicar el descuento en linea.\r\nPrice with VAT and before the line discount.',
  `IdIVA` int(11) default NULL COMMENT 'Identificador del IVA aplicado.\r\nIdentifier of VAT applied.',
  `PorcentajeIVA` decimal(11,3) default '0.000' COMMENT 'Porcentaje del IVA aplicado.\r\nPercentage of VAT applied.',
  `Descuento` double(9,5) default NULL COMMENT 'Descuento de la linea.\r\nDiscount of the line.',
  `DescuentoTotalEnLinea` tinyint(1) default '0',
  `Importe` double(15,3) default NULL COMMENT 'Importe final de la linea de venta.\r\nFinal amount of the sold line.',
  `ImporteSinOferta` double(15,3) default NULL COMMENT 'Importe final de venta sin aplicar la oferta.\r\nFinal amount without offer.',
  `ImporteSinIVASinDtoL` double(15,3) default NULL COMMENT 'Importe sin iva y sin descuento en linea.\r\nAmount without VAT and without line discount.',
  `ImporteConIVASinDtoL` double(15,3) default NULL COMMENT 'Importe con IVA y sin descuento en linea.\r\nAmount with VAT and without line discount.',
  `ImporteSinIVAConDtoL` double(15,3) default NULL COMMENT 'Importe sin iva y con descuento en linea.\r\nAmount without VAT and with line discount.',
  `ImporteDelIVAConDtoL` double(15,3) default NULL COMMENT 'Importe del IVA y con descuento en linea.\r\nAmount of VAT and with line discount.',
  `ImporteSinIVAConDtoLConDtoTotal` double(15,3) default NULL COMMENT 'Importe sin iva, con descuento en linea y con descuento total.\r\nAmount without VAT, with line discount and with total discount.',
  `ImporteDelIVAConDtoLConDtoTotal` double(15,3) default NULL COMMENT 'Importe del iva, con descuento en linea y con descuento total.\r\nAmount of VAT, with line discount and with total discount.',
  `ImporteDelDescuento` double(15,3) default NULL COMMENT 'Importe del descuento en linea.\r\nAmount of the line discount.',
  `ImporteConDtoTotal` double(15,3) default NULL COMMENT 'Importe final de la linea de venta y aplicado el descuento en total.\r\nFinal amount of the sold line and the total discount applied.',
  `Signo` int(11) default '0',
  `PesoAbsoluto` double(15,3) default NULL,
  `ImporteAbsoluto` double(15,3) default NULL,
  `TaraFija` decimal(11,3) default NULL COMMENT 'Tara fija del articulo.\r\nFixed Tare of the article.',
  `TaraPorcentual` decimal(11,3) default NULL COMMENT 'Tara porcentual del articulo.\r\nPercentaje Tare of the article.',
  `DiasCaducidad` int(5) default NULL COMMENT 'Dias de caducidad del articulo.\r\nDays of expiration of the article.',
  `HorasCaducidad` int(5) default NULL COMMENT 'Horas de caducidad del articulo.\r\nHours of expiration of the article.',
  `FechaCaducidad` datetime default NULL COMMENT 'Fecha de caducidad del articulo.\r\nExpiry date of the article',
  `DiasExtra` int(5) default NULL COMMENT 'Dias extra del articulo.\r\nExtra days of the article.',
  `HorasExtra` int(5) default NULL COMMENT 'Horas extra del articulo.\r\nExtra hours of the article.',
  `FechaExtra` datetime default NULL COMMENT 'Fecha extra del articulo.\r\nExtra date if article.',
  `DiasEnvasado` int(5) default NULL COMMENT 'Dias de envasado del articulo.\r\nDays packing of the article.',
  `HorasEnvasado` int(5) default NULL COMMENT 'Horas de envasado del articulo.\r\nHours packing of the article.',
  `FechaEnvasado` datetime default NULL COMMENT 'Fecha de envasado del articulo.\r\nDate packing of the article.',
  `LogoEtiqueta` varchar(1000) default NULL COMMENT 'Ruta del logotipo de la etiqueta.\r\nPath of logo of the label.',
  `CodInterno` int(11) default NULL COMMENT 'Codigo interno del articulo.\r\nInternal code of the article.',
  `EANScannerArticulo` varchar(20) default NULL COMMENT 'Codigo EANScanner del articulo.\r\nEANScanner code of the article.',
  `TextoLote` text COMMENT 'Texto lote del articulo.\r\nLot text of the article.',
  `IdClase` int(11) default NULL COMMENT 'Identificador de la clase del articulo.\r\nClass Identifier of the article.',
  `NombreClase` varchar(25) default NULL COMMENT 'Nombre de la clase del articulo.\r\nClass Name of the article.',
  `IdElemAsociado` int(11) default NULL COMMENT 'Identificador Elemento asociado del articulo.\r\nElement associated Identifier of the article.',
  `NombreElemAsociado` varchar(25) default NULL COMMENT 'Nombre Elemento asociado del articulo.\r\nElement associated Name of the article.',
  `LoteAnimal` varchar(20) default NULL,
  `IdFamilia` int(11) default NULL COMMENT 'Identificador Familia del articulo.\r\nFamily Identifier of the article.',
  `NombreFamilia` varchar(25) default NULL COMMENT 'Nombre Familia del articulo.\r\nFamily Name of the article.',
  `IdSeccion` int(11) default NULL COMMENT 'Identificador de la Seccion del articulo.\r\nSection Identifier of the article.',
  `NombreSeccion` varchar(30) default NULL COMMENT 'Nombre Seccion del articulo.\r\nSection Name of the article.',
  `IdSubFamilia` int(11) default NULL COMMENT 'Identificador Subfamilia del articulo.\r\nSubfamily article identifier.',
  `NombreSubFamilia` varchar(25) default NULL COMMENT 'Nombre Subfamilia del articulo.\r\nSubfamily Name of the article.',
  `IdDepartamento` int(11) default NULL COMMENT 'Identificador Departamento del articulo.\r\nDepartment Identifier of the article.',
  `NombreDepartamento` varchar(25) default NULL COMMENT 'Nombre Departamento del articulo.\r\nDepartment Name of the article.',
  `Texto1` text COMMENT 'Texto 1 del articulo.\r\nText 1 of the article.',
  `Texto2` text COMMENT 'Texto 2 del articulo.\r\nText 2 of the article.',
  `Texto3` text COMMENT 'Texto 3 del articulo.\r\nText 3 of the article.',
  `Texto4` text COMMENT 'Texto 4 del articulo.\r\nText 4 of the article.',
  `Texto5` text COMMENT 'Texto 5 del articulo.\r\nText 5 of the article.',
  `TextoLibre` text COMMENT 'Texto libre del articulo.\r\nFree text of the article.',
  `PesoPieza` decimal(11,3) default NULL COMMENT 'Peso pieza del articulo. No usado.\r\nWeight piece of the article. Not used.',
  `UnidadesCaja` int(11) default NULL COMMENT 'Unidades caja del articulo. No usado.\r\nBox units of the article. Not used.',
  `Facturada` tinyint(1) default '0',
  `Modificado` tinyint(1) default NULL COMMENT '0 No modificado, 1 Modificado\r\n0 Not modified , 1 Modified',
  `Operacion` char(1) default NULL COMMENT 'A=Alta, M=Modificado, B=Borrado\r\nA=New, M=Modified, B=Deleted',
  `Usuario` varchar(20) default NULL COMMENT 'Usuario de creacion del ticket.\r\nUser creation of the receipt.',
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP COMMENT 'Fecha y hora de la ultima modificacion del registro.\r\nDate and time of the last change of the register.',
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanzaMaestra`,`IdBalanzaEsclava`,`TipoVenta`,`IdTicket`,`IdLineaTicket`),
  KEY `IdTicket` (`IdEmpresa`,`IdTienda`,`IdBalanzaMaestra`,`IdTicket`,`IdLineaTicket`),
  KEY `Modificados` (`Modificado`,`Operacion`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guarda toda la informacion de las linea';

--
-- Dumping data for table `dat_ticket_linea`
--


/*!40000 ALTER TABLE `dat_ticket_linea` DISABLE KEYS */;
LOCK TABLES `dat_ticket_linea` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_ticket_linea` ENABLE KEYS */;

--
-- Table structure for table `dat_ticket_linea_historico`
--

DROP TABLE IF EXISTS `dat_ticket_linea_historico`;
CREATE TABLE `dat_ticket_linea_historico` (
  `IdLineaTicket` int(11) NOT NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `IdTienda` int(11) NOT NULL default '1',
  `IdBalanzaMaestra` int(11) NOT NULL default '0',
  `IdBalanzaEsclava` int(11) NOT NULL default '0',
  `IdTicket` bigint(20) NOT NULL default '0' COMMENT 'Id del ticket al que pertenece la Linea. Id ticket that belongs the line.',
  `TipoVenta` tinyint(1) NOT NULL default '2',
  `EstadoLinea` smallint(6) NOT NULL default '0' COMMENT '0=Alta, 1=borrado',
  `IdArticulo` int(11) default NULL,
  `Descripcion` varchar(100) default NULL,
  `Descripcion1` varchar(100) default NULL,
  `Comportamiento` smallint(6) NOT NULL default '0' COMMENT '1=Pesado\r\n0=Unitario',
  `Tara` decimal(11,3) default NULL,
  `TaraPreprogramada` smallint(2) default '0' COMMENT '0=No tara preprogramada. 1=Tara reprogramada',
  `Peso` double(15,3) default NULL,
  `PesoRegalado` double(15,3) default NULL COMMENT 'Campo para guardar el peso regalado al comprador debido al regalo por segmento',
  `PrecioPorCienGramos` tinyint(1) default '0' COMMENT '0=Precio por Kg/Lb, 1=Precio por 100 gramos. 0 =Price per Kg/Lg, 1=Price per 100 grams.',
  `Precio` double(15,3) default NULL,
  `PrecioSinOferta` double(15,3) default NULL,
  `PrecioSinIVA` double(15,3) default NULL,
  `PrecioConIVASinDtoL` double(15,3) default NULL,
  `IdIVA` int(11) default NULL,
  `PorcentajeIVA` decimal(11,3) default '0.000',
  `Descuento` double(9,5) default NULL,
  `Importe` double(15,3) default NULL,
  `ImporteSinOferta` double(15,3) default NULL,
  `ImporteSinIVASinDtoL` double(15,3) default NULL,
  `ImporteConIVASinDtoL` double(15,3) default NULL,
  `ImporteSinIVAConDtoL` double(15,3) default NULL,
  `ImporteDelIVAConDtoL` double(15,3) default NULL,
  `ImporteSinIVAConDtoLConDtoTotal` double(15,3) default NULL,
  `ImporteDelIVAConDtoLConDtoTotal` double(15,3) default NULL,
  `ImporteDelDescuento` double(15,3) default NULL,
  `ImporteConDtoTotal` double(15,3) default NULL,
  `TaraFija` decimal(11,3) default NULL,
  `TaraPorcentual` decimal(11,3) default NULL,
  `DiasCaducidad` int(5) default NULL,
  `HorasCaducidad` int(5) default NULL,
  `FechaCaducidad` datetime default NULL,
  `DiasExtra` int(5) default NULL,
  `HorasExtra` int(5) default NULL,
  `FechaExtra` datetime default NULL,
  `DiasEnvasado` int(5) default NULL,
  `HorasEnvasado` int(5) default NULL,
  `FechaEnvasado` datetime default NULL,
  `LogoEtiqueta` varchar(1000) default NULL,
  `CodInterno` int(11) default NULL,
  `EANScannerArticulo` varchar(20) default NULL,
  `TextoLote` text,
  `IdClase` int(11) default NULL,
  `NombreClase` varchar(25) default NULL,
  `IdElemAsociado` int(11) default NULL,
  `NombreElemAsociado` varchar(25) default NULL,
  `IdFamilia` int(11) default NULL,
  `NombreFamilia` varchar(25) default NULL,
  `IdSeccion` int(11) default NULL,
  `NombreSeccion` varchar(30) default NULL,
  `IdSubFamilia` int(11) default NULL,
  `NombreSubFamilia` varchar(25) default NULL,
  `IdDepartamento` int(11) default NULL,
  `NombreDepartamento` varchar(25) default NULL,
  `Texto1` text,
  `Texto2` text,
  `Texto3` text,
  `Texto4` text,
  `Texto5` text,
  `TextoLibre` text,
  `PesoPieza` decimal(11,3) default NULL,
  `UnidadesCaja` int(11) default NULL,
  `Facturada` tinyint(1) default '0',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanzaMaestra`,`IdBalanzaEsclava`,`TipoVenta`,`IdTicket`,`IdLineaTicket`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guarda toda la informacion de las linea';

--
-- Dumping data for table `dat_ticket_linea_historico`
--


/*!40000 ALTER TABLE `dat_ticket_linea_historico` DISABLE KEYS */;
LOCK TABLES `dat_ticket_linea_historico` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_ticket_linea_historico` ENABLE KEYS */;

--
-- Table structure for table `dat_ticket_max_idticket`
--

DROP TABLE IF EXISTS `dat_ticket_max_idticket`;
CREATE TABLE `dat_ticket_max_idticket` (
  `IdTicket` bigint(20) default NULL COMMENT 'Identificador del siguiente ticket por empresa, tienda y balanza maestra.\r\nIdentifier of the next receipt by enterprise, shop and master scale.',
  `IdEmpresa` int(11) NOT NULL COMMENT 'Identidicador de la empresa.\r\nEnterprise identifier.',
  `IdTienda` int(11) NOT NULL COMMENT 'Identificador de la tienda.\r\nShop identifier.',
  `IdBalanzaMaestra` int(11) NOT NULL COMMENT 'Identificador de la balanza maestra.\r\nMaster scale identifier.',
  `Modificado` tinyint(1) default NULL COMMENT '0 No modificado, 1 Modificado\r\n0 Not modified , 1 Modified',
  `Operacion` varchar(1) default NULL COMMENT 'A=Alta, M=Modificado, B=Borrado\r\nA=New, M=Modified, B=Deleted',
  `Usuario` varchar(20) default NULL COMMENT 'Usuario que ha hecho la ultima modificacion del registro.\r\nUser that has done the last change of the register.',
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP COMMENT 'Fecha y hora de la ultima modificacion del registro.\r\nDate and time of the last change of the register.',
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanzaMaestra`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guarda el numero del proximo idticket. Tab';

--
-- Dumping data for table `dat_ticket_max_idticket`
--


/*!40000 ALTER TABLE `dat_ticket_max_idticket` DISABLE KEYS */;
LOCK TABLES `dat_ticket_max_idticket` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_ticket_max_idticket` ENABLE KEYS */;

--
-- Table structure for table `dat_tienda`
--

DROP TABLE IF EXISTS `dat_tienda`;
CREATE TABLE `dat_tienda` (
  `IdTienda` int(11) NOT NULL,
  `IdEmpresa` int(11) NOT NULL,
  `Nombre` varchar(50) default NULL,
  `PathImagen` varchar(1000) default NULL,
  `DisenoImagen` tinyint(1) default '1',
  `CIF_VAT` varchar(14) default NULL,
  `Direccion` varchar(50) default NULL,
  `CodPostal` varchar(8) default NULL,
  `Poblacion` varchar(25) default NULL,
  `Provincia` varchar(25) default NULL,
  `IdAlmacen` int(11) default NULL,
  `IdTarifa` int(11) default NULL,
  `Ofertas` tinyint(1) default NULL,
  `Dir_IP` varchar(20) default NULL,
  `Port` int(6) default NULL,
  `TipoBase` varchar(20) default NULL,
  `BaseDatos` varchar(50) default NULL,
  `UserDB` varchar(20) default NULL,
  `PasswDB` varchar(24) default NULL,
  `TimeOutConnection` int(4) default '15',
  `CodBarrasEtiquetas` int(11) default NULL,
  `CodBarrasTickets` int(11) default NULL,
  `CodBarrasPreenvasado` int(11) default NULL,
  `CodBarrasTalonCaja` int(11) default NULL,
  `FormatoEtiquetasUnitarias` int(11) default NULL,
  `FormatoEtiquetasPesadas` int(11) default NULL,
  `FormatoTickets` int(11) default NULL,
  `FormatoTalonCaja` int(11) default NULL,
  `FormatoFactura` int(11) default NULL,
  `FormatoAlbaran` int(11) default NULL,
  `Importe` double(9,3) default '0.000',
  `DecimalesPrecio` int(1) default '0',
  `Moneda` text,
  `PuntosFidelidad` double(9,3) default '0.000',
  `PuntosActivados` tinyint(1) default '0',
  `GestionStock` tinyint(1) default '0' COMMENT 'Campo que indica si la tienda tiene o no gestion de stock.\r\nField indicating whether the store has stock management.',
  `VentanaError` tinyint(1) default '0' COMMENT 'Campo donde se guarda si los errores saldran o no con ventanas emergentes en la pantalla de venta',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `Dir_IP_Publica` varchar(20) default NULL,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guarda toda la informacion de las tiendas.';

--
-- Dumping data for table `dat_tienda`
--


/*!40000 ALTER TABLE `dat_tienda` DISABLE KEYS */;
LOCK TABLES `dat_tienda` WRITE;
INSERT INTO `dat_tienda` (`IdTienda`, `IdEmpresa`, `Nombre`, `PathImagen`, `DisenoImagen`, `CIF_VAT`, `Direccion`, `CodPostal`, `Poblacion`, `Provincia`, `IdAlmacen`, `IdTarifa`, `Ofertas`, `Dir_IP`, `Port`, `TipoBase`, `BaseDatos`, `UserDB`, `PasswDB`, `TimeOutConnection`, `CodBarrasEtiquetas`, `CodBarrasTickets`, `CodBarrasPreenvasado`, `CodBarrasTalonCaja`, `FormatoEtiquetasUnitarias`, `FormatoEtiquetasPesadas`, `FormatoTickets`, `FormatoTalonCaja`, `FormatoFactura`, `FormatoAlbaran`, `Importe`, `DecimalesPrecio`, `Moneda`, `PuntosFidelidad`, `PuntosActivados`, `GestionStock`, `VentanaError`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`, `Dir_IP_Publica`) VALUES (1,1,'Shop 1','',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,10.000,0,NULL,1.000,1,0,1,1,'M','admindfs','2013-01-31 07:59:39',NULL);
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_tienda` ENABLE KEYS */;

--
-- Table structure for table `dat_transformacion_campos`
--

DROP TABLE IF EXISTS `dat_transformacion_campos`;
CREATE TABLE `dat_transformacion_campos` (
  `IdImportacion` int(11) default NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `IdCampo` varchar(50) default NULL,
  `ValorOriginal` varchar(20) default NULL,
  `ValorTransformado` varchar(50) default NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_transformacion_campos`
--


/*!40000 ALTER TABLE `dat_transformacion_campos` DISABLE KEYS */;
LOCK TABLES `dat_transformacion_campos` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_transformacion_campos` ENABLE KEYS */;

--
-- Table structure for table `dat_transformacion_campos_exportacion`
--

DROP TABLE IF EXISTS `dat_transformacion_campos_exportacion`;
CREATE TABLE `dat_transformacion_campos_exportacion` (
  `IdExportacion` int(11) default NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `IdCampo` varchar(50) default NULL,
  `ValorOriginal` varchar(20) default NULL,
  `ValorTransformado` varchar(20) default NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_transformacion_campos_exportacion`
--


/*!40000 ALTER TABLE `dat_transformacion_campos_exportacion` DISABLE KEYS */;
LOCK TABLES `dat_transformacion_campos_exportacion` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_transformacion_campos_exportacion` ENABLE KEYS */;

--
-- Table structure for table `dat_vendedor`
--

DROP TABLE IF EXISTS `dat_vendedor`;
CREATE TABLE `dat_vendedor` (
  `IdEmpresa` int(11) NOT NULL default '1',
  `IdVendedor` int(6) NOT NULL,
  `MemoriaSerieL` int(2) default NULL,
  `Nombre` varchar(50) default NULL,
  `Visible` tinyint(1) default '1' COMMENT '0: No visible\r\n1: Visible',
  `IdImagen` int(11) default NULL,
  `IdGrupo` int(11) default '0',
  `Direccion` varchar(50) default NULL,
  `CodPostal` varchar(8) default NULL,
  `Poblacion` varchar(25) default NULL,
  `Provincia` varchar(25) default NULL,
  `DNI` varchar(20) default NULL,
  `Telefono1` varchar(20) default NULL,
  `Telefono2` varchar(20) default NULL,
  `Telefono3` varchar(20) default NULL,
  `Foto` varchar(1000) default NULL,
  `IdDepartamento` int(11) default NULL,
  `IdEstado` int(11) default NULL,
  `Observaciones` text,
  `CodInterno` varchar(25) default NULL COMMENT 'Para posibles codigos que tenga la empresa y quieran relacionarlos con los nuestros.',
  `Comision` decimal(9,3) default NULL,
  `SoloTicket` tinyint(1) default '0',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdVendedor`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guarda toda la informacion de los vendedor';

--
-- Dumping data for table `dat_vendedor`
--


/*!40000 ALTER TABLE `dat_vendedor` DISABLE KEYS */;
LOCK TABLES `dat_vendedor` WRITE;
INSERT INTO `dat_vendedor` (`IdEmpresa`, `IdVendedor`, `MemoriaSerieL`, `Nombre`, `Visible`, `IdImagen`, `IdGrupo`, `Direccion`, `CodPostal`, `Poblacion`, `Provincia`, `DNI`, `Telefono1`, `Telefono2`, `Telefono3`, `Foto`, `IdDepartamento`, `IdEstado`, `Observaciones`, `CodInterno`, `Comision`, `SoloTicket`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`) VALUES (1,1,1,'Fermes du Pays Bourian',1,NULL,0,'La Marzelle','46310','St Germain du bel Air',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'A','admin','2015-09-16 21:31:43'),(1,2,8,'Bruno Belivent',1,NULL,0,'Le Fournel','45310','Montamel',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,1,'M','admin','2015-09-19 14:02:18');
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_vendedor` ENABLE KEYS */;

--
-- Table structure for table `dat_vendedor_tabla_teclas`
--

DROP TABLE IF EXISTS `dat_vendedor_tabla_teclas`;
CREATE TABLE `dat_vendedor_tabla_teclas` (
  `IdEmpresa` int(11) NOT NULL,
  `IdTabla` int(11) NOT NULL,
  `IdVendedor` int(11) NOT NULL,
  `MemoriaSerieL` int(11) default NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdTabla`,`IdVendedor`),
  KEY `IdVendedor` (`IdVendedor`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `dat_vendedor_tabla_teclas`
--


/*!40000 ALTER TABLE `dat_vendedor_tabla_teclas` DISABLE KEYS */;
LOCK TABLES `dat_vendedor_tabla_teclas` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `dat_vendedor_tabla_teclas` ENABLE KEYS */;

--
-- Table structure for table `sys_balanzas`
--

DROP TABLE IF EXISTS `sys_balanzas`;
CREATE TABLE `sys_balanzas` (
  `IdModeloBalanza` tinyint(1) NOT NULL default '0',
  `Modelo` varchar(20) default NULL,
  `Descripcion` varchar(50) default NULL COMMENT 'Accede a la tabla de mensajes en idiomas',
  `ArticulosTotal` int(11) default NULL,
  `VendedoresTotal` int(11) default NULL,
  `SeccionesTotal` int(11) default NULL,
  `IVASTotal` int(11) default NULL,
  `IVASPrimero` int(11) default NULL,
  `IVASUltimo` int(11) default NULL,
  `TarasTotal` int(11) default NULL,
  `TarasPrimero` int(11) default NULL,
  `TarasUltimo` int(11) default NULL,
  `DivisasTotal` int(11) default NULL,
  `DivisasPrimero` int(11) default NULL,
  `DivisasUltimo` int(11) default NULL,
  `CodigosBarraTotal` int(11) default NULL,
  `CodigosBarraPrimero` int(11) default NULL,
  `CodigosBarraUltimo` int(11) default NULL,
  `LogosTotal` int(11) default NULL,
  `LogosPrimeroSeccion` int(11) default NULL,
  `LogosUltimoSeccion` int(11) default NULL,
  `LogosPrimeroImpresion` int(11) default NULL,
  `LogosUltimoImpresion` int(11) default NULL,
  `LogosPrimeroInicio` int(11) default NULL,
  `LogosUltimoInicio` int(11) default NULL,
  `LogosPrimeroArticulo` int(11) default NULL,
  `LogosUltimoArticulo` int(11) default NULL,
  `ClasesTotal` int(11) default NULL,
  `ClasesPrimero` int(11) default NULL,
  `ClasesUltimo` int(11) default NULL,
  `TextosClase` int(11) default NULL,
  `RespuestasAnimal` int(11) default NULL,
  `AnimalesTotal` int(11) default NULL,
  `AnimalesPrimero` int(11) default NULL,
  `AnimalesUltimo` int(11) default NULL,
  `TextosTotal` int(11) default NULL,
  PRIMARY KEY  (`IdModeloBalanza`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `sys_balanzas`
--


/*!40000 ALTER TABLE `sys_balanzas` DISABLE KEYS */;
LOCK TABLES `sys_balanzas` WRITE;
INSERT INTO `sys_balanzas` (`IdModeloBalanza`, `Modelo`, `Descripcion`, `ArticulosTotal`, `VendedoresTotal`, `SeccionesTotal`, `IVASTotal`, `IVASPrimero`, `IVASUltimo`, `TarasTotal`, `TarasPrimero`, `TarasUltimo`, `DivisasTotal`, `DivisasPrimero`, `DivisasUltimo`, `CodigosBarraTotal`, `CodigosBarraPrimero`, `CodigosBarraUltimo`, `LogosTotal`, `LogosPrimeroSeccion`, `LogosUltimoSeccion`, `LogosPrimeroImpresion`, `LogosUltimoImpresion`, `LogosPrimeroInicio`, `LogosUltimoInicio`, `LogosPrimeroArticulo`, `LogosUltimoArticulo`, `ClasesTotal`, `ClasesPrimero`, `ClasesUltimo`, `TextosClase`, `RespuestasAnimal`, `AnimalesTotal`, `AnimalesPrimero`, `AnimalesUltimo`, `TextosTotal`) VALUES (1,'L Series','L Series',8000,30,99,5,1,5,5,1,5,10,0,9,10,1,10,200,60,89,11,15,10,19,0,0,10,1,10,20,20,99,1,99,10),(20,'500 Range','500 Range',10000,30,99,5,1,5,5,1,5,10,0,9,10,1,10,200,101,200,101,200,101,200,101,2000,10,1,10,20,20,99,1,99,20),(40,'D900','D900',10000,30,99,5,1,5,5,1,5,10,0,9,10,1,10,200,101,200,101,200,101,200,101,2000,10,1,10,20,20,99,1,99,20);
UNLOCK TABLES;
/*!40000 ALTER TABLE `sys_balanzas` ENABLE KEYS */;

--
-- Table structure for table `sys_campos_etiqueta`
--

DROP TABLE IF EXISTS `sys_campos_etiqueta`;
CREATE TABLE `sys_campos_etiqueta` (
  `IdEmpresa` int(11) NOT NULL default '1',
  `IdModeloBalanza` int(11) NOT NULL,
  `IdCampo` int(11) NOT NULL,
  `NombreCampo` text NOT NULL,
  `ValorEnBD` text,
  `Agrupacion` text,
  `OrdenAgrupacion` int(11) default NULL,
  `OrdenCampos` int(11) NOT NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdModeloBalanza`,`IdCampo`,`OrdenCampos`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;

--
-- Dumping data for table `sys_campos_etiqueta`
--


/*!40000 ALTER TABLE `sys_campos_etiqueta` DISABLE KEYS */;
LOCK TABLES `sys_campos_etiqueta` WRITE;
INSERT INTO `sys_campos_etiqueta` (`IdEmpresa`, `IdModeloBalanza`, `IdCampo`, `NombreCampo`, `ValorEnBD`, `Agrupacion`, `OrdenAgrupacion`, `OrdenCampos`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`) VALUES (1,1,1,'CodigoBarrasEAN13',NULL,'CodigoBarras',1,1,0,'A','adminDFS','2011-02-14 14:46:00'),(1,1,2,'Importe','0045.67','Importe',3,1,0,'A','adminDFS','2011-02-14 14:42:06'),(1,1,3,'Peso','01.234','Peso',5,1,0,'A','adminDFS','2011-02-14 14:44:30'),(1,1,4,'Hora',NULL,'Fechas',8,7,0,'A','adminDFS','2011-02-14 14:46:56'),(1,1,5,'NumeroTicket','00109','Miscelaneas',11,2,0,'A','adminDFS','2011-02-14 14:48:12'),(1,1,6,'Precio','dat_articulo.PrecioConIva','Precio',4,1,0,'A','adminDFS','2011-02-14 14:50:11'),(1,1,7,'FechaActual',NULL,'Fechas',8,1,0,'A','adminDFS','2011-02-14 14:52:07'),(1,1,8,'FechaCaducidad','dat_articulo.FechaCaducidad','Fechas',8,3,0,'A','adminDFS','2011-02-14 14:52:58'),(1,1,9,'FechaExtra','dat_articulo.FechaExtra','Fechas',8,4,0,'A','adminDFS','2011-02-14 14:53:37'),(1,1,12,'NombreArticulo','dat_articulo.Descripcion','Articulos',2,1,0,'A','adminDFS','2011-02-14 14:54:52'),(1,1,13,'Texto1','dat_articulo.Texto1','Articulos',2,4,0,'A','adminDFS','2011-02-14 14:57:50'),(1,1,14,'Texto2','dat_articulo.Texto2','Articulos',2,5,0,'A','adminDFS','2011-02-14 14:58:22'),(1,1,15,'Texto3','dat_articulo.Texto3','Articulos',2,6,0,'A','adminDFS','2011-02-14 15:28:17'),(1,1,16,'CodigoPLU','dat_articulo.IdArticulo','Articulos',2,25,0,'A','adminDFS','2011-02-15 14:16:53'),(1,1,17,'Cabecera1','dat_cabeceras','Cabeceras',7,1,0,'A','adminDFS','2011-02-14 15:02:13'),(1,1,18,'Cabecera2','dat_cabeceras','Cabeceras',7,2,0,'A','adminDFS','2011-02-15 08:47:00'),(1,1,19,'Cabecera3','dat_cabeceras','Cabeceras',7,3,0,'A','adminDFS','2011-02-14 15:04:30'),(1,1,20,'Cabecera4','dat_cabeceras','Cabeceras',7,4,0,'A','adminDFS','2011-02-14 15:04:59'),(1,1,21,'Cabecera5','dat_cabeceras','Cabeceras',7,5,0,'A','adminDFS','2011-02-14 15:05:18'),(1,1,22,'Cabecera6','dat_cabeceras','Cabeceras',7,6,0,'A','adminDFS','2011-02-14 15:05:34'),(1,1,23,'Cabecera7','dat_cabeceras','Cabeceras',7,7,0,'A','adminDFS','2011-02-14 15:05:48'),(1,1,24,'Cabecera8','dat_cabeceras','Cabeceras',7,8,0,'A','adminDFS','2011-02-14 15:06:13'),(1,1,25,'Tara','dat_articulo.Tara','Peso',5,4,0,'A','adminDFS','2011-02-14 15:06:44'),(1,1,26,'PesoBruto','02.345','Peso',5,2,0,'A','adminDFS','2011-02-14 15:07:28'),(1,1,27,'CodigoVendedor','dat_vendedor.IdVendedor','Miscelaneas',11,3,0,'A','adminDFS','2011-02-14 15:08:08'),(1,1,28,'NombreVendedor','dat_vendedor.Nombre','Miscelaneas',11,4,0,'A','adminDFS','2011-02-14 15:08:24'),(1,1,29,'Nombre3','dat_articulo.Descripcion2','Articulos',2,3,0,'A','adminDFS','2011-02-14 15:11:20'),(1,1,30,'PrecioOferta','dat_articulo.PrecioOferta','Precio',4,2,0,'A','adminDFS','2011-02-14 15:12:04'),(1,1,31,'Ahorro','0012.35','Miscelaneas',11,6,0,'A','adminDFS','2011-02-14 15:21:31'),(1,1,32,'Nombre2','dat_articulo.Descripcion1','Articulos',2,2,0,'A','adminDFS','2011-02-14 15:23:26'),(1,1,33,'Seccion','dat_articulo.IdSeccion','Miscelaneas',11,5,0,'A','adminDFS','2011-02-14 15:24:51'),(1,1,34,'NumLote','000996','Miscelaneas',11,1,0,'A','adminDFS','2011-02-14 15:25:30'),(1,1,35,'Texto4','dat_articulo.Texto4','Articulos',2,7,0,'A','adminDFS','2011-02-14 15:26:03'),(1,1,36,'Texto5','dat_articulo.Texto5','Articulos',2,8,0,'A','adminDFS','2011-02-14 15:29:07'),(1,1,37,'FechaCombinada',NULL,'Fechas',8,5,0,'A','adminDFS','2011-02-14 15:29:45'),(1,1,38,'FechaCombinada2','dat_articulo.FechaCombinada2','Fechas',8,6,0,'A','adminDFS','2011-02-14 15:32:53'),(1,1,39,'TotalTalones',NULL,'Importe',3,10,0,'A','adminDFS','2011-02-14 15:35:42'),(1,1,40,'Rectangulo',NULL,'RectanguloLinea',13,2,0,'A','adminDFS','2011-02-14 15:59:57'),(1,1,41,'Descuento','14','Importe',3,2,0,'A','adminDFS','2011-02-14 16:01:13'),(1,1,42,'ImporteDespuesDescuento','0012.54','Importe',3,3,0,'A','adminDFS','2011-02-14 16:03:34'),(1,1,43,'ImporteDespuesOferta','0012.64','Importe',3,4,0,'A','adminDFS','2011-02-14 16:06:39'),(1,1,44,'LogoImpresion',NULL,'Grafico',9,2,0,'A','adminDFS','2011-02-15 09:21:01'),(1,1,45,'TaraPorcentaje','0.100\r\n000.034','Peso',5,5,0,'A','adminDFS','2011-02-14 16:12:06'),(1,1,46,'ValorTaraPorcentaje','dat_articulo.TaraPorcentual','Peso',5,6,0,'A','adminDFS','2011-02-14 16:12:29'),(1,1,47,'txt_PorcenTARA',NULL,'TextosLiterales',6,7,0,'A','adminDFS','2011-02-15 07:22:44'),(1,1,48,'txt_DataEmbalagem',NULL,'TextosLiterales',6,34,0,'A','adminDFS','2011-02-15 07:23:44'),(1,1,49,'txt_EmbaladoEm',NULL,'TextosLiterales',6,35,0,'A','adminDFS','2011-02-15 07:24:20'),(1,1,50,'txt_ConsumirAte',NULL,'TextosLiterales',6,36,0,'A','adminDFS','2011-02-15 07:24:56'),(1,1,51,'txt_FechaPicado',NULL,'TextosLiterales',6,37,0,'A','adminDFS','2011-02-15 07:25:33'),(1,1,52,'txt_Referencia',NULL,'TextosLiterales',6,38,0,'A','adminDFS','2011-02-15 07:26:00'),(1,1,53,'PrecioMonedaSecundaria','001134','Precio',4,3,0,'A','adminDFS','2011-02-15 07:34:25'),(1,1,55,'CambioEuro',NULL,'Precio',4,6,0,'A','adminDFS','2011-02-15 07:36:19'),(1,1,56,'TotalMonedaSecundaria','004567','Importe',3,6,0,'A','adminDFS','2011-02-15 07:37:16'),(1,1,57,'TotalTalonCaja',NULL,'Importe',3,11,0,'A','adminDFS','2011-02-15 07:47:51'),(1,1,58,'FechaCompleta',NULL,'Fechas',8,2,0,'A','adminDFS','2011-02-15 07:48:33'),(1,1,59,'NumArticulosTicket','09','Miscelaneas',11,7,0,'A','adminDFS','2011-02-15 07:49:22'),(1,1,60,'TotalTicket','0054.46','Importe',3,9,0,'A','adminDFS','2011-02-15 07:50:46'),(1,1,61,'txt_Peso',NULL,'TextosLiterales',6,3,0,'A','adminDFS','2011-02-15 07:51:51'),(1,1,62,'txt_Precio',NULL,'TextosLiterales',6,4,0,'A','adminDFS','2011-02-15 07:52:16'),(1,1,63,'txt_Importe',NULL,'TextosLiterales',6,5,0,'A','adminDFS','2011-02-15 07:52:39'),(1,1,64,'txt_kg',NULL,'TextosLiterales',6,15,0,'A','adminDFS','2011-02-15 07:54:13'),(1,1,65,'txt_Ekg',NULL,'TextosLiterales',6,16,0,'A','adminDFS','2011-02-15 15:00:02'),(1,1,66,'txt_E',NULL,'TextosLiterales',6,17,0,'A','adminDFS','2011-02-15 09:13:00'),(1,1,67,'txt_Unidades',NULL,'TextosLiterales',6,18,0,'A','adminDFS','2011-02-15 08:05:21'),(1,1,68,'txt_EUnidad',NULL,'TextosLiterales',6,19,0,'A','adminDFS','2011-02-15 09:15:05'),(1,1,69,'txt_FEnvasado',NULL,'TextosLiterales',6,9,0,'A','adminDFS','2011-02-15 08:22:14'),(1,1,70,'txt_FCaducidad',NULL,'TextosLiterales',6,8,0,'A','adminDFS','2011-02-15 08:22:32'),(1,1,71,'txt_ConsumirPreferentemente',NULL,'TextosLiterales',6,10,0,'A','adminDFS','2011-02-15 08:22:55'),(1,1,72,'txt_TalonCaja',NULL,'TextosLiterales',6,11,0,'A','adminDFS','2011-02-15 08:23:17'),(1,1,73,'txt_Total',NULL,'TextosLiterales',6,1,0,'A','adminDFS','2011-02-15 08:23:57'),(1,1,74,'txt_PesoKg',NULL,'TextosLiterales',6,6,0,'A','adminDFS','2011-02-15 08:24:38'),(1,1,75,'txt_TotalE',NULL,'TextosLiterales',6,2,0,'A','adminDFS','2011-02-15 08:26:30'),(1,1,78,'txt_Tara',NULL,'TextosLiterales',6,7,0,'A','adminDFS','2011-02-15 08:58:37'),(1,1,80,'txt_Conservar',NULL,'TextosLiterales',6,14,0,'A','adminDFS','2011-02-15 09:00:07'),(1,1,81,'txt_A18C',NULL,'TextosLiterales',6,20,0,'A','adminDFS','2011-02-15 09:00:53'),(1,1,82,'txt_EnFrio',NULL,'TextosLiterales',6,21,0,'A','adminDFS','2011-02-15 09:01:14'),(1,1,83,'txt_Oferta',NULL,'TextosLiterales',6,22,0,'A','adminDFS','2011-02-15 09:01:43'),(1,1,84,'txt_Ahorro',NULL,'TextosLiterales',6,23,0,'A','adminDFS','2011-02-15 09:01:52'),(1,1,85,'txt_Descuento',NULL,'TextosLiterales',6,24,0,'A','adminDFS','2011-02-15 09:03:11'),(1,1,86,'txt_Pta',NULL,'TextosLiterales',6,25,0,'A','adminDFS','2011-02-15 09:13:00'),(1,1,87,'txt_PtaKg',NULL,'TextosLiterales',6,26,0,'A','adminDFS','2011-02-15 09:13:29'),(1,1,88,'txt_PtaUnidad',NULL,'TextosLiterales',6,27,0,'A','adminDFS','2011-02-15 09:15:05'),(1,1,89,'txt_Entre05C',NULL,'TextosLiterales',6,28,0,'A','adminDFS','2011-02-15 09:15:59'),(1,1,90,'txt_TalonCajaEspecial',NULL,'TextosLiterales',6,29,0,'A','adminDFS','2011-02-15 09:18:47'),(1,1,91,'Linea',NULL,'RectanguloLinea',13,1,0,'A','adminDFS','2011-02-15 09:20:22'),(1,1,101,'Cabecera9','dat_cabeceras','Cabeceras',7,9,0,'A','adminDFS','2011-02-15 09:21:52'),(1,1,102,'Cabecera10','dat_cabeceras','Cabeceras',7,10,0,'A','adminDFS','2011-02-15 09:22:02'),(1,1,103,'Cabecera11','dat_cabeceras','Cabeceras',7,11,0,'A','adminDFS','2011-02-15 09:22:54'),(1,1,104,'Cabecera12','dat_cabeceras','Cabeceras',7,12,0,'A','adminDFS','2011-02-15 09:23:12'),(1,1,105,'Cabecera13','dat_cabeceras','Cabeceras',7,13,0,'A','adminDFS','2011-02-15 09:23:56'),(1,1,107,'Cabecera14','dat_cabeceras','Cabeceras',7,14,0,'A','adminDFS','2011-02-15 09:24:43'),(1,1,108,'Cabecera15','dat_cabeceras','Cabeceras',7,15,0,'A','adminDFS','2011-02-15 09:25:06'),(1,1,109,'Texto6','dat_articulo.Texto6','Articulos',2,9,0,'A','adminDFS','2011-02-15 09:25:42'),(1,1,110,'Texto7','dat_articulo.Texto7','Articulos',2,10,0,'A','adminDFS','2011-02-15 09:25:42'),(1,1,111,'Texto8','dat_articulo.Texto8','Articulos',2,11,0,'A','adminDFS','2011-02-15 09:25:42'),(1,1,112,'Texto9','dat_articulo.Texto9','Articulos',2,12,0,'A','adminDFS','2011-02-15 09:25:42'),(1,1,113,'Texto10','dat_articulo.Texto10','Articulos',2,13,0,'A','adminDFS','2011-02-15 09:25:42'),(1,1,114,'Texto11','dat_articulo.Texto11','Articulos',2,14,0,'A','adminDFS','2011-02-15 09:25:42'),(1,1,115,'Texto12','dat_articulo.Texto12','Articulos',2,15,0,'A','adminDFS','2011-02-15 09:25:42'),(1,1,116,'Texto13','dat_articulo.Texto13','Articulos',2,16,0,'A','adminDFS','2011-02-15 09:25:42'),(1,1,117,'Texto14','dat_articulo.Texto14','Articulos',2,17,0,'A','adminDFS','2011-02-15 09:25:42'),(1,1,118,'Texto15','dat_articulo.Texto15','Articulos',2,18,0,'A','adminDFS','2011-02-15 09:25:42'),(1,1,119,'Texto16','dat_articulo.Texto16','Articulos',2,19,0,'A','adminDFS','2011-02-15 09:25:42'),(1,1,120,'Texto17','dat_articulo.Texto17','Articulos',2,20,0,'A','adminDFS','2011-02-15 09:25:42'),(1,1,121,'Texto18','dat_articulo.Texto18','Articulos',2,21,0,'A','adminDFS','2011-02-15 09:25:42'),(1,1,122,'Texto19','dat_articulo.Texto19','Articulos',2,22,0,'A','adminDFS','2011-02-15 09:25:42'),(1,1,123,'Texto20','dat_articulo.Texto20','Articulos',2,23,0,'A','adminDFS','2011-02-15 09:25:42'),(1,1,124,'TextoG','dat_articulo.TextoLibre','Articulos',2,24,0,'A','adminDFS','2011-02-15 09:25:42'),(1,1,125,'TituloReceta','dat_receta.TextoTitulo','Recetas',12,1,0,'A','adminDFS','2011-02-15 09:41:04'),(1,1,126,'TextoReceta','dat_receta.TextoLinea','Recetas',12,2,0,'A','adminDFS','2011-02-15 09:41:30'),(1,1,127,'PrecioEtiquetaTotales','030.30','Precio',4,5,0,'A','adminDFS','2011-02-16 10:11:35'),(1,1,128,'txt_ConsumirAntesDe',NULL,'TextosLiterales',6,30,0,'A','adminDFS','2011-02-15 09:44:18'),(1,1,129,'txt_Divisa1',NULL,'TextosLiterales',6,12,0,'A','adminDFS','2011-02-15 09:45:04'),(1,1,130,'txt_Divisa2',NULL,'TextosLiterales',6,13,0,'A','adminDFS','2011-02-15 09:45:04'),(1,1,131,'ImporteDivisa1','00042.34','Importe',3,5,0,'A','adminDFS','2011-02-15 09:46:39'),(1,1,132,'ImporteDivisa2','00043.34','Importe',3,6,0,'A','adminDFS','2011-02-15 09:46:57'),(1,1,133,'SimboloDivisa1','dat_divisas.Simbolo','Importe',3,7,0,'A','adminDFS','2011-02-15 09:45:43'),(1,1,134,'SimboloDivisa2','dat_divisas.Simbolo','Importe',3,8,0,'A','adminDFS','2011-02-15 09:45:43'),(1,1,138,'PesoNetoNoEscurrido','00.567','Peso',5,3,0,'A','adminDFS','2011-02-15 09:54:10'),(1,1,139,'PrecioNetoNoEscurrido','012.77','Precio',4,4,0,'A','adminDFS','2011-02-15 10:43:58'),(1,1,140,'ImporteNetoNoEscurrido','00046.67','Importe',3,12,0,'A','adminDFS','2011-02-15 10:50:09'),(1,1,141,'HoraEnvasado','dat_articulo.HorasEnvasado','Fechas',8,9,0,'A','adminDFS','2011-02-15 10:51:49'),(1,1,142,'HoraCaducidad','dat_articulo.HorasCaducidad','Fechas',8,8,0,'A','adminDFS','2011-02-15 10:52:13'),(1,1,150,'txt_TemperaturaConservacion',NULL,'TextosLiterales',6,31,0,'A','adminDFS','2011-02-15 10:55:34'),(1,1,151,'txt_FabricadoEl',NULL,'TextosLiterales',6,32,0,'A','adminDFS','2011-02-15 10:56:00'),(1,1,152,'txt_FabricadoPor',NULL,'TextosLiterales',6,33,0,'A','adminDFS','2011-02-15 10:56:47'),(1,1,159,'CodigoBarras2D5',NULL,'CodigoBarras',1,2,0,'A','adminDFS','2011-03-04 08:40:22'),(1,1,160,'txt_NumIdentificacion',NULL,'Trazabilidad',10,1,0,'A','adminDFS','2011-02-15 10:57:48'),(1,1,161,'txt_SacrificadoEn',NULL,'Trazabilidad',10,2,0,'A','adminDFS','2011-02-15 10:58:15'),(1,1,162,'txt_DespieceEn',NULL,'Trazabilidad',10,3,0,'A','adminDFS','2011-02-15 10:58:52'),(1,1,163,'txt_ProducidoEn',NULL,'Trazabilidad',10,4,0,'A','adminDFS','2011-02-15 10:58:56'),(1,1,164,'txt_PaisNacimiento',NULL,'Trazabilidad',10,5,0,'A','adminDFS','2011-02-15 11:00:40'),(1,1,165,'txt_PaisEngorde',NULL,'Trazabilidad',10,6,0,'A','adminDFS','2011-02-15 11:01:44'),(1,1,166,'txt_Categoria',NULL,'Trazabilidad',10,7,0,'A','adminDFS','2011-02-15 11:02:35'),(1,1,167,'txt_Raza',NULL,'Trazabilidad',10,8,0,'A','adminDFS','2011-02-15 11:02:53'),(1,1,168,'txt_Sexo',NULL,'Trazabilidad',10,9,0,'A','adminDFS','2011-02-15 11:03:09'),(1,1,169,'txt_Edad',NULL,'Trazabilidad',10,10,0,'A','adminDFS','2011-02-15 11:03:24'),(1,1,170,'txt_TipoAnimal',NULL,'Trazabilidad',10,11,0,'A','adminDFS','2011-02-15 11:04:05'),(1,1,171,'txt_Origen',NULL,'Trazabilidad',10,12,0,'A','adminDFS','2011-02-15 11:04:47'),(1,1,172,'NumRapidoAnimal','dat_articulo.IdElemAsociado','Trazabilidad',10,13,0,'A','adminDFS','2011-02-15 11:06:24'),(1,1,173,'Matadero',NULL,'Trazabilidad',10,14,0,'A','adminDFS','2011-02-16 09:21:55'),(1,1,174,'PaisMatadero',NULL,'Trazabilidad',10,15,0,'A','adminDFS','2011-02-15 11:06:24'),(1,1,176,'PaisDespiece',NULL,'Trazabilidad',10,16,0,'A','adminDFS','2011-02-15 11:15:46'),(1,1,177,'PaisProduccion',NULL,'Trazabilidad',10,17,0,'A','adminDFS','2011-02-15 11:16:28'),(1,1,178,'FechaProduccion',NULL,'Trazabilidad',10,18,0,'A','adminDFS','2011-02-15 11:17:35'),(1,1,179,'PaisNacimiento',NULL,'Trazabilidad',10,19,0,'A','adminDFS','2011-02-15 11:16:28'),(1,1,180,'PaisEngorde123',NULL,'Trazabilidad',10,20,0,'A','adminDFS','2011-02-15 11:20:17'),(1,1,181,'Categoria',NULL,'Trazabilidad',10,21,0,'A','adminDFS','2011-02-15 11:16:28'),(1,1,182,'Raza',NULL,'Trazabilidad',10,22,0,'A','adminDFS','2011-02-15 11:16:28'),(1,1,183,'Sexo',NULL,'Trazabilidad',10,23,0,'A','adminDFS','2011-02-15 11:16:28'),(1,1,184,'Edad',NULL,'Trazabilidad',10,24,0,'A','adminDFS','2011-02-15 11:16:28'),(1,1,185,'Clase','dat_articulo.IdClase','Trazabilidad',10,25,0,'A','adminDFS','2011-02-15 11:16:28'),(1,1,186,'Origen',NULL,'Trazabilidad',10,26,0,'A','adminDFS','2011-02-15 11:16:28'),(1,1,187,'Texto1Animal',NULL,'Trazabilidad',10,30,0,'A','adminDFS','2011-02-15 12:02:02'),(1,1,188,'Texto2Animal',NULL,'Trazabilidad',10,31,0,'A','adminDFS','2011-02-15 12:02:02'),(1,1,189,'Texto3Animal',NULL,'Trazabilidad',10,32,0,'A','adminDFS','2011-02-15 12:02:02'),(1,1,190,'Texto4Animal',NULL,'Trazabilidad',10,33,0,'A','adminDFS','2011-02-15 12:02:02'),(1,1,191,'Texto5Animal',NULL,'Trazabilidad',10,34,0,'A','adminDFS','2011-02-15 12:02:02'),(1,1,192,'txt_Despiece2En',NULL,'Trazabilidad',10,27,0,'A','adminDFS','2011-02-15 10:58:52'),(1,1,193,'NumDespiece2',NULL,'Trazabilidad',10,28,0,'A','adminDFS','2011-02-15 10:58:52'),(1,1,194,'PaisDespiece2',NULL,'Trazabilidad',10,29,0,'A','adminDFS','2011-02-15 10:58:52'),(1,1,195,'Texto6Animal',NULL,'Trazabilidad',10,35,0,'A','adminDFS','2011-02-15 12:02:02'),(1,1,196,'Texto7Animal',NULL,'Trazabilidad',10,36,0,'A','adminDFS','2011-02-15 12:02:02'),(1,1,197,'Texto8Animal',NULL,'Trazabilidad',10,37,0,'A','adminDFS','2011-02-15 12:02:02'),(1,1,198,'Texto9Animal',NULL,'Trazabilidad',10,38,0,'A','adminDFS','2011-02-15 12:02:02'),(1,1,199,'Texto10Animal',NULL,'Trazabilidad',10,39,0,'A','adminDFS','2011-02-15 12:02:02'),(1,1,200,'Texto11Animal',NULL,'Trazabilidad',10,40,0,'A','adminDFS','2011-02-15 12:02:02'),(1,1,201,'Texto12Animal',NULL,'Trazabilidad',10,41,0,'A','adminDFS','2011-02-15 12:02:02'),(1,1,202,'Texto13Animal',NULL,'Trazabilidad',10,42,0,'A','adminDFS','2011-02-15 12:02:02'),(1,1,203,'Texto14Animal',NULL,'Trazabilidad',10,43,0,'A','adminDFS','2011-02-15 12:02:02'),(1,1,204,'Texto15Animal',NULL,'Trazabilidad',10,44,0,'A','adminDFS','2011-02-15 12:02:02'),(1,1,205,'Texto16Animal',NULL,'Trazabilidad',10,45,0,'A','adminDFS','2011-02-15 12:02:02'),(1,1,206,'Texto17Animal',NULL,'Trazabilidad',10,46,0,'A','adminDFS','2011-02-15 12:02:02'),(1,1,207,'Texto18Animal',NULL,'Trazabilidad',10,47,0,'A','adminDFS','2011-02-15 12:02:02'),(1,1,208,'Texto19Animal',NULL,'Trazabilidad',10,48,0,'A','adminDFS','2011-02-15 12:02:02'),(1,1,209,'Texto20Animal',NULL,'Trazabilidad',10,49,0,'A','adminDFS','2011-02-15 12:02:02'),(1,1,210,'Texto21Animal',NULL,'Trazabilidad',10,50,0,'A','adminDFS','2011-02-15 12:02:02'),(1,1,211,'Texto22Animal',NULL,'Trazabilidad',10,51,0,'A','adminDFS','2011-02-15 12:02:02'),(1,1,212,'Texto23Animal',NULL,'Trazabilidad',10,52,0,'A','adminDFS','2011-02-15 12:02:02'),(1,1,213,'Texto24Animal',NULL,'Trazabilidad',10,53,0,'A','adminDFS','2011-02-15 12:02:02'),(1,1,214,'Texto25Animal',NULL,'Trazabilidad',10,54,0,'A','adminDFS','2011-02-15 12:02:02'),(1,1,215,'Texto26Animal',NULL,'Trazabilidad',10,55,0,'A','adminDFS','2011-02-15 12:02:02'),(1,1,216,'Texto27Animal',NULL,'Trazabilidad',10,56,0,'A','adminDFS','2011-02-15 12:02:02'),(1,1,217,'Texto28Animal',NULL,'Trazabilidad',10,57,0,'A','adminDFS','2011-02-15 12:02:02'),(1,1,218,'Texto29Animal',NULL,'Trazabilidad',10,58,0,'A','adminDFS','2011-02-15 12:02:02'),(1,1,219,'Texto30Animal',NULL,'Trazabilidad',10,59,0,'A','adminDFS','2011-02-15 12:02:02'),(1,1,220,'Texto31Animal',NULL,'Trazabilidad',10,60,0,'A','adminDFS','2011-02-15 12:02:02'),(1,1,221,'Texto32Animal',NULL,'Trazabilidad',10,61,0,'A','adminDFS','2011-02-15 12:02:02'),(1,1,222,'Texto33Animal',NULL,'Trazabilidad',10,62,0,'A','adminDFS','2011-02-15 12:02:02'),(1,1,223,'Texto34Animal',NULL,'Trazabilidad',10,63,0,'A','adminDFS','2011-02-15 12:02:02'),(1,1,224,'Texto35Animal',NULL,'Trazabilidad',10,64,0,'A','adminDFS','2011-02-15 12:02:02'),(1,1,225,'Texto36Animal',NULL,'Trazabilidad',10,65,0,'A','adminDFS','2011-02-15 12:02:02'),(1,1,226,'Texto37Animal',NULL,'Trazabilidad',10,66,0,'A','adminDFS','2011-02-15 12:02:02'),(1,1,227,'Texto38Animal',NULL,'Trazabilidad',10,67,0,'A','adminDFS','2011-02-15 12:02:02'),(1,1,228,'Texto39Animal',NULL,'Trazabilidad',10,68,0,'A','adminDFS','2011-02-15 12:02:02'),(1,1,229,'Texto40Animal',NULL,'Trazabilidad',10,69,0,'A','adminDFS','2011-02-15 12:02:02'),(1,1,230,'Texto41Animal',NULL,'Trazabilidad',10,70,0,'A','adminDFS','2011-02-15 12:02:02'),(1,1,231,'Texto42Animal',NULL,'Trazabilidad',10,71,0,'A','adminDFS','2011-02-15 12:02:02'),(1,1,232,'Texto43Animal',NULL,'Trazabilidad',10,72,0,'A','adminDFS','2011-02-15 12:02:02'),(1,1,233,'Texto44Animal',NULL,'Trazabilidad',10,73,0,'A','adminDFS','2011-02-15 12:02:02'),(1,1,234,'Texto45Animal',NULL,'Trazabilidad',10,74,0,'A','adminDFS','2011-02-15 12:02:02'),(1,1,235,'Texto46Animal',NULL,'Trazabilidad',10,75,0,'A','adminDFS','2011-02-15 12:02:02'),(1,1,236,'Texto47Animal',NULL,'Trazabilidad',10,76,0,'A','adminDFS','2011-02-15 12:02:02'),(1,1,237,'Texto48Animal',NULL,'Trazabilidad',10,77,0,'A','adminDFS','2011-02-15 12:02:02'),(1,1,238,'Texto49Animal',NULL,'Trazabilidad',10,78,0,'A','adminDFS','2011-02-15 12:02:02'),(1,1,239,'Texto50Animal',NULL,'Trazabilidad',10,79,0,'A','adminDFS','2011-02-15 12:02:02'),(1,1,246,'txt_FCongelacion',NULL,'TextosLiterales',6,39,0,'A','adminDFS','2014-05-26 09:54:06'),(1,20,1,'CodigoBarrasEAN13',NULL,'CodigoBarras',1,1,0,'A','adminDFS','2011-02-14 14:46:00'),(1,20,2,'Importe','00045.67','Importe',3,1,0,'A','adminDFS','2011-02-14 14:42:06'),(1,20,3,'Peso','01.234','Peso',5,1,0,'A','adminDFS','2011-02-14 14:44:30'),(1,20,4,'Hora',NULL,'Fechas',8,6,0,'A','adminDFS','2011-02-14 14:46:56'),(1,20,5,'NumeroTicket','00109','Miscelaneas',11,2,0,'A','adminDFS','2011-02-14 14:48:12'),(1,20,6,'Precio','dat_articulo.PrecioConIva','Precio',4,1,0,'A','adminDFS','2011-02-14 14:50:11'),(1,20,7,'FechaActual',NULL,'Fechas',8,1,0,'A','adminDFS','2011-02-14 14:52:07'),(1,20,8,'FechaCaducidad','dat_articulo.FechaCaducidad','Fechas',8,3,0,'A','adminDFS','2011-02-14 14:52:58'),(1,20,9,'FechaExtra','dat_articulo.FechaExtra','Fechas',8,4,0,'A','adminDFS','2011-02-14 14:53:37'),(1,20,11,'Cantidad','000109','Miscelaneas',11,5,0,'A','adminDFS','2011-02-15 14:11:43'),(1,20,12,'NombreArticulo','dat_articulo.Descripcion','Articulos',2,1,0,'A','adminDFS','2011-02-14 14:54:52'),(1,20,13,'Texto1','dat_articulo.Texto1','Articulos',2,4,0,'A','adminDFS','2011-02-14 14:57:50'),(1,20,14,'Texto2','dat_articulo.Texto2','Articulos',2,5,0,'A','adminDFS','2011-02-14 14:58:22'),(1,20,15,'Texto3','dat_articulo.Texto3','Articulos',2,6,0,'A','adminDFS','2011-02-14 15:28:17'),(1,20,16,'CodigoPLU','dat_articulo.IdArticulo','Articulos',2,25,0,'A','adminDFS','2011-02-15 14:17:05'),(1,20,25,'Tara','dat_articulo.Tara','Peso',5,4,0,'A','adminDFS','2011-02-14 15:06:44'),(1,20,26,'PesoBruto','02.345','Peso',5,2,0,'A','adminDFS','2011-02-14 15:07:28'),(1,20,27,'CodigoVendedor','dat_vendedor.IdVendedor','Miscelaneas',11,3,0,'A','adminDFS','2011-02-14 15:08:08'),(1,20,28,'NombreVendedor','dat_vendedor.Nombre','Miscelaneas',11,4,0,'A','adminDFS','2011-02-14 15:08:24'),(1,20,29,'Nombre3','dat_articulo.Descripcion2','Articulos',2,3,0,'A','adminDFS','2011-02-14 15:11:20'),(1,20,30,'PrecioOferta','dat_articulo.PrecioOferta','Precio',4,2,0,'A','adminDFS','2011-02-14 15:12:04'),(1,20,31,'Ahorro','0012.35','Miscelaneas',11,6,0,'A','adminDFS','2011-02-14 15:21:31'),(1,20,32,'Nombre2','dat_articulo.Descripcion1','Articulos',2,2,0,'A','adminDFS','2011-02-14 15:23:26'),(1,20,34,'NumLote','000996','Miscelaneas',11,1,0,'A','adminDFS','2011-02-14 15:25:30'),(1,20,35,'Texto4','dat_articulo.Texto4','Articulos',2,7,0,'A','adminDFS','2011-02-14 15:26:03'),(1,20,36,'Texto5','dat_articulo.Texto5','Articulos',2,8,0,'A','adminDFS','2011-02-14 15:29:07'),(1,20,37,'FechaCombinada',NULL,'Fechas',8,5,0,'A','adminDFS','2011-02-14 15:29:45'),(1,20,39,'TotalTalones',NULL,'Importe',3,10,0,'A','adminDFS','2011-02-14 15:35:42'),(1,20,40,'Rectangulo',NULL,'RectanguloLinea',13,2,0,'A','adminDFS','2011-02-14 15:59:57'),(1,20,41,'Descuento','14','Importe',3,2,0,'A','adminDFS','2011-02-14 16:01:13'),(1,20,42,'ImporteDespuesDescuento','00012.54','Importe',3,3,0,'A','adminDFS','2011-02-14 16:03:34'),(1,20,43,'ImporteDespuesOferta','00012.64','Importe',3,4,0,'A','adminDFS','2011-02-14 16:06:39'),(1,20,44,'LogoImpresion',NULL,'Grafico',9,2,0,'A','adminDFS','2011-02-15 09:21:01'),(1,20,45,'TaraPorcentaje','000.100','Peso',5,5,0,'A','adminDFS','2011-02-14 16:12:06'),(1,20,46,'ValorTaraPorcentaje','dat_articulo.TaraPorcentual','Peso',5,6,0,'A','adminDFS','2011-02-14 16:12:29'),(1,20,47,'LogoArticulo','dat_articulo.IdLogo','Articulos',2,27,0,'A','adminDFS','2011-02-15 14:35:28'),(1,20,48,'txt_DataEmbalagem',NULL,'TextosLiterales',6,39,0,'A','adminDFS','2012-08-06 11:00:00'),(1,20,49,'txt_EmbaladoEm',NULL,'TextosLiterales',6,40,0,'A','adminDFS','2012-08-06 11:00:00'),(1,20,50,'txt_ConsumirAte',NULL,'TextosLiterales',6,41,0,'A','adminDFS','2012-08-06 11:00:00'),(1,20,51,'txt_FechaPicado',NULL,'TextosLiterales',6,37,0,'A','adminDFS','2011-02-15 07:25:33'),(1,20,52,'txt_Referencia',NULL,'TextosLiterales',6,38,0,'A','adminDFS','2011-02-15 07:26:00'),(1,20,53,'PrecioMonedaSecundaria','001134','Precio',4,3,0,'A','adminDFS','2011-02-15 07:34:25'),(1,20,54,'CodigoBarrasEAN128',NULL,'CodigoBarras',1,3,0,'A','adminDFS','2011-02-15 14:41:32'),(1,20,55,'CambioEuro',NULL,'Precio',4,6,0,'A','adminDFS','2011-02-15 07:36:19'),(1,20,56,'TotalMonedaSecundaria','0004567','Importe',3,6,0,'A','adminDFS','2011-02-15 07:37:16'),(1,20,57,'TotalTalonCaja',NULL,'Importe',3,11,0,'A','adminDFS','2011-02-15 07:47:51'),(1,20,58,'FechaCompleta',NULL,'Fechas',8,2,0,'A','adminDFS','2011-02-15 07:48:33'),(1,20,59,'NumArticulosTicket','003','Miscelaneas',11,7,0,'A','adminDFS','2011-02-15 07:49:22'),(1,20,60,'TotalTicket','00054.46','Importe',3,9,0,'A','adminDFS','2011-02-15 07:50:46'),(1,20,61,'txt_Peso',NULL,'TextosLiterales',6,3,0,'A','adminDFS','2011-02-15 07:51:51'),(1,20,62,'txt_Precio',NULL,'TextosLiterales',6,4,0,'A','adminDFS','2011-02-15 07:52:16'),(1,20,63,'txt_Importe',NULL,'TextosLiterales',6,5,0,'A','adminDFS','2011-02-15 07:52:39'),(1,20,64,'txt_kg',NULL,'TextosLiterales',6,15,0,'A','adminDFS','2011-02-15 07:54:13'),(1,20,65,'txt_EnPts',NULL,'TextosLiterales',6,16,0,'A','adminDFS','2011-02-15 15:00:02'),(1,20,66,'txt_Pta',NULL,'TextosLiterales',6,17,0,'A','adminDFS','2011-02-15 09:13:00'),(1,20,67,'txt_Unidades',NULL,'TextosLiterales',6,18,0,'A','adminDFS','2011-02-15 08:05:21'),(1,20,68,'txt_PtaUnidad',NULL,'TextosLiterales',6,19,0,'A','adminDFS','2011-02-15 09:15:05'),(1,20,69,'txt_FEnvasado',NULL,'TextosLiterales',6,8,0,'A','adminDFS','2011-02-15 08:22:14'),(1,20,70,'txt_FCaducidad',NULL,'TextosLiterales',6,9,0,'A','adminDFS','2011-02-15 08:22:32'),(1,20,71,'txt_ConsumirPreferentemente',NULL,'TextosLiterales',6,20,0,'A','adminDFS','2011-02-15 08:22:55'),(1,20,72,'txt_TalonCaja',NULL,'TextosLiterales',6,21,0,'A','adminDFS','2011-02-15 08:23:17'),(1,20,73,'txt_Total',NULL,'TextosLiterales',6,1,0,'A','adminDFS','2011-02-15 08:23:57'),(1,20,74,'txt_PesoKg',NULL,'TextosLiterales',6,6,0,'A','adminDFS','2011-02-15 08:24:38'),(1,20,75,'txt_TotalPta',NULL,'TextosLiterales',6,2,0,'A','adminDFS','2011-02-15 08:26:30'),(1,20,76,'txt_FEnv',NULL,'TextosLiterales',6,11,0,'A','adminDFS','2011-02-15 08:58:07'),(1,20,77,'txt_FCad',NULL,'TextosLiterales',6,10,0,'A','adminDFS','2011-02-15 08:58:23'),(1,20,78,'txt_Tara',NULL,'TextosLiterales',6,7,0,'A','adminDFS','2011-02-15 08:58:37'),(1,20,79,'txt_NumeroLote',NULL,'TextosLiterales',6,14,0,'A','adminDFS','2011-02-15 08:59:45'),(1,20,80,'txt_Conservar',NULL,'TextosLiterales',6,22,0,'A','adminDFS','2011-02-15 09:00:07'),(1,20,81,'txt_A18C',NULL,'TextosLiterales',6,23,0,'A','adminDFS','2011-02-15 09:00:53'),(1,20,82,'txt_EnFrio',NULL,'TextosLiterales',6,24,0,'A','adminDFS','2011-02-15 09:01:14'),(1,20,83,'txt_Oferta',NULL,'TextosLiterales',6,25,0,'A','adminDFS','2011-02-15 09:01:43'),(1,20,84,'txt_Ahorro',NULL,'TextosLiterales',6,26,0,'A','adminDFS','2011-02-15 09:01:52'),(1,20,85,'txt_Descuento',NULL,'TextosLiterales',6,27,0,'A','adminDFS','2011-02-15 09:03:11'),(1,20,86,'txt_E',NULL,'TextosLiterales',6,28,0,'A','adminDFS','2011-02-15 08:04:49'),(1,20,87,'txt_Ekg',NULL,'TextosLiterales',6,29,0,'A','adminDFS','2011-02-15 07:57:51'),(1,20,88,'txt_EUnidad',NULL,'TextosLiterales',6,30,0,'A','adminDFS','2011-02-15 08:20:05'),(1,20,89,'txt_Entre05C',NULL,'TextosLiterales',6,31,0,'A','adminDFS','2011-02-15 09:15:59'),(1,20,90,'txt_EnLugar',NULL,'TextosLiterales',6,32,0,'A','adminDFS','2011-02-15 15:25:01'),(1,20,91,'Linea',NULL,'RectanguloLinea',13,1,0,'A','adminDFS','2011-02-15 09:20:22'),(1,20,94,'CodigoCliente','1','Miscelaneas',11,8,0,'A','adminDFS','2011-03-06 10:00:00'),(1,20,95,'NombreCliente','Peter Jackson','Miscelaneas',11,9,0,'A','adminDFS','2011-03-06 10:00:00'),(1,20,96,'DireccionLogica','00','Miscelaneas',11,10,0,'A','adminDFS','2011-03-06 10:00:00'),(1,20,97,'CodigoDataBar',NULL,'CodigoBarras',1,4,0,'A','adminDFS','2013-10-07 06:42:59'),(1,20,98,'CodigoDataBarExpandido',NULL,'CodigoBarras',1,5,0,'A','adminDFS','2013-10-07 06:59:37'),(1,20,106,'ImporteIVA','00012.34','Importe',3,15,0,'A','adminDFS','2011-05-22 08:00:00'),(1,20,109,'Texto6','dat_articulo.Texto6','Articulos',2,9,0,'A','adminDFS','2011-02-15 09:25:42'),(1,20,110,'Texto7','dat_articulo.Texto7','Articulos',2,10,0,'A','adminDFS','2011-02-15 09:25:42'),(1,20,111,'Texto8','dat_articulo.Texto8','Articulos',2,11,0,'A','adminDFS','2011-02-15 09:25:42'),(1,20,112,'Texto9','dat_articulo.Texto9','Articulos',2,12,0,'A','adminDFS','2011-02-15 09:25:42'),(1,20,113,'Texto10','dat_articulo.Texto10','Articulos',2,13,0,'A','adminDFS','2011-02-15 09:25:42'),(1,20,114,'Texto11','dat_articulo.Texto11','Articulos',2,14,0,'A','adminDFS','2011-02-15 09:25:42'),(1,20,115,'Texto12','dat_articulo.Texto12','Articulos',2,15,0,'A','adminDFS','2011-02-15 09:25:42'),(1,20,116,'Texto13','dat_articulo.Texto13','Articulos',2,16,0,'A','adminDFS','2011-02-15 09:25:42'),(1,20,117,'Texto14','dat_articulo.Texto14','Articulos',2,17,0,'A','adminDFS','2011-02-15 09:25:42'),(1,20,118,'Texto15','dat_articulo.Texto15','Articulos',2,18,0,'A','adminDFS','2011-02-15 09:25:42'),(1,20,119,'Texto16','dat_articulo.Texto16','Articulos',2,19,0,'A','adminDFS','2011-02-15 09:25:42'),(1,20,120,'Texto17','dat_articulo.Texto17','Articulos',2,20,0,'A','adminDFS','2011-02-15 09:25:42'),(1,20,121,'Texto18','dat_articulo.Texto18','Articulos',2,21,0,'A','adminDFS','2011-02-15 09:25:42'),(1,20,122,'Texto19','dat_articulo.Texto19','Articulos',2,22,0,'A','adminDFS','2011-02-15 09:25:42'),(1,20,123,'Texto20','dat_articulo.Texto20','Articulos',2,23,0,'A','adminDFS','2011-02-15 09:25:42'),(1,20,124,'TextoG','dat_articulo.TextoLibre','Articulos',2,24,0,'A','adminDFS','2011-02-15 09:25:42'),(1,20,125,'TituloReceta','dat_receta.TextoTitulo','Recetas',12,1,0,'A','adminDFS','2011-02-15 09:41:04'),(1,20,126,'TextoReceta','dat_receta.TextoLinea','Recetas',12,2,0,'A','adminDFS','2011-02-15 09:41:30'),(1,20,127,'PrecioEtiquetaTotales','0030.30','Precio',4,5,0,'A','adminDFS','2011-02-15 09:42:46'),(1,20,128,'txt_ConsumirPrefH',NULL,'TextosLiterales',6,33,0,'A','adminDFS','2011-02-15 15:36:48'),(1,20,129,'txt_Divisa1',NULL,'TextosLiterales',6,12,0,'A','adminDFS','2011-02-15 09:45:04'),(1,20,130,'txt_Divisa2',NULL,'TextosLiterales',6,13,0,'A','adminDFS','2011-02-15 09:45:04'),(1,20,131,'ImporteDivisa1','00042.34','Importe',3,5,0,'A','adminDFS','2011-02-15 09:46:39'),(1,20,132,'ImporteDivisa2','00043.34','Importe',3,6,0,'A','adminDFS','2011-02-15 09:46:57'),(1,20,133,'SimboloDivisa1','dat_divisas.Simbolo','Importe',3,7,0,'A','adminDFS','2011-02-15 09:45:43'),(1,20,134,'SimboloDivisa2','dat_divisas.Simbolo','Importe',3,8,0,'A','adminDFS','2011-02-15 09:45:43'),(1,20,138,'PesoNetoNoEscurrido','00.567','Peso',5,3,0,'A','adminDFS','2011-02-15 09:54:10'),(1,20,139,'PrecioNetoNoEscurrido','0012.77','Precio',4,4,0,'A','adminDFS','2011-02-15 10:43:58'),(1,20,140,'ImporteNetoNoEscurrido','00046.67','Importe',3,12,0,'A','adminDFS','2011-02-15 10:50:09'),(1,20,141,'HoraEnvasado','dat_articulo.HorasEnvasado','Fechas',8,8,0,'A','adminDFS','2011-02-15 10:51:49'),(1,20,142,'HoraCaducidad','dat_articulo.HorasCaducidad','Fechas',8,7,0,'A','adminDFS','2011-02-15 10:52:13'),(1,20,145,'Cabecera1','dat_cabeceras','Cabeceras',7,1,0,'A','adminDFS','2011-02-14 15:02:13'),(1,20,145,'Cabecera2','dat_cabeceras','Cabeceras',7,2,0,'A','adminDFS','2011-02-15 08:47:00'),(1,20,145,'Cabecera3','dat_cabeceras','Cabeceras',7,3,0,'A','adminDFS','2011-02-14 15:04:30'),(1,20,145,'Cabecera4','dat_cabeceras','Cabeceras',7,4,0,'A','adminDFS','2011-02-14 15:04:59'),(1,20,145,'Cabecera5','dat_cabeceras','Cabeceras',7,5,0,'A','adminDFS','2011-02-14 15:05:18'),(1,20,145,'Cabecera6','dat_cabeceras','Cabeceras',7,6,0,'A','adminDFS','2011-02-14 15:05:34'),(1,20,145,'Cabecera7','dat_cabeceras','Cabeceras',7,7,0,'A','adminDFS','2011-02-14 15:05:48'),(1,20,145,'Cabecera8','dat_cabeceras','Cabeceras',7,8,0,'A','adminDFS','2011-02-14 15:06:13'),(1,20,145,'Cabecera9','dat_cabeceras','Cabeceras',7,9,0,'A','adminDFS','2011-02-15 09:21:52'),(1,20,145,'Cabecera10','dat_cabeceras','Cabeceras',7,10,0,'A','adminDFS','2011-02-15 09:22:02'),(1,20,145,'Cabecera11','dat_cabeceras','Cabeceras',7,11,0,'A','adminDFS','2011-02-15 09:22:54'),(1,20,145,'Cabecera12','dat_cabeceras','Cabeceras',7,12,0,'A','adminDFS','2011-02-15 09:23:12'),(1,20,145,'Cabecera13','dat_cabeceras','Cabeceras',7,13,0,'A','adminDFS','2011-02-15 09:23:56'),(1,20,145,'Cabecera14','dat_cabeceras','Cabeceras',7,14,0,'A','adminDFS','2011-02-15 09:24:43'),(1,20,145,'Cabecera15','dat_cabeceras','Cabeceras',7,15,0,'A','adminDFS','2011-02-15 09:25:06'),(1,20,145,'Cabecera16','dat_cabeceras','Cabeceras',7,16,0,'A','adminDFS','2011-04-07 13:26:29'),(1,20,145,'Cabecera17','dat_cabeceras','Cabeceras',7,17,0,'A','adminDFS','2011-04-07 13:26:29'),(1,20,145,'Cabecera18','dat_cabeceras','Cabeceras',7,18,0,'A','adminDFS','2011-04-07 13:26:29'),(1,20,145,'Cabecera19','dat_cabeceras','Cabeceras',7,19,0,'A','adminDFS','2011-04-07 13:26:29'),(1,20,145,'Cabecera20','dat_cabeceras','Cabeceras',7,20,0,'A','adminDFS','2011-04-07 13:26:29'),(1,20,145,'Cabecera21','dat_cabeceras','Cabeceras',7,21,0,'A','adminDFS','2011-04-07 13:26:29'),(1,20,145,'Cabecera22','dat_cabeceras','Cabeceras',7,22,0,'A','adminDFS','2011-04-07 13:26:29'),(1,20,145,'Cabecera23','dat_cabeceras','Cabeceras',7,23,0,'A','adminDFS','2011-04-07 13:26:29'),(1,20,145,'Cabecera24','dat_cabeceras','Cabeceras',7,24,0,'A','adminDFS','2011-04-07 13:26:29'),(1,20,145,'Cabecera25','dat_cabeceras','Cabeceras',7,25,0,'A','adminDFS','2011-04-07 13:26:29'),(1,20,145,'Cabecera26','dat_cabeceras','Cabeceras',7,26,0,'A','adminDFS','2011-04-07 13:26:29'),(1,20,145,'Cabecera27','dat_cabeceras','Cabeceras',7,27,0,'A','adminDFS','2011-04-07 13:26:29'),(1,20,145,'Cabecera28','dat_cabeceras','Cabeceras',7,28,0,'A','adminDFS','2011-04-07 13:26:29'),(1,20,145,'Cabecera29','dat_cabeceras','Cabeceras',7,29,0,'A','adminDFS','2011-04-07 13:26:29'),(1,20,145,'Cabecera30','dat_cabeceras','Cabeceras',7,30,0,'A','adminDFS','2011-04-07 13:26:29'),(1,20,145,'Cabecera31','dat_cabeceras','Cabeceras',7,31,0,'A','adminDFS','2011-04-07 13:26:29'),(1,20,145,'Cabecera32','dat_cabeceras','Cabeceras',7,32,0,'A','adminDFS','2011-04-07 13:26:29'),(1,20,145,'Cabecera33','dat_cabeceras','Cabeceras',7,33,0,'A','adminDFS','2011-04-07 13:26:29'),(1,20,145,'Cabecera34','dat_cabeceras','Cabeceras',7,34,0,'A','adminDFS','2011-04-07 13:26:29'),(1,20,145,'Cabecera35','dat_cabeceras','Cabeceras',7,35,0,'A','adminDFS','2011-04-07 13:26:29'),(1,20,145,'Cabecera36','dat_cabeceras','Cabeceras',7,36,0,'A','adminDFS','2011-04-07 13:26:29'),(1,20,145,'Cabecera37','dat_cabeceras','Cabeceras',7,37,0,'A','adminDFS','2011-04-07 13:26:29'),(1,20,145,'Cabecera38','dat_cabeceras','Cabeceras',7,38,0,'A','adminDFS','2011-04-07 13:26:29'),(1,20,145,'Cabecera39','dat_cabeceras','Cabeceras',7,39,0,'A','adminDFS','2011-04-07 13:26:29'),(1,20,145,'Cabecera40','dat_cabeceras','Cabeceras',7,40,0,'A','adminDFS','2011-04-07 13:26:29'),(1,20,145,'Cabecera41','dat_cabeceras','Cabeceras',7,41,0,'A','adminDFS','2011-04-07 13:26:29'),(1,20,145,'Cabecera42','dat_cabeceras','Cabeceras',7,42,0,'A','adminDFS','2011-04-07 13:26:29'),(1,20,145,'Cabecera43','dat_cabeceras','Cabeceras',7,43,0,'A','adminDFS','2011-04-07 13:26:29'),(1,20,145,'Cabecera44','dat_cabeceras','Cabeceras',7,44,0,'A','adminDFS','2011-04-07 13:26:29'),(1,20,145,'Cabecera45','dat_cabeceras','Cabeceras',7,45,0,'A','adminDFS','2011-04-07 13:26:29'),(1,20,145,'Cabecera46','dat_cabeceras','Cabeceras',7,46,0,'A','adminDFS','2011-04-07 13:26:29'),(1,20,145,'Cabecera47','dat_cabeceras','Cabeceras',7,47,0,'A','adminDFS','2011-04-07 13:26:30'),(1,20,145,'Cabecera48','dat_cabeceras','Cabeceras',7,48,0,'A','adminDFS','2011-04-07 13:26:30'),(1,20,145,'Cabecera49','dat_cabeceras','Cabeceras',7,49,0,'A','adminDFS','2011-04-07 13:26:30'),(1,20,145,'Cabecera50','dat_cabeceras','Cabeceras',7,50,0,'A','adminDFS','2011-04-07 13:26:30'),(1,20,145,'Cabecera51','dat_cabeceras','Cabeceras',7,51,0,'A','adminDFS','2011-04-07 13:26:30'),(1,20,145,'Cabecera52','dat_cabeceras','Cabeceras',7,52,0,'A','adminDFS','2011-04-07 13:26:30'),(1,20,145,'Cabecera53','dat_cabeceras','Cabeceras',7,53,0,'A','adminDFS','2011-04-07 13:26:30'),(1,20,145,'Cabecera54','dat_cabeceras','Cabeceras',7,54,0,'A','adminDFS','2011-04-07 13:26:30'),(1,20,145,'Cabecera55','dat_cabeceras','Cabeceras',7,55,0,'A','adminDFS','2011-04-07 13:26:30'),(1,20,145,'Cabecera56','dat_cabeceras','Cabeceras',7,56,0,'A','adminDFS','2011-04-07 13:26:30'),(1,20,145,'Cabecera57','dat_cabeceras','Cabeceras',7,57,0,'A','adminDFS','2011-04-07 13:26:30'),(1,20,145,'Cabecera58','dat_cabeceras','Cabeceras',7,58,0,'A','adminDFS','2011-04-07 13:26:30'),(1,20,145,'Cabecera59','dat_cabeceras','Cabeceras',7,59,0,'A','adminDFS','2011-04-07 13:26:30'),(1,20,145,'Cabecera60','dat_cabeceras','Cabeceras',7,60,0,'A','adminDFS','2011-04-07 13:26:30'),(1,20,145,'Cabecera61','dat_cabeceras','Cabeceras',7,61,0,'A','adminDFS','2011-04-07 13:26:30'),(1,20,145,'Cabecera62','dat_cabeceras','Cabeceras',7,62,0,'A','adminDFS','2011-04-07 13:26:30'),(1,20,145,'Cabecera63','dat_cabeceras','Cabeceras',7,63,0,'A','adminDFS','2011-04-07 13:26:30'),(1,20,145,'Cabecera64','dat_cabeceras','Cabeceras',7,64,0,'A','adminDFS','2011-04-07 13:26:30'),(1,20,145,'Cabecera65','dat_cabeceras','Cabeceras',7,65,0,'A','adminDFS','2011-04-07 13:26:30'),(1,20,145,'Cabecera66','dat_cabeceras','Cabeceras',7,66,0,'A','adminDFS','2011-04-07 13:26:30'),(1,20,145,'Cabecera67','dat_cabeceras','Cabeceras',7,67,0,'A','adminDFS','2011-04-07 13:26:30'),(1,20,145,'Cabecera68','dat_cabeceras','Cabeceras',7,68,0,'A','adminDFS','2011-04-07 13:26:30'),(1,20,145,'Cabecera69','dat_cabeceras','Cabeceras',7,69,0,'A','adminDFS','2011-04-07 13:26:30'),(1,20,145,'Cabecera70','dat_cabeceras','Cabeceras',7,70,0,'A','adminDFS','2011-04-07 13:26:30'),(1,20,145,'Cabecera71','dat_cabeceras','Cabeceras',7,71,0,'A','adminDFS','2011-04-07 13:26:30'),(1,20,145,'Cabecera72','dat_cabeceras','Cabeceras',7,72,0,'A','adminDFS','2011-04-07 13:26:30'),(1,20,145,'Cabecera73','dat_cabeceras','Cabeceras',7,73,0,'A','adminDFS','2011-04-07 13:26:30'),(1,20,145,'Cabecera74','dat_cabeceras','Cabeceras',7,74,0,'A','adminDFS','2011-04-07 13:26:30'),(1,20,145,'Cabecera75','dat_cabeceras','Cabeceras',7,75,0,'A','adminDFS','2011-04-07 13:26:30'),(1,20,145,'Cabecera76','dat_cabeceras','Cabeceras',7,76,0,'A','adminDFS','2011-04-07 13:26:30'),(1,20,145,'Cabecera77','dat_cabeceras','Cabeceras',7,77,0,'A','adminDFS','2011-04-07 13:26:30'),(1,20,145,'Cabecera78','dat_cabeceras','Cabeceras',7,78,0,'A','adminDFS','2011-04-07 13:26:30'),(1,20,145,'Cabecera79','dat_cabeceras','Cabeceras',7,79,0,'A','adminDFS','2011-04-07 13:26:30'),(1,20,145,'Cabecera80','dat_cabeceras','Cabeceras',7,80,0,'A','adminDFS','2011-04-07 13:26:30'),(1,20,145,'Cabecera81','dat_cabeceras','Cabeceras',7,81,0,'A','adminDFS','2011-04-07 13:26:31'),(1,20,145,'Cabecera82','dat_cabeceras','Cabeceras',7,82,0,'A','adminDFS','2011-04-07 13:26:31'),(1,20,145,'Cabecera83','dat_cabeceras','Cabeceras',7,83,0,'A','adminDFS','2011-04-07 13:26:31'),(1,20,145,'Cabecera84','dat_cabeceras','Cabeceras',7,84,0,'A','adminDFS','2011-04-07 13:26:31'),(1,20,145,'Cabecera85','dat_cabeceras','Cabeceras',7,85,0,'A','adminDFS','2011-04-07 13:26:31'),(1,20,145,'Cabecera86','dat_cabeceras','Cabeceras',7,86,0,'A','adminDFS','2011-04-07 13:26:31'),(1,20,145,'Cabecera87','dat_cabeceras','Cabeceras',7,87,0,'A','adminDFS','2011-04-07 13:26:31'),(1,20,145,'Cabecera88','dat_cabeceras','Cabeceras',7,88,0,'A','adminDFS','2011-04-07 13:26:31'),(1,20,145,'Cabecera89','dat_cabeceras','Cabeceras',7,89,0,'A','adminDFS','2011-04-07 13:26:31'),(1,20,145,'Cabecera90','dat_cabeceras','Cabeceras',7,90,0,'A','adminDFS','2011-04-07 13:26:31'),(1,20,145,'Cabecera91','dat_cabeceras','Cabeceras',7,91,0,'A','adminDFS','2011-04-07 13:26:31'),(1,20,145,'Cabecera92','dat_cabeceras','Cabeceras',7,92,0,'A','adminDFS','2011-04-07 13:26:31'),(1,20,145,'Cabecera93','dat_cabeceras','Cabeceras',7,93,0,'A','adminDFS','2011-04-07 13:26:31'),(1,20,145,'Cabecera94','dat_cabeceras','Cabeceras',7,94,0,'A','adminDFS','2011-04-07 13:26:31'),(1,20,145,'Cabecera95','dat_cabeceras','Cabeceras',7,95,0,'A','adminDFS','2011-04-07 13:26:31'),(1,20,145,'Cabecera96','dat_cabeceras','Cabeceras',7,96,0,'A','adminDFS','2011-04-07 13:26:31'),(1,20,145,'Cabecera97','dat_cabeceras','Cabeceras',7,97,0,'A','adminDFS','2011-04-07 13:26:31'),(1,20,145,'Cabecera98','dat_cabeceras','Cabeceras',7,98,0,'A','adminDFS','2011-04-07 13:26:31'),(1,20,145,'Cabecera99','dat_cabeceras','Cabeceras',7,99,0,'A','adminDFS','2011-04-07 13:26:31'),(1,20,145,'Cabecera100','dat_cabeceras','Cabeceras',7,100,0,'A','adminDFS','2011-04-07 13:26:31'),(1,20,150,'txt_TemperaturaConservacion',NULL,'TextosLiterales',6,34,0,'A','adminDFS','2011-02-15 10:55:34'),(1,20,151,'txt_FabricadoEl',NULL,'TextosLiterales',6,35,0,'A','adminDFS','2011-02-15 10:56:00'),(1,20,152,'txt_FabricadoPor',NULL,'TextosLiterales',6,36,0,'A','adminDFS','2011-02-15 10:56:47'),(1,20,153,'txt_TotalSinRedondear',NULL,'TextosLiterales',6,42,0,'A','adminDFS','2012-08-06 11:00:00'),(1,20,154,'txt_Redondeo',NULL,'TextosLiterales',6,43,0,'A','adminDFS','2012-08-06 11:00:00'),(1,20,158,'CodeNumberChina','dat_articulo.PLUNumber','Articulos',2,26,0,'A','adminDFS','2011-02-15 15:42:36'),(1,20,159,'CodigoBarras2D5',NULL,'CodigoBarras',1,2,0,'A','adminDFS','2011-02-15 15:44:12'),(1,20,160,'txt_NumIdentificacion',NULL,'Trazabilidad',10,1,0,'A','adminDFS','2011-02-15 10:57:48'),(1,20,170,'txt_TipoAnimal',NULL,'Trazabilidad',10,2,0,'A','adminDFS','2011-02-15 11:04:05'),(1,20,172,'NumRapidoAnimal','dat_articulo.IdElemAsociado','Trazabilidad',10,3,0,'A','adminDFS','2011-02-15 11:06:24'),(1,20,185,'Clase','dat_articulo.IdClase','Trazabilidad',10,4,0,'A','adminDFS','2011-02-15 11:16:28'),(1,20,200,'Respuesta1','dat_datadicional.ValorDatAdicional','Trazabilidad',10,25,0,'A','adminDFS','2011-02-16 07:52:31'),(1,20,201,'Respuesta2','dat_datadicional.ValorDatAdicional','Trazabilidad',10,26,0,'A','adminDFS','2011-02-15 15:46:59'),(1,20,202,'Respuesta3','dat_datadicional.ValorDatAdicional','Trazabilidad',10,27,0,'A','adminDFS','2011-02-15 15:46:59'),(1,20,203,'Respuesta4','dat_datadicional.ValorDatAdicional','Trazabilidad',10,28,0,'A','adminDFS','2011-02-15 15:46:59'),(1,20,204,'Respuesta5','dat_datadicional.ValorDatAdicional','Trazabilidad',10,29,0,'A','adminDFS','2011-02-15 15:46:59'),(1,20,205,'Respuesta6','dat_datadicional.ValorDatAdicional','Trazabilidad',10,30,0,'A','adminDFS','2011-02-15 15:46:59'),(1,20,206,'Respuesta7','dat_datadicional.ValorDatAdicional','Trazabilidad',10,31,0,'A','adminDFS','2011-02-15 15:46:59'),(1,20,207,'Respuesta8','dat_datadicional.ValorDatAdicional','Trazabilidad',10,32,0,'A','adminDFS','2011-02-15 15:46:59'),(1,20,208,'Respuesta9','dat_datadicional.ValorDatAdicional','Trazabilidad',10,33,0,'A','adminDFS','2011-02-15 15:46:59'),(1,20,209,'Respuesta10','dat_datadicional.ValorDatAdicional','Trazabilidad',10,34,0,'A','adminDFS','2011-02-16 07:52:31'),(1,20,210,'Respuesta11','dat_datadicional.ValorDatAdicional','Trazabilidad',10,35,0,'A','adminDFS','2011-02-16 07:52:31'),(1,20,211,'Respuesta12','dat_datadicional.ValorDatAdicional','Trazabilidad',10,36,0,'A','adminDFS','2011-02-16 07:52:31'),(1,20,212,'Respuesta13','dat_datadicional.ValorDatAdicional','Trazabilidad',10,37,0,'A','adminDFS','2011-02-16 07:52:31'),(1,20,213,'Respuesta14','dat_datadicional.ValorDatAdicional','Trazabilidad',10,38,0,'A','adminDFS','2011-02-16 07:52:31'),(1,20,214,'Respuesta15','dat_datadicional.ValorDatAdicional','Trazabilidad',10,39,0,'A','adminDFS','2011-02-16 07:52:31'),(1,20,215,'Respuesta16','dat_datadicional.ValorDatAdicional','Trazabilidad',10,40,0,'A','adminDFS','2011-02-16 07:52:31'),(1,20,216,'Respuesta17','dat_datadicional.ValorDatAdicional','Trazabilidad',10,41,0,'A','adminDFS','2011-02-16 07:52:31'),(1,20,217,'Respuesta18','dat_datadicional.ValorDatAdicional','Trazabilidad',10,42,0,'A','adminDFS','2011-02-16 07:52:31'),(1,20,218,'Respuesta19','dat_datadicional.ValorDatAdicional','Trazabilidad',10,43,0,'A','adminDFS','2011-02-16 07:52:31'),(1,20,219,'Respuesta20','dat_datadicional.ValorDatAdicional','Trazabilidad',10,44,0,'A','adminDFS','2011-02-16 07:52:31'),(1,20,220,'Pregunta1','dat_param_clase.Parametro','Trazabilidad',10,5,0,'A','adminDFS','2011-02-16 07:59:06'),(1,20,221,'Pregunta2','dat_param_clase.Parametro','Trazabilidad',10,6,0,'A','adminDFS','2011-02-16 07:59:06'),(1,20,222,'Pregunta3','dat_param_clase.Parametro','Trazabilidad',10,7,0,'A','adminDFS','2011-02-16 07:59:06'),(1,20,223,'Pregunta4','dat_param_clase.Parametro','Trazabilidad',10,8,0,'A','adminDFS','2011-02-16 07:59:06'),(1,20,224,'Pregunta5','dat_param_clase.Parametro','Trazabilidad',10,9,0,'A','adminDFS','2011-02-16 07:59:06'),(1,20,225,'Pregunta6','dat_param_clase.Parametro','Trazabilidad',10,10,0,'A','adminDFS','2011-02-16 07:59:06'),(1,20,226,'Pregunta7','dat_param_clase.Parametro','Trazabilidad',10,11,0,'A','adminDFS','2011-02-16 07:59:06'),(1,20,227,'Pregunta8','dat_param_clase.Parametro','Trazabilidad',10,12,0,'A','adminDFS','2011-02-16 07:59:06'),(1,20,228,'Pregunta9','dat_param_clase.Parametro','Trazabilidad',10,13,0,'A','adminDFS','2011-02-16 07:59:06'),(1,20,229,'Pregunta10','dat_param_clase.Parametro','Trazabilidad',10,14,0,'A','adminDFS','2011-02-16 07:59:06'),(1,20,230,'Pregunta11','dat_param_clase.Parametro','Trazabilidad',10,15,0,'A','adminDFS','2011-02-16 07:59:06'),(1,20,231,'Pregunta12','dat_param_clase.Parametro','Trazabilidad',10,16,0,'A','adminDFS','2011-02-16 07:59:06'),(1,20,232,'Pregunta13','dat_param_clase.Parametro','Trazabilidad',10,17,0,'A','adminDFS','2011-02-16 07:59:06'),(1,20,233,'Pregunta14','dat_param_clase.Parametro','Trazabilidad',10,18,0,'A','adminDFS','2011-02-16 07:59:06'),(1,20,234,'Pregunta15','dat_param_clase.Parametro','Trazabilidad',10,19,0,'A','adminDFS','2011-02-16 07:59:06'),(1,20,235,'Pregunta16','dat_param_clase.Parametro','Trazabilidad',10,20,0,'A','adminDFS','2011-02-16 07:59:06'),(1,20,236,'Pregunta17','dat_param_clase.Parametro','Trazabilidad',10,21,0,'A','adminDFS','2011-02-16 07:59:06'),(1,20,237,'Pregunta18','dat_param_clase.Parametro','Trazabilidad',10,22,0,'A','adminDFS','2011-02-16 07:59:06'),(1,20,238,'Pregunta19','dat_param_clase.Parametro','Trazabilidad',10,23,0,'A','adminDFS','2011-02-16 07:59:06'),(1,20,239,'Pregunta20','dat_param_clase.Parametro','Trazabilidad',10,24,0,'A','adminDFS','2011-02-16 07:59:06'),(1,20,242,'TaraNoEscurrida','000.080','Peso',5,7,0,'A','adminDFS','2012-11-06 07:38:47'),(1,20,243,'PreguntaNutricional','dat_nutricionales_preguntas.Pregunta','Articulos',2,28,0,'A','adminDFS','2015-05-26 11:03:41'),(1,20,244,'RespuestaNutricional','dat_articulo.TextoNutricional','Articulos',2,29,0,'A','adminDFS','2015-05-26 11:06:35'),(1,20,245,'TextoNutricional','dat_nutricionales_preguntas.Texto','Articulos',2,27,0,'A','adminDFS','2012-11-06 13:13:52'),(1,20,246,'txt_FCongelacion',NULL,'TextosLiterales',6,44,0,'A','adminDFS','2014-05-15 10:34:03'),(1,20,247,'txt_FCon',NULL,'TextosLiterales',6,45,0,'A','adminDFS','2014-05-15 10:34:03'),(1,20,248,'FechaCongelacion','dat_articulo.FechaCongelacion','Fechas',8,11,0,'A','adminDFS','2014-05-15 10:34:03'),(1,20,249,'PorcentajeIVA','dat_iva.PorcentajeIVA','Importe',3,14,0,'A','adminDFS','2011-05-22 08:00:00'),(1,20,250,'PesoArabe','01.234','Peso',5,8,0,'A','adminDFS','2013-02-15 10:58:23'),(1,20,251,'PrecioArabe','dat_articulo.PrecioConIva','Precio',4,7,0,'A','adminDFS','2013-02-15 10:58:23'),(1,20,252,'ImporteArabe','00045.67','Importe',3,13,0,'A','adminDFS','2013-02-15 10:58:23'),(1,20,253,'FechaActualArabe',NULL,'Fechas',8,9,0,'A','adminDFS','2013-02-15 10:58:23'),(1,20,254,'FechaCaducidadArabe','dat_articulo.FechaCaducidad','Fechas',8,10,0,'A','adminDFS','2013-02-15 10:58:23'),(1,60,1,'IdTicket','1','Miscelaneas',11,10,0,'A','adminDFS','2014-06-03 09:02:26'),(1,60,2,'NumTicket','1','Miscelaneas',11,20,0,'A','adminDFS','2014-06-03 09:03:06'),(1,60,3,'IdTienda','dat_tienda.IdTienda','Miscelaneas',11,30,0,'A','adminDFS','2014-06-03 09:10:41'),(1,60,4,'NombreTienda','dat_tienda.Nombre','Miscelaneas',11,40,0,'A','adminDFS','2014-06-03 09:11:11'),(1,60,5,'IdBalanzaMaestra','dat_balanza.IdBalanza','Miscelaneas',11,50,0,'A','adminDFS','2014-06-03 09:11:11'),(1,60,6,'NombreBalanzaMaestra','dat_balanza.Nombre','Miscelaneas',11,60,0,'A','adminDFS','2014-06-03 09:12:25'),(1,60,7,'IdBalanzaEsclava','dat_esclava.IdEsclava','Miscelaneas',11,70,0,'A','adminDFS','2014-06-03 09:12:54'),(1,60,8,'NombreBalanzaEsclava','dat_esclava.Nombre','Miscelaneas',11,80,0,'A','adminDFS','2014-06-03 09:13:25'),(1,60,9,'IdVendedor','dat_vendedor.IdVendedor','Miscelaneas',11,90,0,'A','adminDFS','2014-06-03 09:14:02'),(1,60,10,'NombreVendedor','dat_vendedor.Nombre','Miscelaneas',11,100,0,'A','adminDFS','2014-06-03 09:14:40'),(1,60,11,'NumLineas','10','Miscelaneas',11,110,0,'A','adminDFS','2014-06-03 10:01:53'),(1,60,12,'IdTarifa','1','Miscelaneas',11,120,0,'A','adminDFS','2014-06-03 10:02:03'),(1,60,13,'NombreTarifa',NULL,'Miscelaneas',11,130,0,'A','adminDFS','2014-06-03 10:02:05'),(1,60,14,'PuntosFidelidad','10','Miscelaneas',11,140,0,'A','adminDFS','2014-06-03 10:02:11'),(1,60,15,'NombreEmpresa','dat_empresa.NombreEmpresa','Empresa',9,10,0,'A','adminDFS','2014-06-03 09:04:05'),(1,60,16,'CIF_VAT_Empresa','dat_empresa.CIF_VAT','Empresa',9,20,0,'A','adminDFS','2014-06-03 09:04:49'),(1,60,17,'DireccionEmpresa','dat_empresa.Direccion','Empresa',9,30,0,'A','adminDFS','2014-06-03 09:06:28'),(1,60,18,'PoblacionEmpresa','dat_empresa.Poblacion','Empresa',9,40,0,'A','adminDFS','2014-06-03 09:07:11'),(1,60,19,'CPEmpresa','dat_empresa.CodPostal','Empresa',9,50,0,'A','adminDFS','2014-06-03 09:07:56'),(1,60,20,'TelefonoEmpresa',NULL,'Empresa',9,60,0,'A','adminDFS','2014-06-03 09:08:21'),(1,60,21,'ProvinciaEmpresa','dat_empresa.Provincia','Empresa',9,70,0,'A','adminDFS','2014-06-03 09:09:31'),(1,60,22,'IdCliente','dat_cliente.IdCliente','Cliente',10,10,0,'A','adminDFS','2014-06-03 09:11:11'),(1,60,23,'NombreCliente','dat_cliente.Nombre','Cliente',10,20,0,'A','adminDFS','2014-06-03 09:16:24'),(1,60,24,'DNICliente','dat_cliente.NIF','Cliente',10,30,0,'A','adminDFS','2014-06-03 09:18:04'),(1,60,25,'DireccionCliente',NULL,'Cliente',10,40,0,'A','adminDFS','2014-06-03 09:17:56'),(1,60,26,'PoblacionCliente','dat_cliente.Localidad','Cliente',10,50,0,'A','adminDFS','2014-06-03 09:18:50'),(1,60,27,'ProvinciaCliente',NULL,'Cliente',10,60,0,'A','adminDFS','2014-06-03 09:19:19'),(1,60,28,'PaisCliente',NULL,'Cliente',10,70,0,'A','adminDFS','2014-06-03 09:19:45'),(1,60,29,'CPCliente','dat_cliente.CodPostal','Cliente',10,80,0,'A','adminDFS','2014-06-03 09:20:25'),(1,60,30,'TelefonoCliente',NULL,'Cliente',10,90,0,'A','adminDFS','2014-06-03 09:21:10'),(1,60,31,'ImporteLineas','99.99','Importe',4,10,0,'A','adminDFS','2014-06-03 09:42:02'),(1,60,32,'PorcDescuento','10','Importe',4,20,0,'A','adminDFS','2014-06-03 09:42:05'),(1,60,33,'ImporteDescuento','9.99','Importe',4,30,0,'A','adminDFS','2014-06-03 09:42:07'),(1,60,34,'ImporteTotal','99.99','Importe',4,40,0,'A','adminDFS','2014-06-03 09:42:16'),(1,60,35,'ImporteTotalDelIVAConDtoLConDtoTotal','9.99','Importe',4,50,0,'A','adminDFS','2014-06-03 09:51:15'),(1,60,36,'FechaCreacion',NULL,'Fechas',7,10,0,'A','adminDFS','2014-06-03 10:01:43'),(1,60,37,'FechaCaducidad',NULL,'Fechas',7,20,0,'A','adminDFS','2014-06-03 15:05:13'),(1,60,38,'FechaExtra',NULL,'Fechas',7,30,0,'A','adminDFS','2014-06-03 15:05:32'),(1,60,39,'FechaEnvasado',NULL,'Fechas',7,40,0,'A','adminDFS','2014-06-03 15:05:53'),(1,60,40,'FechaCongelacion',NULL,'Fechas',7,50,0,'A','adminDFS','2014-06-03 15:06:16'),(1,60,41,'CodigoBarras',NULL,'CodigoBarras',2,10,0,'A','adminDFS','2014-06-03 10:01:56'),(1,60,42,'CodigoBarras2',NULL,'CodigoBarras',2,20,0,'A','adminDFS','2014-06-03 10:01:59'),(1,60,43,'CodBarrasTalonCaja',NULL,'CodigoBarras',2,30,0,'A','adminDFS','2014-06-03 10:02:01'),(1,60,44,'Linea',NULL,'Formas',12,10,0,'A','adminDFS','2014-06-03 10:11:46'),(1,60,45,'Circulo',NULL,'Formas',12,20,0,'A','adminDFS','2014-06-03 10:11:21'),(1,60,46,'Rectangulo',NULL,'Formas',12,30,0,'A','adminDFS','2014-06-03 10:11:45'),(1,60,47,'IdArticulo','dat_articulo.IdArticulo','Articulos',3,10,0,'A','adminDFS','2014-06-03 14:53:00'),(1,60,48,'Descripcion','dat_articulo.Descripcion','Articulos',3,20,0,'A','adminDFS','2014-06-03 15:03:26'),(1,60,49,'Descripcion1','dat_articulo.Descripcion1','Articulos',3,30,0,'A','adminDFS','2014-06-03 15:03:28'),(1,60,50,'PrecioSinIVA','dat_articulo.PrecioSinIVA','Articulos',3,40,0,'A','adminDFS','2014-06-03 15:03:35'),(1,60,51,'PrecioConIVASinDtoL','dat_articulo.PrecioConIVA','Articulos',3,50,0,'A','adminDFS','2014-06-03 15:03:38'),(1,60,52,'IdIVA','dat_articulo.IdIVA','Articulos',3,60,0,'A','adminDFS','2014-06-03 15:03:40'),(1,60,53,'PorcentajeIVA','dat_articulo.PorcentajeIVA','Articulos',3,70,0,'A','adminDFS','2014-06-03 15:03:42'),(1,60,54,'Descuento','dat_articulo.Descuento','Articulos',3,80,0,'A','adminDFS','2014-06-03 15:03:44'),(1,60,55,'Precio','dat_articulo.PrecioConIVA','Articulos',3,90,0,'A','adminDFS','2014-06-04 06:31:12'),(1,60,56,'CodInterno','dat_articulo.CodInterno','Articulos',3,100,0,'A','adminDFS','2014-06-03 15:10:39'),(1,60,57,'IdClase','dat_articulo.IdClase','Articulos',3,110,0,'A','adminDFS','2014-06-03 15:11:10'),(1,60,58,'NombreClase','dat_articulo.NombreClase','Articulos',3,120,0,'A','adminDFS','2014-06-03 15:11:36'),(1,60,59,'IdElemAsociado','dat_articulo.IdElemAsociado','Articulos',3,130,0,'A','adminDFS','2014-06-03 15:12:07'),(1,60,60,'NombreElemAsociado','dat_articulo.NombreElemAsociado','Articulos',3,140,0,'A','adminDFS','2014-06-03 15:12:44'),(1,60,61,'IdFamilia','dat_articulo.IdFamilia','Articulos',3,150,0,'A','adminDFS','2014-06-03 15:13:16'),(1,60,62,'NombreFamilia','dat_articulo.NombreFamilia','Articulos',3,160,0,'A','adminDFS','2014-06-03 15:13:39'),(1,60,63,'IdSeccion','dat_articulo.IdSeccion','Articulos',3,170,0,'A','adminDFS','2014-06-03 15:14:03'),(1,60,64,'NombreSeccion','dat_articulo.NombreSeccion','Articulos',3,180,0,'A','adminDFS','2014-06-03 15:14:27'),(1,60,65,'IdSubFamilia','dat_articulo.IdSubFamilia','Articulos',3,190,0,'A','adminDFS','2014-06-03 15:15:06'),(1,60,66,'NombreSubFamilia','dat_articulo.NombreSubFamilia','Articulos',3,200,0,'A','adminDFS','2014-06-03 15:15:34'),(1,60,67,'IdDepartamento','dat_articulo.IdDepartamento','Articulos',3,210,0,'A','adminDFS','2014-06-03 15:16:10'),(1,60,68,'NombreDepartamento','dat_articulo.NombreDepartamento','Articulos',3,220,0,'A','adminDFS','2014-06-03 15:16:35'),(1,60,69,'Texto1','dat_articulo.Texto1','Articulos',3,230,0,'A','adminDFS','2014-06-03 15:17:11'),(1,60,70,'Texto2','dat_articulo.Texto2','Articulos',3,240,0,'A','adminDFS','2014-06-03 15:18:05'),(1,60,71,'Texto3','dat_articulo.Texto3','Articulos',3,250,0,'A','adminDFS','2014-06-03 15:18:25'),(1,60,72,'Texto4','dat_articulo.Texto4','Articulos',3,260,0,'A','adminDFS','2014-06-03 15:18:47'),(1,60,73,'Texto5','dat_articulo.Texto5','Articulos',3,270,0,'A','adminDFS','2014-06-03 15:19:09'),(1,60,74,'Texto6','dat_articulo.Texto6','Articulos',3,280,0,'A','adminDFS','2014-06-03 15:19:32'),(1,60,75,'Texto7','dat_articulo.Texto7','Articulos',3,290,0,'A','adminDFS','2014-06-03 15:25:29'),(1,60,76,'Texto8','dat_articulo.Texto8','Articulos',3,300,0,'A','adminDFS','2014-06-03 15:25:53'),(1,60,77,'Texto9','dat_articulo.Texto9','Articulos',3,310,0,'A','adminDFS','2014-06-03 15:26:19'),(1,60,78,'Texto10','dat_articulo.Texto10','Articulos',3,320,0,'A','adminDFS','2014-06-03 15:26:40'),(1,60,79,'Texto11','dat_articulo.Texto11','Articulos',3,330,0,'A','adminDFS','2014-06-03 15:27:00'),(1,60,80,'Texto12','dat_articulo.Texto12','Articulos',3,340,0,'A','adminDFS','2014-06-03 15:27:19'),(1,60,81,'Texto13','dat_articulo.Texto13','Articulos',3,350,0,'A','adminDFS','2014-06-03 15:27:44'),(1,60,82,'Texto14','dat_articulo.Texto14','Articulos',3,360,0,'A','adminDFS','2014-06-03 15:28:35'),(1,60,83,'Texto15','dat_articulo.Texto15','Articulos',3,370,0,'A','adminDFS','2014-06-03 15:29:15'),(1,60,84,'Texto16','dat_articulo.Texto16','Articulos',3,380,0,'A','adminDFS','2014-06-03 15:29:38'),(1,60,85,'Texto17','dat_articulo.Texto17','Articulos',3,390,0,'A','adminDFS','2014-06-03 15:30:00'),(1,60,86,'Texto18','dat_articulo.Texto18','Articulos',3,400,0,'A','adminDFS','2014-06-03 15:30:21'),(1,60,87,'Texto19','dat_articulo.Texto19','Articulos',3,410,0,'A','adminDFS','2014-06-03 15:34:40'),(1,60,88,'Texto20','dat_articulo.Texto20','Articulos',3,420,0,'A','adminDFS','2014-06-03 15:35:05'),(1,60,89,'TextoLibre','dat_articulo.TextoLibre','Articulos',3,430,0,'A','adminDFS','2014-06-03 15:35:27'),(1,60,90,'Tara','1.000','Peso',5,10,0,'A','adminDFS','2014-06-03 15:03:31'),(1,60,91,'Peso','2.000','Peso',5,20,0,'A','adminDFS','2014-06-03 15:03:33'),(1,60,92,'PesoRegalado','0.500','Peso',5,30,0,'A','adminDFS','2014-06-04 06:35:36'),(1,60,93,'Comportamiento',NULL,'Peso',5,40,0,'A','adminDFS','2014-06-11 11:11:30'),(1,60,94,'PalabraTara',NULL,'Peso',5,50,0,'A','adminDFS','2014-06-11 11:12:38'),(1,60,95,'PalabraNeto',NULL,'Peso',5,60,0,'A','adminDFS','2014-06-11 11:12:56'),(1,60,96,'Imagen',NULL,'Imagenes',1,10,0,'A','adminDFS','2014-06-06 11:25:43'),(1,60,97,'TextoLibre',NULL,'TextosLibres',6,10,0,'A','adminDFS','2014-06-09 07:41:44'),(1,60,98,'Trazabilidad',NULL,'Trazabilidad',8,10,0,'A','adminDFS','2014-06-09 09:39:24'),(1,60,99,'SimboloMoneda',NULL,'Importe',4,60,0,'A','adminDFS','2014-06-11 11:13:50');
UNLOCK TABLES;
/*!40000 ALTER TABLE `sys_campos_etiqueta` ENABLE KEYS */;

--
-- Table structure for table `sys_letras_sustitucion`
--

DROP TABLE IF EXISTS `sys_letras_sustitucion`;
CREATE TABLE `sys_letras_sustitucion` (
  `IdLetra` char(1) NOT NULL default '',
  `Representacion` varchar(50) default NULL,
  `ClaveTraduccion` varchar(20) default NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdLetra`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guarda el significado de cada letra';

--
-- Dumping data for table `sys_letras_sustitucion`
--


/*!40000 ALTER TABLE `sys_letras_sustitucion` DISABLE KEYS */;
LOCK TABLES `sys_letras_sustitucion` WRITE;
INSERT INTO `sys_letras_sustitucion` (`IdLetra`, `Representacion`, `ClaveTraduccion`, `IdEmpresa`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`) VALUES ('A','Numero de Grupo','numeroDeGrupo',1,0,'M','admindfs','2010-10-06 07:34:11'),('B','Numero de cliente','numeroDeCliente',1,0,'A','admindfs','2010-10-06 07:34:14'),('C','Codigo de articulo','codigoDeArticulo',1,0,'A','admindfs','2010-10-06 07:34:18'),('D','Codigo de empleado','codigoDeEmpleado',1,0,'A','admindfs','2010-10-06 07:34:22'),('E','Importe total del ticket','importeTotalTicket',1,0,'A','admindfs','2010-10-06 07:34:26'),('F','Signo del importe','signoDelImporte',1,0,'A','admindfs','2010-10-06 07:34:30'),('G','Numero de articulos','numeroDeArticulos',1,0,'A','admindfs','2010-10-06 07:34:38'),('H','Peso','peso',1,0,'A','admindfs','2010-10-06 07:36:08'),('I','Tipo de IVA','tipoDeIVA',1,0,'A','admindfs','2010-10-06 07:36:12'),('K','Seccion','seccion',1,0,'A','admindfs','2010-10-06 07:36:16'),('M','Número de equipo','numeroEquipo',1,0,'A','admindfs','2015-02-11 14:33:25'),('N','Numero de ticket','numeroTicket',1,0,'A','admindfs','2010-10-06 07:36:20'),('P','Code number','codeNumber',1,0,'A','admindfs','2010-10-06 07:36:16'),('Q','Check de control','checkDeControl',1,0,'A','admindfs','2010-10-06 07:36:23'),('R','Peso con 2 decimal','pesoCon2Decimales',1,0,'A','admindfs','2010-10-06 07:36:28'),('T','Tara','tara',1,0,'A','admindfs','2010-10-06 07:36:35'),('X','Precio (en scaner)','precioEnEscanner',1,0,'M','admindfs','2010-10-06 07:36:39'),('Y','Importe en segunda divisa','importeSegundaDivisa',1,0,'A','admindfs','2010-10-06 07:36:46');
UNLOCK TABLES;
/*!40000 ALTER TABLE `sys_letras_sustitucion` ENABLE KEYS */;

--
-- Table structure for table `sys_letras_sustitucion_ean128`
--

DROP TABLE IF EXISTS `sys_letras_sustitucion_ean128`;
CREATE TABLE `sys_letras_sustitucion_ean128` (
  `IdLetra` char(3) NOT NULL default '',
  `Representacion` varchar(50) default NULL,
  `ClaveTraduccion` varchar(20) default NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdLetra`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guarda el significado de cada letra';

--
-- Dumping data for table `sys_letras_sustitucion_ean128`
--


/*!40000 ALTER TABLE `sys_letras_sustitucion_ean128` DISABLE KEYS */;
LOCK TABLES `sys_letras_sustitucion_ean128` WRITE;
INSERT INTO `sys_letras_sustitucion_ean128` (`IdLetra`, `Representacion`, `ClaveTraduccion`, `IdEmpresa`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`) VALUES ('A','Numero de Grupo','numeroDeGrupo',1,0,'M','admindfs','2011-11-16 08:55:51'),('B','Numero de cliente','numeroDeCliente',1,0,'A','admindfs','2011-11-16 08:56:11'),('C','Codigo de articulo','codigoDeArticulo',1,0,'A','admindfs','2010-10-06 07:34:18'),('D','Codigo de empleado','codigoDeEmpleado',1,0,'A','admindfs','2010-10-06 07:34:22'),('E','Importe total del ticket','importeTotalTicket',1,0,'A','admindfs','2010-10-06 07:34:26'),('F','Signo del importe','signoDelImporte',1,0,'A','admindfs','2010-10-06 07:34:30'),('G','Numero de articulos','numeroDeArticulos',1,0,'A','admindfs','2010-10-06 07:34:38'),('H','Peso','peso',1,0,'A','admindfs','2010-10-06 07:36:08'),('I','Tipo de IVA','tipoDeIVA',1,0,'A','admindfs','2010-10-06 07:36:12'),('K','Seccion','seccion',1,0,'A','admindfs','2010-10-06 07:36:16'),('N','Numero de equipo','numeroEquipo',1,0,'A','admindfs','2011-11-16 08:57:48'),('O','Fecha de caducidad','fechaCaducidad',1,0,'A','admindfs','2013-10-07 07:10:35'),('P','Fecha extra','columnLFechaExtra',1,0,'A','admindfs','2013-10-07 07:10:29'),('T','Numero de etiqueta','numeroEtiqueta',1,0,'A','admindfs','2011-11-16 08:54:29'),('t60','Peso acumulado animal 2','pesoAcumuladoAnimal2',1,0,'A','admindfs','2013-01-18 11:08:48'),('t61','Peso acumulado animal 3','pesoAcumuladoAnimal3',1,0,'A','admindfs','2013-01-18 11:13:18'),('X','Precio (en scaner)','precioEnEscanner',1,0,'M','admindfs','2010-10-06 07:36:39'),('Y','Importe en segunda divisa','importeSegundaDivisa',1,0,'A','admindfs','2010-10-06 07:36:46');
UNLOCK TABLES;
/*!40000 ALTER TABLE `sys_letras_sustitucion_ean128` ENABLE KEYS */;

--
-- Table structure for table `sys_letras_sustitucion_fecha`
--

DROP TABLE IF EXISTS `sys_letras_sustitucion_fecha`;
CREATE TABLE `sys_letras_sustitucion_fecha` (
  `IdLetra` char(1) NOT NULL default '',
  `Representacion` varchar(50) default NULL,
  `ClaveTraduccion` varchar(20) default NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdLetra`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guarda el significado de cada letra';

--
-- Dumping data for table `sys_letras_sustitucion_fecha`
--


/*!40000 ALTER TABLE `sys_letras_sustitucion_fecha` DISABLE KEYS */;
LOCK TABLES `sys_letras_sustitucion_fecha` WRITE;
INSERT INTO `sys_letras_sustitucion_fecha` (`IdLetra`, `Representacion`, `ClaveTraduccion`, `IdEmpresa`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`) VALUES ('','Espacio','Espacio',1,0,'A','admindfs','2011-08-25 10:14:35'),('-','Guion','Guion',1,0,'A','admindfs','2012-01-23 09:59:58'),('/','Barra','Barra',1,0,'A','admindfs','2012-07-25 10:13:50'),(':','Dos puntos','DosPuntos',1,0,'A','admindfs','2012-07-25 10:13:50'),('D','Dia','Dia',1,0,'A','admindfs','2012-01-23 10:00:04'),('H','Horas','Horas',1,0,'A','admindfs','2011-08-25 07:23:08'),('J','Dia juliano','DiaJuliano',1,0,'A','admindfs','2012-01-23 10:00:09'),('M','Mes','Mes',1,0,'A','admindfs','2011-08-25 07:23:13'),('N','Minutos','Minutos',1,0,'A','admindfs','2011-08-25 07:23:20'),('Y','Anio','Anio',1,0,'A','admindfs','2012-01-23 10:00:20'),('_','Subrayado','Subrayado',1,0,'A','admindfs','2011-08-25 10:13:50');
UNLOCK TABLES;
/*!40000 ALTER TABLE `sys_letras_sustitucion_fecha` ENABLE KEYS */;

--
-- Table structure for table `sys_logos`
--

DROP TABLE IF EXISTS `sys_logos`;
CREATE TABLE `sys_logos` (
  `IdEmpresa` int(11) NOT NULL,
  `IdLogo` int(11) NOT NULL,
  `TipoLogo` int(11) default NULL,
  `NombreLogo` varchar(50) default NULL,
  `Bmp` longblob,
  `Orden500` int(11) default NULL,
  `Bmp500` longblob,
  `AjusteBmp500` int(11) default NULL,
  `Ancho500` int(11) default NULL,
  `Alto500` int(11) default NULL,
  `OrdenL` int(11) default NULL,
  `BmpL` longblob,
  `AjusteBmpL` int(11) default NULL,
  `AnchoL` int(11) default NULL,
  `AltoL` int(11) default NULL,
  `Activo` int(11) NOT NULL default '1',
  `OrdenStar` int(11) default NULL,
  `BmpStar` longblob,
  `AnchoStar` int(11) default NULL,
  `AltoStar` int(11) default NULL,
  `OrdenD900_12` int(11) default NULL,
  `BmpD900_12` longblob,
  `AnchoD900_12` int(11) default NULL,
  `AltoD900_12` int(11) default NULL,
  `OrdenD900_15` int(11) default NULL,
  `BmpD900_15` longblob,
  `AnchoD900_15` int(11) default NULL,
  `AltoD900_15` int(11) default NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdLogo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `sys_logos`
--


/*!40000 ALTER TABLE `sys_logos` DISABLE KEYS */;
LOCK TABLES `sys_logos` WRITE;
INSERT INTO `sys_logos` (`IdEmpresa`, `IdLogo`, `TipoLogo`, `NombreLogo`, `Bmp`, `Orden500`, `Bmp500`, `AjusteBmp500`, `Ancho500`, `Alto500`, `OrdenL`, `BmpL`, `AjusteBmpL`, `AnchoL`, `AltoL`, `Activo`, `OrdenStar`, `BmpStar`, `AnchoStar`, `AltoStar`, `OrdenD900_12`, `BmpD900_12`, `AnchoD900_12`, `AltoD900_12`, `OrdenD900_15`, `BmpD900_15`, `AnchoD900_15`, `AltoD900_15`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`) VALUES (1,1,1,'Vaca.bmp','BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0/\0 /\0----\0~)\0~	 \0 \0\0\0!q0>\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',1,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0/\0 /\0----\0~)\0~	 \0 \0\0\0!q0>\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'A','admindfs','2012-04-02 14:19:57'),(1,2,1,'Cordero.bmp','BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\08gCCCG///O?p??\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',2,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\08gCCCG///O?p??\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'A','admindfs','2012-04-02 14:19:57'),(1,3,1,'Pato.bmp','BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?#\0|>?<?|9i13{[\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',3,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?#\0|>?<?|9i13{[\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'A','admindfs','2012-04-02 14:19:57'),(1,4,1,'Bacalao.bmp','BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?<\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0?\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',4,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?<\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0?\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'A','admindfs','2012-04-02 14:19:57'),(1,5,1,'Cerezas.bmp','BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0<\0\0\0\0?\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0@\0?\0\0?!?????~x\0\0|`\0<\08\0\08\0\0x??0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',5,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0<\0\0\0\0?\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0@\0?\0\0?!?????~x\0\0|`\0<\08\0\08\0\0x??0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'A','admindfs','2012-04-02 14:19:57'),(1,6,1,'Uvas.bmp','BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\000p93\0w{ypwa\0sslss<pd\0!?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',6,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\000p93\0w{ypwa\0sslss<pd\0!?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'A','admindfs','2012-04-02 14:19:57'),(1,7,1,'Chorizo.bmp','BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0À\0\0\0?8?8\0\0\0\0 \0`\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',7,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0À\0\0\0?8?8\0\0\0\0 \0`\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'A','admindfs','2012-04-02 14:19:57'),(1,8,1,'Puerros.bmp','BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0s)?\'?\0$ @,b0O\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',8,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0s)?\'?\0$ @,b0O\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'A','admindfs','2012-04-02 14:19:57'),(1,9,1,'Jamon.bmp','BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0?\0??ϟg3	??9=a	\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',9,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0?\0??ϟg3	??9=a	\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'A','admindfs','2012-04-02 14:19:57'),(1,10,1,'Olivas.bmp','BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0C!?8~88????\0??1a\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',10,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0C!?8~88????\0??1a\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'A','admindfs','2012-04-02 14:19:57'),(1,11,1,'Nuez.bmp','BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\01=<91\09{\'Gxr<N\'?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',11,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\01=<91\09{\'Gxr<N\'?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'A','admindfs','2012-04-02 14:19:57'),(1,12,1,'caramelo.bmp','BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?W\0??\0?πAq\0w\0\0\0g\0??\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',12,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?W\0??\0?πAq\0w\0\0\0g\0??\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,NULL,NULL,NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'A','admindfs','2012-04-02 14:19:57'),(1,13,1,'Lpollo.bmp','BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0}\0\0\0r\0\0\0s\0\0\0\'\0\0\0\0ߏ\0\0\0\0\0\0\0\0\0\0?\0\0\0>?\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',13,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0}\0\0\0r\0\0\0s\0\0\0\'\0\0\0\0ߏ\0\0\0\0\0\0\0\0\0\0?\0\0\0>?\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,13,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0}\0\0\0r\0\0\0s\0\0\0\'\0\0\0\0ߏ\0\0\0\0\0\0\0\0\0\0?\0\0\0>?\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'A','admindfs','2012-04-02 14:19:57'),(1,14,1,'Lberen.bmp','BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0??\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\088???\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',14,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0??\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\088???\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,14,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0??\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\088???\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'A','admindfs','2012-04-02 14:19:57'),(1,15,1,'Lpan.bmp','BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',15,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,15,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'A','admindfs','2012-04-02 14:19:57'),(1,16,1,'Lcarne.bmp','BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\00\0\0\0\0`\0\0\0\0\0@\0\0\0\0\0@\0\0\0\0 \0\0\0\00\0\0\0\0\0\0\0\0\09\0\0\0\0\0\0\0\09\0\0\01\0\0\03\0\0\0s\0\0\0\0g\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0?\0\0\0s\0\0\0\0\0\0Ϗ\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',16,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\00\0\0\0\0`\0\0\0\0\0@\0\0\0\0\0@\0\0\0\0 \0\0\0\00\0\0\0\0\0\0\0\0\09\0\0\0\0\0\0\0\09\0\0\01\0\0\03\0\0\0s\0\0\0\0g\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0?\0\0\0s\0\0\0\0\0\0Ϗ\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,16,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\00\0\0\0\0`\0\0\0\0\0@\0\0\0\0\0@\0\0\0\0 \0\0\0\00\0\0\0\0\0\0\0\0\09\0\0\0\0\0\0\0\09\0\0\01\0\0\03\0\0\0s\0\0\0\0g\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0?\0\0\0s\0\0\0\0\0\0Ϗ\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'A','admindfs','2012-04-02 14:19:57'),(1,17,1,'Lchampi.bmp','BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?~??<c8xx?yyx}|<>>??0NM	I	Hh|)\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',17,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?~??<c8xx?yyx}|<>>??0NM	I	Hh|)\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,17,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?~??<c8xx?yyx}|<>>??0NM	I	Hh|)\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'A','admindfs','2012-04-02 14:19:57'),(1,18,1,'Llang.bmp','BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0>\03\0>`\0\0\0\0\0\0\0\0\0\0\0\0\0\0=\0\0\0\00?p?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',18,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0>\03\0>`\0\0\0\0\0\0\0\0\0\0\0\0\0\0=\0\0\0\00?p?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,18,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0>\03\0>`\0\0\0\0\0\0\0\0\0\0\0\0\0\0=\0\0\0\00?p?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'A','admindfs','2012-04-02 14:19:57'),(1,19,1,'Llechu.bmp','BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0?\0\0\0\0\0\0\0\0\0\08\0\0p~\0\0\0\0\0\0\0\0\0\0\0\0\0,&s#@0\0@?\0`\\\0. \03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',19,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0?\0\0\0\0\0\0\0\0\0\08\0\0p~\0\0\0\0\0\0\0\0\0\0\0\0\0,&s#@0\0@?\0`\\\0. \03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,19,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0?\0\0\0\0\0\0\0\0\0\08\0\0p~\0\0\0\0\0\0\0\0\0\0\0\0\0,&s#@0\0@?\0`\\\0. \03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'A','admindfs','2012-04-02 14:19:57'),(1,20,1,'Llimon.bmp','BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?|0cq310|\0?\0t??aÅ\0?\0???\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',20,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?|0cq310|\0?\0t??aÅ\0?\0???\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,20,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?|0cq310|\0?\0t??aÅ\0?\0???\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'A','admindfs','2012-04-02 14:19:57'),(1,21,1,'Lmanz.bmp','BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0<\0\0\0\0\0|\0\0\0\0\0x\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0x\0\0\0\0\0x\0\0\0\0\0<\0\0\0\0\0>\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\04\0\0\0d?\0\0\0F?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',21,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0<\0\0\0\0\0|\0\0\0\0\0x\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0x\0\0\0\0\0x\0\0\0\0\0<\0\0\0\0\0>\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\04\0\0\0d?\0\0\0F?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,21,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0<\0\0\0\0\0|\0\0\0\0\0x\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0x\0\0\0\0\0x\0\0\0\0\0<\0\0\0\0\0>\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\04\0\0\0d?\0\0\0F?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'A','admindfs','2012-04-02 14:19:57'),(1,22,1,'Lmorci.bmp','BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0@\0\0`\0\0|\0\0\0\0\0\0\0\0?\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',22,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0@\0\0`\0\0|\0\0\0\0\0\0\0\0?\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,22,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0@\0\0`\0\0|\0\0\0\0\0\0\0\0?\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'A','admindfs','2012-04-02 14:19:57'),(1,23,1,'Lplatan.bmp','BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\01#O\0?\0\0<\0x\0?>p\0O`a \0\0\0\0a4?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',23,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\01#O\0?\0\0<\0x\0?>p\0O`a \0\0\0\0a4?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,23,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\01#O\0?\0\0<\0x\0?>p\0O`a \0\0\0\0a4?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'A','admindfs','2012-04-02 14:19:57'),(1,24,1,'Ltomate.bmp','BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0G\0\0\0\0C\0\0\0\0\0\0\0\0\0\0\0\0 \0\00\0p c\0c\0\0\0\0\0\0\0\0\0\0\0@\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',24,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0G\0\0\0\0C\0\0\0\0\0\0\0\0\0\0\0\0 \0\00\0p c\0c\0\0\0\0\0\0\0\0\0\0\0@\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,24,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0G\0\0\0\0C\0\0\0\0\0\0\0\0\0\0\0\0 \0\00\0p c\0c\0\0\0\0\0\0\0\0\0\0\0@\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'A','admindfs','2012-04-02 14:19:57'),(1,25,1,'Laguaca.bmp','BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\08\0? \0< \0\00\0\00\00\08\0<\0\0\0\0|8>0> ><\0>\0<\0?\0<\0|x?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',25,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\08\0? \0< \0\00\0\00\00\08\0<\0\0\0\0|8>0> ><\0>\0<\0?\0<\0|x?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,25,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\08\0? \0< \0\00\0\00\00\08\0<\0\0\0\0|8>0> ><\0>\0<\0?\0<\0|x?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'A','admindfs','2012-04-02 14:19:57'),(1,26,1,'Lzanaho.bmp','BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?@?\0\0\0\0\0\0\0\0\0\0\0?\0?\0\0<	\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',26,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?@?\0\0\0\0\0\0\0\0\0\0\0?\0?\0\0<	\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,26,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?@?\0\0\0\0\0\0\0\0\0\0\0?\0?\0\0<	\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'A','admindfs','2012-04-02 14:19:57'),(1,27,1,'Lpimien.bmp','BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\08\0\0\0\0\0\0\0\0\0\0<\0\0\08\0\0\08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',27,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\08\0\0\0\0\0\0\0\0\0\0<\0\0\08\0\0\08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,27,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\08\0\0\0\0\0\0\0\0\0\0<\0\0\08\0\0\08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'A','admindfs','2012-04-02 14:19:57'),(1,28,1,'Lqueso.bmp','BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0?\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0?Ï\0\0\0\0\0\0p\0\0\0\0\0\0?	c\0\0\0\0c\0\0\0\0q\0\0\0>\0q\0\0\0>\0q\0\0\0x\0\0\0x\0\0\0\0|\0\0\00\0|\0\0\0`\n\0|\0\0\0\0|\0\0\0\0a\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',28,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0?\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0?Ï\0\0\0\0\0\0p\0\0\0\0\0\0?	c\0\0\0\0c\0\0\0\0q\0\0\0>\0q\0\0\0>\0q\0\0\0x\0\0\0x\0\0\0\0|\0\0\00\0|\0\0\0`\n\0|\0\0\0\0|\0\0\0\0a\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,28,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0?\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0?Ï\0\0\0\0\0\0p\0\0\0\0\0\0?	c\0\0\0\0c\0\0\0\0q\0\0\0>\0q\0\0\0>\0q\0\0\0x\0\0\0x\0\0\0\0|\0\0\00\0|\0\0\0`\n\0|\0\0\0\0|\0\0\0\0a\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'A','admindfs','2012-04-02 14:19:57'),(1,29,1,'Lpera.bmp','BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0~\0\0\0x\0\0\0\0\0?\0?9?2?2(\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',29,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0~\0\0\0x\0\0\0\0\0?\0?9?2?2(\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,29,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0~\0\0\0x\0\0\0\0\0?\0?9?2?2(\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'A','admindfs','2012-04-02 14:19:57'),(1,30,1,'Lpez.bmp','BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0??\0\0\0\0\0\0\0\0\0\0\0\0\0`\0\0\00\0\0\0\0\0\0\0\0\0\0 \0\0 \0\0@\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',30,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0??\0\0\0\0\0\0\0\0\0\0\0\0\0`\0\0\00\0\0\0\0\0\0\0\0\0\0 \0\0 \0\0@\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,30,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0??\0\0\0\0\0\0\0\0\0\0\0\0\0`\0\0\00\0\0\0\0\0\0\0\0\0\0 \0\0 \0\0@\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'A','admindfs','2012-04-02 14:19:57'),(1,31,1,'Lpez1.bmp','BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?0\0?0\0\0\0?\0\0G\03\0\0\0\0\0\0\0\0\0\0\0\0\0\0@\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',31,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?0\0?0\0\0\0?\0\0G\03\0\0\0\0\0\0\0\0\0\0\0\0\0\0@\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,31,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?0\0?0\0\0\0?\0\0G\03\0\0\0\0\0\0\0\0\0\0\0\0\0\0@\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'A','admindfs','2012-04-02 14:19:57'),(1,32,1,'Lpimi1.bmp','BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0q\01\01\01\0\0\0\0\0\0\0\0OOO\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',32,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0q\01\01\01\0\0\0\0\0\0\0\0OOO\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,32,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0q\01\01\01\0\0\0\0\0\0\0\0OOO\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'A','admindfs','2012-04-02 14:19:57'),(1,33,1,'Lpulpo.bmp','BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0??\0\0q\00 8<@?C!!\0\0\0\0\0\0\0\0\00\0\0\0 \0\0\0\0\00\0x0\0|G|\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',33,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0??\0\0q\00 8<@?C!!\0\0\0\0\0\0\0\0\00\0\0\0 \0\0\0\0\00\0x0\0|G|\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,33,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0??\0\0q\00 8<@?C!!\0\0\0\0\0\0\0\0\00\0\0\0 \0\0\0\0\00\0x0\0|G|\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'A','admindfs','2012-04-02 14:19:57'),(1,34,1,'Lsandia.bmp','BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?<\0?p\0r\0\0BD\0\0\08\0\0\0\0\00\0\0\0\0\0?0\0a@\0@\0\0\0\0@\0\0\0\0D\0@F@@\03@ \0g`\0\0O3\0<??\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',34,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?<\0?p\0r\0\0BD\0\0\08\0\0\0\0\00\0\0\0\0\0?0\0a@\0@\0\0\0\0@\0\0\0\0D\0@F@@\03@ \0g`\0\0O3\0<??\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,34,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?<\0?p\0r\0\0BD\0\0\08\0\0\0\0\00\0\0\0\0\0?0\0a@\0@\0\0\0\0@\0\0\0\0D\0@F@@\03@ \0g`\0\0O3\0<??\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'A','admindfs','2012-04-02 14:19:57'),(1,35,1,'Lcerdo.bmp','BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0@\0\0??A?À\0\0\0\0c{\r=	x!3p\06\0O\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',35,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0@\0\0??A?À\0\0\0\0c{\r=	x!3p\06\0O\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,35,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0@\0\0??A?À\0\0\0\0c{\r=	x!3p\06\0O\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'A','admindfs','2012-04-02 14:19:57'),(1,36,1,'Lpastel.bmp','BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\08\0\0\0\0\0\0?\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0	\0\0\09\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',36,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\08\0\0\0\0\0\0?\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0	\0\0\09\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,36,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\08\0\0\0\0\0\0?\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0	\0\0\09\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'A','admindfs','2012-04-02 14:19:57'),(1,37,1,'Lconejo.bmp','BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0?\0\0\0\0\0\0\0@\0\0\0\0\0\0\0\0\0\0\0\0\0@\0\0\0\0\0\0\0\0\0 \0\0\0(\0\0\0\0\0\00\0\0\0\0\0??1???\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',37,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0?\0\0\0\0\0\0\0@\0\0\0\0\0\0\0\0\0\0\0\0\0@\0\0\0\0\0\0\0\0\0 \0\0\0(\0\0\0\0\0\00\0\0\0\0\0??1???\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,37,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0?\0\0\0\0\0\0\0@\0\0\0\0\0\0\0\0\0\0\0\0\0@\0\0\0\0\0\0\0\0\0 \0\0\0(\0\0\0\0\0\00\0\0\0\0\0??1???\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'A','admindfs','2012-04-02 14:19:57'),(1,38,1,'Lcalaba.bmp','BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0  ???????????Æ1cp\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',38,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0  ???????????Æ1cp\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,38,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0  ???????????Æ1cp\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'A','admindfs','2012-04-02 14:19:57'),(1,39,1,'Lpizza.bmp','BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0x\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0Ȃ\0\0\0\08\08\0\0\0\0<<\0\0\0\0|\0\0\0|\0\0\0fx\0\0\0p \0\0\0\02i\0\0\0~	\0\0\0A\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\08\0\0\0\00\0\0\01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',39,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0x\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0Ȃ\0\0\0\08\08\0\0\0\0<<\0\0\0\0|\0\0\0|\0\0\0fx\0\0\0p \0\0\0\02i\0\0\0~	\0\0\0A\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\08\0\0\0\00\0\0\01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,39,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0x\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0Ȃ\0\0\0\08\08\0\0\0\0<<\0\0\0\0|\0\0\0|\0\0\0fx\0\0\0p \0\0\0\02i\0\0\0~	\0\0\0A\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\08\0\0\0\00\0\0\01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'A','admindfs','2012-04-02 14:19:57'),(1,40,1,'Lcolas.bmp','BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0?\0\0\0}\0\0\0y\0\0\0\0\0\0#\0\0\0>9\03\0\0\0>\099\0\0\0>y9\0\0\0<>9<\0\0\0	<\0\0\0<\0\0\0\0\0\0\0\0\0\0~\0\0\0 \0|\0\0\0P\0\0\0ðτ\0\0\0#\0\0\0c\0\0\0\0\0\0\0\0\0H~\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',40,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0?\0\0\0}\0\0\0y\0\0\0\0\0\0#\0\0\0>9\03\0\0\0>\099\0\0\0>y9\0\0\0<>9<\0\0\0	<\0\0\0<\0\0\0\0\0\0\0\0\0\0~\0\0\0 \0|\0\0\0P\0\0\0ðτ\0\0\0#\0\0\0c\0\0\0\0\0\0\0\0\0H~\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,40,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0?\0\0\0}\0\0\0y\0\0\0\0\0\0#\0\0\0>9\03\0\0\0>\099\0\0\0>y9\0\0\0<>9<\0\0\0	<\0\0\0<\0\0\0\0\0\0\0\0\0\0~\0\0\0 \0|\0\0\0P\0\0\0ðτ\0\0\0#\0\0\0c\0\0\0\0\0\0\0\0\0H~\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'A','admindfs','2012-04-02 14:19:57'),(1,41,1,'Lhelado.bmp','BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0SOO8\0?\0\0?\0\0(\0 \0\0\0\0\0\0\0\0?\0\0\0\0?\0\0?\0?\0?\0?\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',41,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0SOO8\0?\0\0?\0\0(\0 \0\0\0\0\0\0\0\0?\0\0\0\0?\0\0?\0?\0?\0?\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,41,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0SOO8\0?\0\0?\0\0(\0 \0\0\0\0\0\0\0\0?\0\0\0\0?\0\0?\0?\0?\0?\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'A','admindfs','2012-04-02 14:19:57'),(1,42,1,'Lmaiz.bmp','BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0%`\0\0@\0\0?D\0\0\0\0\0@\0\0\0$\0H\0?\0\0?@$H\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',42,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0%`\0\0@\0\0?D\0\0\0\0\0@\0\0\0$\0H\0?\0\0?@$H\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,42,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0%`\0\0@\0\0?D\0\0\0\0\0@\0\0\0$\0H\0?\0\0?@$H\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'A','admindfs','2012-04-02 14:19:57'),(1,43,1,'Lmasa.bmp','BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0???\0\0\0@8\0\0\08\0\0`0\0`\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',43,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0???\0\0\0@8\0\0\08\0\0`0\0`\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,43,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0???\0\0\0@8\0\0\08\0\0`0\0`\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'A','admindfs','2012-04-02 14:19:57'),(1,44,1,'Lpina.bmp','BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0<\0?\0\0_\0\0\0\0\0\0\0_\0\0\0\0\0O\0\0_\0\n\0\0\0>\0\0H\n\0\0=\0?\0\0 ????\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',44,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0<\0?\0\0_\0\0\0\0\0\0\0_\0\0\0\0\0O\0\0_\0\n\0\0\0>\0\0H\n\0\0=\0?\0\0 ????\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,44,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0<\0?\0\0_\0\0\0\0\0\0\0_\0\0\0\0\0O\0\0_\0\n\0\0\0>\0\0H\n\0\0=\0?\0\0 ????\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'A','admindfs','2012-04-02 14:19:57'),(1,45,1,'Lcebolla.bmp','BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0#!aa`\0p\08\0\0\0\0\0\0\0<\0\0|\0\0?\0\0\0?\0\0?\0\0?\0\0?\0\0?\0\0\0?\0\0\0?\0\0\0?\Z\0\0\0\0@\0\0&\0?\0?\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',45,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0#!aa`\0p\08\0\0\0\0\0\0\0<\0\0|\0\0?\0\0\0?\0\0?\0\0?\0\0?\0\0?\0\0\0?\0\0\0?\0\0\0?\Z\0\0\0\0@\0\0&\0?\0?\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,45,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0#!aa`\0p\08\0\0\0\0\0\0\0<\0\0|\0\0?\0\0\0?\0\0?\0\0?\0\0?\0\0?\0\0\0?\0\0\0?\0\0\0?\Z\0\0\0\0@\0\0&\0?\0?\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'A','admindfs','2012-04-02 14:19:57'),(1,46,1,'Lpavo.bmp','BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0 >???\0?\0\0\0\0\0\0\0\0\0\0?\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0p\08>\0\0w?7??\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',46,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0 >???\0?\0\0\0\0\0\0\0\0\0\0?\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0p\08>\0\0w?7??\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,46,'BM>\0\0\0\0\0\0>\0\0\0(\0\0\0(\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0 >???\0?\0\0\0\0\0\0\0\0\0\0?\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0p\08>\0\0w?7??\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,40,32,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'A','admindfs','2012-04-02 14:19:57'),(1,47,2,'LogoCarniceria.bmp','BM\0\0\0\0\0\0>\0\0\0(\0\0\0P\0\0\0P\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0?\0\0?\0\0?\0\0?\0\0?\0\0?\0\0?\0\0?\0\0?|\0\0?|\0\0?\0\0\0?\0\0?\0\0??\0\0??\0\0??\0\0??\0\0??\0\0??\0\0??\0\0?\0\0?\0\0?\0\0?!C\0\0?!C\0\0?!\0\0?\0\0?\0\0?C\0\0?C\0\0?\0\0??\0\0??\0\0??\0\0??\0\0?\0\0\0\0?\0\0?\0\0?\0\0?\0\0?\0\0?\0\0?\0\0?\0\0?\0\0?\0\0?\0\0?\0\0?1q\0\0?1q\0\0?q}\0\0?yq\0\0?yq\0\0?x\0\0?x\0\08`\0\08\0\0\08\0\0\08?\0\08?\0\0>\0\0?\0\0?\0\0?\0\0?\0\0?\0\0\0?~\0\0\0\0?~\0\0\0\0??\0\0\0\0??\0\0\0\0?\0\0~\0\0?\0\0?\0\0?\0\0?\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',1,'BM\0\0\0\0\0\0>\0\0\0(\0\0\0P\0\0\0P\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0?\0\0?\0\0?\0\0?\0\0?\0\0?\0\0?\0\0?\0\0?|\0\0?|\0\0?\0\0\0?\0\0?\0\0??\0\0??\0\0??\0\0??\0\0??\0\0??\0\0??\0\0?\0\0?\0\0?\0\0?!C\0\0?!C\0\0?!\0\0?\0\0?\0\0?C\0\0?C\0\0?\0\0??\0\0??\0\0??\0\0??\0\0?\0\0\0\0?\0\0?\0\0?\0\0?\0\0?\0\0?\0\0?\0\0?\0\0?\0\0?\0\0?\0\0?\0\0?1q\0\0?1q\0\0?q}\0\0?yq\0\0?yq\0\0?x\0\0?x\0\08`\0\08\0\0\08\0\0\08?\0\08?\0\0>\0\0?\0\0?\0\0?\0\0?\0\0?\0\0\0?~\0\0\0\0?~\0\0\0\0??\0\0\0\0??\0\0\0\0?\0\0~\0\0?\0\0?\0\0?\0\0?\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,80,80,1,'BM\0\0\0\0\0\0>\0\0\0(\0\0\0P\0\0\0P\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0?\0\0?\0\0?\0\0?\0\0?\0\0?\0\0?\0\0?\0\0?|\0\0?|\0\0?\0\0\0?\0\0?\0\0??\0\0??\0\0??\0\0??\0\0??\0\0??\0\0??\0\0?\0\0?\0\0?\0\0?!C\0\0?!C\0\0?!\0\0?\0\0?\0\0?C\0\0?C\0\0?\0\0??\0\0??\0\0??\0\0??\0\0?\0\0\0\0?\0\0?\0\0?\0\0?\0\0?\0\0?\0\0?\0\0?\0\0?\0\0?\0\0?\0\0?\0\0?1q\0\0?1q\0\0?q}\0\0?yq\0\0?yq\0\0?x\0\0?x\0\08`\0\08\0\0\08\0\0\08?\0\08?\0\0>\0\0?\0\0?\0\0?\0\0?\0\0?\0\0\0?~\0\0\0\0?~\0\0\0\0??\0\0\0\0??\0\0\0\0?\0\0~\0\0?\0\0?\0\0?\0\0?\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,80,80,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'A','admindfs','2012-04-02 14:19:57'),(1,48,2,'LogoCharcuteria.bmp','BM\0\0\0\0\0\0>\0\0\0(\0\0\0P\0\0\0P\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0?\0\0\0\0\0\0?\0\0\0\0\0\0~\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0>\0\0\0\0\0\0\0?\0\0\0\0\0\0?\0\0\0\0\0?\0\0\0\0\0?\0\0\0\0\0?\0\0\0\0\0\0?\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0`\0\0\0\0`\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0À\0\0\0\0\0?\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\08\0\0\0\0\0\0\08\0\0\0\0\0\0\08\0\0\0\0\0\0\0\08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0>\0\0\0\0\0\0\0\0\0\0\0>\0\0\0\0\0\0\0\0\0\0\0~\0\0\0\0\0\0\0\0\0\0\0p\0\0\0\0\0\0\0\0\0\0\0p\0\0\0\0\0\0\0\0\0\0\0@\0\0\0\0\0\0\0\0\0\0\0@\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',2,'BM\0\0\0\0\0\0>\0\0\0(\0\0\0P\0\0\0P\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0?\0\0\0\0\0\0?\0\0\0\0\0\0~\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0>\0\0\0\0\0\0\0?\0\0\0\0\0\0?\0\0\0\0\0?\0\0\0\0\0?\0\0\0\0\0?\0\0\0\0\0\0?\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0`\0\0\0\0`\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0À\0\0\0\0\0?\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\08\0\0\0\0\0\0\08\0\0\0\0\0\0\08\0\0\0\0\0\0\0\08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0>\0\0\0\0\0\0\0\0\0\0\0>\0\0\0\0\0\0\0\0\0\0\0~\0\0\0\0\0\0\0\0\0\0\0p\0\0\0\0\0\0\0\0\0\0\0p\0\0\0\0\0\0\0\0\0\0\0@\0\0\0\0\0\0\0\0\0\0\0@\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,80,80,2,'BM\0\0\0\0\0\0>\0\0\0(\0\0\0P\0\0\0P\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0?\0\0\0\0\0\0?\0\0\0\0\0\0~\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0>\0\0\0\0\0\0\0?\0\0\0\0\0\0?\0\0\0\0\0?\0\0\0\0\0?\0\0\0\0\0?\0\0\0\0\0\0?\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0`\0\0\0\0`\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0À\0\0\0\0\0?\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\08\0\0\0\0\0\0\08\0\0\0\0\0\0\08\0\0\0\0\0\0\0\08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0>\0\0\0\0\0\0\0\0\0\0\0>\0\0\0\0\0\0\0\0\0\0\0~\0\0\0\0\0\0\0\0\0\0\0p\0\0\0\0\0\0\0\0\0\0\0p\0\0\0\0\0\0\0\0\0\0\0@\0\0\0\0\0\0\0\0\0\0\0@\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,80,80,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'A','admindfs','2012-04-02 14:19:57'),(1,49,2,'LogoAves.bmp','BM\0\0\0\0\0\0>\0\0\0(\0\0\0P\0\0\0P\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0?\0\0\0\0\0\0\0\0\0\0\0\0?\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0?\0\0>>\0\0>>\0\0>>\0\0\0\0\0<\0\0\0\0<\0\0p\0\0@p\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0|\0\0\0\0\0\0\0\0|\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',3,'BM\0\0\0\0\0\0>\0\0\0(\0\0\0P\0\0\0P\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0?\0\0\0\0\0\0\0\0\0\0\0\0?\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0?\0\0>>\0\0>>\0\0>>\0\0\0\0\0<\0\0\0\0<\0\0p\0\0@p\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0|\0\0\0\0\0\0\0\0|\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,80,80,3,'BM\0\0\0\0\0\0>\0\0\0(\0\0\0P\0\0\0P\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0?\0\0\0\0\0\0\0\0\0\0\0\0?\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0?\0\0>>\0\0>>\0\0>>\0\0\0\0\0<\0\0\0\0<\0\0p\0\0@p\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0|\0\0\0\0\0\0\0\0|\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,80,80,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'A','admindfs','2012-04-02 14:19:57'),(1,50,2,'LogoPescaderia.bmp','BM\0\0\0\0\0\0>\0\0\0(\0\0\0P\0\0\0P\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0@\0\0\0\0@\0\0\0\0\0\0@\0\0\0\0@\0\0\0\0\0\0|\0\0\0\0\0\0\0\0\0|\0\0\0\0\0\0\0\0\0~\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0?\0\0\0\0\0\0?\0?\0\0\0\0\0\0?\0\0\0\0\0\0?\0\0\0\0\0\0?\0\0\0\0\0\0?\0\0\0\0\0\0?\0\0\0\0\0\0?\0\0\0\0\0\0\0?\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0>\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\08\0\0\0\0\0\0\0\0\0\00\0\0\0\0\0\0\0\0p\0\0\0\0\0\0\0\0\0\0P\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',4,'BM\0\0\0\0\0\0>\0\0\0(\0\0\0P\0\0\0P\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0@\0\0\0\0@\0\0\0\0\0\0@\0\0\0\0@\0\0\0\0\0\0|\0\0\0\0\0\0\0\0\0|\0\0\0\0\0\0\0\0\0~\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0?\0\0\0\0\0\0?\0?\0\0\0\0\0\0?\0\0\0\0\0\0?\0\0\0\0\0\0?\0\0\0\0\0\0?\0\0\0\0\0\0?\0\0\0\0\0\0?\0\0\0\0\0\0\0?\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0>\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\08\0\0\0\0\0\0\0\0\0\00\0\0\0\0\0\0\0\0p\0\0\0\0\0\0\0\0\0\0P\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,80,80,4,'BM\0\0\0\0\0\0>\0\0\0(\0\0\0P\0\0\0P\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0@\0\0\0\0@\0\0\0\0\0\0@\0\0\0\0@\0\0\0\0\0\0|\0\0\0\0\0\0\0\0\0|\0\0\0\0\0\0\0\0\0~\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0?\0\0\0\0\0\0?\0?\0\0\0\0\0\0?\0\0\0\0\0\0?\0\0\0\0\0\0?\0\0\0\0\0\0?\0\0\0\0\0\0?\0\0\0\0\0\0?\0\0\0\0\0\0\0?\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0>\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\08\0\0\0\0\0\0\0\0\0\00\0\0\0\0\0\0\0\0p\0\0\0\0\0\0\0\0\0\0P\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,80,80,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'A','admindfs','2012-04-02 14:19:57'),(1,51,2,'LogoFruteria.bmp','BM\0\0\0\0\0\0>\0\0\0(\0\0\0P\0\0\0P\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0|\0\0\0\0\0\0\0\0\0|\0\0\0\0\0\0\0\0\0|\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0 \0\0\0|\0\0\0\0\0\0\0|\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0!\0\0!\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',5,'BM\0\0\0\0\0\0>\0\0\0(\0\0\0P\0\0\0P\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0|\0\0\0\0\0\0\0\0\0|\0\0\0\0\0\0\0\0\0|\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0 \0\0\0|\0\0\0\0\0\0\0|\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0!\0\0!\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,80,80,5,'BM\0\0\0\0\0\0>\0\0\0(\0\0\0P\0\0\0P\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0|\0\0\0\0\0\0\0\0\0|\0\0\0\0\0\0\0\0\0|\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0 \0\0\0|\0\0\0\0\0\0\0|\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0!\0\0!\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,80,80,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'A','admindfs','2012-04-02 14:19:57'),(1,53,2,'LogoPuntoVerdeG.bmp','BM\0\0\0\0\0\0>\0\0\0(\0\0\0P\0\0\0P\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\00\0\0\0\0\0\0\0@\0\0\0?\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0??\0\0\0?\0\0\0\0\0\0\0????\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',7,'BM\0\0\0\0\0\0>\0\0\0(\0\0\0P\0\0\0P\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\00\0\0\0\0\0\0\0@\0\0\0?\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0??\0\0\0?\0\0\0\0\0\0\0????\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,80,80,7,'BM\0\0\0\0\0\0>\0\0\0(\0\0\0P\0\0\0P\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\00\0\0\0\0\0\0\0@\0\0\0?\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0??\0\0\0?\0\0\0\0\0\0\0????\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,80,80,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'A','admindfs','2012-04-02 14:19:57'),(1,54,2,'LogoRegSanitario.bmp','BM\0\0\0\0\0\0>\0\0\0(\0\0\0X\0\0\0:\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0?\0q?\0?\0?\0\0q?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0?\0\0\0?\0??\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',8,'BM\0\0\0\0\0\0>\0\0\0(\0\0\0X\0\0\0:\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0?\0q?\0?\0?\0\0q?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0?\0\0\0?\0??\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,88,58,8,'BM\0\0\0\0\0\0>\0\0\0(\0\0\0X\0\0\0:\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0\0\0\0?\0q?\0?\0?\0\0q?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0?\0\0\0?\0??\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,88,58,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'A','admindfs','2012-04-02 14:19:57'),(1,55,2,'LogoPuntoVerdeP.bmp','BM\0\0\0\0\0\0>\0\0\0(\0\0\00\0\0\00\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\00p\0p\0p\0?x\08\0<\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0??\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',9,'BM\0\0\0\0\0\0>\0\0\0(\0\0\00\0\0\00\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\00p\0p\0p\0?x\08\0<\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0??\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,48,48,9,'BM\0\0\0\0\0\0>\0\0\0(\0\0\00\0\0\00\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\00p\0p\0p\0?x\08\0<\0\0\0\0\0\0?\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0?\0\0??\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,48,48,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'A','admindfs','2012-04-02 14:19:57'),(1,56,2,'LogoE.bmp','BM\0\0\0\0\0\0\0>\0\0\0(\0\0\0\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0>\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0>\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',10,'BM\0\0\0\0\0\0\0>\0\0\0(\0\0\0\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0>\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0>\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,24,32,10,'BM\0\0\0\0\0\0\0>\0\0\0(\0\0\0\0\0\0 \0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0>\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0>\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',63,24,32,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'A','admindfs','2012-04-02 14:19:57');
UNLOCK TABLES;
/*!40000 ALTER TABLE `sys_logos` ENABLE KEYS */;

--
-- Table structure for table `sys_ordenes_balanzas`
--

DROP TABLE IF EXISTS `sys_ordenes_balanzas`;
CREATE TABLE `sys_ordenes_balanzas` (
  `IdEmpresa` int(11) NOT NULL,
  `IdTienda` int(11) NOT NULL,
  `IdBalanza` int(11) NOT NULL,
  `IdOrden` int(11) NOT NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdTienda`,`IdBalanza`,`IdOrden`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `sys_ordenes_balanzas`
--


/*!40000 ALTER TABLE `sys_ordenes_balanzas` DISABLE KEYS */;
LOCK TABLES `sys_ordenes_balanzas` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `sys_ordenes_balanzas` ENABLE KEYS */;

--
-- Table structure for table `sys_ordenes_rgi`
--

DROP TABLE IF EXISTS `sys_ordenes_rgi`;
CREATE TABLE `sys_ordenes_rgi` (
  `IdEmpresa` int(11) NOT NULL,
  `IdOrden` int(11) NOT NULL COMMENT '1=Parar,2=Reanudar,3=EnvioModificaciones',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdOrden`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `sys_ordenes_rgi`
--


/*!40000 ALTER TABLE `sys_ordenes_rgi` DISABLE KEYS */;
LOCK TABLES `sys_ordenes_rgi` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `sys_ordenes_rgi` ENABLE KEYS */;

--
-- Table structure for table `sys_registra_version`
--

DROP TABLE IF EXISTS `sys_registra_version`;
CREATE TABLE `sys_registra_version` (
  `IdRegistro` int(11) NOT NULL auto_increment,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  `Descripcion` varchar(255) default NULL,
  `Ok` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`IdRegistro`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='InnoDB free: 31744 kB';

--
-- Dumping data for table `sys_registra_version`
--


/*!40000 ALTER TABLE `sys_registra_version` DISABLE KEYS */;
LOCK TABLES `sys_registra_version` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `sys_registra_version` ENABLE KEYS */;

--
-- Table structure for table `sys_seg_aplicacion`
--

DROP TABLE IF EXISTS `sys_seg_aplicacion`;
CREATE TABLE `sys_seg_aplicacion` (
  `IdAplicacion` varchar(20) NOT NULL,
  `NombreAplicacion` varchar(50) default NULL,
  `ClaveTraduccion` varchar(20) default NULL,
  `IdEmpresa` int(11) default NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdAplicacion`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guardan los distintos modos de entrar a la ap';

--
-- Dumping data for table `sys_seg_aplicacion`
--


/*!40000 ALTER TABLE `sys_seg_aplicacion` DISABLE KEYS */;
LOCK TABLES `sys_seg_aplicacion` WRITE;
INSERT INTO `sys_seg_aplicacion` (`IdAplicacion`, `NombreAplicacion`, `ClaveTraduccion`, `IdEmpresa`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`) VALUES ('Mantenimiento','Mantenimiento','mnuMAplicacion',1,0,'M','admindfs','2010-10-21 08:04:18');
UNLOCK TABLES;
/*!40000 ALTER TABLE `sys_seg_aplicacion` ENABLE KEYS */;

--
-- Table structure for table `sys_seg_controles`
--

DROP TABLE IF EXISTS `sys_seg_controles`;
CREATE TABLE `sys_seg_controles` (
  `IdVentana` varchar(50) NOT NULL,
  `IdControl` varchar(50) NOT NULL,
  `IdPerfilSeguridad` varchar(20) NOT NULL,
  `Visible` tinyint(1) default '0',
  `Modificable` tinyint(1) default '0',
  `Texto` varchar(50) default NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdPerfilSeguridad`,`IdVentana`,`IdControl`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guarda la informacion de los controles de ';

--
-- Dumping data for table `sys_seg_controles`
--


/*!40000 ALTER TABLE `sys_seg_controles` DISABLE KEYS */;
LOCK TABLES `sys_seg_controles` WRITE;
INSERT INTO `sys_seg_controles` (`IdVentana`, `IdControl`, `IdPerfilSeguridad`, `Visible`, `Modificable`, `Texto`, `IdEmpresa`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`) VALUES ('frmArticulo','btnIVA','NoPrice',1,0,NULL,1,0,'A','admindfs','2013-06-27 10:58:50'),('frmArticulo','btnOfertaTempora','NoPrice',1,0,NULL,1,0,'A','admindfs','2013-06-27 10:54:17'),('frmArticulo','btnPrecioSegmento','NoPrice',1,0,NULL,1,0,'A','admindfs','2013-06-27 10:29:24'),('frmArticulo','btnRegaloSegmento','NoPrice',1,0,NULL,1,0,'A','admindfs','2013-06-27 10:29:25'),('frmArticulo','cboAlterarPrecio','NoPrice',1,0,NULL,1,0,'A','admindfs','2013-06-27 13:56:08'),('frmArticulo','cboIVA','NoPrice',1,0,NULL,1,0,'A','admindfs','2013-06-27 10:58:51'),('frmArticulo','cboOfertaTemporal','NoPrice',1,0,NULL,1,0,'A','admindfs','2013-06-27 10:54:18'),('frmArticulo','cboTipoOferta','NoPrice',1,0,NULL,1,0,'A','admindfs','2013-06-27 10:29:27'),('frmArticulo','lblAlterarPrecio','NoPrice',1,0,NULL,1,0,'A','admindfs','2013-06-27 13:56:13'),('frmArticulo','lblDescripcion','NoPrice',1,0,NULL,1,0,'A','admindfs','2013-06-28 08:01:13'),('frmArticulo','lblDescripcion1','NoPrice',1,0,NULL,1,0,'A','admindfs','2013-06-28 08:01:14'),('frmArticulo','lblDescripcion2','NoPrice',1,0,NULL,1,0,'A','admindfs','2013-06-28 08:01:16'),('frmArticulo','lblIVA','NoPrice',1,0,NULL,1,0,'A','admindfs','2013-06-27 10:58:52'),('frmArticulo','lblOfertaTemporal','NoPrice',1,0,NULL,1,0,'A','admindfs','2013-06-27 10:54:19'),('frmArticulo','lblPConIVA','NoPrice',1,0,NULL,1,0,'A','admindfs','2013-06-27 10:29:19'),('frmArticulo','lblPOferta1','NoPrice',1,0,NULL,1,0,'A','admindfs','2013-06-27 10:29:21'),('frmArticulo','lblPorcIVA','NoPrice',1,0,NULL,1,0,'A','admindfs','2013-06-27 10:58:55'),('frmArticulo','lblPrecio','NoPrice',1,0,NULL,1,0,'A','admindfs','2013-06-27 10:29:29'),('frmArticulo','lblTipoOferta','NoPrice',1,0,NULL,1,0,'A','admindfs','2013-06-27 10:29:31'),('frmArticulo','txtDescripcion','NoPrice',1,0,NULL,1,0,'A','admindfs','2013-06-28 08:01:18'),('frmArticulo','txtDescripcion1','NoPrice',1,0,NULL,1,0,'A','admindfs','2013-06-28 08:01:19'),('frmArticulo','txtDescripcion2','NoPrice',1,0,NULL,1,0,'A','admindfs','2013-06-28 08:01:20'),('frmArticulo','txtPConIVA','NoPrice',1,0,NULL,1,0,'A','admindfs','2013-06-27 10:54:22'),('frmArticulo','txtPEstandar','NoPrice',1,0,NULL,1,0,'A','admindfs','2013-06-27 10:29:33'),('frmArticulo','txtPOferta1','NoPrice',1,0,NULL,1,0,'A','admindfs','2013-06-27 10:29:37');
UNLOCK TABLES;
/*!40000 ALTER TABLE `sys_seg_controles` ENABLE KEYS */;

--
-- Table structure for table `sys_seg_impresion`
--

DROP TABLE IF EXISTS `sys_seg_impresion`;
CREATE TABLE `sys_seg_impresion` (
  `IdOrden` varchar(1) default NULL,
  `IdModo` char(1) default '1',
  `Previsualizar` char(1) default NULL,
  `TextoCampoVacio` varchar(50) default '1',
  `Titulo` int(11) default '1',
  `FondoTitulo` int(11) default '1',
  `Cabecera` int(11) default '1',
  `FondoCabecera` int(11) default '1',
  `CampoVacio` int(11) default NULL,
  `FondoCampoVacio` int(11) default NULL,
  `Campo` int(11) default NULL,
  `FondoCampo` int(11) default NULL,
  `FondoSeparacion` int(11) default NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) NOT NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  UNIQUE KEY `IdEmpresa` (`IdEmpresa`,`Usuario`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guardan la configuracion de impresion p';

--
-- Dumping data for table `sys_seg_impresion`
--


/*!40000 ALTER TABLE `sys_seg_impresion` DISABLE KEYS */;
LOCK TABLES `sys_seg_impresion` WRITE;
INSERT INTO `sys_seg_impresion` (`IdOrden`, `IdModo`, `Previsualizar`, `TextoCampoVacio`, `Titulo`, `FondoTitulo`, `Cabecera`, `FondoCabecera`, `CampoVacio`, `FondoCampoVacio`, `Campo`, `FondoCampo`, `FondoSeparacion`, `IdEmpresa`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`) VALUES ('1','0','1','EMPTY',-65536,-2894893,-16776961,-1,-65536,-1,-16777216,-1,-2894893,1,0,'M','admin','2010-01-29 11:35:47');
UNLOCK TABLES;
/*!40000 ALTER TABLE `sys_seg_impresion` ENABLE KEYS */;

--
-- Table structure for table `sys_seg_listado`
--

DROP TABLE IF EXISTS `sys_seg_listado`;
CREATE TABLE `sys_seg_listado` (
  `IdTabla` varchar(20) NOT NULL,
  `IdCampo` varchar(20) NOT NULL,
  `IdPerfilSeguridad` varchar(20) NOT NULL,
  `Visible` tinyint(1) default '0',
  `IdEmpresa` int(11) NOT NULL default '1',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdPerfilSeguridad`,`IdTabla`,`IdCampo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guarda los permisos que tienen los campos de ';

--
-- Dumping data for table `sys_seg_listado`
--


/*!40000 ALTER TABLE `sys_seg_listado` DISABLE KEYS */;
LOCK TABLES `sys_seg_listado` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `sys_seg_listado` ENABLE KEYS */;

--
-- Table structure for table `sys_seg_menu`
--

DROP TABLE IF EXISTS `sys_seg_menu`;
CREATE TABLE `sys_seg_menu` (
  `IdPerfilSeguridad` varchar(20) NOT NULL COMMENT 'Perfil de seguridad',
  `IdMenu` varchar(20) NOT NULL COMMENT 'Menu al que pertenece',
  `IdNombre` varchar(30) NOT NULL COMMENT 'Miembro del menu',
  `IdPadre` varchar(20) default NULL COMMENT 'Padre del que cuelga. Si es nulo sera del nivel 0.',
  `IdClaveTraduccion` varchar(30) default NULL COMMENT 'Clave que correspondera con la del archivo de recursos para su traduccion',
  `Icono` varchar(20) default NULL,
  `Orden` int(11) default NULL COMMENT 'Orden en el que apareceran en el menu',
  `Visible` tinyint(1) default NULL,
  `Accion` varchar(30) default NULL COMMENT 'Accion que se tiene que ejecutar desde el menu',
  `IdEmpresa` int(11) NOT NULL default '1',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdPerfilSeguridad`,`IdMenu`,`IdNombre`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guarda la informacion del menu de la aplic';

--
-- Dumping data for table `sys_seg_menu`
--


/*!40000 ALTER TABLE `sys_seg_menu` DISABLE KEYS */;
LOCK TABLES `sys_seg_menu` WRITE;
INSERT INTO `sys_seg_menu` (`IdPerfilSeguridad`, `IdMenu`, `IdNombre`, `IdPadre`, `IdClaveTraduccion`, `Icono`, `Orden`, `Visible`, `Accion`, `IdEmpresa`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`) VALUES ('AdminDFS','Mantenimiento','AccesoBD','Configuracion','mnuAccesoBD',NULL,20,1,'FrmReAccesoBD',1,0,'A','admindfs','2012-02-29 08:48:15'),('AdminDFS','Mantenimiento','Ajustes',NULL,'mnuAjustes',NULL,121,1,NULL,1,0,'A','admindfs','2012-01-17 10:00:00'),('AdminDFS','Mantenimiento','Articulo Alta rapida','Menu Articulos','dat_articulo_AltaRapida',NULL,20,1,'frmArticuloAltaRapida',1,1,'M','admindfs','2012-03-07 08:14:36'),('AdminDFS','Mantenimiento','Articulos','Menu Articulos','dat_articulo_Titulo',NULL,10,1,'frmArticulo',1,1,'A','admindfs','2012-03-07 08:14:33'),('AdminDFS','Mantenimiento','ArticulosPorBalanza','Asoc articulos','ArticulosPorBalanza',NULL,20,1,'FrmArticulosPorBalanza',1,0,'A','admindfs','2012-10-16 09:22:15'),('AdminDFS','Mantenimiento','Asoc Articulos','Asociaciones','mnuAsocArticulos',NULL,10,1,NULL,1,0,'A','admindfs','2012-03-07 08:16:52'),('AdminDFS','Mantenimiento','Asoc Balanza Alfanumerica','Asoc Publicidad','mnuBalanzaAlfanumerica',NULL,10,1,'FrmAsocPublicidadAlfanumerica',1,0,'A','admindfs','2012-03-07 08:19:54'),('AdminDFS','Mantenimiento','Asoc Configuracion Parametros','Asociaciones','mnuAsocConfiguracionParametros',NULL,30,1,'FrmAsocConfiguracionParametros',1,0,'A','admindfs','2012-03-07 08:16:55'),('AdminDFS','Mantenimiento','Asoc Macros','Asociaciones','mnuAsocMacros',NULL,50,1,'FrmGrupoMacros',1,0,'A','admindfs','2012-03-07 08:16:58'),('AdminDFS','Mantenimiento','Asoc Publicidad','Asociaciones','mnuPublicidad',NULL,40,1,NULL,1,0,'A','admindfs','2012-03-07 08:16:56'),('AdminDFS','Mantenimiento','Asoc Vendedores','Asociaciones','mnuAsocVendedores',NULL,20,1,NULL,1,0,'A','admindfs','2012-03-07 08:16:54'),('AdminDFS','Mantenimiento','Asociaciones',NULL,'mnuAsociaciones',NULL,150,1,NULL,1,1,'A','admindfs','2012-03-07 08:33:18'),('AdminDFS','Mantenimiento','Avisos Email','Configuracion','mnuAvisosEmail',NULL,50,1,'FrmAvisosEmail',1,0,'A','admindfs','2012-02-29 08:49:00'),('AdminDFS','Mantenimiento','Balanza','Importar Exportar','mnuBalanzaImportar',NULL,30,1,NULL,1,0,'A','admindfs','2012-04-24 14:19:17'),('AdminDFS','Mantenimiento','Balanza Grafica','EdicionGeneral','mnuPlantillasPubliGrafica',NULL,10,1,'FrmPublicidadGrafica',1,1,'A','china','2012-03-07 08:16:40'),('AdminDFS','Mantenimiento','Basedatos','Importar Exportar','mnuBaseDatosImportar','',10,1,NULL,1,0,'A','admindfs','2012-04-24 14:19:17'),('AdminDFS','Mantenimiento','Borrado Ventas','Configuracion','mnuBorradoVentas',NULL,70,1,'FrmBorradoVentas',1,0,'A','admindfs','2012-03-07 08:42:50'),('AdminDFS','Mantenimiento','Cabeceras ticket','Formatos','mnuCabecerasTicket',NULL,10,1,'FrmGrupoCabeceras',1,0,'A','admindfs','2012-03-07 08:15:45'),('AdminDFS','Mantenimiento','CDA','Gama500','mnuCDA',NULL,30,1,'FrmCDA',1,0,'M','admindfs','2012-10-31 14:16:20'),('AdminDFS','Mantenimiento','CDA_D900','Publicidad','mnuD900',NULL,60,1,'FrmCDA',1,0,'A','admindfs','2013-05-31 11:04:11'),('AdminDFS','Mantenimiento','Claves Balanza','Menu Datos','mnuClavesBalanza',NULL,110,1,'FrmClavesBalanza',1,0,'A','admindfs','2013-07-12 06:27:06'),('AdminDFS','Mantenimiento','Clientes','Menu Textos','mnuCliente',NULL,90,1,'FrmCliente',1,0,'A','admindfs','2013-02-13 11:00:00'),('AdminDFS','Mantenimiento','Codigos Barras General','Menu Datos','mnuCodBarras',NULL,40,1,'frmCodBarras',1,0,'A','admindfs','2012-03-07 08:16:20'),('AdminDFS','Mantenimiento','Configuracion',NULL,'mnuConfiguracion',NULL,10,1,NULL,1,0,'A','admindfs','2012-03-07 07:56:46'),('AdminDFS','Mantenimiento','Configuracion DFS','Configuracion','mnuConfiguracionDFS',NULL,10,1,'FrmConfiguracionDFS',1,0,'A','admindfs','2012-02-29 08:48:09'),('AdminDFS','Mantenimiento','DGI','Balanza','mnuDGI',NULL,10,1,'FrmDGI',1,0,'A','admindfs','2012-04-24 14:19:17'),('AdminDFS','Mantenimiento','Divisas','Menu Datos','mnuDivisas',NULL,30,1,'frmDivisas',1,0,'A','admindfs','2012-03-07 08:16:19'),('AdminDFS','Mantenimiento','DLD','Editor Etiquetas','mnuDLD',NULL,10,1,'FrmDLD',1,0,'A','admindfs','2012-03-07 08:33:55'),('AdminDFS','Mantenimiento','EdicionGeneral',NULL,'mnuEdicionGeneral',NULL,140,0,NULL,1,0,'A','admindfs','2012-06-13 12:04:57'),('AdminDFS','Mantenimiento','Editor Etiquetas',NULL,'mnuEditorEtiquetas',NULL,20,1,NULL,1,0,'A','admindfs','2012-03-07 08:31:32'),('AdminDFS','Mantenimiento','ExportBD','Basedatos','ExportBD_Titulo',NULL,1,1,'FrmExportBD',1,1,'A','admindfs','2012-04-24 14:19:17'),('AdminDFS','Mantenimiento','Fichero Base Datos','Basedatos','mnuFicheroBaseDatos',NULL,40,1,'FrmImportarFicheroBD',1,0,'A','admindfs','2012-04-24 14:19:17'),('AdminDFS','Mantenimiento','Formatos',NULL,'mnuFormatos',NULL,90,1,NULL,1,0,'A','admindfs','2012-03-07 08:33:11'),('AdminDFS','Mantenimiento','Gama500','Publicidad','Gama500',NULL,20,1,NULL,1,0,'M','admindfs','2012-10-31 14:00:00'),('AdminDFS','Mantenimiento','GDA','PubliGraficaGama500','mnuGDA',NULL,20,1,'FrmGDA',1,0,'M','admindfs','2012-10-31 14:16:34'),('AdminDFS','Mantenimiento','Grafica500Simple','Grupos grafica','Gama500',NULL,2,1,'FrmAsocPublicidadGraficaSimple',1,0,'A','admindfs','2012-10-02 14:47:59'),('AdminDFS','Mantenimiento','GraficaSerieL','Grupos grafica','SerieL',NULL,1,1,'FrmGruposPublicidadGrafica',1,0,'A','admindfs','2012-10-02 14:26:06'),('AdminDFS','Mantenimiento','Grupos grafica','Asoc Publicidad','mnuBalanzaGrafica',NULL,20,1,NULL,1,0,'A','admindfs','2012-10-02 14:25:53'),('AdminDFS','Mantenimiento','GruposArticulo','Asoc articulos','mnuGruposArticulo',NULL,10,1,'FrmGrupoArticulos',1,0,'A','admindfs','2012-03-07 08:19:43'),('AdminDFS','Mantenimiento','GruposVendedor','Asoc Vendedores','mnuGruposVendedor',NULL,10,1,'FrmGrupoVendedores',1,0,'A','admindfs','2012-03-07 08:20:02'),('AdminDFS','Mantenimiento','Idioma','Configuracion','mnuIdioma',NULL,30,1,'FrmIdioma',1,0,'A','admindfs','2012-02-29 08:48:35'),('AdminDFS','Mantenimiento','Importar Exportar',NULL,'mnuImportarExportar',NULL,30,1,NULL,1,0,'A','admindfs','2012-03-07 07:59:00'),('AdminDFS','Mantenimiento','ImportBD','Basedatos','ImportBD_Titulo',NULL,2,1,'FrmImportBD',1,1,'M','admindfs','2012-04-24 14:19:17'),('AdminDFS','Mantenimiento','IVAs','Menu Datos','mnuIVA',NULL,10,1,'frmIVA',1,0,'A','admindfs','2012-03-07 08:16:17'),('AdminDFS','Mantenimiento','LBS','Balanza','mnuLBS',NULL,30,1,'FrmLBS',1,0,'A','admindfs','2012-04-24 14:19:17'),('AdminDFS','Mantenimiento','Licencias','Configuracion','mnuLicencias',NULL,80,1,'FrmLicencias',1,0,'A','admindfs','2012-03-07 08:42:52'),('AdminDFS','Mantenimiento','Listado articulos por balanza','Listados','mnuLArticulosPorBalanza',NULL,40,1,'FrmListadoArticulosPorBalanza',1,0,'A','admindfs','2013-10-09 10:12:26'),('AdminDFS','Mantenimiento','Listado detalle tickets','Listados','mnuLDetalleTickets',NULL,10,1,'FrmListadoDetalleTickets',1,0,'A','admindfs','2012-03-07 08:17:07'),('AdminDFS','Mantenimiento','Listado formas pago','Listados','mnuLFormasPago',NULL,30,1,'FrmListadoFormasPago',1,0,'A','admindfs','2012-03-07 08:17:09'),('AdminDFS','Mantenimiento','Listado personalizado','Listados','mnuListadoPersonalizado',NULL,20,1,'FrmListadoPersonalizado',1,0,'A','admindfs','2012-03-07 08:17:08'),('AdminDFS','Mantenimiento','Listado ventas por articulo','Listados','frmLBVentasArtlblTitulo',NULL,50,1,'FrmVentasPorArticulo',1,0,'A','admindfs','2014-07-16 11:07:18'),('AdminDFS','Mantenimiento','Listado ventas por vendedor','Listados','frmLBVentasEmplblTitulo',NULL,60,1,'FrmVentasPorVendedor',1,0,'A','admindfs','2014-07-16 11:07:18'),('AdminDFS','Mantenimiento','Listados',NULL,'mnuMListados',NULL,170,1,NULL,1,0,'A','admindfs','2012-03-07 08:33:21'),('AdminDFS','Mantenimiento','Mensajes','Menu Textos','mnuMensajes',NULL,40,1,'FrmEnvioSMS',1,0,'A','admindfs','2012-03-07 08:15:31'),('AdminDFS','Mantenimiento','Menu Articulos',NULL,'mnuMArticulo',NULL,50,1,'',1,1,'M','admindfs','2012-03-07 08:33:08'),('AdminDFS','Mantenimiento','Menu Configuracion Parametros',NULL,'mnuConfiguracionParametros',NULL,70,1,'FrmConfiguracionParametros',1,0,'A','admindfs','2012-03-07 08:33:10'),('AdminDFS','Mantenimiento','Menu Datos',NULL,'mnuDatos',NULL,100,1,'',1,0,'A','admindfs','2012-03-07 08:33:13'),('AdminDFS','Mantenimiento','Menu Logos',NULL,'mnuLogos',NULL,131,1,'FrmLogos',1,0,'M','admindfs','2012-06-13 12:04:33'),('AdminDFS','Mantenimiento','Menu Macros',NULL,'mnuMacro',NULL,110,1,'FrmMacro',1,0,'A','admindfs','2012-03-07 08:33:14'),('AdminDFS','Mantenimiento','Menu Textos',NULL,'mnuTextos',NULL,80,1,'',1,0,'M','admindfs','2012-03-07 08:33:10'),('AdminDFS','Mantenimiento','Menu Vendedores',NULL,'mnuVendedor',NULL,60,1,'frmVendedor',1,0,'M','admindfs','2012-03-07 08:33:09'),('AdminDFS','Mantenimiento','NumeroTicket','Ajustes','mnuNumTicket',NULL,10,1,'FrmNumTicket',1,0,'A','admindfs','2013-01-17 10:10:05'),('AdminDFS','Mantenimiento','Nutricionales','Menu Textos','dat_articulo_Nutricionales',NULL,60,1,'FrmPreguntasNutricionales',1,0,'A','admindfs','2012-10-30 15:38:37'),('AdminDFs','Mantenimiento','Ofertas','Menu Datos','mnuOfertas',NULL,60,1,'FrmOfertas',1,0,'A','admindfs','2013-04-30 13:19:00'),('AdminDFS','Mantenimiento','PantallaPublicidadColor','EdicionGeneral','mnuPantallaPublicidadColor',NULL,20,0,'FrmPantallaPublicidadColor',1,1,'A','adminDFS','2012-05-22 07:19:54'),('AdminDFS','Mantenimiento','Password Usuario','Configuracion','mnuPassUsuario',NULL,30,1,'frmPasswordUsuario',1,0,'A','admindfs','2013-08-07 15:09:44'),('AdminDFS','Mantenimiento','Productos','Trazabilidad','mnuElemAsociado',NULL,30,1,'frmElemAsociado',1,0,'M','admindfs','2012-03-07 08:19:21'),('AdminDFS','Mantenimiento','Programaciones','Configuracion','mnuProgramaciones',NULL,40,1,'FrmDetalleProgramacion',1,0,'A','admindfs','2012-02-29 08:48:45'),('AdminDFS','Mantenimiento','PubliAlfaGama500','Gama500','mnuBalanzaAlfanumerica',NULL,10,1,'FrmPublicidadAlfanumerica',1,0,'M','admindfs','2012-10-31 14:05:46'),('AdminDFS','Mantenimiento','PubliAlfaSerieL','SerieL','mnuBalanzaAlfanumerica',NULL,10,1,'FrmPublicidadAlfanumerica',1,0,'M','admindfs','2012-10-31 14:02:16'),('AdminDFS','Mantenimiento','Publicidad',NULL,'mnuPublicidad',NULL,120,1,NULL,1,0,'M','admindfs','2012-10-31 13:57:17'),('AdminDFS','Mantenimiento','PubliGraficaGama500','Gama500','mnuBalanzaGrafica',NULL,20,1,NULL,1,0,'M','admindfs','2012-10-31 14:07:08'),('AdminDFS','Mantenimiento','PubliGraficaSerieL','SerieL','mnuBalanzaGrafica',NULL,20,1,'FrmPubliGrafica',1,0,'M','admindfs','2012-10-31 14:03:11'),('AdminDFS','Mantenimiento','PubliGraficaSimple','PubliGraficaGama500','mnuSimple',NULL,10,1,'FrmPublicidadAzul',1,0,'M','admindfs','2012-10-31 14:08:07'),('AdminDFS','Mantenimiento','Puntos Fidelidad','Menu Datos','mnuPuntosFidelidad',NULL,50,1,'FrmPuntosFidelidad',1,0,'M','admindfs','2012-03-07 08:16:21'),('AdminDFS','Mantenimiento','Recetas','Menu Textos','mnuRecetas',NULL,50,1,'FrmRecetas',1,1,'A','admindfs','2012-03-07 08:15:32'),('AdminDFS','Mantenimiento','Secciones','Menu Textos','mnuSeccion',NULL,20,1,'frmSeccion',1,0,'A','admindfs','2012-03-07 08:15:28'),('AdminDFS','Mantenimiento','Separador',NULL,NULL,NULL,40,1,NULL,1,0,'A','admindfs','2012-03-07 08:33:07'),('AdminDFS','Mantenimiento','Separador2',NULL,NULL,NULL,130,1,NULL,1,0,'A','admindfs','2012-03-07 08:33:16'),('AdminDFS','Mantenimiento','Separador3',NULL,NULL,NULL,160,1,NULL,1,0,'A','admindfs','2012-03-07 08:33:19'),('AdminDFS','Mantenimiento','SerieL','Publicidad','SerieL',NULL,10,1,NULL,1,0,'M','admindfs','2012-10-31 13:59:13'),('AdminDFS','Mantenimiento','Tabla Textos (Clases)','Trazabilidad','mnuClase',NULL,20,1,'frmClase',1,0,'M','admindfs','2012-03-07 08:19:18'),('AdminDFS','Mantenimiento','TablasTeclasVendedor','Asoc Vendedores','mnuTablasTeclasVendedor',NULL,20,1,'FrmTablaTeclasVendedor',1,0,'A','admindfs','2012-03-07 08:20:03'),('AdminDFS','Mantenimiento','Taras','Menu Datos','mnuTaras',NULL,20,1,'FrmTaras',1,0,'A','admindfs','2012-03-07 08:16:18'),('AdminDFS','Mantenimiento','Teclados tradicionales','Configuracion','mnuTecladosTradicionales',NULL,60,1,'FrmTecladosTradicionales',1,0,'A','admindfs','2012-02-29 08:49:20'),('AdminDFS','Mantenimiento','Textos Animal (Respuestas)','Trazabilidad','mnuDatosAdicionales',NULL,10,1,'frmDatosAdicionales',1,0,'M','admindfs','2012-03-07 08:19:17'),('AdminDFS','Mantenimiento','Trazabilidad','Menu Textos','mnuMTrazabilidad',NULL,30,1,'',1,0,'A','admindfs','2012-03-07 08:15:30'),('dibalc','Mantenimiento','Articulos',NULL,'dat_articulo_Titulo',NULL,10,1,'frmArticulo',1,0,'A','admindfs','2014-07-24 09:58:19'),('dibalc','Mantenimiento','Listado articulos por balanza',NULL,'ListadoDeArticulos',NULL,20,1,'FrmListadoArticulosPorBalanza',1,0,'A','admindfs','2014-07-24 13:31:21'),('Items','Mantenimiento','Articulo Alta rapida',NULL,'dat_articulo_AltaRapida',NULL,20,1,'frmArticuloAltaRapida',1,0,'A','admindfs','2013-10-03 13:34:40'),('Items','Mantenimiento','Articulos',NULL,'dat_articulo_Titulo',NULL,10,1,'frmArticulo',1,0,'A','admindfs','2013-10-03 13:25:23'),('Keyboard_Item_List','Mantenimiento','AccesoBD','Configuracion','mnuAccesoBD',NULL,20,0,'FrmReAccesoBD',1,0,'A','admindfs','2015-02-26 09:29:44'),('Keyboard_Item_List','Mantenimiento','Articulo Alta rapida','Menu Articulos','dat_articulo_AltaRapida',NULL,20,1,'frmArticuloAltaRapida',1,0,'A','admindfs','2015-02-26 08:43:00'),('Keyboard_Item_List','Mantenimiento','Articulos','Menu Articulos','dat_articulo_Titulo',NULL,10,1,'frmArticulo',1,0,'A','admindfs','2015-03-02 08:56:26'),('Keyboard_Item_List','Mantenimiento','ArticulosPorBalanza','Asoc articulos','ArticulosPorBalanza',NULL,20,1,'FrmArticulosPorBalanza',1,0,'A','admindfs','2015-02-26 09:54:05'),('Keyboard_Item_List','Mantenimiento','Asoc Articulos','Asociaciones','mnuAsocArticulos',NULL,10,1,NULL,1,0,'A','admindfs','2015-02-26 08:50:49'),('Keyboard_Item_List','Mantenimiento','Asoc Balanza Alfanumerica','Asoc Publicidad','mnuBalanzaAlfanumerica',NULL,10,1,'FrmAsocPublicidadAlfanumerica',1,0,'A','admindfs','2015-02-26 09:54:09'),('Keyboard_Item_List','Mantenimiento','Asoc Configuracion Parametros','Asociaciones','mnuAsocConfiguracionParametros',NULL,30,1,'FrmAsocConfiguracionParametros',1,0,'A','admindfs','2015-02-26 08:51:50'),('Keyboard_Item_List','Mantenimiento','Asoc Macros','Asociaciones','mnuAsocMacros',NULL,50,1,'FrmGrupoMacros',1,0,'A','admindfs','2015-02-26 08:51:54'),('Keyboard_Item_List','Mantenimiento','Asoc Publicidad','Asociaciones','mnuPublicidad',NULL,40,1,NULL,1,0,'A','admindfs','2015-02-26 08:51:57'),('Keyboard_Item_List','Mantenimiento','Asoc Vendedores','Asociaciones','mnuAsocVendedores',NULL,20,1,NULL,1,0,'A','admindfs','2015-02-26 08:52:00'),('Keyboard_Item_List','Mantenimiento','Asociaciones',NULL,'mnuAsociaciones',NULL,150,1,NULL,1,0,'A','admindfs','2015-03-02 08:56:36'),('Keyboard_Item_List','Mantenimiento','Avisos Email','Configuracion','mnuAvisosEmail',NULL,50,0,'FrmAvisosEmail',1,0,'A','admindfs','2015-02-26 09:31:17'),('Keyboard_Item_List','Mantenimiento','Borrado Ventas','Configuracion','mnuBorradoVentas',NULL,70,0,'FrmBorradoVentas',1,0,'A','admindfs','2015-02-26 09:30:58'),('Keyboard_Item_List','Mantenimiento','Configuracion',NULL,'mnuConfiguracion',NULL,10,1,NULL,1,0,'A','admindfs','2015-02-26 08:52:12'),('Keyboard_Item_List','Mantenimiento','Configuracion DFS','Configuracion','mnuConfiguracionDFS',NULL,10,0,'FrmConfiguracionDFS',1,0,'A','admindfs','2015-02-26 09:30:55'),('Keyboard_Item_List','Mantenimiento','Grafica500Simple','Grupos grafica','Gama500',NULL,2,1,'FrmAsocPublicidadGraficaSimple',1,0,'A','admindfs','2015-02-26 11:43:52'),('Keyboard_Item_List','Mantenimiento','GraficaSerieL','Grupos grafica','SerieL',NULL,1,1,'FrmGruposPublicidadGrafica',1,0,'A','admindfs','2015-02-26 11:43:57'),('Keyboard_Item_List','Mantenimiento','Grupos grafica','Asoc Publicidad','mnuBalanzaGrafica',NULL,20,1,NULL,1,0,'A','admindfs','2015-02-26 09:54:11'),('Keyboard_Item_List','Mantenimiento','GruposArticulo','Asoc articulos','mnuGruposArticulo',NULL,10,1,'FrmGrupoArticulos',1,0,'A','admindfs','2015-02-26 09:54:14'),('Keyboard_Item_List','Mantenimiento','GruposVendedor','Asoc Vendedores','mnuGruposVendedor',NULL,10,1,'FrmGrupoVendedores',1,0,'A','admindfs','2015-02-26 09:54:17'),('Keyboard_Item_List','Mantenimiento','Idioma','Configuracion','mnuIdioma',NULL,30,0,'FrmIdioma',1,0,'A','admindfs','2015-02-26 09:30:15'),('Keyboard_Item_List','Mantenimiento','Licencias','Configuracion','mnuLicencias',NULL,80,0,'FrmLicencias',1,0,'A','admindfs','2015-02-26 09:30:27'),('Keyboard_Item_List','Mantenimiento','Listado articulos por balanza','Listados','mnuLArticulosPorBalanza',NULL,40,1,'FrmListadoArticulosPorBalanza',1,0,'A','admindfs','2015-02-26 08:52:27'),('Keyboard_Item_List','Mantenimiento','Listado detalle tickets','Listados','mnuLDetalleTickets',NULL,10,1,'FrmListadoDetalleTickets',1,0,'A','admindfs','2015-02-26 08:52:30'),('Keyboard_Item_List','Mantenimiento','Listado formas pago','Listados','mnuLFormasPago',NULL,30,1,'FrmListadoFormasPago',1,0,'A','admindfs','2015-02-26 08:52:33'),('Keyboard_Item_List','Mantenimiento','Listado personalizado','Listados','mnuListadoPersonalizado',NULL,20,1,'FrmListadoPersonalizado',1,0,'A','admindfs','2015-02-26 08:52:36'),('Keyboard_Item_List','Mantenimiento','Listado ventas por articulo','Listados','frmLBVentasArtlblTitulo',NULL,50,1,'FrmVentasPorArticulo',1,0,'A','admindfs','2015-02-26 08:52:43'),('Keyboard_Item_List','Mantenimiento','Listado ventas por vendedor','Listados','frmLBVentasEmplblTitulo',NULL,60,1,'FrmVentasPorVendedor',1,0,'A','admindfs','2015-02-26 08:52:45'),('Keyboard_Item_List','Mantenimiento','Listados',NULL,'mnuMListados',NULL,170,1,NULL,1,0,'A','admindfs','2015-02-26 08:52:48'),('Keyboard_Item_List','Mantenimiento','Menu Articulos',NULL,'mnuMArticulo',NULL,50,1,NULL,1,0,'A','admindfs','2015-03-02 08:56:58'),('Keyboard_Item_List','Mantenimiento','Menu Configuracion Parametros',NULL,'mnuConfiguracionParametros',NULL,70,1,'FrmConfiguracionParametros',1,0,'A','admindfs','2015-02-27 07:44:54'),('Keyboard_Item_List','Mantenimiento','Password Usuario','Configuracion','mnuPassUsuario',NULL,30,1,'frmPasswordUsuario',1,0,'A','admindfs','2015-02-26 08:52:57'),('Keyboard_Item_List','Mantenimiento','Programaciones','Configuracion','mnuProgramaciones',NULL,40,0,'FrmDetalleProgramacion',1,0,'A','admindfs','2015-02-26 09:30:49'),('Keyboard_Item_List','Mantenimiento','Separador',NULL,NULL,NULL,40,1,NULL,1,0,'A','admindfs','2015-02-26 13:45:19'),('Keyboard_Item_List','Mantenimiento','Separador2',NULL,NULL,NULL,130,1,NULL,1,0,'A','admindfs','2015-02-26 13:45:21'),('Keyboard_Item_List','Mantenimiento','Separador3',NULL,NULL,NULL,160,1,NULL,1,0,'A','admindfs','2015-02-26 13:45:27'),('Keyboard_Item_List','Mantenimiento','TablasTeclasVendedor','Asoc Vendedores','mnuTablasTeclasVendedor',NULL,20,1,'FrmTablaTeclasVendedor',1,0,'A','admindfs','2015-02-26 09:54:24'),('Keyboard_Item_List','Mantenimiento','Teclados tradicionales','Configuracion','mnuTecladosTradicionales',NULL,60,1,'FrmTecladosTradicionales',1,0,'A','admindfs','2015-02-26 08:53:56'),('NoPrice','Mantenimiento','Articulo Alta rapida','Menu Articulos','dat_articulo_AltaRapida',NULL,20,1,'frmArticuloAltaRapida',1,1,'M','admindfs','2013-06-27 09:05:19'),('NoPrice','Mantenimiento','Articulos','Menu Articulos','dat_articulo_Titulo',NULL,10,1,'frmArticulo',1,1,'A','admindfs','2013-06-27 09:05:19'),('NoPrice','Mantenimiento','ArticulosPorBalanza','Asoc articulos','ArticulosPorBalanza',NULL,20,1,'FrmArticulosPorBalanza',1,0,'A','admindfs','2013-06-27 09:05:19'),('NoPrice','Mantenimiento','Asoc Articulos','Asociaciones','mnuAsocArticulos',NULL,10,1,NULL,1,0,'A','admindfs','2013-06-27 09:05:19'),('NoPrice','Mantenimiento','Asoc Configuracion Parametros','Asociaciones','mnuAsocConfiguracionParametros',NULL,30,1,'FrmAsocConfiguracionParametros',1,0,'A','admindfs','2013-06-27 09:05:19'),('NoPrice','Mantenimiento','Asoc Macros','Asociaciones','mnuAsocMacros',NULL,50,1,'FrmGrupoMacros',1,0,'A','admindfs','2013-06-27 09:05:19'),('NoPrice','Mantenimiento','Asoc Vendedores','Asociaciones','mnuAsocVendedores',NULL,20,1,NULL,1,0,'A','admindfs','2013-06-27 09:05:19'),('NoPrice','Mantenimiento','Asociaciones',NULL,'mnuAsociaciones',NULL,150,1,NULL,1,1,'A','admindfs','2013-06-27 09:05:19'),('NoPrice','Mantenimiento','Avisos Email','Configuracion','mnuAvisosEmail',NULL,50,1,'FrmAvisosEmail',1,0,'A','admindfs','2013-06-27 09:05:19'),('NoPrice','Mantenimiento','Balanza','Importar Exportar','mnuBalanzaImportar',NULL,30,1,NULL,1,0,'A','admindfs','2013-06-27 09:05:19'),('NoPrice','Mantenimiento','Basedatos','Importar Exportar','mnuBaseDatosImportar','',10,1,NULL,1,0,'A','admindfs','2013-06-27 09:05:19'),('NoPrice','Mantenimiento','Borrado Ventas','Configuracion','mnuBorradoVentas',NULL,70,1,'FrmBorradoVentas',1,0,'A','admindfs','2013-06-27 09:05:19'),('NoPrice','Mantenimiento','Cabeceras ticket','Formatos','mnuCabecerasTicket',NULL,10,1,'FrmGrupoCabeceras',1,0,'A','admindfs','2013-06-27 09:05:19'),('NoPrice','Mantenimiento','Clientes','Menu Textos','mnuCliente',NULL,90,1,'FrmCliente',1,0,'A','admindfs','2013-06-27 09:05:19'),('NoPrice','Mantenimiento','Codigos Barras General','Menu Datos','mnuCodBarras',NULL,40,1,'frmCodBarras',1,0,'A','admindfs','2013-06-27 09:05:19'),('NoPrice','Mantenimiento','Configuracion',NULL,'mnuConfiguracion',NULL,10,1,NULL,1,0,'A','admindfs','2013-06-27 09:05:19'),('NoPrice','Mantenimiento','Configuracion DFS','Configuracion','mnuConfiguracionDFS',NULL,10,1,'FrmConfiguracionDFS',1,0,'A','admindfs','2013-06-27 09:05:19'),('NoPrice','Mantenimiento','Divisas','Menu Datos','mnuDivisas',NULL,30,1,'frmDivisas',1,0,'A','admindfs','2013-06-27 09:05:19'),('NoPrice','Mantenimiento','DLD','Editor Etiquetas','mnuDLD',NULL,10,1,'FrmDLD',1,0,'A','admindfs','2013-06-27 09:05:19'),('NoPrice','Mantenimiento','Editor Etiquetas',NULL,'mnuEditorEtiquetas',NULL,20,1,NULL,1,0,'A','admindfs','2013-06-27 09:05:19'),('NoPrice','Mantenimiento','ExportBD','Basedatos','ExportBD_Titulo',NULL,1,1,'FrmExportBD',1,1,'A','admindfs','2013-06-27 09:05:19'),('NoPrice','Mantenimiento','Fichero Base Datos','Basedatos','mnuFicheroBaseDatos',NULL,40,1,'FrmImportarFicheroBD',1,0,'A','admindfs','2013-06-27 09:05:19'),('NoPrice','Mantenimiento','Formatos',NULL,'mnuFormatos',NULL,90,1,NULL,1,0,'A','admindfs','2013-06-27 09:05:19'),('NoPrice','Mantenimiento','GruposArticulo','Asoc articulos','mnuGruposArticulo',NULL,10,1,'FrmGrupoArticulos',1,0,'A','admindfs','2013-06-27 09:05:19'),('NoPrice','Mantenimiento','GruposVendedor','Asoc Vendedores','mnuGruposVendedor',NULL,10,1,'FrmGrupoVendedores',1,0,'A','admindfs','2013-06-27 09:05:19'),('NoPrice','Mantenimiento','Idioma','Configuracion','mnuIdioma',NULL,30,1,'FrmIdioma',1,0,'A','admindfs','2013-06-27 09:05:19'),('NoPrice','Mantenimiento','Importar Exportar',NULL,'mnuImportarExportar',NULL,30,1,NULL,1,0,'A','admindfs','2013-06-27 09:05:19'),('NoPrice','Mantenimiento','ImportBD','Basedatos','ImportBD_Titulo',NULL,2,1,'FrmImportBD',1,1,'M','admindfs','2013-06-27 09:05:19'),('NoPrice','Mantenimiento','Listado articulos por balanza','Listados','mnuLArticulosPorBalanza',NULL,40,1,'FrmListadoArticulosPorBalanza',1,0,'A','admindfs','2013-10-09 10:12:26'),('NoPrice','Mantenimiento','Listado detalle tickets','Listados','mnuLDetalleTickets',NULL,10,1,'FrmListadoDetalleTickets',1,0,'A','admindfs','2013-06-27 09:05:19'),('NoPrice','Mantenimiento','Listado formas pago','Listados','mnuLFormasPago',NULL,30,1,'FrmListadoFormasPago',1,0,'A','admindfs','2013-06-27 09:05:19'),('NoPrice','Mantenimiento','Listado personalizado','Listados','mnuListadoPersonalizado',NULL,20,1,'FrmListadoPersonalizado',1,0,'A','admindfs','2013-06-27 09:05:19'),('NoPrice','Mantenimiento','Listado ventas por articulo','Listados','frmLBVentasArtlblTitulo',NULL,50,1,'FrmVentasPorArticulo',1,0,'A','admindfs','2014-07-16 11:07:18'),('NoPrice','Mantenimiento','Listado ventas por vendedor','Listados','frmLBVentasEmplblTitulo',NULL,60,1,'FrmVentasPorVendedor',1,0,'A','admindfs','2014-07-16 11:07:18'),('NoPrice','Mantenimiento','Listados',NULL,'mnuMListados',NULL,170,1,NULL,1,0,'A','admindfs','2013-06-27 09:05:19'),('NoPrice','Mantenimiento','Mensajes','Menu Textos','mnuMensajes',NULL,40,1,'FrmEnvioSMS',1,0,'A','admindfs','2013-06-27 09:05:19'),('NoPrice','Mantenimiento','Menu Articulos',NULL,'mnuMArticulo',NULL,50,1,'',1,1,'M','admindfs','2013-06-27 09:05:19'),('NoPrice','Mantenimiento','Menu Configuracion Parametros',NULL,'mnuConfiguracionParametros',NULL,70,1,'FrmConfiguracionParametros',1,0,'A','admindfs','2013-06-27 09:05:19'),('NoPrice','Mantenimiento','Menu Datos',NULL,'mnuDatos',NULL,100,1,'',1,0,'A','admindfs','2013-06-27 09:05:19'),('NoPrice','Mantenimiento','Menu Logos',NULL,'mnuLogos',NULL,131,1,'FrmLogos',1,0,'M','admindfs','2013-06-27 09:05:19'),('NoPrice','Mantenimiento','Menu Macros',NULL,'mnuMacro',NULL,110,1,'FrmMacro',1,0,'A','admindfs','2013-06-27 09:05:19'),('NoPrice','Mantenimiento','Menu Textos',NULL,'mnuTextos',NULL,80,1,'',1,0,'M','admindfs','2013-06-27 09:05:19'),('NoPrice','Mantenimiento','Menu Vendedores',NULL,'mnuVendedor',NULL,60,1,'frmVendedor',1,0,'M','admindfs','2013-06-27 09:05:19'),('NoPrice','Mantenimiento','Nutricionales','Menu Textos','dat_articulo_Nutricionales',NULL,60,1,'FrmPreguntasNutricionales',1,0,'A','admindfs','2013-06-27 09:05:19'),('NoPrice','Mantenimiento','Productos','Trazabilidad','mnuElemAsociado',NULL,30,1,'frmElemAsociado',1,0,'M','admindfs','2013-06-27 09:05:19'),('NoPrice','Mantenimiento','Programaciones','Configuracion','mnuProgramaciones',NULL,40,1,'FrmDetalleProgramacion',1,0,'A','admindfs','2013-06-27 09:05:19'),('NoPrice','Mantenimiento','Puntos Fidelidad','Menu Datos','mnuPuntosFidelidad',NULL,50,1,'FrmPuntosFidelidad',1,0,'M','admindfs','2013-06-27 09:05:19'),('NoPrice','Mantenimiento','Recetas','Menu Textos','mnuRecetas',NULL,50,1,'FrmRecetas',1,1,'A','admindfs','2013-06-27 09:05:19'),('NoPrice','Mantenimiento','Secciones','Menu Textos','mnuSeccion',NULL,20,1,'frmSeccion',1,0,'A','admindfs','2013-06-27 09:05:19'),('NoPrice','Mantenimiento','Separador',NULL,NULL,NULL,40,1,NULL,1,0,'A','admindfs','2013-06-27 09:05:19'),('NoPrice','Mantenimiento','Separador2',NULL,NULL,NULL,130,1,NULL,1,0,'A','admindfs','2013-06-27 09:05:19'),('NoPrice','Mantenimiento','Separador3',NULL,NULL,NULL,160,1,NULL,1,0,'A','admindfs','2013-06-27 09:05:19'),('NoPrice','Mantenimiento','Tabla Textos (Clases)','Trazabilidad','mnuClase',NULL,20,1,'frmClase',1,0,'M','admindfs','2013-06-27 09:05:19'),('NoPrice','Mantenimiento','TablasTeclasVendedor','Asoc Vendedores','mnuTablasTeclasVendedor',NULL,20,1,'FrmTablaTeclasVendedor',1,0,'A','admindfs','2013-06-27 09:05:19'),('NoPrice','Mantenimiento','Taras','Menu Datos','mnuTaras',NULL,20,1,'FrmTaras',1,0,'A','admindfs','2013-06-27 09:05:19'),('NoPrice','Mantenimiento','Teclados tradicionales','Configuracion','mnuTecladosTradicionales',NULL,60,1,'FrmTecladosTradicionales',1,0,'A','admindfs','2013-06-27 09:05:19'),('NoPrice','Mantenimiento','Textos Animal (Respuestas)','Trazabilidad','mnuDatosAdicionales',NULL,10,1,'frmDatosAdicionales',1,0,'M','admindfs','2013-06-27 09:05:19'),('NoPrice','Mantenimiento','Trazabilidad','Menu Textos','mnuMTrazabilidad',NULL,30,1,'',1,0,'A','admindfs','2013-06-27 09:05:19');
UNLOCK TABLES;
/*!40000 ALTER TABLE `sys_seg_menu` ENABLE KEYS */;

--
-- Table structure for table `sys_seg_perfil`
--

DROP TABLE IF EXISTS `sys_seg_perfil`;
CREATE TABLE `sys_seg_perfil` (
  `IdPerfilSeguridad` varchar(20) NOT NULL,
  `DescripcionPerfil` varchar(50) default NULL,
  `ModificarPrecios` tinyint(1) default '1',
  `ModificarTiendaBalanza` tinyint(1) default '1',
  `ModificarAsociaciones` tinyint(1) default '1',
  `EnviarModificaciones` tinyint(1) default '1',
  `PedirVentas` tinyint(1) default '1',
  `FinDeDia` tinyint(1) default '1',
  `Inicializacion` tinyint(1) default '1',
  `EnviarFicheros` tinyint(1) default '1',
  `Visible` tinyint(1) NOT NULL default '1',
  `Administrador` tinyint(1) NOT NULL default '0',
  `IdEmpresa` int(11) NOT NULL default '1',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `Fecha` date default NULL,
  PRIMARY KEY  (`IdEmpresa`,`IdPerfilSeguridad`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guarda la informacion de los distintos per';

--
-- Dumping data for table `sys_seg_perfil`
--


/*!40000 ALTER TABLE `sys_seg_perfil` DISABLE KEYS */;
LOCK TABLES `sys_seg_perfil` WRITE;
INSERT INTO `sys_seg_perfil` (`IdPerfilSeguridad`, `DescripcionPerfil`, `ModificarPrecios`, `ModificarTiendaBalanza`, `ModificarAsociaciones`, `EnviarModificaciones`, `PedirVentas`, `FinDeDia`, `Inicializacion`, `EnviarFicheros`, `Visible`, `Administrador`, `IdEmpresa`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`, `Fecha`) VALUES ('AdminDFS','Administrador Balanza Tradicional',1,1,1,1,1,1,1,1,1,1,1,0,'A','admindfs','2013-10-03 11:29:23',NULL),('dibalc','Cliente Carrefour',0,0,0,1,0,0,0,0,0,0,1,0,'A','admindfs','2013-10-03 13:18:58',NULL),('Items','Only items',1,0,0,1,0,0,0,0,1,0,1,0,'A','admindfs','2013-10-03 13:18:58',NULL),('Keyboard_Item_List','Teclados_Articulos_Listados',1,0,0,1,1,1,1,1,1,0,1,0,'A','admindfs','2015-02-26 16:22:43',NULL),('NoPrice','Precios no',0,0,1,1,1,1,1,1,1,0,1,0,'A','admindfs','2013-10-03 11:29:35',NULL);
UNLOCK TABLES;
/*!40000 ALTER TABLE `sys_seg_perfil` ENABLE KEYS */;

--
-- Table structure for table `sys_seg_usuario`
--

DROP TABLE IF EXISTS `sys_seg_usuario`;
CREATE TABLE `sys_seg_usuario` (
  `IdUsuario` int(11) NOT NULL,
  `NombreUsuario` varchar(20) NOT NULL,
  `PassWord` varchar(24) NOT NULL,
  `RecorPassword` tinyint(1) default NULL,
  `IdPerfilSeguridad` varchar(20) default NULL,
  `IdMenuArranque` varchar(255) default NULL,
  `IdiomaVendedor` varchar(20) default NULL,
  `IdiomaCliente` varchar(20) default NULL,
  `VendedorUnico` tinyint(4) default NULL,
  `IdVendedorUnico` int(11) default NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `IdPlantillaPantalla` int(11) default NULL,
  `PesajeAutomatico` tinyint(1) default NULL,
  `CalculoCambio` tinyint(1) default NULL,
  `FormaPago` tinyint(1) default NULL,
  `IdFormaPago` int(11) default NULL,
  `ControlarCajon` tinyint(1) default NULL,
  `AbrirCajon` tinyint(1) default NULL,
  `VisionArtificial` tinyint(1) default NULL,
  `AnularLineas` tinyint(1) default NULL,
  `PrevCierreCaja` tinyint(1) default NULL,
  `CierreCajaPorVendedor` tinyint(1) default '0' COMMENT 'Si 1, el cierre de caja se hace por vendedor.\r\nSi 0, el cierre de caja se hace total.',
  `Clientes` tinyint(1) default '0',
  `Descuentos` tinyint(1) default '0',
  `IdDivisa` int(11) default NULL,
  `IdDivisaSecundaria` int(11) default NULL,
  `ModoTrabajo` int(11) default NULL,
  `TalonCaja` tinyint(4) default '0',
  `RetardoTalonCaja` int(11) default '0',
  `CodBarrasEtiquetas` int(11) default NULL,
  `CodBarrasTickets` int(11) default NULL,
  `CodBarrasPreenvasado` int(11) default NULL,
  `CodBarrasTalonCaja` int(11) default NULL,
  `FormatoEtiquetasUnitarias` int(11) default NULL,
  `FormatoEtiquetasPesadas` int(11) default NULL,
  `FormatoTickets` int(11) default NULL,
  `FormatoTalonCaja` int(11) default NULL,
  `FicheroDisenoImportacion` varchar(1000) default NULL,
  `FicheroDisenoExportacion` varchar(1000) default NULL,
  `TipoDisplay` int(11) default '5',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdUsuario`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guarda la informacion de los usuarios que ';

--
-- Dumping data for table `sys_seg_usuario`
--


/*!40000 ALTER TABLE `sys_seg_usuario` DISABLE KEYS */;
LOCK TABLES `sys_seg_usuario` WRITE;
INSERT INTO `sys_seg_usuario` (`IdUsuario`, `NombreUsuario`, `PassWord`, `RecorPassword`, `IdPerfilSeguridad`, `IdMenuArranque`, `IdiomaVendedor`, `IdiomaCliente`, `VendedorUnico`, `IdVendedorUnico`, `IdEmpresa`, `IdPlantillaPantalla`, `PesajeAutomatico`, `CalculoCambio`, `FormaPago`, `IdFormaPago`, `ControlarCajon`, `AbrirCajon`, `VisionArtificial`, `AnularLineas`, `PrevCierreCaja`, `CierreCajaPorVendedor`, `Clientes`, `Descuentos`, `IdDivisa`, `IdDivisaSecundaria`, `ModoTrabajo`, `TalonCaja`, `RetardoTalonCaja`, `CodBarrasEtiquetas`, `CodBarrasTickets`, `CodBarrasPreenvasado`, `CodBarrasTalonCaja`, `FormatoEtiquetasUnitarias`, `FormatoEtiquetasPesadas`, `FormatoTickets`, `FormatoTalonCaja`, `FicheroDisenoImportacion`, `FicheroDisenoExportacion`, `TipoDisplay`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`) VALUES (55,'admin','ISMvKXpXpadDiUoOSoAfww==',1,'AdminDFS','Mantenimiento','fr',NULL,0,NULL,1,NULL,0,0,0,NULL,0,0,0,0,0,0,0,0,NULL,NULL,2,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,5,0,'M','admindfs','2015-09-15 19:43:17'),(56,'admindfs','xSrukFDr8GG7slc6eLfPKg==',1,'AdminDFS','Mantenimiento','fr',NULL,0,NULL,1,NULL,0,0,0,NULL,0,0,0,0,0,0,0,0,NULL,NULL,2,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,5,0,'M','admindfs','2015-09-14 17:22:34'),(58,'DLD','DLD',NULL,NULL,NULL,'fr',NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,5,0,'A','admindfs','2015-09-14 17:22:34'),(59,'DGI','DGI',NULL,NULL,NULL,'en',NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,5,0,'A','admindfs','2015-09-15 20:12:39'),(60,'GDA','GDA',NULL,NULL,NULL,'fr',NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,5,0,'A','admindfs','2015-09-15 20:24:34'),(61,'CDA','CDA',NULL,NULL,NULL,'fr',NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,5,0,'A','admindfs','2015-09-15 20:24:34'),(62,'Scales','Scales',NULL,NULL,NULL,'fr',NULL,NULL,NULL,1,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,5,0,'A','admindfs','2015-09-15 19:43:17'),(63,'noprice','psf9YIUn58nOlPmcFWrslQ==',1,'NoPrice','Mantenimiento',NULL,NULL,0,NULL,1,NULL,0,0,0,NULL,0,0,0,0,0,0,0,0,NULL,NULL,2,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,5,0,'A','admindfs','2013-08-07 14:18:39'),(64,'price','eKXrQ97vmntbnOFXudUqxA==',1,'Items','Mantenimiento',NULL,NULL,0,NULL,1,NULL,0,0,0,NULL,0,0,0,0,0,0,0,0,NULL,NULL,NULL,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,5,0,'A','admindfs','2013-10-03 13:26:46'),(65,'dibalc','dibalc',1,'dibalc','Mantenimiento',NULL,NULL,0,NULL,1,NULL,0,0,0,NULL,0,0,0,0,0,0,0,0,NULL,NULL,2,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,5,0,'A','admindfs','2014-07-24 09:49:01');
UNLOCK TABLES;
/*!40000 ALTER TABLE `sys_seg_usuario` ENABLE KEYS */;

--
-- Table structure for table `sys_seg_ventana`
--

DROP TABLE IF EXISTS `sys_seg_ventana`;
CREATE TABLE `sys_seg_ventana` (
  `IdVentana` varchar(50) NOT NULL default '',
  `IdPerfilSeguridad` varchar(20) NOT NULL,
  `Visualizar` tinyint(1) NOT NULL default '1',
  `Insertar` tinyint(1) NOT NULL default '1',
  `Modificar` tinyint(1) NOT NULL default '1',
  `Borrar` tinyint(1) NOT NULL default '1',
  `Filtrar` tinyint(1) NOT NULL default '1',
  `Imprimir` tinyint(1) NOT NULL default '1',
  `IdEmpresa` int(11) NOT NULL default '1',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`IdPerfilSeguridad`,`IdVentana`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guardan los permisos de las ventanas. Table w';

--
-- Dumping data for table `sys_seg_ventana`
--


/*!40000 ALTER TABLE `sys_seg_ventana` DISABLE KEYS */;
LOCK TABLES `sys_seg_ventana` WRITE;
INSERT INTO `sys_seg_ventana` (`IdVentana`, `IdPerfilSeguridad`, `Visualizar`, `Insertar`, `Modificar`, `Borrar`, `Filtrar`, `Imprimir`, `IdEmpresa`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`) VALUES ('FrmArticulosPorBalanza','Keyboard_Item_List',1,0,0,0,1,1,1,0,'A','admindfs','2015-02-27 08:14:57'),('FrmAsocConfiguracionParametros','Keyboard_Item_List',1,0,0,0,1,1,1,0,'A','admindfs','2015-02-27 08:17:03'),('FrmAsocPublicidadAlfanumerica','Keyboard_Item_List',1,0,0,0,1,1,1,0,'A','admindfs','2015-02-27 08:17:21'),('FrmAsocPublicidadGraficaSimple','Keyboard_Item_List',1,0,0,0,1,1,1,0,'A','admindfs','2015-02-27 08:17:59'),('FrmConfiguracionParametros','Keyboard_Item_List',1,0,0,0,1,1,1,0,'A','admindfs','2015-02-27 08:24:11'),('FrmGrupoArticulos','Keyboard_Item_List',1,0,0,0,1,1,1,0,'A','admindfs','2015-02-27 08:14:51'),('FrmGrupoMacros','Keyboard_Item_List',1,0,0,0,1,1,1,0,'A','admindfs','2015-02-27 08:18:09'),('FrmGruposPublicidadGrafica','Keyboard_Item_List',1,0,0,0,1,1,1,0,'A','admindfs','2015-02-27 08:17:38'),('FrmGrupoVendedores','Keyboard_Item_List',1,0,0,0,1,1,1,0,'A','admindfs','2015-02-27 08:16:14'),('frmPasswordUsuario','Keyboard_Item_List',1,0,1,0,1,1,1,0,'A','admindfs','2015-02-27 12:35:03'),('FrmTablaTeclasVendedor','Keyboard_Item_List',1,0,0,0,1,1,1,0,'A','admindfs','2015-02-27 08:16:42');
UNLOCK TABLES;
/*!40000 ALTER TABLE `sys_seg_ventana` ENABLE KEYS */;

--
-- Table structure for table `sys_tabla_ias`
--

DROP TABLE IF EXISTS `sys_tabla_ias`;
CREATE TABLE `sys_tabla_ias` (
  `Codigo` varchar(20) NOT NULL,
  `Nombre` varchar(50) default NULL,
  `Descripcion` text,
  `Formato` varchar(20) default NULL,
  `Longitud` int(11) default NULL,
  `Numerico` tinyint(1) default NULL,
  `TamFijo` tinyint(1) default NULL,
  `IdEmpresa` int(11) NOT NULL default '1',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdEmpresa`,`Codigo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `sys_tabla_ias`
--


/*!40000 ALTER TABLE `sys_tabla_ias` DISABLE KEYS */;
LOCK TABLES `sys_tabla_ias` WRITE;
INSERT INTO `sys_tabla_ias` (`Codigo`, `Nombre`, `Descripcion`, `Formato`, `Longitud`, `Numerico`, `TamFijo`, `IdEmpresa`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`) VALUES ('00','SSCC-18','Código Seriado del Envase/Unidad de Envío','n2+n18',18,1,1,1,0,'A','admindfs','2012-11-28 11:38:45'),('01','SCC-14 (GTIN)','Número Mundial del Artículo EAN/Código Comercial de la Unidad de Expedición','n2+n14',14,1,1,1,0,'A','admindfs','2012-11-28 11:38:45'),('02','CONTENIDO','Número Mundial del Artículo Comercial Contenido en otra Unidad de la Unidad Logística','n2+n14',14,1,1,1,0,'A','admindfs','2012-11-28 11:38:45'),('10','LOTE','Número de Lote / Partida','n2+an..20',20,0,0,1,0,'A','admindfs','2012-11-28 11:38:45'),('11','FECHA PRODUCCION / FABRICACION','Fecha de Producción o Fabricación','n2+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:45'),('12','FECHA DE PAGO (VENCIMIENTO)','Fecha de Pago (Vencimiento de Pago)','n2+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:45'),('13','FECHA ENVASADO','Fecha de Envasado','n2+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:45'),('15','CONSUMIR PREF. ANTES DE (FECHA MÍN. DURACION)','Fecha de Mínima Duración - Consumir Pref. Antes de','n2+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:45'),('17','UTILIZAR HASTA O VENCIMIENTO','Fecha de Máxima Duración - Fecha de Caducidad - Utilizar hasta (Vencimiento)','n2+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:45'),('20','VARIANTE','Variante del Producto','n2+n2',2,1,1,1,0,'A','admindfs','2012-11-28 11:38:45'),('21','SERIE','Número de Serie','n2+an..20',20,0,0,1,0,'A','admindfs','2012-11-28 11:38:45'),('22','HIBCC','HIBCC - Cantidad, Fecha, Lote y Conexión','n2+an..29',29,0,0,1,0,'A','admindfs','2012-11-28 11:38:45'),('23X','LOTE (TRANSITORIO)','Número de Lote / Partida (Uso Transitorio)','n3+n..19',19,1,0,1,0,'A','admindfs','2012-11-28 11:38:45'),('240','IDENTIFICACION ADICIONAL','Identificación Adicional del Producto','n3+an..30',30,0,0,1,0,'A','admindfs','2012-11-28 11:38:45'),('241','NUMERO PRODUCTO ASIGNADO POR CLIENTE','Número de Producto asignado por el Cliente','n3+an..30',30,0,0,1,0,'A','admindfs','2012-11-28 11:38:45'),('250','SERIE SECUNDARIO','Número de Serie Secundario','n3+an..30',30,0,0,1,0,'A','admindfs','2012-11-28 11:38:45'),('251','REFERENCIA A ORIGEN (CROTAL)','Número de Referencia a Origen de la Entidad / Número de Crotal','n3+an..30',30,0,0,1,0,'A','admindfs','2012-11-28 11:38:45'),('30','CANTIDAD VARIABLE','Cantidad variable','n2+n..8',8,1,0,1,0,'A','admindfs','2012-11-28 11:38:45'),('310y','PESO NETO (KG.)','Peso Neto (Kg.)','n4+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:45'),('311y','LONGITUD (m.)','Longitud ó 1ª Dimensión comercial (m.)','n4+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:45'),('312y','ANCHO (m.)','Anchura, Diámetro ó 2ª Dimensión comercial (m.)','n4+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:45'),('313y','ALTURA (m.)','Profundidad, Espesor, Altura ó 3ª Dimensión comercial (m.)','n4+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:45'),('314y','AREA (m2.)','Área comercial (m2.)','n4+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:45'),('315y','VOLUMEN NETO (l.)','Volumen Neto (l.)','n4+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:45'),('316y','VOLUMEN NETO (m3.)','Volumen Neto (m3.)','n4+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:45'),('320y','PESO NETO (lb.)','Peso Neto (lb.)','n4+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:45'),('321y','LONGITUD (pulg.)','Longitud ó 1ª Dimensión comercial (pulg.)','n4+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:45'),('322y','LONGITUD (pies)','Longitud ó 1ª Dimensión comercial (pies)','n4+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:45'),('323y','LONGITUD (yard.)','Longitud ó 1ª Dimensión comercial (yard.)','n4+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:45'),('324y','ANCHO (pulg.)','Anchura, Diámetro ó 2ª Dimensión comercial (pulg.)','n4+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:45'),('325y','ANCHO (pies)','Anchura, Diámetro ó 2ª Dimensión comercial (pies)','n4+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:45'),('326y','ANCHO (yard.)','Anchura, Diámetro ó 2ª Dimensión comercial (yard.)','n4+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:45'),('327y','ALTURA (pulg.)','Profundidad, Espesor, Altura ó 3ª Dimensión comercial (pulg.)','n4+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:45'),('328y','ALTURA (pies)','Profundidad, Espesor, Altura ó 3ª Dimensión comercial(pies)','n4+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:45'),('329y','ALTURA (yard.)','Profundidad, Espesor, Altura ó 3ª Dimensión comercial(yard.)','n4+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:45'),('330y','PESO BRUTO (Kg.)','Peso Bruto (Kg.)','n4+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:45'),('331y','LONGITUD (m.), log','Longitud ó 1ª Dimensión logística (m.), log.','n4+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:45'),('332y','ANCHO (m.), log','Anchura, Diámetro ó 2ª Dimensión logística (m.), log.','n4+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:45'),('333y','ALTURA (m.), log','Profundidad, Espesor, Altura ó 3ª Dimensión logística (m.), log.','n4+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:45'),('334y','AREA (m2.), log','Área logística (m2.), log.','n4+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:45'),('335y','VOLUMEN (l.), log','Volumen Bruto (l.), log.','n4+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:46'),('336y','VOLUMEN (m3.), log','Volumen Bruto (m3.), log.','n4+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:46'),('337y','KILOGRAMOS POR M2.','Kilogramos por metro cuadrado','n4+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:47'),('340y','PESO BRUTO (lb.)','Peso Bruto (lb.)','n4+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:46'),('341y','LONGITUD (pulg.), log','Longitud ó 1ª Dimensión logística (pulg.), log.','n4+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:46'),('342y','LONGITUD (pies), log','Longitud ó 1ª Dimensión logística (pies.), log.','n4+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:46'),('343y','LONGITUD (y), log','Longitud ó 1ª Dimensión logística (yard.), log.','n4+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:46'),('344y','ANCHO (pulg.), log','Anchura, Diámetro ó 2ª Dimensión logística (pulg.), log.','n4+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:46'),('345y','ANCHO (pies), log','Anchura, Diámetro ó 2ª Dimensión logística (pies), log.','n4+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:46'),('346y','ANCHO (y), log','Anchura, Diámetro ó 2ª Dimensión logística (yard.), log.','n4+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:46'),('347y','ALTURA (pulg.), log','Profundidad, Espesor, Altura ó 3ª Dimensión logística (pulg.), log.','n4+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:46'),('348y','ALTURA (pies), log','Profundidad, Espesor, Altura ó 3ª Dimensión logística (pies), log.','n4+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:46'),('349y','ALTURA (y), log','Profundidad, Espesor, Altura ó 3ª Dimensión logística (yard.), log.','n4+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:46'),('350y','AREA (pulg.2)','Área comercial (pulg.2)','n4+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:46'),('351y','AREA (pies 2)','Área comercial (pies 2)','n4+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:46'),('352y','AREA (y.2)','Área comercial (yard.2)','n4+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:46'),('353y','AREA (pulg.2), log','Área logística (pulg.2), log.','n4+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:46'),('354y','AREA (pies.2), log','Área logística (pies 2), log.','n4+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:46'),('355y','AREA (y.2), log','Área logística (yard.2), log','n4+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:46'),('356y','PESO NETO (ozt.)','Peso Neto (Onza Troy)','n4+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:46'),('357y','PESO NETO (oz.)','Peso Neto (Onza U.S.) (Volumen Neto)','n4+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:46'),('360y','VOLUMEN NETO (c.)','Volumen Neto (cuartos )','n4+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:46'),('361y','VOLUMEN NETO (g)','Volumen Neto (galones ) (U.S.)','n4+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:46'),('362y','VOLUMEN BRUTO (c.), log','Volumen Bruto (c )','n4+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:46'),('363y','VOLUMEN BRUTO (g), log','Volumen Bruto (g )','n4+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:46'),('364y','VOLUMEN NETO (pulg.3)','Volumen Neto (pulg.3)','n4+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:46'),('365y','VOLUMEN NETO (pies 3)','Volumen Neto (pies 3)','n4+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:46'),('366y','VOLUMEN NETO (y.3)','Volumen Neto (yard.3)','n4+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:46'),('367y','VOLUMEN BRUTO (pulg.3), log','Volumen Bruto (pulg.3), log.','n4+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:46'),('368y','VOLUMEN BRUTO (pies 3), log','Volumen Bruto (pies 3), log.','n4+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:46'),('369y','VOLUMEN BRUTO (y.3), log','Volumen Bruto (yard.3), log.','n4+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:46'),('37','CANTIDAD LOGISTICA','Cantidad de Artículos Comerciales en la Unidad Logística','n2+n..8',8,1,0,1,0,'A','admindfs','2012-11-28 11:38:46'),('390y','IMPORTE 1 (IMPORTE MONEDA ÚNICA)','Importe a Pagar   - Área Monetaria única -','n4+n..15',15,1,0,1,0,'A','admindfs','2012-11-28 11:38:46'),('391y','IMPORTE 2 (IMPORTE CÓDIGO ISO)','Importe a Pagar   - Código Monetario ISO -','n4+n3+n..15',18,1,0,1,0,'A','admindfs','2012-11-28 11:38:46'),('392y','PRECIO 1 (PRECIO MONEDA ÚNICA)','Precio a Pagar por Artículo Comercial de Medida Variable - Área Monetaria única -','n4+n..15',15,1,0,1,0,'A','admindfs','2012-11-28 11:38:46'),('393y','PRECIO 2 (PRECIO CÓDIGO ISO)','Precio a Pagar por Artículo Comercial de Medida Variable  - Código Monetario ISO -','n4+n3+n..15',18,1,0,1,0,'A','admindfs','2012-11-28 11:38:46'),('400','NUMERO DE PEDIDO CLIENTE','Número de Pedido / Orden del Cliente','n3+an..30',30,0,0,1,0,'A','admindfs','2012-11-28 11:38:46'),('401','CONSIGNACION','Número de Consignación','n3+an..30',30,0,0,1,0,'A','admindfs','2012-11-28 11:38:46'),('402','NUMERO ID. ENVIO - EMBARQUE','Número de Identificación del Envío','n3+n17',17,1,1,1,0,'A','admindfs','2012-11-28 11:38:46'),('403','RUTA - ITINERARIO','Código de Ruta - Itinerario','n3+an..30',30,0,0,1,0,'A','admindfs','2012-11-28 11:38:46'),('410','EXPEDIR A - ENTREGAR A','Expedir a, Entregar a, Enviar a (punto operacional empleando GTIN-13)','n3+n13',13,1,1,1,0,'A','admindfs','2012-11-28 11:38:46'),('411','FACTURAR A','Facturar a, Cargar en cuenta a (punto operacional empleando GTIN-13)','n3+n13',13,1,1,1,0,'A','admindfs','2012-11-28 11:38:46'),('412','COMPRADO A','Comprado a (punto operacional empleando GTIN-13)','n3+n13',13,1,1,1,0,'A','admindfs','2012-11-28 11:38:46'),('413','EXPEDIR PARA - ENTREGAR PARA','Expedir para, Entregar para, Remitir a (punto operacional empleando GTIN-13)','n3+n13',13,1,1,1,0,'A','admindfs','2012-11-28 11:38:46'),('414','NUMERO LOCALIZACIÓN','Número de Localización (punto operacional empleando GTIN-13)','n3+n13',13,1,1,1,0,'A','admindfs','2012-11-28 11:38:46'),('415','PAGAR A (GLN - FACTURA)','Pagar a (punto operacional GLN - Global Location Number - de la línea de la factura)','n3+n13',13,1,1,1,0,'A','admindfs','2012-11-28 11:38:47'),('420','EXPEDIR A - EMBARCAR A POST (9)','Expedir a (entregar a) Código Postal dentro de una única Autoridad Postal.','n3+n..20',20,1,0,1,0,'A','admindfs','2012-11-28 11:38:47'),('421','EXPEDIR A - EMBARCAR A POST (12)','Expedir a (entregar a) Código Postal precedido del Código del País ISO (3 dígitos).','n3+n3+an..9',12,0,0,1,0,'A','admindfs','2012-11-28 11:38:47'),('422','PAIS NACIMIENTO - ORIGEN','País de Nacimiento - Origen del Animal','n3+n3',3,1,1,1,0,'A','admindfs','2012-11-28 11:38:47'),('423','PAIS DE CEBO - PROCESO INICIAL','País de Cebo  (procesamiento inicial)','n3+n3',3,1,1,1,0,'A','admindfs','2012-11-28 11:38:47'),('424','PAIS DE PRODUCCIÓN','País de Producción - Procesamiento del producto','n3+n3',3,1,1,1,0,'A','admindfs','2012-11-28 11:38:47'),('425','PAIS DE DESPIECE - DESENSAMBLAJE','País de Despiece - Desensamblaje','n3+n3',3,1,1,1,0,'A','admindfs','2012-11-28 11:38:47'),('426','PAIS PROCESO COMPLETO','País de Proceso Completo (nacido, cebado y sacrificado en un mismo país)','n3+n3',3,1,1,1,0,'A','admindfs','2012-11-28 11:38:47'),('7001','NUMERO STOCK','Número de Stock','n4+n13',13,1,1,1,0,'A','admindfs','2012-11-28 11:38:47'),('7002','CORTE CARNE','Clasificación UN/ENE de Cortes y Despieces CARNE y la Carcasa.','n4+an..30',30,0,0,1,0,'A','admindfs','2012-11-28 11:38:47'),('7030','PAIS SACRIFICIO (CARNE)','País de Sacrificio y Número RSI del Matadero','n4+n3+an..27',30,0,0,1,0,'A','admindfs','2012-11-28 11:38:47'),('7030(1-3)','PAIS SACRIFICIO','País de sacrificio','n4+n3+an..27',30,0,0,1,0,'A','admindfs','2013-02-01 09:00:00'),('7030(4-30)','MATADERO','Número RSI del Matadero','n4+n3+an..27',30,0,0,1,0,'A','admindfs','2013-02-01 09:00:00'),('703Y','PAIS DESPIECE (CARNE)','País de Despiece y Número Registro Sanitario de Despiece','n4+n3+an..27',30,0,0,1,0,'A','admindfs','2012-11-28 11:38:47'),('8001','BOBINADO (DIMENSIONES)','Productos Bobinados (Cilindro) Dimensiones - Anchura, Longitud, Diámetro de núcleo, Dirección y Empalmes.','n4+n14',14,1,1,1,0,'A','admindfs','2012-11-28 11:38:47'),('8002','SERIE ELECTRONICA TELEFONOS','Número de Serie Electrónico para Teléfono Móvil Celular','n4+an..20',20,0,0,1,0,'A','admindfs','2012-11-28 11:38:47'),('8003','GRAI','Identificación Mundial del Artículo Retornables (Número GTIN y Número de Serie de Retornables)','n4+n14+an..16',30,0,0,1,0,'A','admindfs','2012-11-28 11:38:47'),('8004','GIAI','Identificación Mundial del Artículo Individual (Número GTIN seriado del Activo)','n4+an..30',30,0,0,1,0,'A','admindfs','2012-11-28 11:38:47'),('8005','PRECIO POR UNIDAD DE MEDIDA','Precio por Unidad de Medida','n4+n6',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:47'),('8006','GCTIN','Identificación de los Componentes del Artículo Comercial','n4+n14+n2+n2',18,1,1,1,0,'A','admindfs','2012-11-28 11:38:47'),('8007','CUENTA BANCO (IBAN)','Número de Cuenta del Banco Internacional','n4+an..30',30,0,0,1,0,'A','admindfs','2012-11-28 11:38:47'),('8008','FECHA - TIEMPO DE PRODUCCION','Fecha y Tiempo de Producción','n4+n8+n..4',12,1,0,1,0,'A','admindfs','2012-11-28 11:38:47'),('8018','GSRN','Número Mundial de identificación de Relación de Servicio individualizado','n4+n18',18,1,1,1,0,'A','admindfs','2012-11-28 11:38:47'),('8020','NUMERO REFERENCIA PAGO','Número de Referencia del Pago (talón)','n4+an..25',25,0,0,1,0,'A','admindfs','2012-11-28 11:38:47'),('8100','CUPON (NSC-OFERTA)','Código Cupón Extendido - NSC + Código Oferta','n4+n1+n5',6,1,1,1,0,'A','admindfs','2012-11-28 11:38:47'),('8101','CUPON (NSC-OFERTA-FIN)','Código Cupón Extendido - NSC + Código Oferta + Fin Código Oferta','n4+n1+n5+n4',10,1,1,1,0,'A','admindfs','2012-11-28 11:38:47'),('8102','CUPON (NSC)','Código Cupón Extendido - NSC','n4+n1+n1',2,1,1,1,0,'A','admindfs','2012-11-28 11:38:47'),('90','INTERNO (FACT Dis)','Aplicaciones Internas mutuamente acordadas.','n2+an..30',30,0,0,1,0,'A','admindfs','2012-11-28 11:38:47'),('91','INTERNO 1','Interno (Materias Primas, Envases, Componentes)','n2+an..30',30,0,0,1,0,'A','admindfs','2012-11-28 11:38:47'),('92','INTERNO 1','Interno (Materias Primas, Envases, Componentes)','n2+an..30',30,0,0,1,0,'A','admindfs','2012-11-28 11:38:47'),('93','INTERNO 2','Interno (Fabricantes de Producto)','n2+an..30',30,0,0,1,0,'A','admindfs','2012-11-28 11:38:47'),('94','INTERNO 2','Interno (Fabricantes de Producto)','n2+an..30',30,0,0,1,0,'A','admindfs','2012-11-28 11:38:47'),('950','TRAZABILIDAD','Trazabilidad Francia','n3+n9',9,1,1,1,0,'A','admindfs','2013-02-01 09:00:00'),('950(1)','TRAZABILIDAD (1)','Trazabilidad Francia','n3+n9',9,1,1,1,0,'A','admindfs','2012-01-31 08:00:00'),('950(2)','TRAZABILIDAD (2)','Trazabilidad Francia','n3+n9',9,1,1,1,0,'A','admindfs','2012-01-31 08:00:00'),('950(3)','TRAZABILIDAD (3)','Trazabilidad Francia','n3+n9',9,1,1,1,0,'A','admindfs','2012-01-31 08:00:00'),('950(4-5)','TRAZABILIDAD (4-5)','Trazabilidad Francia','n3+n9',9,1,1,1,0,'A','admindfs','2012-01-31 08:00:00'),('950(6-7)','TRAZABILIDAD (6-7)','Trazabilidad Francia','n3+n9',9,1,1,1,0,'A','admindfs','2012-01-31 08:00:00'),('950(8-9)','TRAZABILIDAD (8-9)','Trazabilidad Francia','n3+n9',9,1,1,1,0,'A','admindfs','2012-01-31 08:00:00'),('953','ESPECIFICACIONES','Especificaciones','n3+an..29',29,0,0,1,0,'A','admindfs','2013-02-01 09:00:00'),('96','INTERNO 3','Interno (Transportistas)','n2+an..30',30,0,0,1,0,'A','admindfs','2012-11-28 11:38:47'),('97','INTERNO 4','Interno (Mayoristas y Detallistas)','n2+an..30',30,0,0,1,0,'A','admindfs','2012-11-28 11:38:47'),('98','INTERNO 4','Interno (Mayoristas y Detallistas)','n2+an..30',30,0,0,1,0,'A','admindfs','2012-11-28 11:38:47'),('99','INTERNO (TEXTO LIBRE)','Interno (Texto Libre)','n2+an..30',30,0,0,1,0,'A','admindfs','2012-11-28 11:38:47');
UNLOCK TABLES;
/*!40000 ALTER TABLE `sys_tabla_ias` ENABLE KEYS */;

--
-- Table structure for table `sys_tipo`
--

DROP TABLE IF EXISTS `sys_tipo`;
CREATE TABLE `sys_tipo` (
  `IdTipo` int(11) NOT NULL,
  `NombreTipo` varchar(25) NOT NULL default 'Null',
  `IdEmpresa` int(11) NOT NULL default '1',
  `Valor` smallint(6) NOT NULL default '0' COMMENT '1=Pesado\r\n0=Unitario',
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
  `Comportamiento` int(11) default '1' COMMENT '0:Unitario\r\n1:Pesado',
  PRIMARY KEY  (`IdEmpresa`,`IdTipo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='Tabla donde se guarda toda la informacion de los tipos de';

--
-- Dumping data for table `sys_tipo`
--


/*!40000 ALTER TABLE `sys_tipo` DISABLE KEYS */;
LOCK TABLES `sys_tipo` WRITE;
INSERT INTO `sys_tipo` (`IdTipo`, `NombreTipo`, `IdEmpresa`, `Valor`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`, `Comportamiento`) VALUES (1,'sys_tipo_pesado',1,0,0,'M','Admin','2010-07-08 14:56:38',1),(2,'sys_tipo_unitario',1,1,0,'M','Admin','2010-07-08 08:34:00',0),(3,'sys_tipo_pesofijo',1,4,0,'A','Admin','2010-07-08 15:02:11',1),(4,'sys_tipo_devolucion',1,3,0,'A','Admin','2010-07-08 08:34:28',0),(5,'sys_tipo_taraporcentual',1,6,0,'A','Admin','2010-07-08 15:02:13',1),(6,'sys_tipo_cuentapiezas',1,5,0,'A','Admin','2013-10-07 07:11:59',1);
UNLOCK TABLES;
/*!40000 ALTER TABLE `sys_tipo` ENABLE KEYS */;

--
-- Table structure for table `sys_unicodetolc`
--

DROP TABLE IF EXISTS `sys_unicodetolc`;
CREATE TABLE `sys_unicodetolc` (
  `Unicode` varchar(20) NOT NULL,
  `LC` varchar(20) NOT NULL,
  PRIMARY KEY  (`Unicode`,`LC`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `sys_unicodetolc`
--


/*!40000 ALTER TABLE `sys_unicodetolc` DISABLE KEYS */;
LOCK TABLES `sys_unicodetolc` WRITE;
INSERT INTO `sys_unicodetolc` (`Unicode`, `LC`) VALUES ('0000','0000'),('0001','0001'),('0002','0002'),('0003','0003'),('0004','0004'),('0005','0005'),('0006','0006'),('0007','0007'),('0008','0008'),('0009','0009'),('000A','0010'),('000B','0011'),('000C','0012'),('000D','0013'),('000E','0014'),('000F','0015'),('0010','0016'),('0011','0017'),('0012','0018'),('0013','0019'),('0014','0020'),('0015','0021'),('0016','0022'),('0017','0023'),('0018','0024'),('0019','0025'),('001A','0026'),('001B','0027'),('001C','0028'),('001D','0029'),('001E','0030'),('001F','0031'),('0020','0032'),('0021','0033'),('0022','0034'),('0023','0035'),('0024','0036'),('0025','0037'),('0026','0038'),('0027','0039'),('0028','0040'),('0029','0041'),('002A','0042'),('002B','0043'),('002C','0044'),('002D','0045'),('002E','0046'),('002F','0047'),('0030','0048'),('0031','0049'),('0032','0050'),('0033','0051'),('0034','0052'),('0035','0053'),('0036','0054'),('0037','0055'),('0038','0056'),('0039','0057'),('003A','0058'),('003B','0059'),('003C','0060'),('003D','0061'),('003E','0062'),('003F','0063'),('0040','0064'),('0041','0065'),('0042','0066'),('0043','0067'),('0044','0068'),('0045','0069'),('0046','0070'),('0047','0071'),('0048','0072'),('0049','0073'),('004A','0074'),('004B','0075'),('004C','0076'),('004D','0077'),('004E','0078'),('004F','0079'),('0050','0080'),('0051','0081'),('0052','0082'),('0053','0083'),('0054','0084'),('0055','0085'),('0056','0086'),('0057','0087'),('0058','0088'),('0059','0089'),('005A','0090'),('005B','0091'),('005C','0092'),('005D','0093'),('005E','0094'),('005F','0095'),('0060','0096'),('0061','0097'),('0062','0098'),('0063','0099'),('0064','0100'),('0065','0101'),('0066','0102'),('0067','0103'),('0068','0104'),('0069','0105'),('006A','0106'),('006B','0107'),('006C','0108'),('006D','0109'),('006E','0110'),('006F','0111'),('0070','0112'),('0071','0113'),('0072','0114'),('0073','0115'),('0074','0116'),('0075','0117'),('0076','0118'),('0077','0119'),('0078','0120'),('0079','0121'),('007A','0122'),('007B','0123'),('007C','0124'),('007D','0125'),('007E','0126'),('007F','0127'),('0080','0128'),('0081','0129'),('0082','0130'),('0083','0131'),('0084','0132'),('0085','0133'),('0086','0134'),('0087','0135'),('0088','0136'),('0089','0137'),('008A','0138'),('008B','0139'),('008C','0140'),('008D','0141'),('008E','0142'),('008F','0143'),('0090','0144'),('0091','0145'),('0092','0146'),('0093','0147'),('0094','0148'),('0095','0149'),('0096','0150'),('0097','0151'),('0098','0152'),('0099','0153'),('009A','0154'),('009B','0155'),('009C','0156'),('009D','0157'),('009E','0158'),('009F','0159'),('00A0','0160'),('00A1','0161'),('00A2','0162'),('00A3','0163'),('00A4','0164'),('00A5','0165'),('00A6','0166'),('00A7','0167'),('00A8','0168'),('00A9','0169'),('00AA','0170'),('00AB','0171'),('00AC','0172'),('00AD','0173'),('00AE','0174'),('00AF','0175'),('00B0','0176'),('00B1','0177'),('00B2','0178'),('00B3','0179'),('00B4','0180'),('00B5','0181'),('00B6','0182'),('00B7','0183'),('00B8','0184'),('00B9','0185'),('00BA','0186'),('00BB','0187'),('00BC','0188'),('00BD','0189'),('00BE','0190'),('00BF','0191'),('00C0','0192'),('00C1','0193'),('00C2','0194'),('00C3','0195'),('00C4','0196'),('00C5','0197'),('00C6','0198'),('00C7','0199'),('00C8','0200'),('00C9','0201'),('00CA','0202'),('00CB','0203'),('00CC','0204'),('00CD','0205'),('00CE','0206'),('00CF','0207'),('00D0','0208'),('00D1','0209'),('00D2','0210'),('00D3','0211'),('00D4','0212'),('00D5','0213'),('00D6','0214'),('00D7','0215'),('00D8','0216'),('00D9','0217'),('00DA','0218'),('00DB','0219'),('00DC','0220'),('00DD','0221'),('00DE','0222'),('00DF','0223'),('00E0','0224'),('00E1','0225'),('00E2','0226'),('00E3','0227'),('00E4','0228'),('00E5','0229'),('00E6','0230'),('00E7','0231'),('00E8','0232'),('00E9','0233'),('00EA','0234'),('00EB','0235'),('00EC','0236'),('00ED','0237'),('00EE','0238'),('00EF','0239'),('00F0','0240'),('00F1','0241'),('00F2','0242'),('00F3','0243'),('00F4','0244'),('00F5','0245'),('00F6','0246'),('00F7','0247'),('00F8','0248'),('00F9','0249'),('00FA','0250'),('00FB','0251'),('00FC','0252'),('00FD','0253'),('00FE','0254'),('00FF','0255'),('0152','0140'),('20AC','0128'),('4E00','5027'),('4E01','2201'),('4E03','3863'),('4E07','4582'),('4E08','5341'),('4E09','4093'),('4E0A','4147'),('4E0B','4734'),('4E0C','5602'),('4E0D','1827'),('4E0E','5175'),('4E10','5604'),('4E11','1983'),('4E13','5508'),('4E14','3950'),('4E15','5607'),('4E16','4232'),('4E18','3980'),('4E19','1791'),('4E1A','5021'),('4E1B','2052'),('4E1C','2211'),('4E1D','4331'),('4E1E','5609'),('4E22','2210'),('4E24','3329'),('4E25','4947'),('4E27','4105'),('4E28','5613'),('4E2A','2486'),('4E2B','4930'),('4E2C','6760'),('4E2D','5448'),('4E30','2365'),('4E32','2014'),('4E34','3357'),('4E36','5628'),('4E38','4572'),('4E39','2104'),('4E3A','4610'),('4E3B','5487'),('4E3D','3286'),('4E3E','3057'),('4E3F','5615'),('4E43','3643'),('4E45','3035'),('4E47','5617'),('4E48','3520'),('4E49','5069'),('4E4B','5414'),('4E4C','4658'),('4E4D','5307'),('4E4E','2685'),('4E4F','2306'),('4E50','3254'),('4E52','3825'),('4E53','3750'),('4E54','3939'),('4E56','2552'),('4E58','1943'),('4E59','5050'),('4E5C','5631'),('4E5D','3037'),('4E5E','3882'),('4E5F','5018'),('4E60','4716'),('4E61','4771'),('4E66','4273'),('4E69','5632'),('4E70','3482'),('4E71','3450'),('4E73','4073'),('4E7E','3912'),('4E86','3343'),('4E88','5172'),('4E89','5389'),('4E8B','4234'),('4E8C','2294'),('4E8D','5601'),('4E8E','5158'),('4E8F','3187'),('4E91','5238'),('4E92','2705'),('4E93','5633'),('4E94','4669'),('4E95','3014'),('4E98','5608'),('4E9A','4939'),('4E9B','4809'),('4E9F','5629'),('4EA0','5779'),('4EA1','4586'),('4EA2','3126'),('4EA4','2927'),('4EA5','2605'),('4EA6','5064'),('4EA7','1890'),('4EA8','2664'),('4EA9','3622'),('4EAB','4777'),('4EAC','3009'),('4EAD','4504'),('4EAE','3333'),('4EB2','3955'),('4EB3','5781'),('4EB5','5784'),('4EBA','4043'),('4EBB','5673'),('4EBF','5058'),('4EC0','4218'),('4EC1','4042'),('4EC2','5676'),('4EC3','5674'),('4EC4','5638'),('4EC5','2986'),('4EC6','3845'),('4EC7','1980'),('4EC9','5675'),('4ECA','2981'),('4ECB','2973'),('4ECD','4052'),('4ECE','2051'),('4ED1','3456'),('4ED3','1854'),('4ED4','5548'),('4ED5','4243'),('4ED6','4391'),('4ED7','5344'),('4ED8','2422'),('4ED9','4741'),('4EDD','5758'),('4EDE','5680'),('4EDF','3910'),('4EE1','5678'),('4EE3','2090'),('4EE4','3378'),('4EE5','5052'),('4EE8','5677'),('4EEA','5039'),('4EEB','5679'),('4EEC','3539'),('4EF0','4986'),('4EF2','5457'),('4EF3','5682'),('4EF5','5685'),('4EF6','2894'),('4EF7','2859'),('4EFB','4046'),('4EFD','2361'),('4EFF','2334'),('4F01','3883'),('4F09','5688'),('4F0A','5033'),('4F0D','4673'),('4F0E','2831'),('4F0F','2392'),('4F10','2305'),('4F11','4861'),('4F17','5458'),('4F18','5137'),('4F19','2779'),('4F1A','2765'),('4F1B','5681'),('4F1E','4101'),('4F1F','4616'),('4F20','2011'),('4F22','5683'),('4F24','4143'),('4F25','5686'),('4F26','3455'),('4F27','5687'),('4F2A','4617'),('4F2B','5689'),('4F2F','1814'),('4F30','2532'),('4F32','5703'),('4F34','1673'),('4F36','3370'),('4F38','4176'),('4F3A','4337'),('4F3C','4338'),('4F3D','5704'),('4F43','2172'),('4F46','2111'),('4F4D','4627'),('4F4E','2145'),('4F4F','5501'),('4F50','5584'),('4F51','5151'),('4F53','4469'),('4F55','2646'),('4F57','5702'),('4F58','5760'),('4F59','5164'),('4F5A','5693'),('4F5B','2380'),('4F5C','5587'),('4F5D','5694'),('4F5E','5690'),('4F5F','5701'),('4F60','3667'),('4F63','5122'),('4F64','5684'),('4F65','5761'),('4F67','5691'),('4F69','3769'),('4F6C','3248'),('4F6F','4980'),('4F70','1659'),('4F73','2849'),('4F74','5706'),('4F76','5705'),('4F7B','5712'),('4F7C','5714'),('4F7E','5711'),('4F7F','4225'),('4F83','5709'),('4F84','5422'),('4F88','1962'),('4F89','5708'),('4F8B','3293'),('4F8D','4244'),('4F8F','5710'),('4F91','5707'),('4F94','5716'),('4F97','2217'),('4F9B','2509'),('4F9D','5032'),('4FA0','4732'),('4FA3','3434'),('4FA5','2936'),('4FA6','5376'),('4FA7','1864'),('4FA8','3940'),('4FA9','3175'),('4FAA','5713'),('4FAC','5715'),('4FAE','4674'),('4FAF','2678'),('4FB5','3954'),('4FBF','1767'),('4FC3','2057'),('4FC4','2277'),('4FC5','5720'),('4FCA','3101'),('4FCE','5762'),('4FCF','3946'),('4FD0','3294'),('4FD1','5724'),('4FD7','4355'),('4FD8','2393'),('4FDA','5721'),('4FDC','5723'),('4FDD','1703'),('4FDE','5165'),('4FDF','5725'),('4FE1','4837'),('4FE3','5722'),('4FE6','5717'),('4FE8','5718'),('4FE9','3309'),('4FEA','5719'),('4FED','2883'),('4FEE','4862'),('4FEF','2409'),('4FF1','3067'),('4FF3','5729'),('4FF8','5726'),('4FFA','1619'),('4FFE','5734'),('500C','5736'),('500D','1722'),('500F','5731'),('5012','2125'),('5014','3083'),('5018','4440'),('5019','2682'),('501A','5048'),('501C','5735'),('501F','2972'),('5021','1911'),('5025','5737'),('5026','3075'),('5028','5738'),('5029','5727'),('502A','3663'),('502C','5730'),('502D','5733'),('502E','5732'),('503A','5314'),('503C','5421'),('503E','3967'),('5043','5740'),('5047','2857'),('5048','5742'),('504C','5728'),('504E','5743'),('504F','3811'),('5055','5741'),('505A','5586'),('505C','4503'),('5065','2901'),('506C','5744'),('5076','3728'),('5077','4521'),('507B','5745'),('507E','5739'),('507F','1905'),('5080','3194'),('5085','2421'),('5088','3292'),('508D','1688'),('50A3','2086'),('50A5','5746'),('50A7','5747'),('50A8','2002'),('50A9','5748'),('50AC','2063'),('50B2','1633'),('50BA','5749'),('50BB','4121'),('50CF','4781'),('50D6','5750'),('50DA','3337'),('50E6','5754'),('50E7','4114'),('50EC','5753'),('50ED','5752'),('50EE','5755'),('50F3','4359'),('50F5','2909'),('50FB','3807'),('5106','5751'),('5107','5756'),('510B','5757'),('5112','4069'),('5121','3260'),('513F','2289'),('5140','5603'),('5141','5242'),('5143','5210'),('5144','4854'),('5145','1968'),('5146','5355'),('5148','4740'),('5149','2566'),('514B','3143'),('514D','3566'),('5151','2250'),('5154','4535'),('5155','5778'),('5156','5780'),('515A','2119'),('515C','2221'),('5162','3004'),('5165','4075'),('5168','4011'),('516B','1643'),('516C','2511'),('516D','3389'),('516E','5766'),('5170','3228'),('5171','2518'),('5173','2556'),('5174','4843'),('5175','1788'),('5176','3868'),('5177','3063'),('5178','2168'),('5179','5540'),('517B','4988'),('517C','2870'),('517D','4262'),('5180','2829'),('5181','5770'),('5182','5671'),('5185','3658'),('5188','2452'),('5189','4029'),('518C','1865'),('518D','5257'),('5192','3516'),('5195','3565'),('5196','5802'),('5197','4063'),('5199','4820'),('519B','3092'),('519C','3709'),('51A0','2558'),('51A2','5803'),('51A4','5209'),('51A5','5804'),('51AB','5791'),('51AC','2212'),('51AF','2375'),('51B0','1789'),('51B1','5792'),('51B2','1969'),('51B3','3086'),('51B5','3186'),('51B6','5017'),('51B7','3268'),('51BB','2219'),('51BC','5794'),('51BD','5793'),('51C0','3027'),('51C4','3864'),('51C6','5528'),('51C7','5801'),('51C9','3325'),('51CB','2182'),('51CC','3372'),('51CF','2885'),('51D1','2053'),('51DB','3361'),('51DD','3693'),('51E0','2824'),('51E1','2318'),('51E4','2379'),('51EB','5776'),('51ED','3830'),('51EF','3113'),('51F0','2743'),('51F3','2142'),('51F5','5941'),('51F6','4855'),('51F8','4525'),('51F9','1628'),('51FA','1986'),('51FB','2787'),('51FC','5942'),('51FD','2615'),('51FF','5268'),('5200','2122'),('5201','2183'),('5202','5654'),('5203','4048'),('5206','2354'),('5207','3948'),('5208','5655'),('520A','3115'),('520D','5927'),('520E','5656'),('5211','4844'),('5212','2714'),('5216','7530'),('5217','3348'),('5218','3385'),('5219','5282'),('521A','2453'),('521B','2020'),('521D','1985'),('5220','4130'),('5224','3748'),('5228','3757'),('5229','3291'),('522B','1780'),('522D','5657'),('522E','2546'),('5230','2129'),('5233','5658'),('5236','5438'),('5237','4302'),('5238','4015'),('5239','4118'),('523A','2044'),('523B','3144'),('523D','2584'),('523F','5659'),('5240','5660'),('5241','2271'),('5242','2833'),('5243','4474'),('524A','4787'),('524C','5661'),('524D','3916'),('5250','2548'),('5251','2903'),('5254','4462'),('5256','3842'),('525C','5664'),('525E','5662'),('5261','5663'),('5265','1694'),('5267','3071'),('5269','4203'),('526A','2884'),('526F','2417'),('5272','2478'),('527D','5666'),('527F','2943'),('5281','5668'),('5282','5667'),('5288','3792'),('5290','5669'),('5293','5670'),('529B','3306'),('529D','4016'),('529E','1676'),('529F','2506'),('52A0','2851'),('52A1','4681'),('52A2','5929'),('52A3','3351'),('52A8','2215'),('52A9','5490'),('52AA','3712'),('52AB','2957'),('52AC','5930'),('52AD','5931'),('52B1','3288'),('52B2','3002'),('52B3','3245'),('52BE','5932'),('52BF','4238'),('52C3','1810'),('52C7','5134'),('52C9','3567'),('52CB','4911'),('52D0','5934'),('52D2','3253'),('52D6','5935'),('52D8','3117'),('52DF','3628'),('52E4','3958'),('52F0','5936'),('52F9','5772'),('52FA','4155'),('52FE','2520'),('52FF','4680'),('5300','5240'),('5305','1692'),('5306','2050'),('5308','4857'),('530D','5773'),('530F','6243'),('5310','5775'),('5315','5616'),('5316','2715'),('5317','1717'),('5319','1955'),('531A','5646'),('531D','5249'),('5320','2919'),('5321','3179'),('5323','4727'),('5326','5648'),('532A','2343'),('532E','5649'),('5339','3805'),('533A','3988'),('533B','5029'),('533E','5650'),('533F','3668'),('5341','4214'),('5343','3907'),('5345','5606'),('5347','4193'),('5348','4671'),('5349','2760'),('534A','1675'),('534E','2710'),('534F','4813'),('5351','1716'),('5352','5568'),('5353','5531'),('5355','2105'),('5356','3484'),('5357','3647'),('535A','1809'),('535C','1823'),('535E','1769'),('535F','6318'),('5360','5328'),('5361','3108'),('5362','3412'),('5363','5653'),('5364','3417'),('5366','5652'),('5367','4652'),('5369','5864'),('536B','4632'),('536E','5620'),('536F','3514'),('5370','5101'),('5371','4603'),('5373','2820'),('5374','4020'),('5375','3449'),('5377','3077'),('5378','4822'),('537A','5865'),('537F','3968'),('5382','1907'),('5384','2282'),('5385','4492'),('5386','3290'),('5389','3287'),('538B','4925'),('538C','4965'),('538D','5639'),('5395','1862'),('5398','3269'),('539A','2681'),('539D','5640'),('539F','5213'),('53A2','4765'),('53A3','5641'),('53A5','5642'),('53A6','4735'),('53A8','1988'),('53A9','3039'),('53AE','5643'),('53B6','5944'),('53BB','4005'),('53BF','4756'),('53C1','4094'),('53C2','1846'),('53C8','5154'),('53C9','1870'),('53CA','2816'),('53CB','5149'),('53CC','4311'),('53CD','2320'),('53D1','2302'),('53D4','4269'),('53D6','4001'),('53D7','4260'),('53D8','1768'),('53D9','4880'),('53DB','3749'),('53DF','5937'),('53E0','2194'),('53E3','3158'),('53E4','2537'),('53E5','3068'),('53E6','3377'),('53E8','6322'),('53E9','6321'),('53EA','5427'),('53EB','2948'),('53EC','5357'),('53ED','1640'),('53EE','2203'),('53EF','3141'),('53F0','4408'),('53F1','6319'),('53F2','4223'),('53F3','5150'),('53F5','5647'),('53F6','5022'),('53F7','2637'),('53F8','4330'),('53F9','4430'),('53FB','6323'),('53FC','2180'),('53FD','6320'),('5401','5185'),('5403','1952'),('5404','2487'),('5406','6326'),('5408','2647'),('5409','2810'),('540A','2185'),('540C','4512'),('540D','3591'),('540E','2683'),('540F','3284'),('5410','4534'),('5411','4782'),('5412','6324'),('5413','4737'),('5415','3432'),('5416','6325'),('5417','3480'),('541B','3093'),('541D','3363'),('541E','4544'),('541F','5087'),('5420','2345'),('5421','6333'),('5423','6336'),('5426','2381'),('5427','1641'),('5428','2254'),('5429','2352'),('542B','2612'),('542C','4493'),('542D','3152'),('542E','4317'),('542F','3884'),('5431','5408'),('5432','6337'),('5434','4666'),('5435','1919'),('5438','4692'),('5439','2021'),('543B','4639'),('543C','2680'),('543E','4665'),('5440','4929'),('5443','6332'),('5446','2084'),('5448','1942'),('544A','2470'),('544B','6327'),('5450','3637'),('5452','6328'),('5453','6329'),('5454','6330'),('5455','3727'),('5456','6331'),('5457','6334'),('5458','5217'),('5459','6335'),('545B','3926'),('545C','4656'),('5462','3656'),('5464','6342'),('5466','6347'),('5468','5460'),('5471','6341'),('5472','6358'),('5473','4622'),('5475','2639'),('5476','6346'),('5477','6340'),('5478','3762'),('547B','4175'),('547C','2684'),('547D','3592'),('5480','3055'),('5482','6338'),('5484','6345'),('5486','3756'),('548B','5306'),('548C','2645'),('548E','3044'),('548F','5129'),('5490','2432'),('5492','5468'),('5494','6339'),('5495','2530'),('5496','3107'),('5499','3392'),('549A','6343'),('549B','6344'),('549D','6348'),('54A3','6359'),('54A4','6369'),('54A6','6355'),('54A7','6354'),('54A8','5541'),('54A9','6367'),('54AA','6368'),('54AB','6975'),('54AC','5007'),('54AD','6350'),('54AF','3109'),('54B1','5259'),('54B3','3140'),('54B4','6352'),('54B8','4744'),('54BB','6361'),('54BD','4942'),('54BF','6362'),('54C0','1607'),('54C1','3823'),('54C2','6351'),('54C4','2669'),('54C6','2263'),('54C7','4559'),('54C8','2594'),('54C9','5253'),('54CC','6363'),('54CD','4776'),('54CE','1605'),('54CF','6371'),('54D0','6349'),('54D1','4938'),('54D2','6353'),('54D3','6356'),('54D4','6357'),('54D5','6360'),('54D7','2709'),('54D9','6364'),('54DA','6365'),('54DC','6366'),('54DD','6370'),('54DE','6372'),('54DF','5120'),('54E5','2471'),('54E6','3722'),('54E7','6374'),('54E8','4158'),('54E9','3308'),('54EA','3636'),('54ED','3162'),('54EE','4788'),('54F2','5360'),('54F3','6378'),('54FA','1824'),('54FC','2663'),('54FD','6376'),('54FF','5933'),('5501','4968'),('5506','4384'),('5507','2029'),('5509','1606'),('550F','6381'),('5510','4438'),('5511','6382'),('5514','6377'),('551B','6373'),('5520','6375'),('5522','6379'),('5523','6380'),('5524','2729'),('5527','6383'),('552A','6384'),('552C','2703'),('552E','4259'),('552F','4608'),('5530','6407'),('5531','1910'),('5533','6406'),('5537','6401'),('553C','6394'),('553E','4557'),('553F','6392'),('5541','6390'),('5543','3148'),('5544','5536'),('5546','4144'),('5549','6388'),('554A','1601'),('5550','6393'),('5555','6391'),('5556','6402'),('555C','6408'),('5561','2340'),('5564','3801'),('5565','4122'),('5566','3218'),('5567','6385'),('556A','3730'),('556C','5636'),('556D','6389'),('556E','3686'),('5575','6403'),('5576','6404'),('5577','6405'),('5578','4805'),('557B','6420'),('557C','4468'),('557E','6417'),('5580','3106'),('5581','6415'),('5582','4625'),('5583','6411'),('5584','4138'),('5587','3214'),('5588','6414'),('5589','2677'),('558A','2616'),('558B','6409'),('558F','6386'),('5591','6419'),('5594','6424'),('5598','2013'),('5599','6425'),('559C','4718'),('559D','2640'),('559F','6416'),('55A7','4890'),('55B1','6412'),('55B3','5291'),('55B5','6387'),('55B7','3771'),('55B9','6413'),('55BB','5187'),('55BD','6422'),('55BE','6423'),('55C4','6436'),('55C5','4865'),('55C9','6428'),('55CC','6441'),('55CD','6442'),('55D1','6430'),('55D2','6410'),('55D3','4104'),('55D4','6433'),('55D6','6418'),('55DC','4240'),('55DD','6435'),('55DF','6421'),('55E1','4643'),('55E3','4335'),('55E4','6445'),('55E5','6438'),('55E6','6434'),('55E8','6443'),('55EA','6426'),('55EB','6431'),('55EC','6432'),('55EF','6437'),('55F2','6439'),('55F3','6440'),('55F5','6444'),('55F7','6427'),('55FD','4352'),('55FE','6453'),('5600','6454'),('5601','6450'),('5608','6448'),('5609','2846'),('560C','6449'),('560E','2434'),('560F','5637'),('5618','4874'),('561B','3479'),('561E','6447'),('561F','6429'),('5623','6452'),('5624','6451'),('5627','6455'),('562C','6460'),('562D','6456'),('5631','5486'),('5632','1916'),('5634','5576'),('5636','4327'),('5639','6458'),('563B','4691'),('563F','2657'),('564C','6465'),('564D','6461'),('564E','5013'),('5654','6466'),('5657','6459'),('5658','6457'),('5659','6463'),('565C','6464'),('5662','6462'),('5664','6468'),('5668','3887'),('5669','5612'),('566A','5275'),('566B','6470'),('566C','4241'),('5671','6469'),('5676','2433'),('567B','6471'),('567C','6472'),('5685','6473'),('5686','6467'),('568E','2631'),('568F','4471'),('5693','6474'),('56A3','4789'),('56AF','6475'),('56B7','4034'),('56BC','2932'),('56CA','3650'),('56D4','6476'),('56D7','6477'),('56DA','3984'),('56DB','4336'),('56DD','6478'),('56DE','2756'),('56DF','5622'),('56E0','5082'),('56E1','6479'),('56E2','4537'),('56E4','2258'),('56EB','6481'),('56ED','5216'),('56F0','3207'),('56F1','2049'),('56F4','4607'),('56F5','6480'),('56F9','6482'),('56FA','2544'),('56FD','2590'),('56FE','4528'),('56FF','6483'),('5703','3852'),('5704','6484'),('5706','5218'),('5708','4006'),('5709','6486'),('570A','6485'),('571C','6487'),('571F','4533'),('5723','4205'),('5728','5258'),('5729','5955'),('572A','5957'),('572C','5956'),('572D','2571'),('572E','5960'),('572F','5961'),('5730','2156'),('5733','5958'),('5739','5959'),('573A','1901'),('573B','5963'),('573E','2788'),('5740','5423'),('5742','5964'),('5747','3089'),('574A','2327'),('574C','5948'),('574D','4414'),('574E','3118'),('574F','2721'),('5750','5588'),('5751','3151'),('5757','3173'),('575A','2865'),('575B','4419'),('575C','5962'),('575D','1651'),('575E','4675'),('575F','2356'),('5760','5525'),('5761','3834'),('5764','3204'),('5766','4425'),('5768','5971'),('5769','5965'),('576A','3826'),('576B','5967'),('576D','5972'),('576F','3787'),('5773','5974'),('5776','5973'),('5777','3132'),('577B','5970'),('577C','5969'),('5782','2025'),('5783','3212'),('5784','3402'),('5785','5966'),('5786','5968'),('578B','4845'),('578C','5977'),('5792','3261'),('5793','5982'),('579B','2266'),('57A0','5983'),('57A1','5950'),('57A2','2524'),('57A3','5211'),('57A4','5976'),('57A6','3149'),('57A7','5980'),('57A9','5949'),('57AB','2170'),('57AD','5975'),('57AE','3169'),('57B2','5978'),('57B4','5981'),('57B8','5989'),('57C2','2501'),('57C3','1603'),('57CB','3481'),('57CE','1939'),('57CF','5979'),('57D2','5988'),('57D4','3850'),('57D5','5984'),('57D8','5985'),('57D9','5987'),('57DA','5986'),('57DD','5994'),('57DF','5182'),('57E0','1826'),('57E4','5993'),('57ED','6004'),('57EF','5991'),('57F4','5990'),('57F8','5992'),('57F9','3764'),('57FA','2789'),('57FD','6003'),('5800','6005'),('5802','4435'),('5806','2249'),('5807','6132'),('580B','6001'),('580D','6002'),('5811','3921'),('5815','2273'),('5819','6007'),('581E','6006'),('5820','6009'),('5821','1704'),('5824','2144'),('582A','3116'),('5830','4963'),('5835','2234'),('5844','6008'),('584C','4390'),('584D','7583'),('5851','4360'),('5854','4394'),('5858','4433'),('585E','4091'),('5865','6010'),('586B','4478'),('586C','6011'),('587E','5951'),('5880','6015'),('5881','6012'),('5883','3019'),('5885','4291'),('5889','6013'),('5892','4142'),('5893','3625'),('5899','3929'),('589A','6014'),('589E','5286'),('589F','4870'),('58A8','3611'),('58A9','2253'),('58BC','5952'),('58C1','1758'),('58C5','5953'),('58D1','5954'),('58D5','2630'),('58E4','4032'),('58EB','4231'),('58EC','4041'),('58EE','5519'),('58F0','4189'),('58F3','3139'),('58F6','2688'),('58F9','5028'),('5902','6626'),('5904','2006'),('5907','1724'),('590D','2420'),('590F','4736'),('5914','5771'),('5915','4706'),('5916','4566'),('5919','5777'),('591A','2264'),('591C','5025'),('591F','2527'),('5924','6625'),('5925','6623'),('5927','2083'),('5929','4476'),('592A','4411'),('592B','2382'),('592D','5618'),('592E','4975'),('592F','2627'),('5931','4207'),('5934','4523'),('5937','5036'),('5938','3168'),('5939','2848'),('593A','2265'),('593C','6237'),('5941','6238'),('5942','5928'),('5944','4957'),('5947','3870'),('5948','3646'),('5949','2378'),('594B','2360'),('594E','3192'),('594F','5564'),('5951','3885'),('5954','1728'),('5955','6240'),('5956','2917'),('5957','4455'),('5958','6242'),('595A','6241'),('5960','2176'),('5962','4161'),('5965','1634'),('5973','3714'),('5974','3711'),('5976','3644'),('5978','2873'),('5979','4393'),('597D','2635'),('5981','6989'),('5982','4071'),('5983','6990'),('5984','4593'),('5986','5517'),('5987','2430'),('5988','3472'),('598A','4049'),('598D','6991'),('5992','2242'),('5993','2843'),('5996','4993'),('5997','7001'),('5999','3578'),('599E','7004'),('59A3','6994'),('59A4','7005'),('59A5','4555'),('59A8','2333'),('59A9','6992'),('59AA','6993'),('59AB','7003'),('59AE','3661'),('59AF','7008'),('59B2','7007'),('59B9','3535'),('59BB','3862'),('59BE','7010'),('59C6','3623'),('59CA','7002'),('59CB','4228'),('59D0','2967'),('59D1','2535'),('59D2','7006'),('59D3','4853'),('59D4','4615'),('59D7','7009'),('59D8','7016'),('59DA','5006'),('59DC','2910'),('59DD','7013'),('59E3','7015'),('59E5','3249'),('59E8','5044'),('59EC','2807'),('59F9','7017'),('59FB','5086'),('59FF','5543'),('5A01','4594'),('5A03','4562'),('5A04','3406'),('5A05','7011'),('5A06','7012'),('5A07','2931'),('5A08','7014'),('5A09','7019'),('5A0C','7018'),('5A11','7022'),('5A13','7024'),('5A18','3679'),('5A1C','3640'),('5A1F','3074'),('5A20','4179'),('5A23','7023'),('5A25','2280'),('5A29','3568'),('5A31','5173'),('5A32','7020'),('5A34','7021'),('5A36','4002'),('5A3C','7029'),('5A40','7025'),('5A46','3837'),('5A49','4581'),('5A4A','7027'),('5A55','7028'),('5A5A','2773'),('5A62','7030'),('5A67','7026'),('5A6A','3223'),('5A74','5104'),('5A75','7031'),('5A76','4184'),('5A77','7035'),('5A7A','7036'),('5A7F','4886'),('5A92','3529'),('5A9A','3536'),('5A9B','7034'),('5AAA','7033'),('5AB2','7039'),('5AB3','4717'),('5AB5','7584'),('5AB8','7042'),('5ABE','7037'),('5AC1','2862'),('5AC2','4109'),('5AC9','2821'),('5ACC','4751'),('5AD2','7040'),('5AD4','7041'),('5AD6','7046'),('5AD8','7048'),('5ADC','7049'),('5AE0','7043'),('5AE1','2153'),('5AE3','7044'),('5AE6','7047'),('5AE9','3659'),('5AEB','7038'),('5AF1','7045'),('5B09','7050'),('5B16','7052'),('5B17','7051'),('5B32','7053'),('5B34','5788'),('5B37','7054'),('5B40','7055'),('5B50','5551'),('5B51','7061'),('5B53','7062'),('5B54','3155'),('5B55','5248'),('5B57','5554'),('5B58','2070'),('5B59','4379'),('5B5A','7058'),('5B5B','5635'),('5B5C','5546'),('5B5D','4802'),('5B5F','3547'),('5B62','7063'),('5B63','2830'),('5B64','2534'),('5B65','7059'),('5B66','4907'),('5B69','2602'),('5B6A','3447'),('5B6C','5611'),('5B70','4275'),('5B71','6978'),('5B73','7060'),('5B75','2385'),('5B7A','4070'),('5B7D','3685'),('5B80','6918'),('5B81','3694'),('5B83','4392'),('5B84','6919'),('5B85','5312'),('5B87','5178'),('5B88','4256'),('5B89','1618'),('5B8B','4346'),('5B8C','4574'),('5B8F','2674'),('5B93','6921'),('5B95','6920'),('5B97','5558'),('5B98','2557'),('5B99','5470'),('5B9A','2208'),('5B9B','4580'),('5B9C','5043'),('5B9D','1706'),('5B9E','4221'),('5BA0','1972'),('5BA1','4183'),('5BA2','3145'),('5BA3','4891'),('5BA4','4250'),('5BA5','6922'),('5BA6','2734'),('5BAA','4760'),('5BAB','2512'),('5BB0','5255'),('5BB3','2606'),('5BB4','4971'),('5BB5','4792'),('5BB6','2850'),('5BB8','6923'),('5BB9','4061'),('5BBD','3177'),('5BBE','1786'),('5BBF','4362'),('5BC2','2837'),('5BC4','2836'),('5BC5','5090'),('5BC6','3560'),('5BC7','3160'),('5BCC','2427'),('5BD0','3534'),('5BD2','2614'),('5BD3','5202'),('5BDD','3962'),('5BDE','3615'),('5BDF','1876'),('5BE1','2549'),('5BE4','6927'),('5BE5','3340'),('5BE8','5315'),('5BEE','6928'),('5BF0','6930'),('5BF8','2071'),('5BF9','2252'),('5BFA','4334'),('5BFB','4916'),('5BFC','2128'),('5BFF','4257'),('5C01','2366'),('5C04','4168'),('5C06','2911'),('5C09','4630'),('5C0A','5580'),('5C0F','4801'),('5C11','4157'),('5C14','2291'),('5C15','7056'),('5C16','2866'),('5C18','1930'),('5C1A','4148'),('5C1C','7057'),('5C1D','1902'),('5C22','6244'),('5C24','5140'),('5C25','6245'),('5C27','5002'),('5C2C','6246'),('5C31','3045'),('5C34','6247'),('5C38','4212'),('5C39','5092'),('5C3A','1963'),('5C3B','6974'),('5C3C','3665'),('5C3D','3001'),('5C3E','4618'),('5C3F','3682'),('5C40','3054'),('5C41','3808'),('5C42','1867'),('5C45','3051'),('5C48','3992'),('5C49','4475'),('5C4A','2976'),('5C4B','4661'),('5C4E','4226'),('5C4F','3833'),('5C50','6976'),('5C51','4828'),('5C55','5325'),('5C59','6977'),('5C5E','4284'),('5C60','4532'),('5C61','3437'),('5C63','6979'),('5C65','3436'),('5C66','6980'),('5C6E','6988'),('5C6F','4545'),('5C71','4129'),('5C79','5057'),('5C7A','6508'),('5C7F','5176'),('5C81','4374'),('5C82','3881'),('5C88','6512'),('5C8C','6507'),('5C8D','6509'),('5C90','6510'),('5C91','6515'),('5C94','1877'),('5C96','6511'),('5C97','2458'),('5C98','6513'),('5C99','6514'),('5C9A','6516'),('5C9B','2126'),('5C9C','6517'),('5CA2','6519'),('5CA3','6524'),('5CA9','4950'),('5CAB','6522'),('5CAC','6521'),('5CAD','3375'),('5CB1','6523'),('5CB3','5232'),('5CB5','6518'),('5CB7','6526'),('5CB8','1622'),('5CBD','6520'),('5CBF','3189'),('5CC1','6525'),('5CC4','6527'),('5CCB','6530'),('5CD2','6528'),('5CD9','5437'),('5CE1','4731'),('5CE4','6529'),('5CE5','6531'),('5CE6','3445'),('5CE8','2275'),('5CEA','5188'),('5CED','3945'),('5CF0','2369'),('5CFB','3094'),('5D02','6532'),('5D03','6533'),('5D06','6539'),('5D07','1971'),('5D0E','3873'),('5D14','2062'),('5D16','4934'),('5D1B','6540'),('5D1E','6538'),('5D24','6537'),('5D26','6535'),('5D27','6534'),('5D29','1732'),('5D2D','5324'),('5D2E','6536'),('5D34','6543'),('5D3D','6544'),('5D3E','6542'),('5D47','7990'),('5D4A','6551'),('5D4B','6550'),('5D4C','3922'),('5D58','6541'),('5D5B','6546'),('5D5D','6548'),('5D69','6552'),('5D6B','6549'),('5D6C','6545'),('5D6F','6547'),('5D74','6553'),('5D82','6554'),('5D99','6555'),('5D9D','6556'),('5DB7','6558'),('5DC5','6559'),('5DCD','4601'),('5DDB','7161'),('5DDD','2008'),('5DDE','5461'),('5DE1','4918'),('5DE2','1918'),('5DE5','2504'),('5DE6','5583'),('5DE7','3941'),('5DE8','3062'),('5DE9','2514'),('5DEB','4655'),('5DEE','1878'),('5DEF','5947'),('5DF1','2826'),('5DF2','5049'),('5DF3','4340'),('5DF4','1645'),('5DF7','4779'),('5DFD','5767'),('5DFE','2977'),('5E01','1750'),('5E02','4248'),('5E03','1828'),('5E05','4307'),('5E06','2311'),('5E08','4206'),('5E0C','4703'),('5E0F','6488'),('5E10','5342'),('5E11','6491'),('5E14','6490'),('5E15','3733'),('5E16','4491'),('5E18','3317'),('5E19','6489'),('5E1A','5467'),('5E1B','1815'),('5E1C','5436'),('5E1D','2159'),('5E26','2088'),('5E27','5401'),('5E2D','4715'),('5E2E','1679'),('5E31','6492'),('5E37','6501'),('5E38','1903'),('5E3B','6493'),('5E3C','6494'),('5E3D','3517'),('5E42','3561'),('5E44','6502'),('5E45','2389'),('5E4C','2747'),('5E54','6503'),('5E55','3627'),('5E5B','6504'),('5E5E','6505'),('5E61','6506'),('5E62','2017'),('5E72','2441'),('5E73','3829'),('5E74','3674'),('5E76','1802'),('5E78','4850'),('5E7A','7159'),('5E7B','2735'),('5E7C','5155'),('5E7D','5136'),('5E7F','2567'),('5E80','6647'),('5E84','5515'),('5E86','3976'),('5E87','1751'),('5E8A','2018'),('5E8B','6649'),('5E8F','4882'),('5E90','3414'),('5E91','6648'),('5E93','3166'),('5E94','5106'),('5E95','2155'),('5E96','6650'),('5E97','2174'),('5E99','3577'),('5E9A','2493'),('5E9C','2414'),('5E9E','3751'),('5E9F','2347'),('5EA0','6652'),('5EA5','6651'),('5EA6','2240'),('5EA7','5589'),('5EAD','4505'),('5EB3','6656'),('5EB5','6654'),('5EB6','4292'),('5EB7','3121'),('5EB8','5125'),('5EB9','6653'),('5EBE','6655'),('5EC9','3314'),('5ECA','3240'),('5ED1','6659'),('5ED2','6658'),('5ED3','3210'),('5ED6','3346'),('5EDB','6660'),('5EE8','6661'),('5EEA','6662'),('5EF4','5940'),('5EF6','4951'),('5EF7','4502'),('5EFA','2908'),('5EFE','6235'),('5EFF','5605'),('5F00','3110'),('5F01','5945'),('5F02','5076'),('5F03','3890'),('5F04','3710'),('5F08','6236'),('5F0A','1755'),('5F0B','6314'),('5F0F','4229'),('5F11','6317'),('5F13','2513'),('5F15','5093'),('5F17','2405'),('5F18','2675'),('5F1B','1958'),('5F1F','2160'),('5F20','5337'),('5F25','3554'),('5F26','4750'),('5F27','2701'),('5F29','6983'),('5F2A','6982'),('5F2D','6984'),('5F2F','4568'),('5F31','4085'),('5F39','2115'),('5F3A','3931'),('5F3C','6986'),('5F40','7616'),('5F50','6970'),('5F52','2573'),('5F53','2117'),('5F55','3428'),('5F56','6972'),('5F57','6971'),('5F58','6973'),('5F5D','5045'),('5F61','6574'),('5F62','4846'),('5F64','4514'),('5F66','4969'),('5F69','1842'),('5F6A','1775'),('5F6C','1782'),('5F6D','3777'),('5F70','5335'),('5F71','5116'),('5F73','6560'),('5F77','6561'),('5F79','5059'),('5F7B','1925'),('5F7C','1743'),('5F80','4589'),('5F81','5387'),('5F82','6562'),('5F84','3022'),('5F85','2093'),('5F87','6563'),('5F88','2660'),('5F89','6564'),('5F8A','2718'),('5F8B','3441'),('5F8C','6565'),('5F90','4876'),('5F92','4529'),('5F95','6566'),('5F97','2135'),('5F98','3739'),('5F99','6567'),('5F9C','6568'),('5FA1','5189'),('5FA8','6569'),('5FAA','4913'),('5FAD','6570'),('5FAE','4602'),('5FB5','6571'),('5FB7','2134'),('5FBC','6572'),('5FBD','2753'),('5FC3','4836'),('5FC4','6664'),('5FC5','1756'),('5FC6','5068'),('5FC9','6665'),('5FCC','2841'),('5FCD','4044'),('5FCF','6667'),('5FD0','7694'),('5FD1','7693'),('5FD2','6315'),('5FD6','6666'),('5FD7','5430'),('5FD8','4592'),('5FD9','3506'),('5FDD','6735'),('5FE0','5450'),('5FE1','6671'),('5FE4','6672'),('5FE7','5139'),('5FEA','6676'),('5FEB','3176'),('5FED','6677'),('5FEE','6669'),('5FF1','1932'),('5FF5','3678'),('5FF8','6678'),('5FFB','4835'),('5FFD','2686'),('5FFE','6673'),('5FFF','2362'),('6000','2719'),('6001','4412'),('6002','4343'),('6003','6668'),('6004','6670'),('6005','6674'),('6006','6675'),('600A','6687'),('600D','6684'),('600E','5285'),('600F','6683'),('6012','3713'),('6014','5390'),('6015','3734'),('6016','1832'),('6019','6679'),('601B','6682'),('601C','3315'),('601D','4328'),('6020','2101'),('6021','6689'),('6025','2817'),('6026','6681'),('6027','4852'),('6028','5225'),('6029','6685'),('602A','2554'),('602B','6686'),('602F','3951'),('6035','6680'),('603B','5560'),('603C','7701'),('603F','6688'),('6041','7705'),('6042','6694'),('6043','4249'),('604B','3321'),('604D','2748'),('6050','3154'),('6052','2667'),('6055','4301'),('6059','7706'),('605A','7703'),('605D','7702'),('6062','2754'),('6063','7707'),('6064','4884'),('6067','7704'),('6068','2662'),('6069','2287'),('606A','6701'),('606B','2218'),('606C','4481'),('606D','2507'),('606F','4702'),('6070','3901'),('6073','3150'),('6076','2281'),('6078','6690'),('6079','6691'),('607A','6693'),('607B','6692'),('607C','3653'),('607D','6702'),('607F','5133'),('6083','6707'),('6084','3936'),('6089','4704'),('608C','6709'),('608D','2623'),('6092','6708'),('6094','2758'),('6096','6703'),('609A','6704'),('609B','6710'),('609D','6706'),('609F','4682'),('60A0','5138'),('60A3','2728'),('60A6','5235'),('60A8','3690'),('60AB','7708'),('60AC','4892'),('60AD','6705'),('60AF','3585'),('60B1','6713'),('60B2','1715'),('60B4','6718'),('60B8','2834'),('60BB','6712'),('60BC','2131'),('60C5','3973'),('60C6','6716'),('60CA','3010'),('60CB','4579'),('60D1','2783'),('60D5','4472'),('60D8','6715'),('60DA','6717'),('60DC','4707'),('60DD','6714'),('60DF','4609'),('60E0','2761'),('60E6','2175'),('60E7','3069'),('60E8','1850'),('60E9','1945'),('60EB','1725'),('60EC','6711'),('60ED','1849'),('60EE','2112'),('60EF','2563'),('60F0','2272'),('60F3','4775'),('60F4','6723'),('60F6','2744'),('60F9','4039'),('60FA','4842'),('6100','6724'),('6101','1978'),('6106','7709'),('6108','5190'),('6109','5168'),('610D','7710'),('610E','6725'),('610F','5066'),('6115','6721'),('611A','5162'),('611F','2448'),('6120','6719'),('6123','6722'),('6124','2363'),('6126','6720'),('6127','3202'),('612B','6726'),('613F','5224'),('6148','2040'),('614A','6727'),('614C','2737'),('614E','4187'),('6151','4169'),('6155','3629'),('615D','7711'),('6162','3493'),('6167','2759'),('6168','3114'),('6170','4631'),('6175','6728'),('6177','3122'),('618B','1779'),('618E','5287'),('6194','6730'),('619D','7713'),('61A7','6731'),('61A8','2609'),('61A9','7712'),('61AC','6729'),('61B7','6732'),('61BE','2622'),('61C2','2214'),('61C8','4824'),('61CA','1635'),('61CB','7714'),('61D1','7715'),('61D2','3233'),('61D4','6733'),('61E6','3719'),('61F5','6734'),('61FF','6018'),('6206','7716'),('6208','2474'),('620A','4676'),('620B','7407'),('620C','4871'),('620D','4289'),('620E','4054'),('620F','4723'),('6210','1941'),('6211','4650'),('6212','2968'),('6215','6762'),('6216','2782'),('6217','7408'),('6218','5329'),('621A','3861'),('621B','7409'),('621F','7410'),('6221','7412'),('6222','7411'),('6224','7414'),('6225','7413'),('622A','2956'),('622C','7415'),('622E','3430'),('6233','2033'),('6234','2087'),('6237','2707'),('623D','7670'),('623E','7669'),('623F','2331'),('6240','4389'),('6241','1766'),('6243','7671'),('6247','4140'),('6248','7672'),('6249','7673'),('624B','4254'),('624C','6248'),('624D','1837'),('624E','5290'),('6251','3843'),('6252','1639'),('6253','2082'),('6254','4051'),('6258','4548'),('625B','3124'),('6263','3159'),('6266','3904'),('6267','5420'),('6269','3209'),('626A','6249'),('626B','4108'),('626C','4979'),('626D','3704'),('626E','1671'),('626F','1922'),('6270','4037'),('6273','1666'),('6276','2386'),('6279','3790'),('627C','2283'),('627E','5350'),('627F','1948'),('6280','2828'),('6284','1913'),('6289','3081'),('628A','1649'),('6291','5054'),('6292','4267'),('6293','5505'),('6295','4522'),('6296','2222'),('6297','3125'),('6298','5359'),('629A','2407'),('629B','3755'),('629F','6250'),('62A0','3157'),('62A1','3453'),('62A2','3932'),('62A4','2704'),('62A5','1708'),('62A8','3774'),('62AB','3791'),('62AC','4407'),('62B1','1707'),('62B5','2154'),('62B9','3608'),('62BB','6251'),('62BC','4926'),('62BD','1973'),('62BF','3582'),('62C2','2387'),('62C4','5484'),('62C5','2103'),('62C6','1880'),('62C7','3620'),('62C8','3673'),('62C9','3213'),('62CA','6252'),('62CC','1672'),('62CD','3736'),('62CE','3364'),('62D0','2553'),('62D2','3060'),('62D3','4556'),('62D4','1646'),('62D6','4547'),('62D7','6254'),('62D8','3048'),('62D9','5530'),('62DA','6253'),('62DB','5348'),('62DC','1661'),('62DF','3666'),('62E2','3403'),('62E3','2880'),('62E5','5121'),('62E6','3225'),('62E7','3701'),('62E8','1806'),('62E9','5281'),('62EC','3208'),('62ED','4235'),('62EE','6255'),('62EF','5392'),('62F1','2516'),('62F3','4013'),('62F4','4309'),('62F6','6257'),('62F7','3129'),('62FC','3820'),('62FD','5507'),('62FE','4216'),('62FF','3635'),('6301','1954'),('6302','2550'),('6307','5424'),('6308','7492'),('6309','1620'),('630E','3170'),('6311','4484'),('6316','4558'),('631A','5431'),('631B','3446'),('631D','4646'),('631E','4402'),('631F','4814'),('6320','3651'),('6321','2118'),('6322','6256'),('6323','5385'),('6324','2823'),('6325','2751'),('6328','1604'),('632A','3718'),('632B','2076'),('632F','5381'),('6332','7493'),('6339','6258'),('633A','4506'),('633D','4576'),('6342','4670'),('6343','6260'),('6345','4517'),('6346','3206'),('6349','5529'),('634B','6259'),('634C','1638'),('634D','2620'),('634E','4151'),('634F','3683'),('6350','3072'),('6355','1822'),('635E','3244'),('635F','4380'),('6361','2881'),('6362','2727'),('6363','2123'),('6367','3785'),('6369','6270'),('636D','6267'),('636E','3061'),('6371','6263'),('6376','2023'),('6377','2961'),('637A','6264'),('637B','3677'),('6380','4738'),('6382','2164'),('6387','2262'),('6388','4258'),('6389','2184'),('638A','6269'),('638C','5338'),('638E','6265'),('638F','4445'),('6390','3894'),('6392','3737'),('6396','5020'),('6398','3082'),('63A0','3451'),('63A2','4429'),('63A3','1924'),('63A5','2951'),('63A7','3156'),('63A8','4538'),('63A9','4958'),('63AA','2075'),('63AC','6268'),('63AD','6261'),('63AE','6271'),('63B0','7494'),('63B3','3416'),('63B4','6266'),('63B7','5432'),('63B8','2107'),('63BA','1884'),('63BC','6272'),('63BE','6282'),('63C4','6277'),('63C6','6281'),('63C9','4064'),('63CD','5565'),('63CE','6279'),('63CF','3572'),('63D0','4465'),('63D2','1869'),('63D6','5030'),('63DE','6278'),('63E0','6275'),('63E1','4653'),('63E3','2007'),('63E9','3111'),('63EA','3030'),('63ED','2950'),('63F2','6273'),('63F4','5214'),('63F6','6262'),('63F8','6274'),('63FD','3231'),('63FF','6276'),('6400','1883'),('6401','2473'),('6402','3407'),('6405','2933'),('640B','6285'),('640C','6288'),('640F','1811'),('6410','2004'),('6413','2074'),('6414','4106'),('641B','6286'),('641C','4349'),('641E','2467'),('6420','6287'),('6421','6290'),('6426','6289'),('642A','4434'),('642C','1665'),('642D','2078'),('6434','6926'),('643A','4815'),('643D','1875'),('643F','7501'),('6441','6284'),('6444','4167'),('6445','6283'),('6446','1658'),('6447','5001'),('6448','1787'),('644A','4415'),('6452','6280'),('6454','4304'),('6458','5310'),('645E','6291'),('6467','2061'),('6469','3606'),('646D','6293'),('6478','3594'),('6479','3601'),('647A','6301'),('6482','3344'),('6484','6292'),('6485','3079'),('6487','3818'),('6491','1937'),('6492','4086'),('6495','4326'),('6496','6294'),('6499','6304'),('649E','5518'),('64A4','1923'),('64A9','3335'),('64AC','3943'),('64AD','1805'),('64AE','2073'),('64B0','5511'),('64B5','3676'),('64B7','6302'),('64B8','6303'),('64BA','6305'),('64BC','2619'),('64C0','6306'),('64C2','3262'),('64C5','4135'),('64CD','1857'),('64CE','3970'),('64D0','6307'),('64D2','3960'),('64D7','6308'),('64D8','7502'),('64DE','4351'),('64E2','6310'),('64E4','6309'),('64E6','1833'),('6500','3742'),('6509','6311'),('6512','5260'),('6518','4033'),('6525','6312'),('652B','3080'),('652E','6313'),('652F','5407'),('6534','7423'),('6535','7522'),('6536','4253'),('6538','5692'),('6539','2436'),('653B','2505'),('653E','2337'),('653F','5394'),('6545','2542'),('6548','4807'),('6549','8445'),('654C','2148'),('654F','3584'),('6551','3040'),('6555','7523'),('6556','1629'),('6559','2944'),('655B','3318'),('655D','1754'),('655E','1908'),('6562','2450'),('6563','4102'),('6566','2256'),('656B','7524'),('656C','3020'),('6570','4293'),('6572','3935'),('6574','5391'),('6577','2383'),('6587','4636'),('658B','5311'),('658C','1783'),('6590','7619'),('6591','1663'),('6593','7621'),('6597','2223'),('6599','3347'),('659B','8590'),('659C','4817'),('659F','5369'),('65A1','4651'),('65A4','2979'),('65A5','1966'),('65A7','2411'),('65A9','5322'),('65AB','7729'),('65AD','2247'),('65AF','4325'),('65B0','4834'),('65B9','2329'),('65BC','7622'),('65BD','4209'),('65C1','3752'),('65C3','7625'),('65C4','7624'),('65C5','3435'),('65C6','7623'),('65CB','4893'),('65CC','7626'),('65CE','7627'),('65CF','5569'),('65D2','7628'),('65D6','7629'),('65D7','3876'),('65E0','4662'),('65E2','2840'),('65E5','4053'),('65E6','2109'),('65E7','3041'),('65E8','5428'),('65E9','5271'),('65EC','4914'),('65ED','4881'),('65EE','7424'),('65EF','7425'),('65F0','7426'),('65F1','2621'),('65F6','4217'),('65F7','3185'),('65FA','4590'),('6600','7432'),('6602','1626'),('6603','7430'),('6606','3205'),('660A','7427'),('660C','1893'),('660E','3587'),('660F','2772'),('6613','5055'),('6614','4684'),('6615','7431'),('6619','7428'),('661D','7435'),('661F','4839'),('6620','5119'),('6625','2026'),('6627','3533'),('6628','5582'),('662D','5349'),('662F','4239'),('6631','7437'),('6634','7436'),('6635','7439'),('6636','7438'),('663C','5471'),('663E','4752'),('6641','7443'),('6643','2746'),('664B','2990'),('664C','4146'),('664F','7444'),('6652','4125'),('6653','4794'),('6654','7442'),('6655','5246'),('6656','7445'),('6657','7447'),('665A','4577'),('665F','7441'),('6661','7446'),('6664','4678'),('6666','2762'),('6668','1931'),('666E','3853'),('666F','3016'),('6670','4690'),('6674','3971'),('6676','3007'),('6677','7448'),('667A','5439'),('667E','3332'),('6682','5261'),('6684','7449'),('6687','4730'),('668C','7450'),('6691','4278'),('6696','3715'),('6697','1621'),('669D','7452'),('66A7','7451'),('66A8','8463'),('66AE','3626'),('66B4','1709'),('66B9','6963'),('66BE','7453'),('66D9','4279'),('66DB','7454'),('66DC','7455'),('66DD','3856'),('66E6','7456'),('66E9','7457'),('66F0','5227'),('66F2','3990'),('66F3','5023'),('66F4','2492'),('66F7','7434'),('66F9','1860'),('66FC','3492'),('66FE','5288'),('66FF','4470'),('6700','5578'),('6708','5234'),('6709','5148'),('670A','7535'),('670B','3783'),('670D','2394'),('6710','7552'),('6714','4323'),('6715','7562'),('6717','3242'),('671B','4591'),('671D','1915'),('671F','3858'),('6726','7592'),('6728','3630'),('672A','4620'),('672B','3609'),('672C','1730'),('672D','5293'),('672F','4285'),('6731','5476'),('6734','3851'),('6735','2268'),('673A','2790'),('673D','4864'),('6740','4117'),('6742','5251'),('6743','4008'),('6746','2443'),('6748','7230'),('6749','4128'),('674C','7227'),('674E','3278'),('674F','4851'),('6750','1836'),('6751','2069'),('6753','7228'),('6756','5340'),('675C','2237'),('675E','7229'),('675F','4288'),('6760','2460'),('6761','4485'),('6765','3220'),('6768','4978'),('6769','7231'),('676A','7234'),('676D','2628'),('676F','1713'),('6770','2960'),('6772','7429'),('6773','7235'),('6775','7238'),('6777','7243'),('677C','7244'),('677E','4341'),('677F','1669'),('6781','2811'),('6784','2525'),('6787','7233'),('6789','4587'),('678B','7242'),('6790','4686'),('6795','5377'),('6797','3354'),('6798','7236'),('679A','3522'),('679C','2591'),('679D','5406'),('679E','7240'),('67A2','4264'),('67A3','5270'),('67A5','7232'),('67A7','7237'),('67A8','7239'),('67AA','3925'),('67AB','2367'),('67AD','7241'),('67AF','3161'),('67B0','7250'),('67B3','7255'),('67B5','7253'),('67B6','2860'),('67B7','2847'),('67B8','7259'),('67C1','7262'),('67C3','7258'),('67C4','1790'),('67CF','1656'),('67D0','3619'),('67D1','2444'),('67D2','3866'),('67D3','4030'),('67D4','4065'),('67D8','7247'),('67D9','7252'),('67DA','7254'),('67DC','2581'),('67DD','7256'),('67DE','5585'),('67E0','3691'),('67E2','7260'),('67E5','1873'),('67E9','7249'),('67EC','2877'),('67EF','3134'),('67F0','7245'),('67F1','5489'),('67F3','3388'),('67F4','1881'),('67FD','7263'),('67FF','4233'),('6800','7257'),('6805','5304'),('6807','1774'),('6808','5327'),('6809','7246'),('680A','7248'),('680B','2216'),('680C','7251'),('680E','7261'),('680F','3224'),('6811','4287'),('6813','4308'),('6816','3860'),('6817','3285'),('681D','7273'),('6821','4803'),('6829','7282'),('682A','5474'),('6832','7264'),('6833','7265'),('6837','4989'),('6838','2643'),('6839','2489'),('683C','2481'),('683D','5252'),('683E','7279'),('6840','7278'),('6841','7276'),('6842','2580'),('6843','4450'),('6844','7270'),('6845','4606'),('6846','3182'),('6848','1624'),('6849','7281'),('684A','7280'),('684C','5532'),('684E','7268'),('6850','4509'),('6851','4103'),('6853','2724'),('6854','2959'),('6855','7274'),('6860','7266'),('6861','7267'),('6862','7269'),('6863','2121'),('6864','7271'),('6865','3937'),('6866','7275'),('6867','7277'),('6868','2916'),('6869','5514'),('686B','7288'),('6874','7285'),('6876','4516'),('6877','7286'),('6881','3326'),('6883','7272'),('6885','3523'),('6886','1680'),('688F','7284'),('6893','7287'),('6897','2503'),('68A2','4150'),('68A6','3546'),('68A7','4664'),('68A8','3270'),('68AD','4383'),('68AF','4461'),('68B0','4821'),('68B3','4265'),('68B5','7283'),('68C0','2876'),('68C2','7289'),('68C9','3562'),('68CB','3869'),('68CD','2587'),('68D2','1684'),('68D5','5556'),('68D8','2812'),('68DA','3779'),('68E0','4436'),('68E3','7306'),('68EE','4113'),('68F0','7302'),('68F1','3266'),('68F5','3135'),('68F9','7294'),('68FA','2555'),('68FC','7291'),('6901','7304'),('6905','5046'),('690B','7303'),('690D','5418'),('690E','5521'),('6910','7307'),('6912','2923'),('691F','7292'),('6920','7293'),('6924','7301'),('692D','4554'),('6930','5012'),('6934','7318'),('6939','7309'),('693D','2010'),('693F','2027'),('6942','7311'),('6954','4808'),('6957','7305'),('695A','1994'),('695D','7312'),('695E','3267'),('6960','7310'),('6963','7325'),('6966','7324'),('696B','7314'),('696E','7290'),('6971','7308'),('6977','3112'),('6978','7317'),('6979','7326'),('697C','3405'),('6980','7315'),('6982','2437'),('6984','7313'),('6986','5160'),('6987','7320'),('6988','7321'),('6989','7323'),('698D','7339'),('6994','3238'),('6995','7337'),('6998','7316'),('699B','7327'),('699C','1681'),('69A7','7328'),('69A8','5305'),('69AB','7330'),('69AD','7331'),('69B1','7333'),('69B4','3381'),('69B7','4022'),('69BB','7329'),('69C1','7334'),('69CA','7335'),('69CC','7319'),('69CE','7322'),('69D0','2717'),('69D4','7332'),('69DB','2887'),('69DF','7336'),('69E0','7338'),('69ED','7342'),('69F2','7346'),('69FD','1859'),('69FF','7340'),('6A0A','2314'),('6A17','7343'),('6A18','7344'),('6A1F','5333'),('6A21','3603'),('6A28','7356'),('6A2A','2665'),('6A2F','7341'),('6A31','5103'),('6A35','7352'),('6A3D','7355'),('6A3E','7348'),('6A44','7347'),('6A47','3933'),('6A50','7350'),('6A58','7357'),('6A59','1940'),('6A5B','7351'),('6A61','4780'),('6A65','7345'),('6A71','1987'),('6A79','7354'),('6A7C','7358'),('6A80','4420'),('6A84','4713'),('6A8E','7353'),('6A90','7360'),('6A91','7359'),('6A97','7362'),('6AA0','7349'),('6AA9','7361'),('6AAB','7363'),('6AAC','3542'),('6B20','3923'),('6B21','2046'),('6B22','2722'),('6B23','4832'),('6B24','7603'),('6B27','3723'),('6B32','5191'),('6B37','7604'),('6B39','7605'),('6B3A','3859'),('6B3E','3178'),('6B43','7606'),('6B46','7607'),('6B47','4810'),('6B49','3924'),('6B4C','2472'),('6B59','7608'),('6B62','5425'),('6B63','5393'),('6B64','2043'),('6B65','1829'),('6B66','4668'),('6B67','3871'),('6B6A','4565'),('6B79','2085'),('6B7B','4332'),('6B7C','2863'),('6B81','7366'),('6B82','7367'),('6B83','4974'),('6B84','7369'),('6B86','2089'),('6B87','7368'),('6B89','4919'),('6B8A','4266'),('6B8B','1848'),('6B8D','7372'),('6B92','7370'),('6B93','7371'),('6B96','5419'),('6B9A','7373'),('6B9B','7374'),('6BA1','7375'),('6BAA','7376'),('6BB3','7615'),('6BB4','3725'),('6BB5','2246'),('6BB7','5083'),('6BBF','2178'),('6BC1','2757'),('6BC2','7617'),('6BC5','5067'),('6BCB','4667'),('6BCD','3624'),('6BCF','3531'),('6BD2','2230'),('6BD3','5625'),('6BD4','1740'),('6BD5','1747'),('6BD6','1749'),('6BD7','3794'),('6BD9','1748'),('6BDB','3511'),('6BE1','5317'),('6BEA','7504'),('6BEB','2633'),('6BEF','4426'),('6BF3','7505'),('6BF5','7507'),('6BF9','7508'),('6BFD','7506'),('6C05','7509'),('6C06','7511'),('6C07','7510'),('6C0D','7512'),('6C0F','4247'),('6C10','5621'),('6C11','3581'),('6C13','3505'),('6C14','3888'),('6C15','7513'),('6C16','3642'),('6C18','7514'),('6C19','7515'),('6C1A','7516'),('6C1B','2353'),('6C1F','2390'),('6C21','7517'),('6C22','3966'),('6C24','7519'),('6C26','2604'),('6C27','4985'),('6C28','1617'),('6C29','7518'),('6C2A','7520'),('6C2E','2110'),('6C2F','3440'),('6C30','3972'),('6C32','7521'),('6C34','4314'),('6C35','6763'),('6C38','5132'),('6C3D','5759'),('6C40','4501'),('6C41','5413'),('6C42','3983'),('6C46','5764'),('6C47','2767'),('6C49','2626'),('6C4A','6766'),('6C50','4711'),('6C54','6764'),('6C55','4139'),('6C57','2625'),('6C5B','4920'),('6C5C','6765'),('6C5D','4074'),('6C5E','2515'),('6C5F','2913'),('6C60','1956'),('6C61','4659'),('6C64','4432'),('6C68','6772'),('6C69','6773'),('6C6A','4584'),('6C70','4413'),('6C72','2819'),('6C74','6774'),('6C76','6775'),('6C79','4858'),('6C7D','3891'),('6C7E','2358'),('6C81','3963'),('6C82','5042'),('6C83','4654'),('6C85','6768'),('6C86','6776'),('6C88','4182'),('6C89','1933'),('6C8C','6771'),('6C8F','3867'),('6C90','6769'),('6C93','7719'),('6C94','6770'),('6C99','4119'),('6C9B','3770'),('6C9F','2521'),('6CA1','3527'),('6CA3','6767'),('6CA4','3729'),('6CA5','3304'),('6CA6','3457'),('6CA7','1855'),('6CA9','6777'),('6CAA','2706'),('6CAB','3613'),('6CAD','6780'),('6CAE','3058'),('6CB1','6791'),('6CB2','6785'),('6CB3','2651'),('6CB8','2348'),('6CB9','5145'),('6CBB','5446'),('6CBC','5351'),('6CBD','2533'),('6CBE','5320'),('6CBF','4956'),('6CC4','4825'),('6CC5','3986'),('6CC9','4010'),('6CCA','1820'),('6CCC','3558'),('6CD0','6778'),('6CD3','6792'),('6CD4','6779'),('6CD5','2308'),('6CD6','6787'),('6CD7','6784'),('6CDB','2326'),('6CDE','3702'),('6CE0','6786'),('6CE1','3761'),('6CE2','1808'),('6CE3','3892'),('6CE5','3664'),('6CE8','5502'),('6CEA','3265'),('6CEB','6789'),('6CEE','6790'),('6CEF','6793'),('6CF0','4409'),('6CF1','6783'),('6CF3','5130'),('6CF5','1735'),('6CF6','7720'),('6CF7','6781'),('6CF8','6782'),('6CFA','6788'),('6CFB','4826'),('6CFC','3835'),('6CFD','5283'),('6CFE','6794'),('6D01','2964'),('6D04','6807'),('6D07','6806'),('6D0B','4983'),('6D0C','6803'),('6D0E','6809'),('6D12','4087'),('6D17','4720'),('6D19','6808'),('6D1A','6814'),('6D1B','3469'),('6D1E','2220'),('6D25','2982'),('6D27','6802'),('6D2A','2673'),('6D2B','6810'),('6D2E','6812'),('6D31','2293'),('6D32','5462'),('6D33','6818'),('6D35','6813'),('6D39','6801'),('6D3B','2778'),('6D3C','4561'),('6D3D','3902'),('6D3E','3741'),('6D41','3387'),('6D43','6804'),('6D45','3919'),('6D46','2912'),('6D47','2929'),('6D48','6805'),('6D4A','5539'),('6D4B','1866'),('6D4D','6811'),('6D4E','2835'),('6D4F','6815'),('6D51','2775'),('6D52','6816'),('6D53','3708'),('6D54','6817'),('6D59','5367'),('6D5A','3103'),('6D5C','6826'),('6D5E','6823'),('6D60','6827'),('6D63','6829'),('6D66','3854'),('6D69','2638'),('6D6A','3243'),('6D6E','2401'),('6D6F','6820'),('6D74','5201'),('6D77','2603'),('6D78','2994'),('6D7C','6828'),('6D82','4531'),('6D85','3689'),('6D88','4791'),('6D89','4170'),('6D8C','5131'),('6D8E','4749'),('6D91','6819'),('6D93','6824'),('6D94','6825'),('6D95','4473'),('6D9B','4446'),('6D9D','3252'),('6D9E','6821'),('6D9F','3316'),('6DA0','6822'),('6DA1','4648'),('6DA3','2733'),('6DA4','2151'),('6DA6','4083'),('6DA7','2907'),('6DA8','5339'),('6DA9','4112'),('6DAA','2402'),('6DAB','6842'),('6DAE','6844'),('6DAF','4936'),('6DB2','5026'),('6DB5','2613'),('6DB8','2652'),('6DBF','6835'),('6DC0','2177'),('6DC4','5545'),('6DC5','6832'),('6DC6','4793'),('6DC7','6831'),('6DCB','3360'),('6DCC','4442'),('6DD1','4271'),('6DD6','3655'),('6DD8','4452'),('6DD9','6840'),('6DDD','6839'),('6DDE','6833'),('6DE0','6836'),('6DE1','2113'),('6DE4','5157'),('6DE6','6838'),('6DEB','5089'),('6DEC','2067'),('6DEE','2720'),('6DF1','4178'),('6DF3','2030'),('6DF7','2776'),('6DF9','4945'),('6DFB','4477'),('6DFC','7721'),('6E05','3969'),('6E0A','5208'),('6E0C','6843'),('6E0D','5553'),('6E0E','6834'),('6E10','2905'),('6E11','6837'),('6E14','5170'),('6E16','6841'),('6E17','4188'),('6E1A','6830'),('6E1D','5169'),('6E20','3994'),('6E21','2241'),('6E23','5292'),('6E24','1819'),('6E25','6855'),('6E29','4634'),('6E2B','6845'),('6E2D','4628'),('6E2F','2459'),('6E32','6854'),('6E34','3142'),('6E38','5146'),('6E3A','3576'),('6E43','3740'),('6E44','6856'),('6E4D','4536'),('6E4E','6847'),('6E53','6852'),('6E54','6853'),('6E56','2694'),('6E58','4770'),('6E5B','5331'),('6E5F','6850'),('6E6B','6848'),('6E6E','6846'),('6E7E','4569'),('6E7F','4210'),('6E83','3203'),('6E85','2906'),('6E86','6851'),('6E89','2440'),('6E8F','6871'),('6E90','5220'),('6E98','6859'),('6E9C','3379'),('6E9F','6873'),('6EA2','5071'),('6EA5','6863'),('6EA7','6864'),('6EAA','4710'),('6EAF','4361'),('6EB1','6858'),('6EB2','6849'),('6EB4','6869'),('6EB6','4060'),('6EB7','6867'),('6EBA','3671'),('6EBB','6866'),('6EBD','6865'),('6EC1','1992'),('6EC2','6872'),('6EC7','2165'),('6ECB','5544'),('6ECF','6870'),('6ED1','2712'),('6ED3','5550'),('6ED4','4447'),('6ED5','7588'),('6ED7','6868'),('6EDA','2586'),('6EDE','5445'),('6EDF','6857'),('6EE0','6860'),('6EE1','3490'),('6EE2','6862'),('6EE4','3443'),('6EE5','3236'),('6EE6','3448'),('6EE8','1785'),('6EE9','4418'),('6EF4','2146'),('6EF9','6879'),('6F02','3815'),('6F06','3865'),('6F09','6885'),('6F0F','3409'),('6F13','3276'),('6F14','4961'),('6F15','6878'),('6F20','3614'),('6F24','6877'),('6F29','6886'),('6F2A','6884'),('6F2B','3494'),('6F2D','6861'),('6F2F','6880'),('6F31','4294'),('6F33','5336'),('6F36','6881'),('6F3E','4990'),('6F46','6875'),('6F47','6876'),('6F4B','6882'),('6F4D','4611'),('6F58','3743'),('6F5C','3917'),('6F5E','3426'),('6F62','6874'),('6F66','3342'),('6F6D','4422'),('6F6E','1917'),('6F72','6891'),('6F74','6883'),('6F78','6890'),('6F7A','6893'),('6F7C','6892'),('6F84','1946'),('6F88','1926'),('6F89','6887'),('6F8C','6889'),('6F8D','6888'),('6F8E','3776'),('6F9C','3229'),('6FA1','5272'),('6FA7','6902'),('6FB3','1636'),('6FB6','6904'),('6FB9','6903'),('6FC0','2804'),('6FC2','6905'),('6FC9','6901'),('6FD1','6894'),('6FD2','1784'),('6FDE','6908'),('6FE0','6909'),('6FE1','6906'),('6FEE','6907'),('6FEF','6910'),('7011','3857'),('701A','6911'),('701B','6913'),('7023','6912'),('7035','6915'),('7039','6914'),('704C','2564'),('704F','6916'),('705E','6917'),('706B','2780'),('706C','7665'),('706D','3580'),('706F','2138'),('7070','2750'),('7075','3373'),('7076','5278'),('7078','3036'),('707C','5538'),('707E','5254'),('707F','1851'),('7080','7630'),('7085','7433'),('7089','3415'),('708A','2022'),('708E','4955'),('7092','1920'),('7094','4018'),('7095','3127'),('7096','7632'),('7099','5443'),('709C','7631'),('709D','7633'),('70AB','7637'),('70AC','3070'),('70AD','4431'),('70AE','3758'),('70AF','3028'),('70B1','7638'),('70B3','1794'),('70B7','7636'),('70B8','5308'),('70B9','2167'),('70BB','7634'),('70BC','3322'),('70BD','1967'),('70C0','7635'),('70C1','4324'),('70C2','3235'),('70C3','4494'),('70C8','3350'),('70CA','7640'),('70D8','2670'),('70D9','3251'),('70DB','5482'),('70DF','4944'),('70E4','3130'),('70E6','2319'),('70E7','4153'),('70E8','7639'),('70E9','2766'),('70EB','4444'),('70EC','2993'),('70ED','4040'),('70EF','4709'),('70F7','4573'),('70F9','3775'),('70FD','2373'),('7109','4941'),('710A','2624'),('7110','7641'),('7113','7642'),('7115','2732'),('7116','7643'),('7118','7666'),('7119','1726'),('711A','2357'),('7126','2925'),('712F','7644'),('7130','4970'),('7131','7645'),('7136','4027'),('7145','7649'),('714A','7651'),('714C','2745'),('714E','2869'),('715C','7647'),('715E','4123'),('7164','3526'),('7166','7667'),('7167','5353'),('7168','7648'),('716E','5483'),('7172','7650'),('7173','7646'),('7178','7652'),('717A','7653'),('717D','4131'),('7184','4708'),('718A','4860'),('718F','4912'),('7194','4059'),('7198','7654'),('7199','4685'),('719F','4276'),('71A0','7658'),('71A8','7657'),('71AC','1630'),('71B3','7655'),('71B5','7656'),('71B9','7668'),('71C3','4028'),('71CE','3339'),('71D4','7660'),('71D5','4964'),('71E0','7659'),('71E5','5279'),('71E7','7661'),('71EE','5938'),('71F9','7662'),('7206','1712'),('721D','7663'),('7228','7664'),('722A','5506'),('722C','3732'),('7230','7528'),('7231','1614'),('7235','3084'),('7236','2424'),('7237','5015'),('7238','1654'),('7239','2189'),('723B','5619'),('723D','4312'),('723F','6761'),('7247','3812'),('7248','1670'),('724C','3738'),('724D','7525'),('7252','7526'),('7256','7527'),('7259','4932'),('725B','3703'),('725D','7482'),('725F','3618'),('7261','3621'),('7262','3246'),('7266','7483'),('7267','3633'),('7269','4679'),('726E','7480'),('726F','7484'),('7272','4192'),('7275','3903'),('7279','4456'),('727A','4694'),('727E','7485'),('727F','7486'),('7280','4712'),('7281','3271'),('7284','7487'),('728A','2231'),('728B','7488'),('728D','7489'),('728F','7490'),('7292','7491'),('729F','7481'),('72AC','4014'),('72AD','6575'),('72AF','2324'),('72B0','6576'),('72B4','6577'),('72B6','5520'),('72B7','6578'),('72B8','6579'),('72B9','5144'),('72C1','6581'),('72C2','3181'),('72C3','6580'),('72C4','2150'),('72C8','1723'),('72CD','6583'),('72CE','6582'),('72D0','2692'),('72D2','6584'),('72D7','2523'),('72D9','3049'),('72DE','3692'),('72E0','2661'),('72E1','2938'),('72E8','6585'),('72E9','6587'),('72EC','2232'),('72ED','4733'),('72EE','4208'),('72EF','6586'),('72F0','5388'),('72F1','5192'),('72F2','6588'),('72F3','6592'),('72F4','6589'),('72F7','6590'),('72F8','3274'),('72FA','6594'),('72FB','6601'),('72FC','3239'),('7301','6591'),('7303','6593'),('730A','6605'),('730E','3352'),('7313','6603'),('7315','6608'),('7316','1894'),('7317','6602'),('731B','3545'),('731C','1834'),('731D','6607'),('731E','6606'),('7321','6604'),('7322','6609'),('7325','6611'),('7329','4841'),('732A','5477'),('732B','3508'),('732C','6612'),('732E','4755'),('7331','6614'),('7334','2679'),('7337','7364'),('7338','6613'),('7339','6610'),('733E','2711'),('733F','5219'),('734D','6616'),('7350','6615'),('7352','7365'),('7357','6617'),('7360','6618'),('736C','6619'),('736D','4401'),('736F','6620'),('737E','6621'),('7384','4894'),('7387','3442'),('7389','5181'),('738B','4585'),('738E','7164'),('7391','7165'),('7396','3033'),('739B','3474'),('739F','7168'),('73A2','7167'),('73A9','4570'),('73AB','3521'),('73AE','7166'),('73AF','2723'),('73B0','4754'),('73B2','3365'),('73B3','7173'),('73B7','7172'),('73BA','7184'),('73BB','1803'),('73C0','7174'),('73C2','7170'),('73C8','7176'),('73C9','7175'),('73CA','4126'),('73CD','5368'),('73CF','7169'),('73D0','2309'),('73D1','7171'),('73D9','7178'),('73DE','7183'),('73E0','5473'),('73E5','7177'),('73E7','7182'),('73E9','7181'),('73ED','1664'),('73F2','7185'),('7403','3982'),('7405','3237'),('7406','3277'),('7409','3380'),('740A','7180'),('740F','7186'),('7410','4386'),('741A','7202'),('741B','7201'),('7422','5533'),('7425','7190'),('7426','7189'),('7428','7191'),('742A','7187'),('742C','7194'),('742E','7193'),('7430','7192'),('7433','3353'),('7434','3957'),('7435','3793'),('7436','3735'),('743C','3977'),('7441','7203'),('7455','7206'),('7457','7205'),('7459','7207'),('745A','2687'),('745B','7188'),('745C','7204'),('745E','4080'),('745F','4110'),('746D','7209'),('7470','2569'),('7476','4994'),('7477','7208'),('747E','7210'),('7480','7213'),('7481','7214'),('7483','3307'),('7487','7215'),('748B','7216'),('748E','7212'),('7490','7220'),('749C','7211'),('749E','7217'),('74A7','7221'),('74A8','7218'),('74A9','7219'),('74BA','7223'),('74D2','7222'),('74DC','2547'),('74DE','8012'),('74E0','8013'),('74E2','3816'),('74E3','1674'),('74E4','4031'),('74E6','4563'),('74EE','4645'),('74EF','7417'),('74F4','7418'),('74F6','3831'),('74F7','2041'),('74FF','7419'),('7504','5371'),('750D','6189'),('750F','7420'),('7511','7421'),('7513','7422'),('7518','2442'),('7519','6316'),('751A','4185'),('751C','4480'),('751F','4190'),('7525','4191'),('7528','5135'),('7529','4306'),('752B','2406'),('752C','8014'),('752D','1734'),('752F','6924'),('7530','4479'),('7531','5141'),('7532','2855'),('7533','4174'),('7535','2171'),('7537','3648'),('7538','2173'),('753A','7814'),('753B','2713'),('753E','7162'),('7540','7815'),('7545','1909'),('7548','7818'),('754B','7817'),('754C','2971'),('754E','7816'),('754F','4623'),('7554','3747'),('7559','3384'),('755A','5946'),('755B','7819'),('755C','4883'),('7565','3452'),('7566','3872'),('756A','2312'),('7572','7820'),('7574','1975'),('7578','2791'),('7579','7821'),('757F','7160'),('7583','7822'),('7586','2914'),('758B','8166'),('758F','4272'),('7591','5041'),('7592','8058'),('7594','8059'),('7596','8060'),('7597','3338'),('7599','2477'),('759A','3046'),('759D','8062'),('759F','3717'),('75A0','8061'),('75A1','4981'),('75A3','8064'),('75A4','1644'),('75A5','2974'),('75AB','5063'),('75AC','8063'),('75AE','2015'),('75AF','2372'),('75B0','8070'),('75B1','8069'),('75B2','3803'),('75B3','8065'),('75B4','8066'),('75B5','2035'),('75B8','8067'),('75B9','5378'),('75BC','4459'),('75BD','3050'),('75BE','2818'),('75C2','8072'),('75C3','8071'),('75C4','8068'),('75C5','1801'),('75C7','5402'),('75C8','5124'),('75C9','3023'),('75CA','4012'),('75CD','8074'),('75D2','4987'),('75D4','5444'),('75D5','2659'),('75D6','8073'),('75D8','2227'),('75DB','4520'),('75DE','3806'),('75E2','3301'),('75E3','8075'),('75E4','8078'),('75E6','8077'),('75E7','8080'),('75E8','8076'),('75EA','2730'),('75EB','8079'),('75F0','4421'),('75F1','8082'),('75F4','1953'),('75F9','1752'),('75FC','8083'),('75FF','8084'),('7600','8086'),('7601','2065'),('7603','8081'),('7605','8087'),('760A','8090'),('760C','8088'),('7610','8085'),('7615','8093'),('7617','8089'),('7618','8092'),('7619','8094'),('761B','8101'),('761F','4633'),('7620','8104'),('7622','8103'),('7624','3386'),('7625','8091'),('7626','4261'),('7629','2081'),('762A','1781'),('762B','4417'),('762D','8106'),('7630','8107'),('7633','8112'),('7634','5346'),('7635','8109'),('7638','4019'),('763C','8102'),('763E','8111'),('763F','8108'),('7640','8105'),('7643','8110'),('764C','1609'),('764D','8113'),('7654','8115'),('7656','8117'),('765C','8116'),('765E','8114'),('7663','4902'),('766B','8118'),('766F','8119'),('7678','2579'),('767B','2139'),('767D','1655'),('767E','1657'),('7682','5277'),('7684','2136'),('7686','2952'),('7687','2742'),('7688','8007'),('768B','2462'),('768E','8008'),('7691','1608'),('7693','8009'),('7696','4578'),('7699','8010'),('76A4','8011'),('76AE','3804'),('76B1','5469'),('76B2','8168'),('76B4','8169'),('76BF','3583'),('76C2','5159'),('76C5','5449'),('76C6','3772'),('76C8','5115'),('76CA','5070'),('76CD','7833'),('76CE','1627'),('76CF','5321'),('76D0','4946'),('76D1','2864'),('76D2','2648'),('76D4','3188'),('76D6','2439'),('76D7','2133'),('76D8','3744'),('76DB','4202'),('76DF','3543'),('76E5','7834'),('76EE','3631'),('76EF','2202'),('76F1','7776'),('76F2','3504'),('76F4','5417'),('76F8','4764'),('76F9','7779'),('76FC','3746'),('76FE','2260'),('7701','4201'),('7704','7777'),('7707','7780'),('7708','7781'),('7709','3528'),('770B','3120'),('770D','7778'),('7719','7784'),('771A','7782'),('771F','5370'),('7720','3563'),('7722','7783'),('7726','7786'),('7728','5303'),('7729','4903'),('772D','7785'),('772F','3548'),('7735','7787'),('7736','3184'),('7737','3076'),('7738','7788'),('773A','4487'),('773C','4959'),('7740','5537'),('7741','5386'),('7743','7792'),('7747','7791'),('7750','7789'),('7751','7790'),('775A','7793'),('775B','3006'),('7761','4315'),('7762','7801'),('7763','2229'),('7765','7802'),('7766','3632'),('7768','7794'),('776B','2962'),('776C','1839'),('7779','2235'),('777D','7805'),('777E','5626'),('777F','7803'),('7780','7806'),('7784','3573'),('7785','1982'),('778C','7807'),('778D','7804'),('778E','4725'),('7791','7808'),('7792','3487'),('779F','7809'),('77A0','7810'),('77A2','6211'),('77A5','3819'),('77A7','3938'),('77A9','5485'),('77AA','2141'),('77AC','4318'),('77B0','7811'),('77B3','4511'),('77B5','7812'),('77BB','5316'),('77BD','7813'),('77BF','8636'),('77CD','5939'),('77D7','2003'),('77DB','3512'),('77DC','8170'),('77E2','4224'),('77E3','5051'),('77E5','5410'),('77E7','7982'),('77E9','3056'),('77EB','2935'),('77EC','7983'),('77ED','2244'),('77EE','1611'),('77F3','4215'),('77F6','7722'),('77F8','7723'),('77FD','4689'),('77FE','2315'),('77FF','3183'),('7800','7724'),('7801','3475'),('7802','4116'),('7809','7725'),('780C','3886'),('780D','3119'),('7811','7728'),('7812','3788'),('7814','4948'),('7816','5509'),('7817','7726'),('7818','7727'),('781A','4966'),('781C','7731'),('781D','7732'),('781F','7736'),('7823','7740'),('7825','7738'),('7826','7746'),('7827','5372'),('7829','7741'),('782C','7739'),('782D','7730'),('7830','3773'),('7834','3838'),('7837','4173'),('7838','5250'),('7839','7733'),('783A','7734'),('783B','7735'),('783C','7737'),('783E','3289'),('7840','2001'),('7845','2572'),('7847','7748'),('784C','7749'),('784E','7742'),('7850','7747'),('7852','4688'),('7855','4322'),('7856','7744'),('7857','7745'),('785D','4785'),('786A','7750'),('786B','3382'),('786C','5118'),('786D','7743'),('786E','4023'),('7877','2879'),('787C','3780'),('7887','7754'),('7889','2179'),('788C','3421'),('788D','1613'),('788E','4373'),('7891','1714'),('7893','7752'),('7897','4575'),('7898','2166'),('789A','7753'),('789B','7751'),('789C','7755'),('789F','2190'),('78A1','7756'),('78A3','7757'),('78A5','7760'),('78A7','1744'),('78B0','3786'),('78B1','2878'),('78B2','7758'),('78B3','4428'),('78B4','1874'),('78B9','7759'),('78BE','3675'),('78C1','2037'),('78C5','1685'),('78C9','7763'),('78CA','3258'),('78CB','2072'),('78D0','3745'),('78D4','7761'),('78D5','3136'),('78D9','7762'),('78E8','3605'),('78EC','7764'),('78F2','7765'),('78F4','7767'),('78F7','3355'),('78FA','2739'),('7901','2924'),('7905','7766'),('7913','7768'),('791E','7770'),('7924','7769'),('7934','7771'),('793A','4230'),('793B','7674'),('793C','3281'),('793E','4171'),('7940','7675'),('7941','3878'),('7946','7676'),('7948','3877'),('7949','7677'),('7953','7680'),('7956','5570'),('7957','7683'),('795A','7681'),('795B','7678'),('795C','7679'),('795D','5503'),('795E','4181'),('795F','4378'),('7960','7684'),('7962','7682'),('7965','4773'),('7967','7686'),('7968','3817'),('796D','2832'),('796F','7685'),('7977','2127'),('7978','2786'),('797A','7687'),('7980','5787'),('7981','2991'),('7984','3427'),('7985','7688'),('798A','7689'),('798F','2403'),('799A','7690'),('79A7','7691'),('79B3','7692'),('79B9','5177'),('79BA','5614'),('79BB','3275'),('79BD','3961'),('79BE','2644'),('79C0','4867'),('79C1','4329'),('79C3','4526'),('79C6','2449'),('79C9','1792'),('79CB','3979'),('79CD','5454'),('79D1','3138'),('79D2','3575'),('79D5','7985'),('79D8','3556'),('79DF','5566'),('79E3','7987'),('79E4','1951'),('79E6','3956'),('79E7','4977'),('79E9','5440'),('79EB','7988'),('79ED','7986'),('79EF','2793'),('79F0','1938'),('79F8','2953'),('79FB','5038'),('79FD','2764'),('7A00','4701'),('7A02','7992'),('7A03','7991'),('7A06','7989'),('7A0B','1944'),('7A0D','4152'),('7A0E','4316'),('7A14','7994'),('7A17','1662'),('7A1A','5441'),('7A1E','7993'),('7A20','1977'),('7A23','8653'),('7A33','4640'),('7A37','8002'),('7A39','8001'),('7A3B','2130'),('7A3C','2858'),('7A3D','2792'),('7A3F','2469'),('7A46','3634'),('7A51','8003'),('7A57','4375'),('7A70','8006'),('7A74','4908'),('7A76','3031'),('7A77','3978'),('7A78','8122'),('7A79','8123'),('7A7A','3153'),('7A7F','2009'),('7A80','8124'),('7A81','4527'),('7A83','3952'),('7A84','5313'),('7A86','8125'),('7A88','8126'),('7A8D','3947'),('7A91','5004'),('7A92','5447'),('7A95','8127'),('7A96','2949'),('7A97','2016'),('7A98','3029'),('7A9C','2060'),('7A9D','4649'),('7A9F','3163'),('7AA0','8129'),('7AA5','3190'),('7AA6','8128'),('7AA8','8131'),('7AAC','8130'),('7AAD','8132'),('7AB3','8133'),('7ABF','3394'),('7ACB','3302'),('7AD6','4290'),('7AD9','5330'),('7ADE','3026'),('7ADF','3025'),('7AE0','5334'),('7AE3','3102'),('7AE5','4515'),('7AE6','8121'),('7AED','2963'),('7AEF','2243'),('7AF9','5481'),('7AFA','8335'),('7AFD','8336'),('7AFF','2445'),('7B03','8338'),('7B04','8339'),('7B06','1642'),('7B08','8337'),('7B0A','8341'),('7B0B','4381'),('7B0F','8343'),('7B11','4806'),('7B14','1742'),('7B15','8340'),('7B19','8347'),('7B1B','2149'),('7B1E','8355'),('7B20','8350'),('7B24','8352'),('7B25','8351'),('7B26','2391'),('7B28','1731'),('7B2A','8346'),('7B2B','8342'),('7B2C','2158'),('7B2E','8348'),('7B31','8349'),('7B33','8353'),('7B38','8345'),('7B3A','2867'),('7B3C','3393'),('7B3E','8354'),('7B45','8358'),('7B47','8344'),('7B49','2140'),('7B4B','2978'),('7B4C','8360'),('7B4F','2304'),('7B50','3180'),('7B51','5494'),('7B52','4518'),('7B54','2080'),('7B56','1863'),('7B58','8356'),('7B5A','8357'),('7B5B','4124'),('7B5D','8361'),('7B60','8362'),('7B62','8365'),('7B6E','8363'),('7B71','8367'),('7B72','8366'),('7B75','8359'),('7B77','3174'),('7B79','1979'),('7B7B','8364'),('7B7E','3909'),('7B80','2882'),('7B85','8375'),('7B8D','2531'),('7B90','8368'),('7B94','1813'),('7B95','2794'),('7B97','4367'),('7B9C','8377'),('7B9D','8373'),('7BA1','2560'),('7BA2','8378'),('7BA6','8369'),('7BA7','8370'),('7BA8','8374'),('7BA9','3465'),('7BAA','8376'),('7BAB','8379'),('7BAC','8372'),('7BAD','2893'),('7BB1','4768'),('7BB4','8380'),('7BB8','8371'),('7BC1','8382'),('7BC6','5513'),('7BC7','3810'),('7BCC','8383'),('7BD1','8381'),('7BD3','3408'),('7BD9','2461'),('7BDA','8385'),('7BDD','8384'),('7BE1','2059'),('7BE5','8386'),('7BE6','8387'),('7BEA','8388'),('7BEE','3226'),('7BF1','3273'),('7BF7','3781'),('7BFC','8391'),('7BFE','8390'),('7C07','2056'),('7C0B','8394'),('7C0C','8389'),('7C0F','8392'),('7C16','8393'),('7C1F','8401'),('7C26','8403'),('7C27','2741'),('7C2A','8402'),('7C38','8404'),('7C3F','1830'),('7C40','8406'),('7C41','8405'),('7C4D','2814'),('7C73','3555'),('7C74','5765'),('7C7B','3264'),('7C7C','8444'),('7C7D','5549'),('7C89','2359'),('7C91','8446'),('7C92','3303'),('7C95','3841'),('7C97','2054'),('7C98','5319'),('7C9C','8448'),('7C9D','8447'),('7C9E','8449'),('7C9F','4358'),('7CA2','8450'),('7CA4','5233'),('7CA5','5464'),('7CAA','2364'),('7CAE','3324'),('7CB1','3327'),('7CB2','8451'),('7CB3','3012'),('7CB9','2066'),('7CBC','8452'),('7CBD','8453'),('7CBE','3011'),('7CC1','8454'),('7CC5','8459'),('7CC7','8455'),('7CC8','8458'),('7CCA','2693'),('7CCC','8456'),('7CCD','8457'),('7CD5','2466'),('7CD6','4439'),('7CD7','8460'),('7CD9','1858'),('7CDC','3551'),('7CDF','5267'),('7CE0','3123'),('7CE8','8461'),('7CEF','3720'),('7CF8','8473'),('7CFB','4721'),('7D0A','4641'),('7D20','4356'),('7D22','4387'),('7D27','2984'),('7D2B','5547'),('7D2F','3259'),('7D6E','4885'),('7D77','8474'),('7DA6','8475'),('7DAE','8476'),('7E3B','8767'),('7E41','2317'),('7E47','8477'),('7E82','5575'),('7E9B','8478'),('7E9F','7089'),('7EA0','3032'),('7EA1','7090'),('7EA2','2676'),('7EA3','7091'),('7EA4','4743'),('7EA5','7092'),('7EA6','5228'),('7EA7','2822'),('7EA8','7093'),('7EA9','7094'),('7EAA','2845'),('7EAB','4050'),('7EAC','4619'),('7EAD','7101'),('7EAF','2031'),('7EB0','7102'),('7EB1','4120'),('7EB2','2457'),('7EB3','3641'),('7EB5','5561'),('7EB6','3458'),('7EB7','2355'),('7EB8','5429'),('7EB9','4638'),('7EBA','2336'),('7EBD','3706'),('7EBE','7103'),('7EBF','4763'),('7EC0','7104'),('7EC1','7105'),('7EC2','7106'),('7EC3','3323'),('7EC4','5573'),('7EC5','4180'),('7EC6','4724'),('7EC7','5415'),('7EC8','5453'),('7EC9','7107'),('7ECA','1677'),('7ECB','7108'),('7ECC','7109'),('7ECD','4160'),('7ECE','5079'),('7ECF','3013'),('7ED0','7110'),('7ED1','1683'),('7ED2','4062'),('7ED3','2965'),('7ED4','7111'),('7ED5','4038'),('7ED7','7112'),('7ED8','2770'),('7ED9','2488'),('7EDA','4904'),('7EDB','7113'),('7EDC','3471'),('7EDD','3088'),('7EDE','2942'),('7EDF','4519'),('7EE0','7114'),('7EE1','7115'),('7EE2','3078'),('7EE3','4869'),('7EE5','4371'),('7EE6','4448'),('7EE7','2844'),('7EE8','7116'),('7EE9','2808'),('7EEA','4887'),('7EEB','7117'),('7EED','4888'),('7EEE','7118'),('7EEF','7119'),('7EF0','2034'),('7EF1','7120'),('7EF2','7121'),('7EF3','4194'),('7EF4','4612'),('7EF5','3564'),('7EF6','7123'),('7EF7','1733'),('7EF8','1981'),('7EFA','7124'),('7EFB','7125'),('7EFC','5559'),('7EFD','5332'),('7EFE','7126'),('7EFF','3444'),('7F00','5526'),('7F01','7127'),('7F02','7128'),('7F03','7129'),('7F04','2874'),('7F05','3569'),('7F06','3234'),('7F07','7130'),('7F08','7131'),('7F09','2809'),('7F0B','7132'),('7F0C','7133'),('7F0D','7122'),('7F0E','2248'),('7F0F','7134'),('7F11','7135'),('7F12','7136'),('7F13','2726'),('7F14','2162'),('7F15','3438'),('7F16','1764'),('7F17','7137'),('7F18','5221'),('7F19','7138'),('7F1A','2431'),('7F1B','7140'),('7F1C','7139'),('7F1D','2376'),('7F1F','7141'),('7F20','1888'),('7F21','7142'),('7F22','7143'),('7F23','7144'),('7F24','7145'),('7F25','7146'),('7F26','7147'),('7F27','7148'),('7F28','5107'),('7F29','4385'),('7F2A','7149'),('7F2B','7150'),('7F2C','7151'),('7F2D','7152'),('7F2E','4141'),('7F2F','7153'),('7F30','7154'),('7F31','7155'),('7F32','7156'),('7F33','7157'),('7F34','2941'),('7F35','7158'),('7F36','8330'),('7F38','2455'),('7F3A','4017'),('7F42','8331'),('7F44','8332'),('7F45','8333'),('7F50','2562'),('7F51','4588'),('7F54','5672'),('7F55','2617'),('7F57','3462'),('7F58','7823'),('7F5A','2303'),('7F5F','7825'),('7F61','7824'),('7F62','1653'),('7F68','7827'),('7F69','5354'),('7F6A','5579'),('7F6E','5435'),('7F71','7829'),('7F72','4280'),('7F74','7828'),('7F79','7830'),('7F7E','7832'),('7F81','7831'),('7F8A','4982'),('7F8C','3928'),('7F8E','3532'),('7F94','2465'),('7F9A','3371'),('7F9D','8438'),('7F9E','4863'),('7F9F','8439'),('7FA1','4759'),('7FA4','4026'),('7FA7','8440'),('7FAF','8441'),('7FB0','8442'),('7FB2','8443'),('7FB8','5790'),('7FB9','2494'),('7FBC','6981'),('7FBD','5180'),('7FBF','8464'),('7FC1','4644'),('7FC5','1965'),('7FCA','8120'),('7FCC','5078'),('7FCE','8465'),('7FD4','4772'),('7FD5','8466'),('7FD8','3944'),('7FDF','2152'),('7FE0','2068'),('7FE1','8468'),('7FE5','8467'),('7FE6','8469'),('7FE9','8470'),('7FEE','8471'),('7FF0','2618'),('7FF1','1631'),('7FF3','8472'),('7FFB','2313'),('7FFC','5077'),('8000','5011'),('8001','3247'),('8003','3128'),('8004','7503'),('8005','5363'),('8006','7440'),('800B','8183'),('800C','2288'),('800D','4303'),('8010','3645'),('8012','8171'),('8014','8172'),('8015','2491'),('8016','8173'),('8017','2636'),('8018','5237'),('8019','1650'),('801C','8174'),('8020','8175'),('8022','8176'),('8025','8177'),('8026','8178'),('8027','8179'),('8028','8181'),('8029','8180'),('802A','3753'),('8031','8182'),('8033','2290'),('8035','8184'),('8036','5014'),('8037','6239'),('8038','4342'),('803B','1960'),('803D','2102'),('803F','2502'),('8042','3684'),('8043','8185'),('8046','8186'),('804A','3336'),('804B','3391'),('804C','5416'),('804D','8187'),('8052','8188'),('8054','3310'),('8058','3824'),('805A','3059'),('8069','8189'),('806A','2047'),('8071','8190'),('807F','7718'),('8080','7717'),('8083','4364'),('8084','5062'),('8086','4333'),('8087','5356'),('8089','4066'),('808B','3263'),('808C','2801'),('8093','7533'),('8096','4804'),('8098','5466'),('809A','2239'),('809B','2456'),('809C','7532'),('809D','2446'),('809F','7531'),('80A0','1906'),('80A1','2541'),('80A2','5411'),('80A4','2384'),('80A5','2342'),('80A9','2871'),('80AA','2330'),('80AB','7538'),('80AD','7539'),('80AE','1625'),('80AF','3147'),('80B1','7537'),('80B2','5193'),('80B4','7540'),('80B7','7541'),('80BA','2346'),('80BC','7534'),('80BD','7536'),('80BE','4186'),('80BF','5455'),('80C0','5345'),('80C1','4818'),('80C2','7547'),('80C3','4624'),('80C4','7548'),('80C6','2108'),('80CC','1719'),('80CD','7550'),('80CE','4405'),('80D6','3754'),('80D7','7551'),('80D9','7549'),('80DA','3763'),('80DB','7546'),('80DC','4204'),('80DD','7553'),('80DE','1691'),('80E1','2690'),('80E4','5623'),('80E5','8167'),('80E7','7542'),('80E8','7543'),('80E9','7544'),('80EA','7545'),('80EB','7554'),('80EC','7032'),('80ED','7557'),('80EF','3172'),('80F0','5040'),('80F1','7555'),('80F2','7560'),('80F3','2476'),('80F4','7556'),('80F6','2926'),('80F8','4856'),('80FA','1623'),('80FC','7561'),('80FD','3660'),('8102','5412'),('8106','2064'),('8109','3486'),('810A','2825'),('810D','7558'),('810E','7559'),('810F','5264'),('8110','3874'),('8111','3652'),('8112','7563'),('8113','3707'),('8114','5785'),('8116','1817'),('8118','7568'),('811A','2937'),('811E','7566'),('812C','7567'),('812F','2412'),('8131','4549'),('8132','7569'),('8136','7565'),('8138','3319'),('813E','3802'),('8146','4483'),('8148','7570'),('814A','3216'),('814B','5024'),('814C','7571'),('8150','2415'),('8151','2413'),('8153','7572'),('8154','3927'),('8155','4583'),('8159','7574'),('815A','7575'),('8160','7577'),('8165','4840'),('8167','7582'),('8169','7578'),('816D','7581'),('816E','4089'),('8170','4992'),('8171','7576'),('8174','7573'),('8179','2425'),('817A','4757'),('817B','3669'),('817C','7579'),('817D','7580'),('817E','4458'),('817F','4540'),('8180','1682'),('8182','7586'),('8188','7585'),('818A','1818'),('818F','2464'),('8191','7587'),('8198','1776'),('819B','4437'),('819C','3604'),('819D','4705'),('81A3','7589'),('81A6','7602'),('81A8','3782'),('81AA','7590'),('81B3','4137'),('81BA','6663'),('81BB','7594'),('81C0','4546'),('81C1','7601'),('81C2','1759'),('81C3','5123'),('81C6','5060'),('81CA','7593'),('81CC','7591'),('81E3','1928'),('81E7','7416'),('81EA','5552'),('81EC','8411'),('81ED','1984'),('81F3','5433'),('81F4','5434'),('81FB','5373'),('81FC','3042'),('81FE','8407'),('8200','5008'),('8201','8408'),('8202','8409'),('8204','8410'),('8205','3043'),('8206','5163'),('820C','4164'),('820D','4165'),('8210','8334'),('8212','4270'),('8214','4482'),('821B','6622'),('821C','4320'),('821E','4672'),('821F','5459'),('8221','8413'),('8222','8414'),('8223','8415'),('8228','8418'),('822A','2629'),('822B','8419'),('822C','1667'),('822D','8416'),('822F','8417'),('8230','2902'),('8231','1853'),('8233','8422'),('8234','8423'),('8235','2270'),('8236','1816'),('8237','4747'),('8238','8420'),('8239','2012'),('823B','8421'),('823E','8424'),('8244','8425'),('8247','4507'),('8249','8426'),('824B','8427'),('824F','8428'),('8258','4350'),('825A','8429'),('825F','8430'),('8268','8431'),('826E','8462'),('826F','3328'),('8270','2872'),('8272','4111'),('8273','4962'),('8274','6985'),('8279','6019'),('827A','5053'),('827D','6020'),('827E','1612'),('827F','6021'),('8282','2958'),('8284','6025'),('8288','5634'),('828A','6023'),('828B','5183'),('828D','4154'),('828E','6026'),('828F','6022'),('8291','6027'),('8292','3502'),('8297','6028'),('8298','6037'),('8299','6029'),('829C','4663'),('829D','5405'),('829F','6047'),('82A1','6045'),('82A4','6050'),('82A5','2970'),('82A6','3411'),('82A8','6024'),('82A9','6043'),('82AA','6046'),('82AB','6030'),('82AC','2350'),('82AD','1637'),('82AE','6039'),('82AF','4830'),('82B0','6033'),('82B1','2708'),('82B3','2328'),('82B4','6044'),('82B7','6038'),('82B8','6031'),('82B9','3959'),('82BD','4931'),('82BE','6032'),('82C1','6042'),('82C4','6048'),('82C7','4613'),('82C8','6034'),('82CA','6035'),('82CB','6040'),('82CC','6041'),('82CD','1852'),('82CE','6049'),('82CF','4353'),('82D1','5223'),('82D2','6059'),('82D3','6063'),('82D4','4406'),('82D5','6070'),('82D7','3571'),('82D8','6060'),('82DB','3133'),('82DC','6057'),('82DE','1690'),('82DF','2522'),('82E0','6069'),('82E1','6051'),('82E3','6036'),('82E4','6054'),('82E5','4084'),('82E6','3164'),('82EB','4127'),('82EF','1729'),('82F1','5102'),('82F4','6058'),('82F7','6053'),('82F9','3827'),('82FB','6062'),('8301','5534'),('8302','3515'),('8303','2322'),('8304','3949'),('8305','3509'),('8306','6066'),('8307','6056'),('8308','6075'),('8309','6052'),('830C','6061'),('830E','3005'),('830F','6055'),('8311','6064'),('8314','6067'),('8315','6068'),('8317','6088'),('831A','6065'),('831B','6102'),('831C','6071'),('8327','2875'),('8328','2036'),('832B','3503'),('832C','1871'),('832D','6090'),('832F','6082'),('8331','6079'),('8333','6092'),('8334','6078'),('8335','5080'),('8336','1872'),('8338','4055'),('8339','4067'),('833A','6091'),('833C','6077'),('8340','6087'),('8343','6085'),('8346','3003'),('8347','6084'),('8349','1861'),('834F','6083'),('8350','2886'),('8351','6072'),('8352','2736'),('8354','3283'),('835A','2852'),('835B','6073'),('835C','6074'),('835E','6081'),('835F','6086'),('8360','6089'),('8361','2120'),('8363','4057'),('8364','2771'),('8365','6094'),('8366','6093'),('8367','5111'),('8368','6101'),('8369','6103'),('836A','6105'),('836B','5081'),('836C','6104'),('836D','6106'),('836E','6107'),('836F','5009'),('8377','2641'),('8378','6109'),('837B','6122'),('837C','6117'),('837D','6120'),('8385','6116'),('8386','3846'),('8389','3282'),('838E','4115'),('8392','6076'),('8393','6114'),('8398','6123'),('839B','6080'),('839C','6115'),('839E','6124'),('83A0','6112'),('83A8','6125'),('83A9','6119'),('83AA','6113'),('83AB','3610'),('83B0','6108'),('83B1','3219'),('83B2','3311'),('83B3','6110'),('83B4','6111'),('83B6','6118'),('83B7','2781'),('83B8','6121'),('83B9','5108'),('83BA','6126'),('83BC','6127'),('83BD','3507'),('83C0','6150'),('83C1','6128'),('83C5','6149'),('83C7','2529'),('83CA','3053'),('83CC','3090'),('83CF','2642'),('83D4','6142'),('83D6','6137'),('83D8','6131'),('83DC','1843'),('83DD','6135'),('83DF','6143'),('83E0','1804'),('83E1','6153'),('83E5','6130'),('83E9','3848'),('83EA','6148'),('83F0','6152'),('83F1','3366'),('83F2','2338'),('83F8','6146'),('83F9','6147'),('83FD','6136'),('8401','6129'),('8403','6145'),('8404','4449'),('8406','6141'),('840B','6134'),('840C','3540'),('840D','3828'),('840E','4614'),('840F','6144'),('8411','6140'),('8418','6133'),('841C','6138'),('841D','3460'),('8424','5109'),('8425','5110'),('8426','6151'),('8427','4784'),('8428','4088'),('8431','6170'),('8438','6139'),('843C','6164'),('843D','3468'),('8446','6165'),('8451','6155'),('8457','5488'),('8459','6157'),('845A','6156'),('845B','2480'),('845C','6154'),('8461','3847'),('8463','2213'),('8469','6166'),('846B','2689'),('846C','5265'),('846D','6171'),('8471','2048'),('8473','6158'),('8475','3191'),('8476','6167'),('8478','6163'),('847A','6161'),('8482','2157'),('8487','6159'),('8488','6160'),('8489','6162'),('848B','2915'),('848C','6168'),('848E','6169'),('8497','6185'),('8499','3541'),('849C','4366'),('84A1','6182'),('84AF','5665'),('84B2','3849'),('84B4','6184'),('84B8','5384'),('84B9','6183'),('84BA','6180'),('84BD','6176'),('84BF','6179'),('84C1','6172'),('84C4','4878'),('84C9','4056'),('84CA','6178'),('84CD','6173'),('84D0','6174'),('84D1','4382'),('84D3','6177'),('84D6','1745'),('84DD','3222'),('84DF','2827'),('84E0','6181'),('84E3','6187'),('84E5','6186'),('84E6','6175'),('84EC','3778'),('84F0','6191'),('84FC','6204'),('84FF','6203'),('850C','6188'),('8511','3579'),('8513','3491'),('8517','5365'),('851A','4621'),('851F','6193'),('8521','1844'),('852B','3672'),('852C','4263'),('8537','3930'),('8538','6190'),('8539','6192'),('853A','6194'),('853B','6202'),('853C','1610'),('853D','1746'),('8543','6212'),('8548','6206'),('8549','2922'),('854A','4079'),('8556','6201'),('8559','6205'),('855E','6209'),('8564','6208'),('8568','6207'),('8572','6213'),('8574','5244'),('8579','6219'),('857A','6210'),('857B','6214'),('857E','3257'),('8584','1701'),('8585','6222'),('8587','6217'),('858F','6218'),('859B','4906'),('859C','6221'),('85A4','6215'),('85A8','6216'),('85AA','4829'),('85AE','6220'),('85AF','4277'),('85B0','6225'),('85B7','6224'),('85B9','6223'),('85C1','6227'),('85C9','2969'),('85CF','1856'),('85D0','3574'),('85D3','6226'),('85D5','3726'),('85DC','6228'),('85E4','4457'),('85E9','2310'),('85FB','5269'),('85FF','6229'),('8605','6231'),('8611','3602'),('8616','6233'),('8627','6230'),('8629','6232'),('8638','5326'),('863C','6234'),('864D','8214'),('864E','2702'),('864F','3418'),('8650','3716'),('8651','3439'),('8654','8215'),('865A','4873'),('865E','5161'),('8662','7529'),('866B','1970'),('866C','8216'),('866E','8217'),('8671','4213'),('8679','2671'),('867A','8219'),('867B','8221'),('867C','8220'),('867D','4368'),('867E','4726'),('867F','8218'),('8680','4220'),('8681','5047'),('8682','3476'),('868A','4635'),('868B','8224'),('868C','1686'),('868D','8223'),('8693','8230'),('8695','1847'),('869C','4933'),('869D','8226'),('86A3','8228'),('86A4','5273'),('86A7','8227'),('86A8','8222'),('86A9','8231'),('86AA','8229'),('86AC','8225'),('86AF','8239'),('86B0','8236'),('86B1','8238'),('86B4','8242'),('86B5','8234'),('86B6','8232'),('86BA','8237'),('86C0','5491'),('86C4','8233'),('86C6','3989'),('86C7','4163'),('86C9','8240'),('86CA','2538'),('86CB','2116'),('86CE','8235'),('86CF','8241'),('86D0','8248'),('86D1','8254'),('86D4','2755'),('86D8','8253'),('86D9','4560'),('86DB','5475'),('86DE','8250'),('86DF','8252'),('86E4','2482'),('86E9','8243'),('86ED','8246'),('86EE','3489'),('86F0','5361'),('86F1','8244'),('86F2','8245'),('86F3','8247'),('86F4','8251'),('86F8','8257'),('86F9','5128'),('86FE','2274'),('8700','4281'),('8702','2368'),('8703','8255'),('8707','8256'),('8708','8258'),('8709','8261'),('870A','8259'),('870D','8260'),('8712','4949'),('8713','8249'),('8715','4541'),('8717','4647'),('8718','5409'),('871A','8267'),('871C','3559'),('871E','8264'),('8721','3215'),('8722','8276'),('8723','8262'),('8725','8265'),('8729','8272'),('872E','8266'),('8731','8271'),('8734','8270'),('8737','8273'),('873B','8263'),('873E','8268'),('873F','8274'),('8747','5112'),('8748','8269'),('8749','1885'),('874C','8282'),('874E','4811'),('8753','8285'),('8757','2740'),('8759','8289'),('8760','8280'),('8763','8286'),('8764','8288'),('8765','8290'),('876E','8283'),('8770','8281'),('8774','2691'),('8776','2191'),('877B','8279'),('877C','8287'),('877D','8277'),('877E','8278'),('8782','8275'),('8783','8306'),('8785','8303'),('8788','8302'),('878B','8284'),('878D','4058'),('8793','8291'),('8797','8305'),('879F','3588'),('87A8','8293'),('87AB','8307'),('87AC','8309'),('87AD','8304'),('87AF','8292'),('87B3','8311'),('87B5','8310'),('87BA','3461'),('87BD','8314'),('87C0','8316'),('87C6','8301'),('87CA','8317'),('87CB','8312'),('87D1','8315'),('87D2','8294'),('87D3','8313'),('87DB','8318'),('87E0','8320'),('87E5','8308'),('87EA','8319'),('87EE','8321'),('87F9','4823'),('87FE','8324'),('8803','5789'),('880A','8325'),('8813','8323'),('8815','4068'),('8816','8322'),('881B','8326'),('8821','8327'),('8822','2032'),('8832','7835'),('8839','8328'),('883C','8329'),('8840','4910'),('8844','8412'),('8845','4838'),('884C','4848'),('884D','4960'),('8854','4746'),('8857','2954'),('8859','4935'),('8861','2666'),('8862','6573'),('8863','5034'),('8864','8134'),('8865','1825'),('8868','1777'),('8869','8135'),('886B','4132'),('886C','1936'),('886E','5782'),('8870','4305'),('8872','8136'),('8877','5452'),('887D','8137'),('887E','8432'),('887F','8138'),('8881','5212'),('8882','8139'),('8884','1632'),('8885','8433'),('8888','8434'),('888B','2092'),('888D','3759'),('8892','4427'),('8896','4868'),('889C','4564'),('88A2','8140'),('88A4','5783'),('88AB','1727'),('88AD','4714'),('88B1','2404'),('88B7','8142'),('88BC','8143'),('88C1','1835'),('88C2','3349'),('88C5','5516'),('88C6','8141'),('88C9','8144'),('88CE','8146'),('88D2','5786'),('88D4','5065'),('88D5','5203'),('88D8','8435'),('88D9','4025'),('88DF','8436'),('88E2','8145'),('88E3','8147'),('88E4','3167'),('88E5','8148'),('88E8','8152'),('88F0','8154'),('88F1','8149'),('88F3','4149'),('88F4','3765'),('88F8','3467'),('88F9','2592'),('88FC','8151'),('88FE','8153'),('8902','2551'),('890A','8159'),('8910','2654'),('8912','1693'),('8913','8157'),('8919','8156'),('891A','8150'),('891B','8158'),('8921','8155'),('8925','4076'),('892A','4542'),('892B','8161'),('8930','6929'),('8934','8160'),('8936','8162'),('8941','8163'),('8944','4769'),('895E','8437'),('895F','2983'),('8966','8164'),('897B','8165'),('897F','4687'),('8981','5010'),('8983','8191'),('8986','2418'),('89C1','2891'),('89C2','2559'),('89C4','2570'),('89C5','3557'),('89C6','4251'),('89C7','7472'),('89C8','3232'),('89C9','3085'),('89CA','7473'),('89CB','7474'),('89CC','7475'),('89CE','7476'),('89CF','7477'),('89D0','7478'),('89D1','7479'),('89D2','2939'),('89D6','8591'),('89DA','8593'),('89DC','8594'),('89DE','8592'),('89E3','2966'),('89E5','8601'),('89E6','2005'),('89EB','8602'),('89EF','8603'),('89F3','7618'),('8A00','4952'),('8A07','5774'),('8A3E','8604'),('8A48','7826'),('8A79','5318'),('8A89','5194'),('8A8A','4460'),('8A93','4236'),('8B07','6932'),('8B26','8605'),('8B66','3015'),('8B6C','3809'),('8BA0','5805'),('8BA1','2838'),('8BA2','2209'),('8BA3','2428'),('8BA4','4047'),('8BA5','2805'),('8BA6','5806'),('8BA7','5807'),('8BA8','4454'),('8BA9','4035'),('8BAA','5808'),('8BAB','3893'),('8BAD','4921'),('8BAE','5073'),('8BAF','4922'),('8BB0','2839'),('8BB2','2918'),('8BB3','2768'),('8BB4','5809'),('8BB5','5810'),('8BB6','4940'),('8BB7','5811'),('8BB8','4877'),('8BB9','2279'),('8BBA','3459'),('8BBC','4347'),('8BBD','2377'),('8BBE','4172'),('8BBF','2335'),('8BC0','3087'),('8BC1','5404'),('8BC2','5812'),('8BC3','5813'),('8BC4','3832'),('8BC5','5571'),('8BC6','4222'),('8BC8','5309'),('8BC9','4363'),('8BCA','5379'),('8BCB','5814'),('8BCC','5463'),('8BCD','2042'),('8BCE','5816'),('8BCF','5815'),('8BD1','5075'),('8BD2','5817'),('8BD3','5818'),('8BD4','5819'),('8BD5','4252'),('8BD6','5820'),('8BD7','4211'),('8BD8','5821'),('8BD9','5822'),('8BDA','1947'),('8BDB','5479'),('8BDC','5823'),('8BDD','2716'),('8BDE','2114'),('8BDF','5824'),('8BE0','5825'),('8BE1','2578'),('8BE2','4915'),('8BE3','5072'),('8BE4','5826'),('8BE5','2435'),('8BE6','4774'),('8BE7','1879'),('8BE8','5827'),('8BE9','5828'),('8BEB','2975'),('8BEC','4660'),('8BED','5179'),('8BEE','5829'),('8BEF','4683'),('8BF0','5830'),('8BF1','5153'),('8BF2','2769'),('8BF3','5831'),('8BF4','4321'),('8BF5','4348'),('8BF6','5832'),('8BF7','3975'),('8BF8','5478'),('8BF9','5833'),('8BFA','3721'),('8BFB','2233'),('8BFC','5834'),('8BFD','2344'),('8BFE','3146'),('8BFF','5835'),('8C00','5836'),('8C01','4313'),('8C02','5837'),('8C03','2187'),('8C04','5838'),('8C05','3334'),('8C06','5527'),('8C07','5839'),('8C08','4424'),('8C0A','5074'),('8C0B','3617'),('8C0C','5840'),('8C0D','2193'),('8C0E','2749'),('8C0F','5841'),('8C10','4819'),('8C11','5842'),('8C12','5843'),('8C13','4629'),('8C14','5844'),('8C15','5845'),('8C16','5846'),('8C17','1887'),('8C18','5849'),('8C19','5847'),('8C1A','4972'),('8C1B','5848'),('8C1C','3553'),('8C1D','5850'),('8C1F','5851'),('8C20','5852'),('8C21','5853'),('8C22','4827'),('8C23','5005'),('8C24','1689'),('8C25','5854'),('8C26','3911'),('8C27','5855'),('8C28','2987'),('8C29','3501'),('8C2A','5856'),('8C2B','5857'),('8C2C','3593'),('8C2D','4423'),('8C2E','5858'),('8C2F','5859'),('8C30','3230'),('8C31','3855'),('8C32','5860'),('8C33','5861'),('8C34','3920'),('8C35','5862'),('8C36','5863'),('8C37','2540'),('8C41','2777'),('8C46','2225'),('8C47','8488'),('8C49','8489'),('8C4C','4567'),('8C55','8525'),('8C5A','7564'),('8C61','4783'),('8C62','2731'),('8C6A','2632'),('8C6B','5205'),('8C73','6557'),('8C78','8584'),('8C79','1710'),('8C7A','1882'),('8C82','8585'),('8C85','8587'),('8C89','2649'),('8C8A','8586'),('8C8C','3518'),('8C94','8589'),('8C98','8588'),('8D1D','1720'),('8D1E','5374'),('8D1F','2426'),('8D21','2517'),('8D22','1838'),('8D23','5280'),('8D24','4745'),('8D25','1660'),('8D26','5343'),('8D27','2785'),('8D28','5442'),('8D29','2323'),('8D2A','4416'),('8D2B','3822'),('8D2C','1765'),('8D2D','2526'),('8D2E','5492'),('8D2F','2565'),('8D30','2301'),('8D31','2890'),('8D32','7458'),('8D33','7459'),('8D34','4489'),('8D35','2583'),('8D36','7460'),('8D37','2091'),('8D38','3519'),('8D39','2349'),('8D3A','2656'),('8D3B','7461'),('8D3C','5284'),('8D3D','7462'),('8D3E','2854'),('8D3F','2763'),('8D40','7463'),('8D41','3362'),('8D42','3424'),('8D43','5263'),('8D44','5542'),('8D45','7464'),('8D46','7465'),('8D47','7468'),('8D48','7466'),('8D49','7467'),('8D4A','4162'),('8D4B','2419'),('8D4C','2236'),('8D4D','7469'),('8D4E','4274'),('8D4F','4145'),('8D50','2045'),('8D53','6657'),('8D54','3766'),('8D55','7470'),('8D56','3221'),('8D58','5524'),('8D59','7471'),('8D5A','5512'),('8D5B','4092'),('8D5C','5651'),('8D5D','5645'),('8D5E','5262'),('8D60','5289'),('8D61','4136'),('8D62','5114'),('8D63','2451'),('8D64','1964'),('8D66','4166'),('8D67','8486'),('8D6B','2653'),('8D6D','8487'),('8D70','5563'),('8D73','8481'),('8D74','2416'),('8D75','5352'),('8D76','2447'),('8D77','3880'),('8D81','1935'),('8D84','8482'),('8D85','1912'),('8D8A','5229'),('8D8B','3987'),('8D91','8484'),('8D94','8483'),('8D9F','4443'),('8DA3','4004'),('8DB1','8485'),('8DB3','5567'),('8DB4','3731'),('8DB5','8532'),('8DB8','8527'),('8DBA','8535'),('8DBC','8534'),('8DBE','5426'),('8DBF','8533'),('8DC3','5230'),('8DC4','8536'),('8DC6','8544'),('8DCB','1647'),('8DCC','2188'),('8DCE','8541'),('8DCF','8542'),('8DD1','3760'),('8DD6','8537'),('8DD7','8538'),('8DDA','8539'),('8DDB','8543'),('8DDD','3064'),('8DDE','8540'),('8DDF','2490'),('8DE3','8548'),('8DE4','8551'),('8DE8','3171'),('8DEA','2582'),('8DEB','8528'),('8DEC','8545'),('8DEF','3423'),('8DF3','4488'),('8DF5','2889'),('8DF7','8546'),('8DF8','8547'),('8DF9','8549'),('8DFA','2269'),('8DFB','8550'),('8DFD','8553'),('8E05','8529'),('8E09','8552'),('8E0A','5127'),('8E0C','1976'),('8E0F','4404'),('8E14','8554'),('8E1D','8555'),('8E1E','3065'),('8E1F','8556'),('8E22','4463'),('8E23','8559'),('8E29','1840'),('8E2A','5557'),('8E2C','8557'),('8E2E','8558'),('8E2F','8560'),('8E31','8566'),('8E35','8564'),('8E39','8563'),('8E3A','8561'),('8E3D','8565'),('8E40','8562'),('8E41','8568'),('8E42','8569'),('8E44','4467'),('8E47','6931'),('8E48','2124'),('8E49','8567'),('8E4A','8572'),('8E4B','4403'),('8E51','8570'),('8E52','8571'),('8E59','8530'),('8E66','1736'),('8E69','8531'),('8E6C','2137'),('8E6D','1868'),('8E6F','8576'),('8E70','8573'),('8E72','2255'),('8E74','8577'),('8E76','8574'),('8E7C','8575'),('8E7F','2058'),('8E81','5274'),('8E85','8578'),('8E87','1989'),('8E8F','8579'),('8E90','8581'),('8E94','8580'),('8E9C','8582'),('8E9E','8583'),('8EAB','4177'),('8EAC','2510'),('8EAF','3991'),('8EB2','2267'),('8EBA','4441'),('8ECE','7406'),('8F66','1921'),('8F67','5294'),('8F68','2576'),('8F69','4889'),('8F6B','7377'),('8F6C','5510'),('8F6D','7378'),('8F6E','3454'),('8F6F','4077'),('8F70','2668'),('8F71','7379'),('8F72','7380'),('8F73','7381'),('8F74','5465'),('8F75','7382'),('8F76','7383'),('8F77','7385'),('8F78','7384'),('8F79','7386'),('8F7A','7387'),('8F7B','3965'),('8F7C','7388'),('8F7D','5256'),('8F7E','7389'),('8F7F','2946'),('8F81','7390'),('8F82','7391'),('8F83','2947'),('8F84','7392'),('8F85','2408'),('8F86','3330'),('8F87','7393'),('8F88','1718'),('8F89','2752'),('8F8A','2585'),('8F8B','7394'),('8F8D','7401'),('8F8E','7402'),('8F8F','7403'),('8F90','2388'),('8F91','2813'),('8F93','4268'),('8F94','6446'),('8F95','5215'),('8F96','4729'),('8F97','5323'),('8F98','7404'),('8F99','5362'),('8F9A','7405'),('8F9B','4833'),('8F9C','2528'),('8F9E','2039'),('8F9F','1757'),('8FA3','3217'),('8FA8','1770'),('8FA9','1771'),('8FAB','1772'),('8FB0','1929'),('8FB1','4072'),('8FB6','6933'),('8FB9','1763'),('8FBD','3341'),('8FBE','2079'),('8FC1','3908'),('8FC2','5156'),('8FC4','3889'),('8FC5','4924'),('8FC7','2593'),('8FC8','3485'),('8FCE','5113'),('8FD0','5243'),('8FD1','2992'),('8FD3','6934'),('8FD4','2321'),('8FD5','6935'),('8FD8','2725'),('8FD9','5366'),('8FDB','2988'),('8FDC','5222'),('8FDD','4605'),('8FDE','3312'),('8FDF','1957'),('8FE2','4486'),('8FE4','6938'),('8FE5','6936'),('8FE6','6940'),('8FE8','6942'),('8FE9','6939'),('8FEA','2147'),('8FEB','3840'),('8FED','2192'),('8FEE','6937'),('8FF0','4286'),('8FF3','6941'),('8FF7','3552'),('8FF8','1737'),('8FF9','2803'),('8FFD','5523'),('9000','4543'),('9001','4345'),('9002','4242'),('9003','4451'),('9004','6944'),('9005','6943'),('9006','3670'),('9009','4901'),('900A','4923'),('900B','6945'),('900D','6948'),('900F','4524'),('9010','5480'),('9011','6947'),('9012','2161'),('9014','4530'),('9016','6949'),('9017','2226'),('901A','4508'),('901B','2568'),('901D','4237'),('901E','1949'),('901F','4357'),('9020','5276'),('9021','6950'),('9022','2374'),('9026','6946'),('902D','6953'),('902E','2094'),('902F','6954'),('9035','6951'),('9036','6952'),('9038','5061'),('903B','3463'),('903C','1738'),('903E','5166'),('9041','2261'),('9042','4376'),('9044','6955'),('9047','5186'),('904D','1773'),('904F','2284'),('9050','6958'),('9051','6956'),('9052','6957'),('9053','2132'),('9057','5037'),('9058','6960'),('905B','6962'),('9062','6961'),('9063','3918'),('9065','5003'),('9068','6959'),('906D','5266'),('906E','5358'),('9074','6964'),('9075','5581'),('907D','6965'),('907F','1760'),('9080','4991'),('9082','6966'),('9083','6968'),('9088','6967'),('908B','6969'),('9091','5056'),('9093','2143'),('9095','7163'),('9097','5885'),('9099','5888'),('909B','5886'),('909D','5887'),('90A1','5890'),('90A2','4847'),('90A3','3639'),('90A6','1678'),('90AA','4816'),('90AC','5889'),('90AE','5142'),('90AF','2610'),('90B0','5902'),('90B1','3981'),('90B3','5892'),('90B4','5891'),('90B5','4159'),('90B6','5893'),('90B8','5901'),('90B9','5562'),('90BA','5894'),('90BB','3358'),('90BE','5905'),('90C1','5184'),('90C4','5907'),('90C5','5904'),('90C7','5908'),('90CA','2928'),('90CE','3241'),('90CF','5903'),('90D0','5906'),('90D1','5403'),('90D3','5909'),('90D7','5913'),('90DB','5914'),('90DC','5912'),('90DD','2634'),('90E1','3104'),('90E2','5911'),('90E6','5910'),('90E7','5239'),('90E8','1831'),('90EB','5915'),('90ED','2589'),('90EF','5916'),('90F4','1927'),('90F8','2106'),('90FD','2228'),('90FE','5917'),('9102','2285'),('9104','5918'),('9119','1741'),('911E','5920'),('9122','5919'),('9123','5921'),('912F','5923'),('9131','5922'),('9139','5924'),('9143','5925'),('9146','5926'),('9149','5147'),('914A','8490'),('914B','3985'),('914C','5535'),('914D','3768'),('914E','8492'),('914F','8493'),('9150','8491'),('9152','3038'),('9157','4879'),('915A','2351'),('915D','5245'),('915E','4410'),('9161','8502'),('9162','8501'),('9163','2608'),('9164','8494'),('9165','4354'),('9169','8504'),('916A','3250'),('916C','1974'),('916E','4510'),('916F','8505'),('9170','8503'),('9171','2920'),('9172','8508'),('9174','8509'),('9175','2945'),('9176','3524'),('9177','3165'),('9178','4365'),('9179','8510'),('917D','8506'),('917E','8507'),('917F','3680'),('9185','8512'),('9187','2028'),('9189','5577'),('918B','2055'),('918C','8511'),('918D','8514'),('9190','8513'),('9191','8515'),('9192','4849'),('919A','3549'),('919B','4009'),('91A2','8516'),('91A3','8517'),('91AA','8518'),('91AD','8519'),('91AE','8520'),('91AF','8521'),('91B4','8523'),('91B5','8522'),('91BA','8524'),('91C7','1841'),('91C9','5152'),('91CA','4245'),('91CC','3279'),('91CD','5456'),('91CE','5016'),('91CF','3331'),('91D1','2980'),('91DC','2410'),('9274','2888'),('928E','8638'),('92AE','8639'),('92C8','8640'),('933E','8641'),('936A','8642'),('938F','8644'),('93CA','8643'),('93D6','8773'),('943E','8645'),('946B','8646'),('9485','7836'),('9486','7837'),('9487','7838'),('9488','5375'),('9489','2204'),('948A','7840'),('948B','7839'),('948C','7841'),('948D','7842'),('948E','3905'),('948F','7843'),('9490','7844'),('9492','2316'),('9493','2186'),('9494','7845'),('9495','7847'),('9497','7846'),('9499','2438'),('949A','7848'),('949B','7849'),('949C','7850'),('949D','2259'),('949E','1914'),('949F','5451'),('94A0','3638'),('94A1','1721'),('94A2','2454'),('94A3','7851'),('94A4','7852'),('94A5','5231'),('94A6','3953'),('94A7','3091'),('94A8','4657'),('94A9','2519'),('94AA','7854'),('94AB','7853'),('94AC','7856'),('94AD','7855'),('94AE','3705'),('94AF','7857'),('94B0','7858'),('94B1','3914'),('94B2','7859'),('94B3','3915'),('94B4','7860'),('94B5','1807'),('94B6','7861'),('94B7','7862'),('94B8','7863'),('94B9','7864'),('94BA','7865'),('94BB','5574'),('94BC','7866'),('94BD','7867'),('94BE','2856'),('94BF','7868'),('94C0','5143'),('94C1','4490'),('94C2','1812'),('94C3','3369'),('94C4','7869'),('94C5','3906'),('94C6','3513'),('94C8','7870'),('94C9','7871'),('94CA','7872'),('94CB','7873'),('94CC','7874'),('94CD','7875'),('94CE','7876'),('94D0','7877'),('94D1','7878'),('94D2','7879'),('94D5','7880'),('94D6','7881'),('94D7','7882'),('94D8','7884'),('94D9','7883'),('94DB','7885'),('94DC','4513'),('94DD','3433'),('94DE','7886'),('94DF','7887'),('94E0','7888'),('94E1','5301'),('94E2','7889'),('94E3','4719'),('94E4','7890'),('94E5','7891'),('94E7','7892'),('94E8','7893'),('94E9','7901'),('94EA','7894'),('94EB','7902'),('94EC','2485'),('94ED','3590'),('94EE','7903'),('94EF','7904'),('94F0','2934'),('94F1','5031'),('94F2','1889'),('94F3','7905'),('94F4','7906'),('94F5','7907'),('94F6','5088'),('94F7','7908'),('94F8','5493'),('94F9','7909'),('94FA','3844'),('94FC','7910'),('94FD','7911'),('94FE','3320'),('94FF','7912'),('9500','4790'),('9501','4388'),('9502','7914'),('9503','7913'),('9504','1990'),('9505','2588'),('9506','7915'),('9507','7916'),('9508','4866'),('9509','7917'),('950A','7918'),('950B','2370'),('950C','4831'),('950D','7919'),('950E','7920'),('950F','7921'),('9510','4081'),('9511','4464'),('9512','7922'),('9513','7923'),('9514','7924'),('9515','7925'),('9516','7926'),('9517','5364'),('9518','7927'),('9519','2077'),('951A','3510'),('951B','7928'),('951D','7929'),('951E','7930'),('951F','7931'),('9521','4693'),('9522','7932'),('9523','3464'),('9524','2024'),('9525','5522'),('9526','2985'),('9528','4739'),('9529','7935'),('952A','7933'),('952B','7934'),('952C','7936'),('952D','2207'),('952E','2892'),('952F','3066'),('9530','3544'),('9531','7937'),('9532','7938'),('9534','7939'),('9535','7947'),('9536','7940'),('9537','7941'),('9538','7942'),('9539','3934'),('953A','7981'),('953B','2245'),('953C','7943'),('953E','7944'),('953F','7945'),('9540','2238'),('9541','3530'),('9542','7946'),('9544','7948'),('9545','7949'),('9546','7950'),('9547','5382'),('9549','7951'),('954A','3687'),('954C','7952'),('954D','3688'),('954E','7953'),('954F','7954'),('9550','2468'),('9551','1687'),('9552','7955'),('9553','7956'),('9554','7957'),('9556','7958'),('9557','7959'),('9558','7960'),('9559','7961'),('955B','7962'),('955C','3021'),('955D','7965'),('955E','7963'),('955F','7964'),('9561','7966'),('9562','7967'),('9563','3345'),('9564','7968'),('9565','7969'),('9566','7970'),('9567','7971'),('9568','7972'),('9569','7973'),('956A','7974'),('956B','7975'),('956C','7976'),('956D','3256'),('956F','7977'),('9570','3313'),('9571','7978'),('9572','7979'),('9573','7980'),('9576','4766'),('957F','1904'),('95E8','3537'),('95E9','6737'),('95EA','4133'),('95EB','6738'),('95ED','1753'),('95EE','4642'),('95EF','2019'),('95F0','4082'),('95F1','6739'),('95F2','4748'),('95F3','6740'),('95F4','2868'),('95F5','6741'),('95F6','6742'),('95F7','3538'),('95F8','5302'),('95F9','3654'),('95FA','2575'),('95FB','4637'),('95FC','6743'),('95FD','3586'),('95FE','6744'),('9600','2307'),('9601','2483'),('9602','2650'),('9603','6745'),('9604','6746'),('9605','5236'),('9606','6747'),('9608','6748'),('9609','4943'),('960A','6749'),('960B','6750'),('960C','6751'),('960D','6752'),('960E','4954'),('960F','6753'),('9610','1891'),('9611','3227'),('9612','6754'),('9614','3211'),('9615','6755'),('9616','6756'),('9617','6757'),('9619','6758'),('961A','6759'),('961C','2423'),('961D','5866'),('961F','2251'),('9621','5868'),('9622','5867'),('962A','5870'),('962E','4078'),('9631','5869'),('9632','2332'),('9633','4984'),('9634','5085'),('9635','5383'),('9636','2955'),('963B','5572'),('963C','5872'),('963D','5871'),('963F','1602'),('9640','4551'),('9642','5873'),('9644','2429'),('9645','2842'),('9646','3429'),('9647','3404'),('9648','1934'),('9649','5874'),('964B','3410'),('964C','3616'),('964D','2921'),('9650','4762'),('9654','5875'),('9655','4134'),('965B','1761'),('965F','5876'),('9661','2224'),('9662','5226'),('9664','1993'),('9667','5877'),('9668','5241'),('9669','4753'),('966A','3767'),('966C','5878'),('9672','5879'),('9674','5880'),('9675','3374'),('9676','4453'),('9677','4761'),('9685','5171'),('9686','3401'),('9688','5881'),('968B','4369'),('968D','5882'),('968F','4370'),('9690','5094'),('9694','2484'),('9697','5883'),('9698','1615'),('9699','4722'),('969C','5347'),('96A7','4377'),('96B0','5884'),('96B3','6736'),('96B6','3305'),('96B9','8631'),('96BC','8632'),('96BD','8633'),('96BE','3649'),('96C0','4024'),('96C1','4967'),('96C4','4859'),('96C5','4937'),('96C6','2815'),('96C7','2545'),('96C9','7984'),('96CC','2038'),('96CD','5126'),('96CE','8634'),('96CF','1991'),('96D2','8635'),('96D5','2181'),('96E0','8637'),('96E8','5174'),('96E9','8607'),('96EA','4909'),('96EF','8609'),('96F3','8608'),('96F6','3367'),('96F7','3255'),('96F9','1702'),('96FE','4677'),('9700','4872'),('9701','8611'),('9704','4786'),('9706','8610'),('9707','5380'),('9708','8612'),('9709','3525'),('970D','2784'),('970E','8614'),('970F','8613'),('9713','3662'),('9716','3356'),('971C','4310'),('971E','4728'),('972A','8615'),('972D','8616'),('9730','8617'),('9732','3422'),('9738','1652'),('9739','3789'),('973E','8618'),('9752','3964'),('9753','8606'),('9756','3024'),('9759','3018'),('975B','2169'),('975E','2339'),('9760','3131'),('9761','3550'),('9762','3570'),('9765','5644'),('9769','2479'),('9773','2989'),('9774','4905'),('9776','1648'),('977C','8716'),('9785','8717'),('978B','4812'),('978D','1616'),('9791','8718'),('9792','8719'),('9794','8720'),('9798','3942'),('97A0','3047'),('97A3','8723'),('97AB','8722'),('97AD','1762'),('97AF','8721'),('97B2','8724'),('97B4','8725'),('97E6','4604'),('97E7','4045'),('97E9','2611'),('97EA','7224'),('97EB','7225'),('97EC','7226'),('97ED','3034'),('97F3','5084'),('97F5','5247'),('97F6','4156'),('9875','5019'),('9876','2205'),('9877','3974'),('9878','8192'),('9879','4778'),('987A','4319'),('987B','4875'),('987C','7179'),('987D','4571'),('987E','2543'),('987F','2257'),('9880','8193'),('9881','1668'),('9882','4344'),('9883','8194'),('9884','5204'),('9885','3413'),('9886','3376'),('9887','3836'),('9888','3017'),('9889','8201'),('988A','2853'),('988C','8202'),('988D','8203'),('988F','8204'),('9890','5035'),('9891','3821'),('9893','4539'),('9894','8205'),('9896','5117'),('9897','3137'),('9898','4466'),('989A','8206'),('989B','8207'),('989C','4953'),('989D','2278'),('989E','8208'),('989F','8209'),('98A0','2163'),('98A1','8210'),('98A2','8211'),('98A4','1892'),('98A5','8212'),('98A6','8213'),('98A7','4007'),('98CE','2371'),('98D1','7609'),('98D2','7610'),('98D3','7611'),('98D5','7612'),('98D8','3814'),('98D9','7613'),('98DA','7614'),('98DE','2341'),('98DF','4219'),('98E7','6624'),('98E8','8747'),('990D','8748'),('9910','1845'),('992E','8749'),('9954','8751'),('9955','8750'),('9963','6627'),('9965','2802'),('9967','6628'),('9968','6629'),('9969','6630'),('996A','6631'),('996B','6632'),('996C','6633'),('996D','2325'),('996E','5091'),('996F','2904'),('9970','4246'),('9971','1705'),('9972','4339'),('9974','6634'),('9975','2292'),('9976','4036'),('9977','6635'),('997A','2940'),('997C','1793'),('997D','6636'),('997F','2286'),('9980','6637'),('9981','3657'),('9984','6638'),('9985','4758'),('9986','2561'),('9987','6639'),('9988','3201'),('998A','6640'),('998B','1886'),('998D','6641'),('998F','3383'),('9990','6642'),('9991','6643'),('9992','3488'),('9993','6644'),('9994','6645'),('9995','6646'),('9996','4255'),('9997','5624'),('9998','5769'),('9999','4767'),('99A5','8005'),('99A8','6016'),('9A6C','3477'),('9A6D','5206'),('9A6E','4552'),('9A6F','4917'),('9A70','1959'),('9A71','3993'),('9A73','1821'),('9A74','3431'),('9A75','7064'),('9A76','4227'),('9A77','7065'),('9A78','7066'),('9A79','3052'),('9A7A','7067'),('9A7B','5504'),('9A7C','4553'),('9A7D','7069'),('9A7E','2861'),('9A7F','7068'),('9A80','7070'),('9A81','7071'),('9A82','3478'),('9A84','2930'),('9A85','7072'),('9A86','3470'),('9A87','2607'),('9A88','7073'),('9A8A','7074'),('9A8B','1950'),('9A8C','4973'),('9A8F','3105'),('9A90','7075'),('9A91','3879'),('9A92','7076'),('9A93','7077'),('9A96','7078'),('9A97','3813'),('9A98','7079'),('9A9A','4107'),('9A9B','7080'),('9A9C','7081'),('9A9D','7082'),('9A9E','6925'),('9A9F','7083'),('9AA0','7084'),('9AA1','3466'),('9AA2','7085'),('9AA3','7086'),('9AA4','5472'),('9AA5','7087'),('9AA7','7088'),('9AA8','2539'),('9AB0','8727'),('9AB1','8726'),('9AB6','8730'),('9AB7','8728'),('9AB8','2601'),('9ABA','8731'),('9ABC','8732'),('9AC0','8734'),('9AC1','8733'),('9AC2','8736'),('9AC5','8735'),('9ACB','8737'),('9ACC','8738'),('9AD1','8739'),('9AD3','4372'),('9AD8','2463'),('9ADF','8752'),('9AE1','8753'),('9AE6','8754'),('9AEB','8756'),('9AED','8758'),('9AEF','8755'),('9AF9','8759'),('9AFB','8757'),('9B03','5555'),('9B08','8760'),('9B0F','8761'),('9B13','8762'),('9B1F','8763'),('9B23','8764'),('9B2F','5943'),('9B32','5610'),('9B3B','6987'),('9B3C','2577'),('9B41','3193'),('9B42','2774'),('9B43','8741'),('9B44','3839'),('9B45','8740'),('9B47','8742'),('9B48','8744'),('9B49','8743'),('9B4D','8745'),('9B4F','4626'),('9B51','8746'),('9B54','3607'),('9C7C','5167'),('9C7F','8647'),('9C81','3419'),('9C82','8648'),('9C85','8649'),('9C86','8650'),('9C87','8651'),('9C88','8652'),('9C8B','8654'),('9C8D','1711'),('9C8E','8655'),('9C90','8656'),('9C91','8657'),('9C92','8658'),('9C94','8659'),('9C95','8660'),('9C9A','8661'),('9C9B','8662'),('9C9C','4742'),('9C9E','8663'),('9C9F','8664'),('9CA0','8665'),('9CA1','8666'),('9CA2','8667'),('9CA3','8668'),('9CA4','3280'),('9CA5','8669'),('9CA6','8670'),('9CA7','8671'),('9CA8','8672'),('9CA9','8673'),('9CAB','8674'),('9CAD','8675'),('9CAE','8676'),('9CB0','8677'),('9CB1','8678'),('9CB2','8679'),('9CB3','8680'),('9CB4','8681'),('9CB5','8682'),('9CB6','8683'),('9CB7','8684'),('9CB8','3008'),('9CBA','8685'),('9CBB','8686'),('9CBC','8687'),('9CBD','8688'),('9CC3','4090'),('9CC4','8689'),('9CC5','8690'),('9CC6','8691'),('9CC7','8692'),('9CCA','8693'),('9CCB','8694'),('9CCC','8701'),('9CCD','8702'),('9CCE','8703'),('9CCF','8704'),('9CD0','8705'),('9CD3','8706'),('9CD4','8707'),('9CD5','8708'),('9CD6','1778'),('9CD7','8709'),('9CD8','8710'),('9CD9','8711'),('9CDC','8712'),('9CDD','8713'),('9CDE','3359'),('9CDF','8714'),('9CE2','8715'),('9E1F','3681'),('9E20','8015'),('9E21','2806'),('9E22','8016'),('9E23','3589'),('9E25','3724'),('9E26','4927'),('9E28','8017'),('9E29','8018'),('9E2A','8019'),('9E2B','8020'),('9E2C','8021'),('9E2D','4928'),('9E2F','4976'),('9E31','8023'),('9E32','8022'),('9E33','5207'),('9E35','4550'),('9E36','8024'),('9E37','8026'),('9E38','8025'),('9E39','8027'),('9E3A','8028'),('9E3D','2475'),('9E3E','8029'),('9E3F','2672'),('9E41','8030'),('9E42','8031'),('9E43','3073'),('9E44','8032'),('9E45','2276'),('9E46','8033'),('9E47','8034'),('9E48','8035'),('9E49','8036'),('9E4A','4021'),('9E4B','8037'),('9E4C','8038'),('9E4E','8039'),('9E4F','3784'),('9E51','8040'),('9E55','8041'),('9E57','8042'),('9E58','8729'),('9E5A','8043'),('9E5B','8044'),('9E5C','8045'),('9E5E','8046'),('9E63','8047'),('9E64','2655'),('9E66','8048'),('9E67','8049'),('9E68','8050'),('9E69','8051'),('9E6A','8052'),('9E6B','8053'),('9E6C','8054'),('9E6D','8056'),('9E70','5105'),('9E71','8055'),('9E73','8057'),('9E7E','8526'),('9E7F','3425'),('9E82','8768'),('9E87','8769'),('9E88','8770'),('9E8B','8771'),('9E92','8772'),('9E93','3420'),('9E9D','8774'),('9E9F','8775'),('9EA6','3483'),('9EB4','8480'),('9EB8','8479'),('9EBB','3473'),('9EBD','8765'),('9EBE','8766'),('9EC4','2738'),('9EC9','5768'),('9ECD','4282'),('9ECE','3272'),('9ECF','8004'),('9ED1','2658'),('9ED4','3913'),('9ED8','3612'),('9EDB','8776'),('9EDC','8777'),('9EDD','8778'),('9EDF','8780'),('9EE0','8779'),('9EE2','8781'),('9EE5','8784'),('9EE7','8783'),('9EE9','8782'),('9EEA','8785'),('9EEF','8786'),('9EF9','7773'),('9EFB','7774'),('9EFC','7775'),('9EFE','8628'),('9F0B','8629'),('9F0D','8630'),('9F0E','2206'),('9F10','5630'),('9F13','2536'),('9F17','5627'),('9F19','6017'),('9F20','4283'),('9F22','8787'),('9F2C','8788'),('9F2F','8789'),('9F37','8791'),('9F39','8790'),('9F3B','1739'),('9F3D','8792'),('9F3E','8793'),('9F44','8794'),('9F50','3875'),('9F51','7620'),('9F7F','1961'),('9F80','8619'),('9F83','8620'),('9F84','3368'),('9F85','8621'),('9F86','8622'),('9F87','8623'),('9F88','8624'),('9F89','8625'),('9F8A','8626'),('9F8B','4003'),('9F8C','8627'),('9F99','3390'),('9F9A','2508'),('9F9B','7772'),('9F9F','2574'),('9FA0','5763');
UNLOCK TABLES;
/*!40000 ALTER TABLE `sys_unicodetolc` ENABLE KEYS */;

--
-- Table structure for table `sys_usuarios_balanzas`
--

DROP TABLE IF EXISTS `sys_usuarios_balanzas`;
CREATE TABLE `sys_usuarios_balanzas` (
  `IdUsuario` int(11) NOT NULL,
  `IdModeloBalanza` int(11) NOT NULL,
  `Modificado` tinyint(1) default NULL,
  `Operacion` char(1) default NULL,
  `Usuario` varchar(20) default NULL,
  `TimeStamp` timestamp NOT NULL default CURRENT_TIMESTAMP,
  PRIMARY KEY  (`IdUsuario`,`IdModeloBalanza`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `sys_usuarios_balanzas`
--


/*!40000 ALTER TABLE `sys_usuarios_balanzas` DISABLE KEYS */;
LOCK TABLES `sys_usuarios_balanzas` WRITE;
INSERT INTO `sys_usuarios_balanzas` (`IdUsuario`, `IdModeloBalanza`, `Modificado`, `Operacion`, `Usuario`, `TimeStamp`) VALUES (55,1,0,'A','admin','2015-02-17 09:08:47'),(55,20,0,'A','admin','2015-02-17 10:55:51'),(55,40,0,'A','admin','2015-02-17 09:07:19'),(56,1,0,'A','admindfs','2011-06-13 08:08:47'),(56,20,0,'A','admindfs','2010-09-27 09:55:51'),(56,40,0,'A','admindfs','2013-05-06 08:07:19'),(57,1,0,'A','china','2010-09-27 09:56:03'),(57,20,0,'A','china','2010-09-27 09:56:12'),(57,40,0,'A','china','2013-05-06 08:07:19'),(63,1,0,'A','noprice','2013-07-02 13:21:25'),(63,20,0,'A','noprice','2013-07-02 13:21:40'),(63,40,0,'A','noprice','2013-07-02 13:21:58'),(64,1,0,'A','price','2013-10-03 14:12:29'),(64,20,0,'A','price','2013-10-03 14:12:43'),(64,40,0,'A','price','2013-10-03 14:13:07'),(65,1,0,'A','dibalc','2014-07-28 08:00:00'),(65,20,0,'A','dibalc','2014-07-28 08:00:00'),(65,40,0,'A','dibalc','2014-07-28 08:00:00');
UNLOCK TABLES;
/*!40000 ALTER TABLE `sys_usuarios_balanzas` ENABLE KEYS */;

--
-- Table structure for table `sys_version`
--

DROP TABLE IF EXISTS `sys_version`;
CREATE TABLE `sys_version` (
  `Version` int(11) NOT NULL,
  `Id` int(11) NOT NULL,
  `Actualizando` tinyint(1) default '0',
  PRIMARY KEY  (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `sys_version`
--


/*!40000 ALTER TABLE `sys_version` DISABLE KEYS */;
LOCK TABLES `sys_version` WRITE;
INSERT INTO `sys_version` (`Version`, `Id`, `Actualizando`) VALUES (138,1,0);
UNLOCK TABLES;
/*!40000 ALTER TABLE `sys_version` ENABLE KEYS */;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

